/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.NetworkSettingsObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class NetworkSettingDlg
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JPanel settingPane;
    private JCheckBox trustChk;
    private JCheckBox networkCacheChk;
    private JSpinner entrySpinner;
    private JSpinner secondSpinner;
    private JLabel keepLabel;
    private JLabel deleteLabel;
    private NetworkSettingsObject networkSettingsObj;

    public NetworkSettingDlg(String title) {
        super(title, true, true);
    }

    public void setObject(NetworkSettingsObject networkSettingsObj) {
        this.networkSettingsObj = networkSettingsObj;
        this.updatePanel();
    }

    @Override
    protected void commit() {
        this.saveData();
    }

    @Override
    protected JPanel getContentPanel() {
        if (this.contentPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.label.networkSetting");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.label.networkSettingDesc");
            this.contentPane = new AvTemplatePane(title, desc);
            this.contentPane.add(this.getSettingPane());
        }
        return this.contentPane;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_files_processes_scan_details_network_setting";
    }

    private JPanel getSettingPane() {
        if (this.settingPane == null) {
            this.settingPane = new JPanel();
            this.settingPane.setLayout(new BorderLayout());
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 3;
            c.gridx = 0;
            c.gridy = 0;
            this.trustChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.checkbox.trust"));
            this.trustChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    NetworkSettingDlg.this.trustChk.setFocusPainted(true);
                }
            });
            pane.add((Component)this.trustChk, c);
            c.gridx = 0;
            c.gridy = 1;
            this.networkCacheChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.checkbox.networkCache"));
            this.networkCacheChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    NetworkSettingDlg.this.networkCacheChkSelected();
                }
            });
            pane.add((Component)this.networkCacheChk, c);
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(5, 20, 0, 0);
            c.gridwidth = 1;
            this.keepLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.label.keep"));
            pane.add((Component)this.keepLabel, c);
            c.gridx = 1;
            c.gridy = 2;
            SpinnerNumberModel entryModel = new SpinnerNumberModel(1, 1, 100, 1);
            this.entrySpinner = new JSpinner(entryModel);
            UIUtilities.enableOnlyValidEdits(this.entrySpinner);
            pane.add((Component)this.entrySpinner, c);
            c.gridx = 2;
            c.gridy = 2;
            c.insets = new Insets(5, 5, 0, 0);
            JLabel entryLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.label.entries"));
            pane.add((Component)entryLabel, c);
            c.gridx = 0;
            c.gridy = 3;
            c.insets = new Insets(5, 20, 0, 0);
            c.gridwidth = 1;
            this.deleteLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.label.delete"));
            pane.add((Component)this.deleteLabel, c);
            c.gridx = 1;
            c.gridy = 3;
            SpinnerNumberModel secondModel = new SpinnerNumberModel(1, 1, 1000, 1);
            this.secondSpinner = new JSpinner(secondModel);
            UIUtilities.enableOnlyValidEdits(this.secondSpinner);
            pane.add((Component)this.secondSpinner, c);
            c.gridx = 2;
            c.gridy = 3;
            c.insets = new Insets(5, 5, 0, 0);
            JLabel secondLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.label.seconds"));
            pane.add((Component)secondLabel, c);
            this.settingPane.add((Component)pane, "Before");
            this.settingPane.addHierarchyListener(new HierarchyListenerImpl());
        }
        return this.settingPane;
    }

    private void updatePanel() {
        this.trustChk.setSelected(this.networkSettingsObj.getTrustRemoteFiles());
        this.networkCacheChk.setSelected(this.networkSettingsObj.getEnableNetworkCache());
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (this.networkCacheChk.isSelected() && !AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.keepLabel.setEnabled(true);
            this.deleteLabel.setEnabled(true);
            this.entrySpinner.setEnabled(true);
            this.secondSpinner.setEnabled(true);
        } else {
            this.keepLabel.setEnabled(false);
            this.deleteLabel.setEnabled(false);
            this.entrySpinner.setEnabled(false);
            this.secondSpinner.setEnabled(false);
        }
        this.entrySpinner.setValue(this.networkSettingsObj.getFileCacheEntries());
        this.secondSpinner.setValue(this.networkSettingsObj.getDeleteCacheAfterSeconds());
    }

    private void saveData() {
        this.networkSettingsObj.setTrustRemoteFiles(this.trustChk.isSelected());
        this.networkSettingsObj.setEnableNetworkCache(this.networkCacheChk.isSelected());
        this.networkSettingsObj.setFileCacheEntries((Integer)this.entrySpinner.getValue());
        this.networkSettingsObj.setDeleteCacheAfterSeconds((Integer)this.secondSpinner.getValue());
    }

    private void networkCacheChkSelected() {
        if (this.networkCacheChk.isSelected()) {
            this.keepLabel.setEnabled(true);
            this.deleteLabel.setEnabled(true);
            this.entrySpinner.setEnabled(true);
            this.secondSpinner.setEnabled(true);
        } else {
            this.keepLabel.setEnabled(false);
            this.deleteLabel.setEnabled(false);
            this.entrySpinner.setEnabled(false);
            this.secondSpinner.setEnabled(false);
        }
    }
}

