/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.DownloadAdvisorOptions;
import com.sygate.scm.common.configobject.schema.SecurityRiskGroup;
import com.sygate.scm.common.configobject.schema.SecurityRiskItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CloudLockPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.util.DynaCatManipulationUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MalwareActionPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private LockCheckBox lockFirstActionChk;
    private LockCheckBox lockIfFirstFailChk;
    private LockCheckBox lockDaProtectionChk;
    private JComboBox<String> firstActionCombo;
    private transient ItemListener firstActionListener;
    private JComboBox<String> ifFirstFailCombo;
    private JComboBox<String> dAGrayFirstActionCombo;
    private DefaultComboBoxModel<String> firstActionModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel<String> ifFirstFailModel = new DefaultComboBoxModel();
    private ApAction action;
    private final String[] ACTION_TYPES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.clean"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.quarantine"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.delete"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.logOnly")};
    private static final int DEFAULT_SECURITY_ACTION_INDEX = 1;
    private static final int DEFAULT_SECURITY_FAIL_ACTION_INDEX = 3;
    private static final int CLEAN_INDEX = 0;
    private static final int QUARANTINE_INDEX = 1;
    private static final int DELETE_INDEX = 2;
    private static final int LOG_ONLY_INDEX = 3;
    private Hashtable<String, Integer> mapActionTypeToIndex = new Hashtable(4);
    private Hashtable<Integer, String> mapIndexToActionType = new Hashtable(4);
    private JLabel firstLabel;
    private JLabel ifFirstFailLabel;
    private JLabel advanceDaSettingsLevel;
    private boolean isScanDialogSettings;
    private DownloadAdvisorOptions daOptions;
    private boolean actionsChanged = false;

    public MalwareActionPanel() {
        this.initialize();
    }

    public void enableAppropriate(boolean res) {
        this.lockFirstActionChk.setEnabled(res);
        this.lockIfFirstFailChk.setEnabled(res);
        this.lockDaProtectionChk.setEnabled(res);
        this.firstActionCombo.setEnabled(res);
        this.ifFirstFailCombo.setEnabled(res);
        this.dAGrayFirstActionCombo.setEnabled(res);
    }

    public void setGrayApplicationSetting(boolean state) {
        this.dAGrayFirstActionCombo.setEnabled(state);
    }

    public MalwareActionPanel(boolean isScanDialogSettings) {
        this.isScanDialogSettings = isScanDialogSettings;
        this.initialize();
    }

    public void setDaObject(DownloadAdvisorOptions daOption) {
        this.daOptions = daOption;
    }

    private void initialize() {
        this.populateIndexTypeMap();
        this.populateActionTypeIndexMap();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.getSetupPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
    }

    public void dispose() {
        this.mapActionTypeToIndex.clear();
        this.mapIndexToActionType.clear();
    }

    public void enableAppropriateActionComponents(boolean val) {
        this.lockFirstActionChk.setEnabled(val);
        this.lockIfFirstFailChk.setEnabled(val);
        this.lockDaProtectionChk.setEnabled(val);
        this.firstActionCombo.setEnabled(val);
        this.ifFirstFailCombo.setEnabled(val);
        this.dAGrayFirstActionCombo.setEnabled(val);
        this.firstLabel.setEnabled(val);
        this.ifFirstFailLabel.setEnabled(val);
        if (this.firstActionModel.getSelectedItem().equals(this.ACTION_TYPES[3])) {
            this.ifFirstFailCombo.setEnabled(false);
        } else {
            this.ifFirstFailCombo.setEnabled(val);
        }
    }

    private void populateIndexTypeMap() {
        this.mapActionTypeToIndex.put(this.ACTION_TYPES[0], ApAction.CLEAN);
        this.mapActionTypeToIndex.put(this.ACTION_TYPES[1], ApAction.QUARANTINE);
        this.mapActionTypeToIndex.put(this.ACTION_TYPES[2], ApAction.DELETE);
        this.mapActionTypeToIndex.put(this.ACTION_TYPES[3], ApAction.LOG_ONLY);
    }

    private void populateActionTypeIndexMap() {
        this.mapIndexToActionType.put(ApAction.CLEAN, this.ACTION_TYPES[0]);
        this.mapIndexToActionType.put(ApAction.QUARANTINE, this.ACTION_TYPES[1]);
        this.mapIndexToActionType.put(ApAction.DELETE, this.ACTION_TYPES[2]);
        this.mapIndexToActionType.put(ApAction.LOG_ONLY, this.ACTION_TYPES[3]);
    }

    public ApAction getDownloadsAction() {
        return this.action;
    }

    public void setObject(ApAction action) {
        SecurityRiskItem downloadRiskItem = new SecurityRiskItem();
        downloadRiskItem.setName("1:18");
        this.action = DynaCatManipulationUtility.getApAction((SecurityRiskItem)downloadRiskItem);
        if (action != null) {
            this.action.setFirstAction(action.getFirstAction());
            this.action.setSecondAction(action.getSecondAction());
            this.action.setOptLockFirstAction(action.getOptLockFirstAction());
            this.action.setOptLockSecondAction(action.getOptLockSecondAction());
        }
        this.updatePanel();
        if (this.daOptions != null) {
            this.daOptions.setOptDAGrayPrompt(Boolean.valueOf(this.grayApplicationAction(this.dAGrayFirstActionCombo.getSelectedIndex())));
        }
    }

    private boolean grayApplicationAction(int index) {
        return index != DownloadAdvisorOptions.IGNORE;
    }

    public boolean isActionsChanged() {
        return this.actionsChanged;
    }

    public void updateApActions(ApActions apActions) {
        if (apActions == null) {
            return;
        }
        SecurityRiskGroup malwareGroup = null;
        SecurityRiskItem downloadRiskItem = null;
        for (int i = 0; i < apActions.getSecurityRiskGroupCount(); ++i) {
            SecurityRiskGroup group = apActions.getSecurityRiskGroup(i);
            String groupKey = group.getName();
            String uberCatName = DynaCatManipulationUtility.checkMalWareSecurityGroup((String)groupKey);
            if (uberCatName != null) {
                group.setName(uberCatName);
                groupKey = uberCatName;
            }
            if (!"1".equals(groupKey)) continue;
            malwareGroup = group;
            boolean hasFoundDownloadRiskItem = false;
            for (int j = 0; j < group.getSecurityRiskItemCount(); ++j) {
                downloadRiskItem = group.getSecurityRiskItem(j);
                String riskKey = downloadRiskItem.getName();
                if ("DownloadAction".equals(riskKey)) {
                    downloadRiskItem.setName("1:18");
                    riskKey = "1:18";
                }
                if (!"1:18".equals(riskKey)) continue;
                downloadRiskItem.setOptApAction(this.action);
                hasFoundDownloadRiskItem = true;
            }
            if (hasFoundDownloadRiskItem) continue;
            downloadRiskItem = null;
        }
        if (malwareGroup == null) {
            malwareGroup = new SecurityRiskGroup();
            malwareGroup.setName("1");
            malwareGroup.setApAction(DynaCatManipulationUtility.getApAction((SecurityRiskGroup)malwareGroup));
            apActions.addSecurityRiskGroup(malwareGroup);
        }
        if (downloadRiskItem == null) {
            downloadRiskItem = new SecurityRiskItem();
            downloadRiskItem.setName("1:18");
            downloadRiskItem.setOptApAction(this.action);
            malwareGroup.addSecurityRiskItem(downloadRiskItem);
        }
    }

    public void save() {
        Boolean optLockFirstAction = this.action.getOptLockFirstAction();
        if (optLockFirstAction == null) {
            optLockFirstAction = false;
        }
        if (optLockFirstAction.booleanValue() != this.lockFirstActionChk.isSelected()) {
            this.actionsChanged = true;
        }
        this.action.setOptLockFirstAction(Boolean.valueOf(this.lockFirstActionChk.isSelected()));
        if (!this.action.getFirstAction().equals(this.mapActionTypeToIndex.get(this.firstActionCombo.getSelectedItem()))) {
            this.actionsChanged = true;
        }
        this.action.setFirstAction(this.mapActionTypeToIndex.get(this.firstActionCombo.getSelectedItem()));
        Boolean optLockSecondAction = this.action.getOptLockSecondAction();
        if (optLockSecondAction == null) {
            optLockSecondAction = false;
        }
        if (optLockSecondAction.booleanValue() != this.lockIfFirstFailChk.isSelected()) {
            this.actionsChanged = true;
        }
        this.action.setOptLockSecondAction(Boolean.valueOf(this.lockIfFirstFailChk.isSelected()));
        if (!this.action.getSecondAction().equals(this.mapActionTypeToIndex.get(this.ifFirstFailCombo.getSelectedItem()))) {
            this.actionsChanged = true;
        }
        this.action.setSecondAction(this.mapActionTypeToIndex.get(this.ifFirstFailCombo.getSelectedItem()));
        if (!this.isScanDialogSettings) {
            this.daOptions.setOptDAGrayFirstAction(Integer.valueOf(this.dAGrayFirstActionCombo.getSelectedIndex()));
            this.daOptions.setOptLockDAGrayFirstAction(Boolean.valueOf(this.lockDaProtectionChk.isSelected()));
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_files_download_protection_actions";
    }

    private void setupComponents() {
        int i;
        this.lockFirstActionChk = new LockCheckBox(Boolean.FALSE);
        this.lockFirstActionChk.setSelectedIcon(AvConstants.lockIcon);
        this.lockIfFirstFailChk = new LockCheckBox(Boolean.FALSE);
        this.lockIfFirstFailChk.setSelectedIcon(AvConstants.lockIcon);
        this.lockDaProtectionChk = new LockCheckBox(Boolean.FALSE);
        this.lockDaProtectionChk.setSelectedIcon(AvConstants.lockIcon);
        for (i = 1; i < this.ACTION_TYPES.length; ++i) {
            this.ifFirstFailModel.addElement(this.ACTION_TYPES[i]);
        }
        this.ifFirstFailCombo = new JComboBox<String>(this.ifFirstFailModel);
        for (i = 1; i < this.ACTION_TYPES.length; ++i) {
            this.firstActionModel.addElement(this.ACTION_TYPES[i]);
        }
        this.firstActionCombo = new JComboBox<String>(this.firstActionModel);
        this.firstActionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    MalwareActionPanel.this.removeFirstSelectionFromIfFirstFail();
                    if (MalwareActionPanel.this.firstActionModel.getSelectedItem().equals(MalwareActionPanel.this.ACTION_TYPES[3])) {
                        MalwareActionPanel.this.ifFirstFailCombo.setEnabled(false);
                    } else {
                        MalwareActionPanel.this.ifFirstFailCombo.setEnabled(true);
                    }
                }
            }
        };
        this.firstActionCombo.addItemListener(this.firstActionListener);
        this.dAGrayFirstActionCombo = new JComboBox<String>(new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.quarantine"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.delete"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.logOnly"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.prompt"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionListPane.list.action.ignore")});
        this.dAGrayFirstActionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MalwareActionPanel.this.daOptions.setOptDAGrayPrompt(Boolean.valueOf(MalwareActionPanel.this.grayApplicationAction(MalwareActionPanel.this.dAGrayFirstActionCombo.getSelectedIndex())));
            }
        });
    }

    private static boolean isCloudEnrolled() {
        return CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    }

    private void removeFirstSelectionFromIfFirstFail() {
        Object selectedItem = this.ifFirstFailModel.getSelectedItem();
        this.ifFirstFailCombo.removeAllItems();
        for (int i = 1; i < this.ACTION_TYPES.length; ++i) {
            this.ifFirstFailModel.addElement(this.ACTION_TYPES[i]);
        }
        this.ifFirstFailModel.removeElement(this.firstActionModel.getSelectedItem());
        if (this.firstActionModel.getSelectedItem() != selectedItem) {
            this.ifFirstFailModel.setSelectedItem(selectedItem);
        } else {
            int defaultIndex = 3;
            if (this.ifFirstFailModel.getIndexOf(this.ACTION_TYPES[defaultIndex]) != -1) {
                this.ifFirstFailModel.setSelectedItem(this.ACTION_TYPES[defaultIndex]);
            } else {
                this.ifFirstFailModel.setSelectedItem(this.ACTION_TYPES[1]);
            }
        }
    }

    private JPanel getSetupPanel() {
        this.setupComponents();
        JPanel dpActionsPanel = new JPanel();
        dpActionsPanel.setLayout(new BoxLayout(dpActionsPanel, 1));
        DescriptionTextArea area = !this.isScanDialogSettings ? new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.action.labelText")) : new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.AdminScanDialog.action.labelText"));
        AvTemplatePane outerpane = new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MalwareActionPanel.title.action"), area.getText());
        JPanel actionPane = new JPanel();
        actionPane.setLayout(new GridBagLayout());
        this.firstLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileActionPane.label.firstAction"));
        this.ifFirstFailLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileActionPane.label.firstActionFail"));
        this.advanceDaSettingsLevel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MalwareActionPanel.label.advanceDaSettings"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 0, 0);
        constraints.gridwidth = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        if (!this.isScanDialogSettings) {
            actionPane.add((Component)new CloudLockPanel(this.lockFirstActionChk), constraints);
        } else {
            actionPane.add((Component)new JLabel(), constraints);
        }
        constraints.insets = new Insets(5, 2, 0, 0);
        constraints.gridx = 1;
        constraints.gridy = 0;
        actionPane.add((Component)this.firstLabel, constraints);
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.gridx = 2;
        constraints.gridy = 0;
        actionPane.add(this.firstActionCombo, constraints);
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 1;
        if (!this.isScanDialogSettings) {
            actionPane.add((Component)new CloudLockPanel(this.lockIfFirstFailChk), constraints);
        } else {
            actionPane.add((Component)new JLabel(), constraints);
        }
        constraints.insets = new Insets(5, 2, 0, 0);
        constraints.gridx = 1;
        constraints.gridy = 1;
        actionPane.add((Component)this.ifFirstFailLabel, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = new Insets(10, 5, 0, 0);
        actionPane.add(this.ifFirstFailCombo, constraints);
        AvTemplatePane template = null;
        if (!this.isScanDialogSettings) {
            template = new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MalwareActionPanel.unprovenFiles.title"), "");
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.add(new CloudLockPanel(this.lockDaProtectionChk));
            panel.add(this.advanceDaSettingsLevel);
            panel.add(this.dAGrayFirstActionCombo);
            template.add(panel);
        }
        actionPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)actionPane, "Before");
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)pane, "North");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)p1, "Center");
        this.setLayout(new BorderLayout());
        outerpane.add(panel);
        dpActionsPanel.add(outerpane);
        if (template != null) {
            dpActionsPanel.add(template);
        }
        if (MalwareActionPanel.isCloudEnrolled()) {
            String tooltip = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled");
            this.firstLabel.setToolTipText(tooltip);
            this.ifFirstFailLabel.setToolTipText(tooltip);
            this.lockFirstActionChk.setToolTipText(tooltip);
            this.lockIfFirstFailChk.setToolTipText(tooltip);
            this.firstActionCombo.setToolTipText(tooltip);
            this.ifFirstFailCombo.setToolTipText(tooltip);
            this.lockDaProtectionChk.setToolTipText(tooltip);
            this.advanceDaSettingsLevel.setToolTipText(tooltip);
            this.dAGrayFirstActionCombo.setToolTipText(tooltip);
        }
        return dpActionsPanel;
    }

    private void setDefaultActions() {
        this.firstActionModel.setSelectedItem(this.ACTION_TYPES[1]);
        this.ifFirstFailModel.setSelectedItem(this.ACTION_TYPES[3]);
    }

    public void updatePanel() {
        Boolean lockBoolean = this.action.getOptLockFirstAction();
        if (lockBoolean == null) {
            lockBoolean = this.action.getDefLockFirstAction();
        }
        this.lockFirstActionChk.setSelected(lockBoolean);
        lockBoolean = this.action.getOptLockSecondAction();
        if (lockBoolean == null) {
            lockBoolean = this.action.getDefLockSecondAction();
        }
        this.lockIfFirstFailChk.setSelected(lockBoolean);
        this.firstActionCombo.removeItemListener(this.firstActionListener);
        this.setDefaultActions();
        this.firstActionCombo.addItemListener(this.firstActionListener);
        Integer actionInteger = this.action.getFirstAction();
        if (actionInteger != null) {
            this.firstActionModel.setSelectedItem(this.mapIndexToActionType.get(actionInteger));
        }
        if ((actionInteger = this.action.getSecondAction()) != null) {
            this.ifFirstFailModel.setSelectedItem(this.mapIndexToActionType.get(actionInteger));
        }
        this.removeFirstSelectionFromIfFirstFail();
        if (this.firstActionModel.getSelectedItem().equals(this.ACTION_TYPES[3])) {
            this.ifFirstFailCombo.setEnabled(false);
        }
        if (!this.isScanDialogSettings) {
            Boolean lockAction = this.daOptions.getOptLockDAGrayFirstAction();
            if (lockAction == null) {
                lockAction = this.daOptions.getDefLockDAGrayFirstAction();
            }
            this.lockDaProtectionChk.setSelected(lockAction);
            Integer firstAction = this.daOptions.getOptDAGrayFirstAction();
            if (firstAction == null) {
                firstAction = this.daOptions.getDefDAGrayFirstAction();
            }
            this.dAGrayFirstActionCombo.setSelectedIndex(firstAction);
        }
    }
}

