/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CompressedFilesPane;
import com.sygate.scm.console.ui.policy.av.common.FileTypesPane;
import com.sygate.scm.console.ui.policy.av.logicobject.ApMailScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.CompressedFilesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.FileTypesObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MailScanDetailsPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    public static final int INTERNET_EMAIL = 1;
    public static final int MSFT_EXCHANGE = 2;
    public static final int LOTUS_NOTES = 3;
    private AvTemplatePane scanningPane;
    private CompressedFilesPane compressedFilesPane;
    private CompressedFilesObject compressedFilesObj;
    private FileTypesObject fileTypesObj;
    private FileTypesPane fileTypesPane;
    private JPanel enablePane;
    private FlowLayout flowLayout = new FlowLayout();
    private JCheckBox enableChk;
    private LockCheckBox lockEnableChk;
    private int emailType;
    private ApMailScanDetailsObject mailScanObj;

    public MailScanDetailsPane(int emailType) {
        this.emailType = emailType;
        this.initGUI();
    }

    public void setObject(ApMailScanDetailsObject mailScanObj) {
        this.mailScanObj = mailScanObj;
        this.updatePanel();
    }

    public void save() {
        this.saveData();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        switch (this.emailType) {
            case 1: {
                return "sesm_policies_dialog_av_auto_protect_internet_email_scan_details";
            }
            case 2: {
                return "sesm_policies_dialog_av_auto_protect_msft_exchange_scan_details";
            }
            case 3: {
                return "sesm_policies_dialog_av_auto_protect_lotus_notes_scan_details";
            }
        }
        return null;
    }

    private void initGUI() {
        this.flowLayout.setAlignment(3);
        this.setLayout(new BoxLayout(this, 1));
        this.getEnablePane().setAlignmentX(0.0f);
        this.getScanningPane().setAlignmentX(0.0f);
        this.add(this.getEnablePane());
        this.add(this.getScanningPane());
    }

    private JPanel getEnablePane() {
        if (this.enablePane == null) {
            this.enablePane = new JPanel();
            this.enablePane.setLayout(new BoxLayout(this.enablePane, 1));
            this.enablePane.setMaximumSize(new Dimension(2000, 100));
            this.enablePane.setAlignmentX(0.0f);
            JPanel optionsPanel = new JPanel();
            optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
            optionsPanel.setAlignmentX(0.0f);
            this.lockEnableChk = new LockCheckBox(Boolean.FALSE);
            this.lockEnableChk.setSelectedIcon(AvConstants.lockIcon);
            optionsPanel.add(this.lockEnableChk);
            String chkStr = null;
            String noteStr = null;
            switch (this.emailType) {
                case 1: {
                    chkStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MailScanDetailsPane.label.enableInternet");
                    noteStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MailScanDetailsPane.label.enableInternet.deprecated");
                    break;
                }
                case 2: {
                    chkStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MailScanDetailsPane.label.enableExchange");
                    noteStr = "";
                    break;
                }
                case 3: {
                    chkStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MailScanDetailsPane.label.enableLotusnotes");
                    noteStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MailScanDetailsPane.label.enableLotusnotes.deprecated");
                    break;
                }
            }
            this.enableChk = new JCheckBox(chkStr);
            this.enableChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MailScanDetailsPane.this.enableAppropriate();
                }
            });
            optionsPanel.add(this.enableChk);
            JPanel notePanel = new JPanel();
            notePanel.setAlignmentX(0.0f);
            JLabel noteLabel = new JLabel(noteStr);
            noteLabel.setForeground(Color.RED);
            noteLabel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
            notePanel.add(noteLabel);
            this.enablePane.add(notePanel);
            this.enablePane.add(optionsPanel);
        }
        return this.enablePane;
    }

    private AvTemplatePane getScanningPane() {
        if (this.scanningPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MailScanDetailsPane.label.scanning");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MailScanDetailsPane.label.scanningDesc");
            this.scanningPane = new AvTemplatePane(title, desc);
            this.fileTypesPane = new FileTypesPane(false, true);
            this.fileTypesPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.scanningPane.add(this.fileTypesPane);
            this.compressedFilesPane = new CompressedFilesPane(false, 1);
            this.compressedFilesPane.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
            this.scanningPane.add(this.compressedFilesPane);
        }
        return this.scanningPane;
    }

    private void enableAppropriate() {
        boolean allEnabled = this.enableChk.isSelected();
        this.fileTypesPane.enableAppropriate(allEnabled);
        this.compressedFilesPane.enableAppropriate(allEnabled);
    }

    private void updatePanel() {
        this.lockEnableChk.setSelected(this.mailScanObj.isEnableEmailApLocked());
        this.enableChk.setSelected(this.mailScanObj.isEmailApEnabled());
        this.fileTypesObj = new FileTypesObject(this.mailScanObj.getFileTypes());
        this.fileTypesPane.setObject(this.fileTypesObj);
        this.compressedFilesObj = new CompressedFilesObject(this.mailScanObj.getCompressedFiles());
        this.compressedFilesPane.setObject(this.compressedFilesObj);
        this.enableAppropriate();
    }

    private void saveData() {
        this.fileTypesPane.save();
        this.compressedFilesPane.save();
        this.mailScanObj.lockEnableEmailAp(this.lockEnableChk.isSelected());
        this.mailScanObj.enableEmailAp(this.enableChk.isSelected());
        this.mailScanObj.setFileTypes(this.fileTypesObj);
        this.mailScanObj.setCompressedFiles(this.compressedFilesObj);
    }
}

