/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ui.policy.av.ap.MacMountDiskScanDetailsPane;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.MountDiskScanOptionsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.OptimizedMountScanObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MacMountScanSettingsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String AVAP = "com.sygate.scm.console.ui.policy.av.ap.avap";
    private JCheckBox diskTypeDataDisk;
    private JCheckBox diskTypeAllOtherDisks;
    private String legacyClientSettingsToolTipText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskFileScanDetailsPane.label.legacyClientSettingsToolTip");
    String link = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskFileScanDetailsPane.label");
    private MountDiskScanOptionsObject mdsoObject;
    private OptimizedMountScanObject omsObj;
    HtmlEnabledJLabel jLableLegacyClientSettings;

    public MacMountScanSettingsPane() {
        this.setLayout(new GridBagLayout());
        this.initialize();
    }

    public void setObject(MountDiskScanOptionsObject mdsoObj, OptimizedMountScanObject omsObj, boolean isEnable) {
        this.mdsoObject = mdsoObj;
        this.omsObj = omsObj;
        this.updatePanel();
        this.enableAppropriate(isEnable);
    }

    public void save() {
        this.saveData();
    }

    public void enableAppropriate(boolean allEnabled) {
        this.jLableLegacyClientSettings.setEnabled(allEnabled);
        if (!allEnabled) {
            this.jLableLegacyClientSettings.setForeground(Color.GRAY);
            this.jLableLegacyClientSettings.setToolTipText("");
        } else {
            this.jLableLegacyClientSettings.unhighlightLink();
            this.jLableLegacyClientSettings.setToolTipText(this.legacyClientSettingsToolTipText);
        }
        this.enableDiskTypeCheckboxes(allEnabled);
    }

    private void initialize() {
        String title = MessageResources.getInstance().getString(AVAP, "MacMountDiskScanDetailsPane.title");
        String desc = MessageResources.getInstance().getString(AVAP, "MacMountDiskScanDetailsPane.desc");
        AvTemplatePane headerPane = new AvTemplatePane(title, desc);
        JLabel mdsoSubTitleLabel = new JLabel(MessageResources.getInstance().getString(AVAP, "MacMountDiskScanDetailsPane.diskTypesSubTitle"));
        this.diskTypeDataDisk = new JCheckBox(MessageResources.getInstance().getString(AVAP, "MacMountDiskScanDetailsPane.dataDisks"));
        this.diskTypeAllOtherDisks = new JCheckBox(MessageResources.getInstance().getString(AVAP, "MacMountDiskScanDetailsPane.allOtherDisksnDevices"));
        int widthx = 1;
        int widthy = 1;
        double weightx = 1.0;
        double weighty = 1.0;
        Insets insetsHeader = new Insets(10, 0, 0, 0);
        Insets insetsLeft = new Insets(0, 20, 0, 0);
        widthx = 6;
        widthy = 1;
        this.addComponent(this, headerPane, 0, 0, 0, widthy, weightx, weighty, 18, 2, insetsHeader);
        this.addComponent(this, mdsoSubTitleLabel, 0, 1, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        weightx = 0.2;
        this.addComponent(this, this.diskTypeDataDisk, 0, 4, 1, 1, weightx, weighty, 18, 0, insetsLeft);
        this.addComponent(this, this.diskTypeAllOtherDisks, 0, 5, 1, 1, weightx, weighty, 18, 0, insetsLeft);
        this.jLableLegacyClientSettings = this.createLinkLabel(this.link);
        this.jLableLegacyClientSettings.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MacMountScanSettingsPane.this.jLableLegacyClientSettings.isEnabled()) {
                    String title = MessageResources.getInstance().getString(MacMountScanSettingsPane.AVAP, "MacMountDiskScanDetailsPane.title");
                    new MacMountDiskScanDetailsPane(MacMountScanSettingsPane.this.mdsoObject, title, true);
                }
            }
        });
        this.addComponent(this, (Component)this.jLableLegacyClientSettings, 0, 6, widthx, widthy, weightx, weighty, 18, 0, new Insets(10, 20, 0, 0));
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    private void updatePanel() {
        this.diskTypeDataDisk.setSelected(this.omsObj.getDataDisk());
        this.diskTypeAllOtherDisks.setSelected(this.omsObj.getAllOtherDisks());
    }

    private void saveData() {
        this.omsObj.setDataDisk(this.diskTypeDataDisk.isSelected());
        this.omsObj.setAllOtherDisks(this.diskTypeAllOtherDisks.isSelected());
    }

    private HtmlEnabledJLabel createLinkLabel(String text) {
        HtmlEnabledJLabel link = new HtmlEnabledJLabel(text, true);
        link.setCursor(Cursor.getPredefinedCursor(12));
        link.setToolTipText(this.legacyClientSettingsToolTipText);
        link.putClientProperty((Object)"cssClass", (Object)"jLableLegacyClientSettings");
        link.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        return link;
    }

    private void enableDiskTypeCheckboxes(boolean enabled) {
        this.diskTypeDataDisk.setEnabled(enabled);
        this.diskTypeAllOtherDisks.setEnabled(enabled);
    }
}

