/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.MountDiskScanOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.MountDiskScanOptionsObject;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MacMountDiskScanDetailsPane
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JCheckBox scanDisksOnMount;
    private JCheckBox showScanProgress;
    private JCheckBox diskTypeAudioVideoDisk;
    private JCheckBox diskTypeDataDisk;
    private JCheckBox diskTypeIPod;
    private JCheckBox diskTypeAllOtherDisks;
    private JRadioButton scanAllRadio;
    private JRadioButton scanSelectedRadio;
    private MountDiskScanOptionsObject mdsoObject;
    JPanel centerPanel;

    public MacMountDiskScanDetailsPane(MountDiskScanOptionsObject mdsoObj, String title, boolean modal) {
        super(Manager.frame, title, modal);
        this.mdsoObject = mdsoObj;
        this.initialize();
        this.setObject(mdsoObj, true);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_av_auto_protect_scan_details_legacy";
    }

    @Override
    public void commit() {
        this.saveData();
    }

    public void setObject(MountDiskScanOptionsObject mdsoObj, boolean isEnable) {
        this.mdsoObject = mdsoObj;
        this.updatePanel();
        this.enableAppropriate(isEnable);
    }

    @Override
    public boolean isValidate() {
        if (this.scanSelectedRadio.isSelected()) {
            boolean isAtleastOneOptionSelected;
            boolean bl = isAtleastOneOptionSelected = this.diskTypeAudioVideoDisk.isSelected() || this.diskTypeDataDisk.isSelected() || this.diskTypeIPod.isSelected() || this.diskTypeAllOtherDisks.isSelected();
            if (!isAtleastOneOptionSelected) {
                MessageResources msgRes = MessageResources.getInstance();
                JOptionPane.showMessageDialog(Manager.frame, msgRes.getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.error.selectDiskType"), msgRes.getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacApFilePane.errorDlg.title"), 0);
            }
            return isAtleastOneOptionSelected;
        }
        return true;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.desc");
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new GridBagLayout());
        AvTemplatePane headerPane = new AvTemplatePane("", desc);
        MountDiskScanItemListener mdsItemListener = new MountDiskScanItemListener();
        this.scanDisksOnMount = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.enableScan"));
        this.scanDisksOnMount.addItemListener(mdsItemListener);
        this.showScanProgress = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.showProgress"));
        JLabel mdsoSubTitleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.diskTypesSubTitle"));
        this.scanAllRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.scanAll"));
        this.scanSelectedRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.scanSelected"));
        this.scanAllRadio.addItemListener(mdsItemListener);
        this.scanSelectedRadio.addItemListener(mdsItemListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.scanAllRadio);
        group.add(this.scanSelectedRadio);
        this.diskTypeAudioVideoDisk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.musicVideoDisks"));
        this.diskTypeDataDisk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.dataDisks"));
        this.diskTypeIPod = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.ipod"));
        this.diskTypeAllOtherDisks = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacMountDiskScanDetailsPane.allOtherDisks"));
        int widthx = 1;
        int widthy = 1;
        double weightx = 1.0;
        double weighty = 1.0;
        Insets insetsHeader = new Insets(10, 0, 0, 0);
        Insets insetsLeft = new Insets(0, 20, 0, 0);
        Insets insetsLeft2 = new Insets(0, 40, 0, 0);
        Insets insetsLeft3 = new Insets(0, 60, 0, 0);
        Insets insetsNone = new Insets(0, 0, 0, 0);
        widthx = 6;
        widthy = 1;
        this.addComponent(headerPane, 0, 0, 0, widthy, weightx, weighty, 18, 2, insetsHeader);
        this.addComponent(this.scanDisksOnMount, 0, 1, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        this.addComponent(this.showScanProgress, 0, 2, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        this.addComponent(mdsoSubTitleLabel, 0, 3, widthx, widthy, weightx, weighty, 18, 0, insetsLeft2);
        this.addComponent(this.scanAllRadio, 0, 4, widthx, widthy, weightx, weighty, 18, 0, insetsLeft2);
        this.addComponent(this.scanSelectedRadio, 0, 5, widthx, widthy, weightx, weighty, 18, 0, insetsLeft2);
        weightx = 0.2;
        this.addComponent(this.diskTypeAudioVideoDisk, 0, 6, 1, 1, weightx, weighty, 18, 0, insetsLeft3);
        this.addComponent(this.diskTypeDataDisk, 1, 6, 1, 1, weightx, weighty, 18, 0, insetsNone);
        this.addComponent(Box.createGlue(), 2, 6, 1, 1, 1.0 - 2.0 * weightx, weighty, 18, 2, insetsNone);
        this.addComponent(this.diskTypeIPod, 0, 7, 1, 1, weightx, weighty, 18, 0, insetsLeft3);
        this.addComponent(this.diskTypeAllOtherDisks, 1, 7, 1, 1, weightx, weighty, 18, 0, insetsNone);
        this.addComponent(Box.createGlue(), 2, 7, 1, 1, 1.0 - 2.0 * weightx, weighty, 18, 2, insetsNone);
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        UiUtilities.centerComponent((Component)this);
    }

    private void addComponent(Component component, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, 0, 0);
        this.centerPanel.add(component, gbc);
    }

    private void updatePanel() {
        if (this.mdsoObject == null) {
            MountDiskScanOptions mdScanOptions = new MountDiskScanOptions();
            this.mdsoObject = new MountDiskScanOptionsObject(mdScanOptions);
        }
        this.scanDisksOnMount.setSelected(this.mdsoObject.getMDSOEnabled());
        this.showScanProgress.setSelected(this.mdsoObject.getMDSOShowProgress());
        boolean tmpBool = this.mdsoObject.getDTAllSelected();
        if (tmpBool) {
            this.scanAllRadio.setSelected(true);
        } else {
            this.scanSelectedRadio.setSelected(true);
        }
        this.diskTypeAudioVideoDisk.setSelected(this.mdsoObject.getDTAudioVideoDiskSelected());
        this.diskTypeDataDisk.setSelected(this.mdsoObject.getDTDataDiskSelected());
        this.diskTypeIPod.setSelected(this.mdsoObject.getDTIpodSelected());
        this.diskTypeAllOtherDisks.setSelected(this.mdsoObject.getDTAllOtherDisksSelected());
    }

    private void enableAppropriate(boolean allEnabled) {
        this.enableMountScanPane(allEnabled && this.scanDisksOnMount.isSelected());
    }

    private void enableMountScanPane(boolean enabled) {
        this.showScanProgress.setEnabled(enabled);
        this.scanAllRadio.setEnabled(enabled);
        this.scanSelectedRadio.setEnabled(enabled);
        this.enableDiskTypeCheckboxes(enabled && this.scanSelectedRadio.isSelected());
    }

    private void enableDiskTypeCheckboxes(boolean enabled) {
        this.diskTypeAudioVideoDisk.setEnabled(enabled);
        this.diskTypeDataDisk.setEnabled(enabled);
        this.diskTypeIPod.setEnabled(enabled);
        this.diskTypeAllOtherDisks.setEnabled(enabled);
    }

    private void saveData() {
        if (this.mdsoObject == null) {
            System.out.println("MountDiskScanOptionsObject object is null");
        } else {
            this.mdsoObject.setMDSOEnabled(this.scanDisksOnMount.isSelected());
            this.mdsoObject.setMDSOShowProgress(this.showScanProgress.isSelected());
            if (this.scanAllRadio.isSelected()) {
                this.mdsoObject.setMDSODiskTypesAll();
            } else {
                boolean isAudioVideoDisk = this.diskTypeAudioVideoDisk.isSelected();
                boolean isDataDisk = this.diskTypeDataDisk.isSelected();
                boolean isIpod = this.diskTypeIPod.isSelected();
                boolean isAllOtherDisks = this.diskTypeAllOtherDisks.isSelected();
                this.mdsoObject.setMDSODiskTypesSelected(isAudioVideoDisk, isDataDisk, isIpod, isAllOtherDisks);
            }
        }
    }

    private class MountDiskScanItemListener
    implements ItemListener {
        private MountDiskScanItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() instanceof JRadioButton) {
                MacMountDiskScanDetailsPane.this.enableDiskTypeCheckboxes(MacMountDiskScanDetailsPane.this.scanSelectedRadio.isSelected());
            } else if (e.getItemSelectable() instanceof JCheckBox) {
                MacMountDiskScanDetailsPane.this.enableMountScanPane(MacMountDiskScanDetailsPane.this.scanDisksOnMount.isSelected());
            }
        }
    }
}

