/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApScanOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.ap.FileInclusionDialog;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.ApScanOptionsObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MacGeneralScanDetailsPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JRadioButton scanEveryWhereRadio;
    private JRadioButton scanOnlyInRadio;
    private JRadioButton scanExceptInRadio;
    private Map<Integer, JRadioButton> radioMap;
    private Integer selectedIdx = null;
    private AlwaysEnabledButton editOnlyInFoldersBtn;
    private JTextArea onlyInFoldersTA;
    private ApScanOptionsObject apScanOptionsObj;

    public MacGeneralScanDetailsPane() {
        VerticalFlowLayout thisLayout = new VerticalFlowLayout(0, 0);
        this.setLayout(thisLayout);
        this.initInternalPanel();
    }

    public void setObject(ApScanOptions apScanOptions, boolean isEnable) {
        this.apScanOptionsObj = new ApScanOptionsObject(apScanOptions);
        this.updatePanel();
        this.enableAppropriate(isEnable);
    }

    public void save() {
        this.saveData();
    }

    private void initInternalPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.title");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.description");
        AvTemplatePane headerPane = new AvTemplatePane(title, desc);
        String scanExceptInNote = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.scanExceptInNote");
        int numRows1 = 2;
        JTextArea scanExceptInNoteTextArea = new JTextArea();
        scanExceptInNoteTextArea.setRows(numRows1);
        scanExceptInNoteTextArea.setBackground(this.getBackground());
        scanExceptInNoteTextArea.setEditable(false);
        scanExceptInNoteTextArea.setLineWrap(true);
        scanExceptInNoteTextArea.setWrapStyleWord(true);
        scanExceptInNoteTextArea.setText(scanExceptInNote);
        RadioItemListener ril = new RadioItemListener();
        this.scanEveryWhereRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.scanEverywhere"));
        this.scanOnlyInRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.scanOnlyIn"));
        this.scanExceptInRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.scanExceptIn"));
        this.scanEveryWhereRadio.addItemListener(ril);
        this.scanOnlyInRadio.addItemListener(ril);
        this.scanExceptInRadio.addItemListener(ril);
        this.radioMap = new HashMap<Integer, JRadioButton>();
        this.radioMap.put(ApScanOptions.SCAN_EVERYWHERE, this.scanEveryWhereRadio);
        this.radioMap.put(ApScanOptions.SCAN_ONLY_IN, this.scanOnlyInRadio);
        this.radioMap.put(ApScanOptions.SCAN_EXCEPT_IN, this.scanExceptInRadio);
        ButtonGroup group = new ButtonGroup();
        group.add(this.scanEveryWhereRadio);
        group.add(this.scanOnlyInRadio);
        group.add(this.scanExceptInRadio);
        ButtonActionListener bal = new ButtonActionListener();
        this.editOnlyInFoldersBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.editFolders"));
        this.editOnlyInFoldersBtn.addActionListener(bal);
        int numRows = 3;
        int numCols = 30;
        this.onlyInFoldersTA = new JTextArea();
        this.onlyInFoldersTA.setRows(numRows);
        this.onlyInFoldersTA.setColumns(numCols);
        this.onlyInFoldersTA.setEditable(false);
        this.onlyInFoldersTA.setLineWrap(true);
        this.onlyInFoldersTA.setText("");
        JScrollPane jspOI = new JScrollPane(22, 31);
        UiUtilities.setupScrollPane((JScrollPane)jspOI, (JTextArea)this.onlyInFoldersTA);
        jspOI.setPreferredSize(this.onlyInFoldersTA.getPreferredSize());
        int x = 0;
        int y = 0;
        int widthx = 1;
        int widthy = 1;
        double weightx = 1.0;
        double weighty = 1.0;
        double weightxCol2 = 1.0;
        double weightyCol2 = 1.0;
        Insets insetsHeader = new Insets(5, 0, 0, 0);
        Insets insetsLeft = new Insets(0, 20, 0, 0);
        Insets insetsLeftTA = new Insets(0, 40, 0, 0);
        Insets insetsButton = new Insets(0, 10, 0, 0);
        x = 0;
        y = 0;
        widthx = 0;
        widthy = 1;
        this.addComponent(panel, headerPane, x, y, widthx, widthy, weightx, weighty, 18, 2, insetsHeader);
        x = 0;
        y += widthy;
        widthx = 2;
        widthy = 1;
        this.addComponent(panel, this.scanEveryWhereRadio, x, y, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        x = 0;
        y += widthy;
        widthx = 2;
        widthy = 1;
        this.addComponent(panel, this.scanOnlyInRadio, x, y, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        x = 0;
        y += widthy;
        widthx = 1;
        widthy = 1;
        this.addComponent(panel, jspOI, x, y, widthx, widthy, weightx, weighty, 18, 2, insetsLeftTA);
        x += widthx;
        widthx = 1;
        widthy = 1;
        this.addComponent(panel, this.editOnlyInFoldersBtn, x, y, widthx, widthy, weightxCol2, weightyCol2, 23, 0, insetsButton);
        x = 0;
        y += widthy;
        widthx = 2;
        widthy = 1;
        this.addComponent(panel, this.scanExceptInRadio, x, y, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        y += widthy;
        widthx = 1;
        widthy = 1;
        this.addComponent(panel, scanExceptInNoteTextArea, x += 0, y, widthx, widthy, weightx, weighty, 18, 2, insetsLeftTA);
        this.add(panel);
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    private void enableAllComponents(boolean enabled) {
        this.scanEveryWhereRadio.setEnabled(enabled);
        this.scanOnlyInRadio.setEnabled(enabled);
        this.scanExceptInRadio.setEnabled(enabled);
        this.onlyInFoldersTA.setEnabled(false);
        this.editOnlyInFoldersBtn.setEnabled(false);
    }

    private void selectRadioButton(Integer radioIdx) {
        this.radioMap.get(radioIdx).setSelected(true);
    }

    public void enableAppropriate(boolean allEnabled) {
        this.enableAllComponents(allEnabled);
        if (allEnabled && this.scanOnlyInRadio.isSelected()) {
            this.editOnlyInFoldersBtn.setEnabled(true);
            this.onlyInFoldersTA.setEnabled(true);
        }
    }

    private void setSelectedRadioIdx() {
        if (this.scanEveryWhereRadio.isSelected()) {
            this.selectedIdx = ApScanOptions.SCAN_EVERYWHERE;
        } else if (this.scanOnlyInRadio.isSelected()) {
            this.selectedIdx = ApScanOptions.SCAN_ONLY_IN;
        } else if (this.scanExceptInRadio.isSelected()) {
            this.selectedIdx = ApScanOptions.SCAN_EXCEPT_IN;
        }
    }

    private void updatePanel() {
        Integer radioIdx = this.apScanOptionsObj.getScanOption();
        if (radioIdx == null) {
            radioIdx = ApScanOptions.SCAN_EVERYWHERE;
        }
        this.selectRadioButton(radioIdx);
        List<String> listPaths = this.apScanOptionsObj.getFileListingDetails();
        String textTA = this.getStringFromList(listPaths);
        this.onlyInFoldersTA.setText(textTA);
    }

    private String getStringFromList(List<String> listPaths) {
        StringBuffer textTA = new StringBuffer();
        if (null != listPaths && listPaths.size() > 0) {
            for (String str : listPaths) {
                if (textTA.length() > 0) {
                    textTA.append("\n");
                }
                textTA.append(str);
            }
        }
        return textTA.toString();
    }

    private List<String> getListFromString(String strTmp) {
        ArrayList<String> lstFileNames = null;
        String[] linesInTxtArea = null;
        if (null != strTmp && strTmp.length() > 0) {
            linesInTxtArea = strTmp.split("\n");
            lstFileNames = new ArrayList<String>();
            for (int idx = 0; idx < linesInTxtArea.length; ++idx) {
                lstFileNames.add(linesInTxtArea[idx]);
            }
        }
        return lstFileNames;
    }

    private void saveData() {
        this.apScanOptionsObj.setScanOption(this.selectedIdx);
        this.apScanOptionsObj.setFileListingDetails(this.getListFromString(this.onlyInFoldersTA.getText()));
    }

    public boolean valuesValid() {
        String strTmp;
        if (this.scanOnlyInRadio.isSelected() && (null == (strTmp = this.onlyInFoldersTA.getText()) || strTmp.length() == 0)) {
            MessageResources msgRes = MessageResources.getInstance();
            JOptionPane.showMessageDialog(Manager.getFrame(), msgRes.getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacGeneralScanDetailsPane.error.selectOnlyInFiles"), msgRes.getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacApFilePane.errorDlg.title"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_av_global_scan_options";
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileInclusionDialog fileDlg = new FileInclusionDialog(2);
            fileDlg.setIncludeFileList(MacGeneralScanDetailsPane.this.getListFromString(MacGeneralScanDetailsPane.this.onlyInFoldersTA.getText()));
            fileDlg.setVisible(true);
            if (fileDlg.isOk()) {
                MacGeneralScanDetailsPane.this.onlyInFoldersTA.setText(MacGeneralScanDetailsPane.this.getStringFromList(fileDlg.getIncludeFileList()));
            }
        }
    }

    private class RadioItemListener
    implements ItemListener {
        private RadioItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MacGeneralScanDetailsPane.this.enableAppropriate(true);
            MacGeneralScanDetailsPane.this.setSelectedRadioIdx();
        }
    }
}

