/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.ap.MacMountScanSettingsPane;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.SimpleRiskActionsPanel;
import com.sygate.scm.console.ui.policy.av.logicobject.ApActionsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvFileApObject;
import com.sygate.scm.console.ui.policy.av.logicobject.CompressedFilesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacHppBpeObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MountDiskScanOptionsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.OptimizedMountScanObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MacFileScanDetailsPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JPanel enableOptionsPane;
    private JCheckBox enableFSAPChk;
    private JCheckBox lockFSAPEnableChk;
    private JCheckBox scanCompressedChk;
    private SimpleRiskActionsPanel simpleRiskActionsPanel;
    private MacMountScanSettingsPane mdsdPane;
    private AvFileApObject avFileApObject = null;
    private ApActionsObject apActionsObj = null;
    private CompressedFilesObject cmpFilesObj = null;
    private MountDiskScanOptionsObject mdsoObj = null;
    private OptimizedMountScanObject omsObj = null;
    private transient MacHppBpeObject bpeObject = null;
    private JPanel sonarPanel = null;
    private JCheckBox bpeEnableCheckBox;
    private LockCheckBox lockBpeCheckBox;

    public MacFileScanDetailsPane() {
        this.initGUI();
    }

    public void setObject(AvFileApObject avFileApObj, MacHppBpeObject macHppObj) {
        this.avFileApObject = avFileApObj;
        if (avFileApObj != null) {
            this.apActionsObj = avFileApObj.getApActionsObject();
            this.cmpFilesObj = avFileApObj.getCompressedFilesObject();
            this.mdsoObj = avFileApObj.getMountDiskScanOptionsObject();
            this.omsObj = avFileApObj.getOptimizedMountScanObject();
        }
        this.bpeObject = macHppObj;
        this.updatePanel();
        this.enableAppropriate();
        this.setObjectForIncludedPanels();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_av_auto_protect_files_processes_scan_details";
    }

    private void enableAppropriateLocal() {
        boolean enable = this.enableFSAPChk.isSelected();
        this.lockFSAPEnableChk.setEnabled(true);
        this.enableFSAPChk.setEnabled(true);
        this.scanCompressedChk.setEnabled(enable);
        this.bpeEnableCheckBox.setEnabled(true);
        this.lockBpeCheckBox.setEnabled(true);
    }

    private void enableAppropriateIncludedPanes() {
        boolean enable = this.enableFSAPChk.isSelected();
        this.mdsdPane.enableAppropriate(enable);
        this.simpleRiskActionsPanel.enableAppropriate(enable);
    }

    private void setObjectForIncludedPanels() {
        boolean enable = this.enableFSAPChk.isSelected();
        this.mdsdPane.setObject(this.mdsoObj, this.omsObj, enable);
        this.simpleRiskActionsPanel.setObject(this.apActionsObj.getMacApAction());
    }

    private void saveDataForIncludedPanels() {
        this.mdsdPane.save();
        this.apActionsObj.setMacApAction(this.simpleRiskActionsPanel.save());
    }

    private void enableAppropriate() {
        this.enableAppropriateLocal();
        this.enableAppropriateIncludedPanes();
    }

    public boolean valuesValid() {
        return true;
    }

    public void save() {
        this.saveData();
    }

    private void initGUI() {
        VerticalFlowLayout thisLayout = new VerticalFlowLayout(0, 0);
        this.setLayout(thisLayout);
        this.add(this.getEnablePane());
        this.add(this.getMacMountScanSettingsPane());
        this.add(this.getSonarPanel());
    }

    private JPanel getMacMountScanSettingsPane() {
        if (null == this.mdsdPane) {
            this.mdsdPane = new MacMountScanSettingsPane();
        }
        return this.mdsdPane;
    }

    private JPanel getEnablePane() {
        if (this.enableOptionsPane == null) {
            this.enableOptionsPane = new JPanel();
            this.enableOptionsPane.setLayout(new GridBagLayout());
            double weightx = 0.01;
            double weighty = 1.0;
            Insets insets = new Insets(7, 3, 0, 0);
            String lockMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacFileScanDetailsPane.lockMsg");
            this.lockFSAPEnableChk = new JCheckBox(lockMsg, AvConstants.unlockIcon);
            this.lockFSAPEnableChk.setSelectedIcon(AvConstants.lockIcon);
            int x = 0;
            int y = 0;
            this.addComponent(this.enableOptionsPane, this.lockFSAPEnableChk, x, y, 1, 1, weightx, weighty, 18, 2, insets);
            weightx = 0.5;
            insets = new Insets(0, 20, 0, 0);
            this.enableFSAPChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacFileScanDetailsPane.enableFSAutoProtect"));
            AutoProtectEnableItemListener itl = new AutoProtectEnableItemListener();
            this.enableFSAPChk.addItemListener(itl);
            this.addComponent(this.enableOptionsPane, this.enableFSAPChk, x, ++y, 1, 1, weightx, weighty, 18, 2, insets);
            this.simpleRiskActionsPanel = new SimpleRiskActionsPanel(true);
            this.addComponent(this.enableOptionsPane, this.simpleRiskActionsPanel, x, ++y, 1, 1, weightx, weighty, 18, 2, new Insets(0, 40, 10, 0));
            this.scanCompressedChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacFileScanDetailsPane.scanCompressedFiles"));
            this.addComponent(this.enableOptionsPane, this.scanCompressedChk, x, ++y, 1, 1, weightx, weighty, 18, 2, insets);
        }
        return this.enableOptionsPane;
    }

    private JPanel getSonarPanel() {
        if (this.sonarPanel == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppConfidenceSettingsPane.confidenceTitle");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppConfidenceSettingsPane.confidenceDesc");
            this.sonarPanel = new AvTemplatePane(title, desc);
            this.sonarPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            JPanel innerPanel = new JPanel();
            this.lockBpeCheckBox = new LockCheckBox(Boolean.FALSE);
            this.lockBpeCheckBox.setSelectedIcon(AvConstants.lockIcon);
            this.bpeEnableCheckBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.hpp.hpp", "HppBPESettingsPane.enableBPE"));
            innerPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConstraint = new GridBagConstraints();
            gbConstraint.anchor = 23;
            gbConstraint.gridx = 0;
            gbConstraint.gridy = 0;
            gbConstraint.insets = new Insets(7, 1, 0, 0);
            innerPanel.add((Component)this.lockBpeCheckBox, gbConstraint);
            gbConstraint.gridx = 1;
            gbConstraint.gridy = 0;
            gbConstraint.insets = new Insets(7, 0, 0, 0);
            innerPanel.add((Component)this.bpeEnableCheckBox, gbConstraint);
            JPanel westPanel = new JPanel();
            westPanel.setLayout(new BorderLayout());
            westPanel.add((Component)innerPanel, "West");
            this.sonarPanel.add((Component)westPanel, "Center");
        }
        return this.sonarPanel;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    private void updatePanel() {
        this.enableFSAPChk.setSelected(this.avFileApObject.getApFileScanEnabled());
        this.lockFSAPEnableChk.setSelected(this.avFileApObject.getApFileScanLockEnabled());
        this.scanCompressedChk.setSelected(this.cmpFilesObj.getScanInsideCompressedFiles());
        this.lockBpeCheckBox.setSelected(this.bpeObject.isBpeLock());
        this.bpeEnableCheckBox.setSelected(this.bpeObject.isEnabled());
    }

    private void saveData() {
        this.avFileApObject.setApFileScanEnabled(this.enableFSAPChk.isSelected());
        this.avFileApObject.setApFileScanLockEnabled(this.lockFSAPEnableChk.isSelected());
        this.cmpFilesObj.setScanInsideCompressedFiles(this.scanCompressedChk.isSelected());
        this.bpeObject.setBpeLock(this.lockBpeCheckBox.isSelected());
        this.bpeObject.setEnabled(this.bpeEnableCheckBox.isSelected());
        this.saveDataForIncludedPanels();
    }

    private class AutoProtectEnableItemListener
    implements ItemListener {
        private AutoProtectEnableItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MacFileScanDetailsPane.this.enableAppropriate();
        }
    }
}

