/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.AvFileAp;
import com.sygate.scm.common.configobject.schema.BASHBPESettings;
import com.sygate.scm.common.configobject.schema.BASHPolicy;
import com.sygate.scm.common.configobject.schema.MacHppPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.ap.MacFileScanDetailsPane;
import com.sygate.scm.console.ui.policy.av.logicobject.AvFileApObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacHppBpeObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class MacApFilePane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    protected static JFrame frame = new JFrame();
    private MacFileScanDetailsPane macFileScanDetailsPane;
    private AvFileAp avFileAp;
    private AvFileApObject avFileApObject = null;
    private MacHppPolicy macHpp;
    private transient MacHppBpeObject macBpeObject = null;

    public MacApFilePane() {
        this.init();
    }

    private void init() {
        this.macFileScanDetailsPane = new MacFileScanDetailsPane();
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "MacApFilePane.title.scanDetails"), UIUtilities.createScrollPaneWithoutBoard(this.macFileScanDetailsPane));
    }

    public void setFileApObject(AvFileAp fileAp, MacHppPolicy macHpp) throws ConsoleException {
        this.avFileAp = fileAp;
        this.macHpp = macHpp;
        this.updateValues();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }

    public boolean valuesValid() {
        return this.macFileScanDetailsPane.valuesValid();
    }

    public void save() throws ConsoleException {
        BASHBPESettings bpeSetting;
        this.macFileScanDetailsPane.save();
        this.avFileAp.setOptApActions(this.avFileApObject.getApActionsObject().getSchemaObject());
        this.avFileAp.setOptApScanOptions(this.avFileApObject.getApScanOptionsObject().getSchemaObject());
        this.avFileAp.setOptCompressedFiles(this.avFileApObject.getCompressedFilesObject().getSchemaObject());
        this.avFileAp.setOptMountDiskScanOptions(this.avFileApObject.getMountDiskScanOptionsObject().getSchemaObject());
        this.avFileAp.setOptOptimizedMountScan(this.avFileApObject.getOptimizedMountScanObject().getSchemaObject());
        BASHPolicy bash = this.macHpp.getOptBASHPolicy();
        if (bash == null) {
            bash = new BASHPolicy();
            this.macHpp.setOptBASHPolicy(bash);
        }
        if ((bpeSetting = bash.getOptBASHBPESettings()) == null) {
            bpeSetting = new BASHBPESettings();
            bash.setOptBASHBPESettings(bpeSetting);
        }
        bpeSetting.setOptLocked(Boolean.valueOf(this.macBpeObject.isBpeLock()));
        bpeSetting.setOptEnabled(Boolean.valueOf(this.macBpeObject.isEnabled()));
        bpeSetting.setHighConfidenceAction(bpeSetting.getDefHighConfidenceAction());
        bpeSetting.setLowConfidenceAction(bpeSetting.getDefLowConfidenceAction());
    }

    private void updateValues() throws ConsoleException {
        if (this.avFileApObject == null && this.avFileAp != null) {
            this.avFileApObject = new AvFileApObject(this.avFileAp);
        }
        if (this.macBpeObject == null && this.macHpp != null) {
            boolean locked = false;
            boolean enabled = false;
            BASHPolicy bashPolicy = this.macHpp.getOptBASHPolicy();
            if (bashPolicy != null && bashPolicy.getOptBASHBPESettings() != null) {
                locked = bashPolicy.getOptBASHBPESettings().getOptLocked();
                enabled = bashPolicy.getOptBASHBPESettings().getOptEnabled();
            } else {
                locked = new BASHBPESettings().getDefLocked();
                enabled = new BASHBPESettings().getDefEnabled();
            }
            this.macBpeObject = new MacHppBpeObject(locked, enabled);
        }
        this.macFileScanDetailsPane.setObject(this.avFileApObject, this.macBpeObject);
    }
}

