/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.ap.DetectionNotificationPane;
import com.sygate.scm.console.ui.policy.av.ap.EmailMsgPane;
import com.sygate.scm.console.ui.policy.av.logicobject.DetectionNotificationObject;
import com.sygate.scm.console.ui.policy.av.logicobject.EmailMessagesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MailNotificationObject;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import javax.swing.JPanel;

public class LotusNotesNotificationPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private DetectionNotificationPane detectionNotificationPane;
    private EmailMsgPane emailMsgPane;
    private MailNotificationObject notificationObj;

    public LotusNotesNotificationPane() {
        this.init();
    }

    public void setObject(MailNotificationObject notificationObj) {
        this.notificationObj = notificationObj;
        this.updatePanel();
    }

    public boolean valuesValid() {
        if (!this.emailMsgPane.valuesValid(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LotusNotesNotificationPane.label.notes"))) {
            return false;
        }
        return this.detectionNotificationPane.valuesValid(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "LotusNotesNotificationPane.label.notes"));
    }

    public void save() {
        this.saveData();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_msft_lotus_notifications";
    }

    private void init() {
        this.setLayout(new VerticalFlowLayout());
        this.add(this.getDetectionNotificationPane());
        this.add(this.getEmailMsgPane());
    }

    private DetectionNotificationPane getDetectionNotificationPane() {
        if (this.detectionNotificationPane == null) {
            this.detectionNotificationPane = new DetectionNotificationPane();
        }
        return this.detectionNotificationPane;
    }

    private EmailMsgPane getEmailMsgPane() {
        if (this.emailMsgPane == null) {
            this.emailMsgPane = new EmailMsgPane(2);
        }
        return this.emailMsgPane;
    }

    private void updatePanel() {
        this.detectionNotificationPane.setObject(this.notificationObj.getDetectionNotificationObj());
        this.emailMsgPane.setObject(this.notificationObj.getEmailMessagesObject());
    }

    private void saveData() {
        DetectionNotificationObject detectionNotificationObj = this.getDetectionNotificationPane().save();
        this.notificationObj.setDetectionNotificationObj(detectionNotificationObj);
        EmailMessagesObject emailMsgObj = this.getEmailMsgPane().save();
        this.notificationObj.setEmailMessagesObject(emailMsgObj);
    }
}

