/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.FloppySettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.FloppySettingsObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FloppySettingDlg
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] TYPES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FloppySettingDlg.list." + FloppySettings.CLEAN), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FloppySettingDlg.list." + FloppySettings.LEAVE_ALONE)};
    private DefaultComboBoxModel<String> actionModel;
    private AvTemplatePane contentPane;
    private JPanel settingPane;
    private LockCheckBox lockCheckFloppyChk;
    private JCheckBox checkFloppyChk;
    private JComboBox<String> actionsComboBx;
    private FloppySettingsObject floppySettingsObj;

    public FloppySettingDlg(String title) {
        super(title, true, true);
    }

    public void setObject(FloppySettingsObject floppySettingsObj) {
        this.floppySettingsObj = floppySettingsObj;
        this.updatePanel();
    }

    @Override
    protected void commit() {
        this.saveData();
    }

    @Override
    protected final JPanel getContentPanel() {
        if (this.contentPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FloppySettingDlg.label.floppySetting");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FloppySettingDlg.label.floppySettingDesc");
            this.contentPane = new AvTemplatePane(title, desc);
            this.contentPane.add(this.getSettingPane());
        }
        return this.contentPane;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_files_processes_scan_details_floppy_settings";
    }

    private JPanel getSettingPane() {
        if (this.settingPane == null) {
            this.settingPane = new JPanel();
            this.settingPane.setLayout(new BorderLayout());
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            this.lockCheckFloppyChk = new LockCheckBox(Boolean.FALSE);
            this.lockCheckFloppyChk.setSelectedIcon(AvConstants.lockIcon);
            pane.add((Component)this.lockCheckFloppyChk, c);
            c.gridx = 1;
            c.gridy = 0;
            this.checkFloppyChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FloppySettingDlg.checkbox.check"));
            this.checkFloppyChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FloppySettingDlg.this.checkFloppyChk.isSelected()) {
                        FloppySettingDlg.this.actionsComboBx.setEnabled(true);
                    } else {
                        FloppySettingDlg.this.actionsComboBx.setEnabled(false);
                    }
                }
            });
            pane.add((Component)this.checkFloppyChk, c);
            c.gridx = 1;
            c.gridy = 1;
            c.insets = new Insets(5, 20, 0, 0);
            JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FloppySettingDlg.label.when"));
            pane.add((Component)label, c);
            c.gridx = 1;
            c.gridy = 2;
            c.insets = new Insets(5, 20, 0, 0);
            this.actionModel = new DefaultComboBoxModel<String>(TYPES);
            this.actionsComboBx = new JComboBox<String>(this.actionModel);
            pane.add(this.actionsComboBx, c);
            this.settingPane.add((Component)pane, "Before");
        }
        return this.settingPane;
    }

    void updatePanel() {
        this.lockCheckFloppyChk.setSelected(this.floppySettingsObj.getLockCheckFloppiesForBootVirus());
        this.checkFloppyChk.setSelected(this.floppySettingsObj.getCheckFloppiesForBootVirus());
        if (this.floppySettingsObj.getCheckFloppiesForBootVirus()) {
            this.actionsComboBx.setEnabled(true);
            this.actionsComboBx.setSelectedIndex(this.floppySettingsObj.getActionForBootVirus());
        } else {
            this.actionsComboBx.setEnabled(false);
        }
    }

    void saveData() {
        this.floppySettingsObj.setLockCheckFloppiesForBootVirus(this.lockCheckFloppyChk.isSelected());
        this.floppySettingsObj.setCheckFloppiesForBootVirus(this.checkFloppyChk.isSelected());
        if (this.checkFloppyChk.isSelected()) {
            this.floppySettingsObj.setActionForBootVirus(this.actionsComboBx.getSelectedIndex());
        }
    }
}

