/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApAdvancedScanSettings;
import com.sygate.scm.common.configobject.schema.FloppySettings;
import com.sygate.scm.common.configobject.schema.NetworkSettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.ap.AdvancedScanningDlg;
import com.sygate.scm.console.ui.policy.av.ap.NetworkSettingDlg;
import com.sygate.scm.console.ui.policy.av.ap.interop.AutoProtectStateManager;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.DriveTypesLocalPane;
import com.sygate.scm.console.ui.policy.av.common.FileTypesPane;
import com.sygate.scm.console.ui.policy.av.logicobject.AdvancedScanSettingsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.DriveTypesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.FileTypesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.FloppySettingsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.NetworkSettingsObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FileScanDetailsPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private AvTemplatePane scanningPane;
    private AvTemplatePane driveTypePane;
    private FileTypesPane fileTypesPane;
    private DriveTypesLocalPane driveTypesLocalPane;
    private JPanel enablePane;
    private FlowLayout flowLayout = new FlowLayout();
    private JCheckBox enableChk;
    private LockCheckBox lockEnableChk;
    private JCheckBox scanForSecurityRiskChk;
    private LockCheckBox lockScanForSecurityRiskChk;
    private AlwaysEnabledButton advancedScanBtn;
    private ApFileScanDetailsObject fileScanObj;
    private FileTypesObject fileTypesObj;
    private DriveTypesObject driveTypesObj;
    private FloppySettingsObject floppyObj;
    private int platformType = 1;
    AdvancedScanSettingsObject advancedScanObj;
    private AutoProtectStateManager autoProtectStateManager;
    private JCheckBox networkChk;
    private LockCheckBox lockNetworkChk;
    private AlwaysEnabledButton networkBtn;
    private JCheckBox onlyWhenFilesExecutedChk;

    public FileScanDetailsPane(int platformType) {
        this.platformType = platformType;
        this.initGUI();
    }

    public void setApStateManager(AutoProtectStateManager autoProtectStateObject) {
        this.autoProtectStateManager = autoProtectStateObject;
    }

    public void setScanForSecurityRisk(boolean checked) {
        this.scanForSecurityRiskChk.setSelected(checked);
    }

    public void setObject(ApFileScanDetailsObject fileScanObj) {
        this.fileScanObj = fileScanObj;
        this.updatePanel();
        this.enableAppropriate();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platformType) {
            return "linux_sesm_policies_dialog_av_auto_protect_files_processes_scan_details";
        }
        return "sesm_policies_dialog_av_auto_protect_files_processes_scan_details";
    }

    private void enableAllComponents(boolean enable) {
        this.scanForSecurityRiskChk.setEnabled(enable);
        this.advancedScanBtn.setEnabled(enable);
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.networkChk.setEnabled(enable);
            this.onlyWhenFilesExecutedChk.setEnabled(enable);
            this.networkBtn.setEnabled(enable);
        }
    }

    private void enableAppropriate() {
        boolean isApEnabled = this.enableChk.isSelected();
        this.enableAllComponents(isApEnabled);
        this.fileTypesPane.enableAppropriate(isApEnabled);
        this.driveTypesLocalPane.enableAppropriate(isApEnabled);
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.networkBtn.setEnabled(isApEnabled && this.networkChk.isSelected());
            if (!this.networkChk.isSelected()) {
                this.onlyWhenFilesExecutedChk.setEnabled(false);
            }
        }
    }

    private void showAutoProtectWarningMessage() {
        if (!this.enableChk.isSelected()) {
            if (3 != this.platformType && 0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.warningMessage"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.warningTitleText"), 0)) {
                this.enableChk.setSelected(true);
            } else {
                this.enableChk.setSelected(false);
            }
        }
        this.enableAppropriate();
    }

    public void save() {
        this.fileScanObj.lockEnableApFile(this.lockEnableChk.isSelected());
        this.fileScanObj.enableApFile(this.enableChk.isSelected());
        this.fileScanObj.setLockScanSecurityRisks(this.lockScanForSecurityRiskChk.isSelected());
        this.fileScanObj.setScanSecurityRisks(this.scanForSecurityRiskChk.isSelected());
        this.fileTypesPane.save();
        this.driveTypesLocalPane.save();
        this.fileScanObj.setFileTypes(this.fileTypesObj);
        this.driveTypesObj.setLockEnableNetwork(this.lockNetworkChk.isSelected());
        this.driveTypesObj.setEnableNetwork(this.networkChk.isSelected());
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.driveTypesObj.setOnlyWhenFilesExecuted(this.onlyWhenFilesExecutedChk.isSelected());
        }
        this.driveTypesObj.setFloppySettings(this.floppyObj);
        this.fileScanObj.setDriveTypes(this.driveTypesObj);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        northPanel.add(this.getEnablePane());
        northPanel.add(this.getScanningPane());
        northPanel.add(this.getAdvanceScanButtonPanel());
        if (!LicenseObject.getInstance().isSBProduct()) {
            northPanel.add(this.getDriveTypePane());
        }
        this.add((Component)northPanel, "North");
    }

    private JPanel getEnablePane() {
        if (this.enablePane == null) {
            this.enablePane = new JPanel();
            this.enablePane.setLayout(new FlowLayout(0));
            this.flowLayout.setHgap(0);
            this.lockEnableChk = new LockCheckBox(Boolean.FALSE);
            this.lockEnableChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockEnableChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileScanDetailsPane.this.fileScanObj.lockEnableApFile(FileScanDetailsPane.this.lockEnableChk.isSelected());
                    FileScanDetailsPane.this.enableAppropriate();
                    if (FileScanDetailsPane.this.autoProtectStateManager != null) {
                        FileScanDetailsPane.this.autoProtectStateManager.autoProtectStateChanged(FileScanDetailsPane.this.enableChk.isSelected(), FileScanDetailsPane.this.lockEnableChk.isSelected());
                    }
                }
            });
            this.enablePane.add(this.lockEnableChk);
            this.enableChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.label.enableAutoProtect"));
            this.enableChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileScanDetailsPane.this.fileScanObj.enableApFile(FileScanDetailsPane.this.enableChk.isSelected());
                    FileScanDetailsPane.this.showAutoProtectWarningMessage();
                    if (FileScanDetailsPane.this.autoProtectStateManager != null) {
                        FileScanDetailsPane.this.autoProtectStateManager.autoProtectStateChanged(FileScanDetailsPane.this.enableChk.isSelected(), FileScanDetailsPane.this.lockEnableChk.isSelected());
                    }
                }
            });
            this.enablePane.add(this.enableChk);
        }
        return this.enablePane;
    }

    private JPanel getScanningPane() {
        if (this.scanningPane == null) {
            int gridY = 0;
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.label.scanning");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.label.scanningDesc");
            JLabel linuxLabel = null;
            this.scanningPane = new AvTemplatePane(title, desc, linuxLabel);
            JLabel additionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.label.additionalOptions"));
            this.scanForSecurityRiskChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.checkbox.scanForSecurityRisk"));
            this.advancedScanBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.button.advancedScan"));
            JPanel additionPane = new JPanel();
            additionPane.setLayout(new GridBagLayout());
            GridBagConstraints c1 = new GridBagConstraints();
            c1.anchor = 21;
            c1.insets = new Insets(0, 0, 0, 0);
            c1.gridx = 1;
            gridY = 0;
            c1.gridy = gridY++;
            additionPane.add((Component)additionLabel, c1);
            c1.gridx = 0;
            c1.gridy = gridY;
            c1.insets = new Insets(0, 0, 0, 0);
            this.lockScanForSecurityRiskChk = new LockCheckBox(Boolean.FALSE);
            this.lockScanForSecurityRiskChk.setSelectedIcon(AvConstants.lockIcon);
            additionPane.add((Component)this.lockScanForSecurityRiskChk, c1);
            this.lockScanForSecurityRiskChk.setVisible(3 != this.platformType);
            c1.gridx = 1;
            c1.gridy = gridY++;
            c1.insets = new Insets(0, 0, 0, 0);
            additionPane.add((Component)this.scanForSecurityRiskChk, c1);
            if (LicenseObject.getInstance().isSBProduct()) {
                this.initNetworkSettings();
                c1.insets = new Insets(0, 0, 0, 0);
                c1.gridx = 0;
                c1.gridy = gridY;
                additionPane.add((Component)this.lockNetworkChk, c1);
                c1.gridx = 1;
                c1.gridy = gridY;
                c1.insets = new Insets(0, 0, 0, 0);
                additionPane.add((Component)this.networkChk, c1);
            }
            JPanel p2 = new JPanel();
            p2.setLayout(new BorderLayout());
            p2.add((Component)additionPane, "Before");
            JPanel pane = new JPanel();
            pane.setLayout(new VerticalFlowLayout());
            if (3 == this.platformType) {
                this.driveTypesLocalPane = new DriveTypesLocalPane(false, this.platformType);
                this.fileTypesPane = new FileTypesPane(false, false, this.platformType);
                pane.add(this.fileTypesPane);
                pane.add(this.driveTypesLocalPane);
            } else {
                this.driveTypesLocalPane = new DriveTypesLocalPane(true, this.platformType);
                this.fileTypesPane = new FileTypesPane(true, true, this.platformType);
                pane.add(this.fileTypesPane);
            }
            pane.add(p2);
            this.scanningPane.add(pane);
        }
        return this.scanningPane;
    }

    private JPanel getAdvanceScanButtonPanel() {
        this.advancedScanBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.button.advancedScan"));
        this.advancedScanBtn.setVisible(!LicenseObject.getInstance().isSBProduct());
        this.advancedScanBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.title");
                FileScanDetailsPane.this.advancedScanObj = FileScanDetailsPane.this.fileScanObj.getApAdvancedScanSettings() == null ? new AdvancedScanSettingsObject(new ApAdvancedScanSettings()) : new AdvancedScanSettingsObject(FileScanDetailsPane.this.fileScanObj.getApAdvancedScanSettings());
                AdvancedScanningDlg dlg = new AdvancedScanningDlg(title, FileScanDetailsPane.this.fileScanObj, FileScanDetailsPane.this.platformType);
                ReadOnlyUtils.disableDialogIfNeeded(FileScanDetailsPane.this.advancedScanBtn, dlg);
                dlg.setObject(FileScanDetailsPane.this.advancedScanObj);
                ReadOnlyUtils.disableDialogIfNeeded(FileScanDetailsPane.this.advancedScanBtn, dlg);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    dlg.dispose();
                    FileScanDetailsPane.this.fileScanObj.setApAdvancedScanSettings(FileScanDetailsPane.this.advancedScanObj);
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        buttonPanel.setLayout(gridBag);
        buttonPanel.add((Component)this.advancedScanBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 33, 0, 0), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(buttonPanel);
        return panel;
    }

    private void initNetworkSettings() {
        this.lockNetworkChk = new LockCheckBox(Boolean.FALSE);
        this.lockNetworkChk.setSelectedIcon(AvConstants.lockIcon);
        this.lockNetworkChk.setVisible(this.platformType != 3);
        this.networkChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.checkbox.network"));
        this.networkChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileScanDetailsPane.this.enableAppropriate();
            }
        });
        this.onlyWhenFilesExecutedChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.checkbox.network.OnlyWhenFilesExecuted"));
    }

    private JPanel getDriveTypePane() {
        if (this.driveTypePane != null) {
            return this.driveTypePane;
        }
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.label.driveTypes");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.label.driveTypesDesc");
        this.networkBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.button.network"));
        this.networkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dlgTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "NetworkSettingDlg.title");
                NetworkSettingsObject networkSettingsObj = FileScanDetailsPane.this.driveTypesObj.getNetworkSettings() == null ? new NetworkSettingsObject(new NetworkSettings()) : new NetworkSettingsObject(FileScanDetailsPane.this.driveTypesObj.getNetworkSettings());
                NetworkSettingDlg dlg = new NetworkSettingDlg(dlgTitle);
                dlg.setObject(networkSettingsObj);
                ReadOnlyUtils.disableDialogIfNeeded(FileScanDetailsPane.this.networkBtn, dlg);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    dlg.commit();
                    FileScanDetailsPane.this.driveTypesObj.setNetworkSettings(networkSettingsObj);
                }
                dlg.dispose();
            }
        });
        JLabel linuxLabel = null;
        this.driveTypePane = new AvTemplatePane(title, desc, linuxLabel);
        JPanel typePane = new JPanel();
        GridBagLayout grid = new GridBagLayout();
        typePane.setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        this.initNetworkSettings();
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        typePane.add((Component)this.lockNetworkChk, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        typePane.add((Component)this.networkChk, c);
        if (1 == this.platformType) {
            c.insets = new Insets(0, 0, 5, 0);
            c.gridx = 2;
            c.gridy = 0;
            typePane.add((Component)this.networkBtn, c);
            c.insets = new Insets(0, 10, 0, 0);
            c.gridx = 1;
            c.gridy = 1;
            typePane.add((Component)this.onlyWhenFilesExecutedChk, c);
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)typePane, "Before");
        this.driveTypePane.add(p);
        return this.driveTypePane;
    }

    private void updatePanel() {
        this.lockEnableChk.setSelected(this.fileScanObj.isEnableApFileLocked());
        this.enableChk.setSelected(this.fileScanObj.isApFileEnabled());
        if (3 != this.platformType) {
            this.lockScanForSecurityRiskChk.setSelected(this.fileScanObj.getLockScanSecurityRisks());
        }
        this.scanForSecurityRiskChk.setSelected(this.fileScanObj.getScanSecurityRisks());
        this.driveTypesObj = new DriveTypesObject(this.fileScanObj.getDriveTypes());
        this.lockNetworkChk.setSelected(this.driveTypesObj.getLockEnableNetwork());
        this.networkChk.setSelected(this.driveTypesObj.getEnableNetwork());
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.onlyWhenFilesExecutedChk.setSelected(this.driveTypesObj.getOnlyWhenFilesExecuted());
        }
        this.fileTypesObj = new FileTypesObject(this.fileScanObj.getFileTypes());
        this.fileTypesPane.setObject(this.fileTypesObj);
        this.driveTypesLocalPane.setObject(this.driveTypesObj);
        this.floppyObj = this.driveTypesObj.getFloppySettings() == null ? new FloppySettingsObject(new FloppySettings()) : new FloppySettingsObject(this.driveTypesObj.getFloppySettings());
        this.advancedScanObj = this.fileScanObj.getApAdvancedScanSettings() == null ? new AdvancedScanSettingsObject(new ApAdvancedScanSettings()) : new AdvancedScanSettingsObject(this.fileScanObj.getApAdvancedScanSettings());
    }
}

