/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.ap.DetectionNotificationPane;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.logicobject.DetectionNotificationObject;
import com.sygate.scm.console.ui.policy.av.logicobject.FileNotificationObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class FileNotificationPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private DetectionNotificationPane detectionNotificationPane;
    private LockCheckBox lockDisplayResultChk;
    private JCheckBox displayResultChk;
    private FileNotificationObject notificationObj;
    private boolean isMacNotification = false;
    private int platformType = 1;

    public FileNotificationPane(int platformType) {
        this.platformType = platformType;
        this.init();
    }

    public void setObject(FileNotificationObject notificationObj, boolean isMacNotification) {
        this.isMacNotification = isMacNotification;
        this.setObject(notificationObj);
        this.updatePanelForMac();
    }

    public void setObject(FileNotificationObject notificationObj) {
        this.notificationObj = notificationObj;
        this.updatePanel();
    }

    public boolean valuesValid(String key) {
        return this.detectionNotificationPane.valuesValid(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", key));
    }

    public boolean valuesValid() {
        return this.valuesValid("FileNotificationPane.label.fileProc");
    }

    public void save() {
        this.saveData();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_files_processes_notifications";
    }

    private void init() {
        this.setLayout(new VerticalFlowLayout());
        this.add(this.getDetectionNotificationPane());
    }

    private DetectionNotificationPane getDetectionNotificationPane() {
        if (this.detectionNotificationPane == null) {
            this.detectionNotificationPane = new DetectionNotificationPane();
            this.lockDisplayResultChk = new LockCheckBox(Boolean.FALSE);
            this.lockDisplayResultChk.setSelectedIcon(AvConstants.lockIcon);
            this.displayResultChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileNotificationPane.checkbox.displayApResult"));
            JPanel displayResultPane = new JPanel();
            displayResultPane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            displayResultPane.add((Component)this.lockDisplayResultChk, c);
            c.gridx = 1;
            c.gridy = 0;
            displayResultPane.add((Component)this.displayResultChk, c);
            JPanel pane = new JPanel();
            pane.setLayout(new BorderLayout());
            if (3 != this.platformType) {
                pane.add((Component)displayResultPane, "Before");
                this.detectionNotificationPane.add(pane);
            }
        }
        return this.detectionNotificationPane;
    }

    private void updatePanel() {
        this.lockDisplayResultChk.setSelected(this.notificationObj.getLockDisplayApResults());
        this.displayResultChk.setSelected(this.notificationObj.getDisplayApResults());
        this.getDetectionNotificationPane().setObject(this.notificationObj.getDetectionNotificationObj(), this.isMacNotification);
    }

    private void updatePanelForMac() {
        if (this.isMacNotification) {
            this.displayResultChk.setSelected(false);
            this.displayResultChk.setVisible(false);
            this.lockDisplayResultChk.setSelected(false);
            this.lockDisplayResultChk.setVisible(false);
        }
    }

    private void saveData() {
        DetectionNotificationObject detectionNotificationObj = this.getDetectionNotificationPane().save();
        this.notificationObj.setLockDisplayApResults(this.lockDisplayResultChk.isSelected());
        this.notificationObj.setDisplayApResults(this.displayResultChk.isSelected());
        this.notificationObj.setDetectionNotificationObj(detectionNotificationObj);
    }
}

