/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.FolderPrefixGlossaryDialog;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileInclusionDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String AV_AP_PROP = "com.sygate.scm.console.ui.policy.av.ap.avap";
    private JPanel customPathPanel;
    private JButton addButton;
    private JButton removeButton;
    private JComboBox<String> prefixComboBox;
    private JTextField fileNameTextBox;
    private JList<String> fileNameLstBox;
    JPanel newPanel;
    private List<String> includeFileList;
    private String excludeStringForPath = "?*";
    private boolean isPathCaseSensitive = false;
    private String errorMsgTitle = "MacApFilePane.errorDlg.title";
    private Pattern macFilePathPattern = Pattern.compile("(.*)(//)(.*)");
    private int platform = 2;

    public FileInclusionDialog(int platform) {
        super(Manager.getFrame(), MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.title.file"), true);
        this.platform = platform;
        this.setOSSpecificProperties(this.platform);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            UIUtilities.setContainerStatus(this.newPanel, false);
            this.resetOKButton(false);
        }
    }

    public void setOSSpecificProperties(int platform) {
        if (platform == 2) {
            this.excludeStringForPath = "";
            this.isPathCaseSensitive = true;
            this.errorMsgTitle = "MacApFilePane.errorDlg.title.mac";
        }
    }

    private void initialize() {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        this.newPanel = new JPanel();
        this.newPanel.setLayout(new BoxLayout(this.newPanel, 1));
        AvTemplatePane headerPane = new AvTemplatePane(MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.heading.label"), MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.heading.desc"));
        this.newPanel.add(headerPane);
        this.newPanel.add(Box.createVerticalStrut(10));
        this.newPanel.add(this.getCustomPathPanel());
        this.newPanel.add(Box.createVerticalStrut(10));
        cont.add((Component)this.newPanel, "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_av_auto_protect_files_include_exclude_file_list";
    }

    protected JPanel getCustomPathPanel() {
        CustomPathPanelEventListener evl = new CustomPathPanelEventListener();
        String[] values = ConstantValue.getMacDirKeys();
        this.prefixComboBox = new JComboBox<String>(values);
        this.prefixComboBox.addActionListener(evl);
        this.customPathPanel = new JPanel(new GridBagLayout());
        JLabel pLabel = new JLabel(MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.label.prefixVariable"));
        JLabel fLabel = new JLabel(MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.label.file"));
        if (this.fileNameTextBox == null) {
            this.fileNameTextBox = new JTextField("", 20);
        }
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
        doc.setValidator(this.excludeStringForPath, false);
        this.fileNameTextBox.setDocument(doc);
        this.fileNameTextBox.getDocument().addDocumentListener(evl);
        this.fileNameTextBox.putClientProperty("ajaxswing.textfield.documentListener", Boolean.TRUE);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridwidth = 2;
        constraints.insets.left = 10;
        constraints.gridwidth = 1;
        constraints.gridy = 1;
        this.customPathPanel.add((Component)pLabel, constraints);
        constraints.gridy = 2;
        this.customPathPanel.add(this.prefixComboBox, constraints);
        constraints.gridx = 1;
        constraints.insets.left = 5;
        this.customPathPanel.add((Component)FolderPrefixGlossaryDialog.createFolderGlossaryButton(ConstantValue.getMacDirKeys()), constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets.left = 10;
        this.customPathPanel.add((Component)fLabel, constraints);
        constraints.gridy = 2;
        constraints.ipadx = 200;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.customPathPanel.add((Component)this.fileNameTextBox, constraints);
        JLabel fLabel1 = new JLabel(MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.label.file1"));
        constraints.gridy = 3;
        this.customPathPanel.add((Component)fLabel1, constraints);
        JLabel fLabel2 = new JLabel(MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.label.file2"));
        constraints.gridy = 4;
        this.customPathPanel.add((Component)fLabel2, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 2;
        constraints.insets.left = 10;
        constraints.insets.right = 5;
        constraints.fill = 1;
        constraints.anchor = 18;
        this.addButton = new JButton(MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.button.add"));
        this.addButton.addActionListener(evl);
        this.customPathPanel.add((Component)this.addButton, constraints);
        this.fileNameLstBox = new JList(new DefaultListModel());
        this.fileNameLstBox.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(22, 31);
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, this.fileNameLstBox);
        scrollPane.setPreferredSize(new Dimension(600, 100));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 3;
        constraints.gridheight = 3;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets.top = 10;
        constraints.insets.left = 10;
        this.customPathPanel.add((Component)scrollPane, constraints);
        constraints.gridx = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets.left = 10;
        constraints.insets.right = 5;
        this.removeButton = new JButton(MSGRES.getString(AV_AP_PROP, "FileInclusionDialog.button.remove"));
        this.removeButton.addActionListener(evl);
        this.customPathPanel.add((Component)this.removeButton, constraints);
        return this.customPathPanel;
    }

    boolean inPrefixList(String str) {
        String[] values = ConstantValue.getDirKeys();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isValidate() {
        boolean isAtLeastOnePathSelected = false;
        if (this.fileNameLstBox.getModel().getSize() > 0) {
            isAtLeastOnePathSelected = true;
        }
        if (!isAtLeastOnePathSelected) {
            this.showValidationError("FileInclusionDialog.errMsg.emptySelection");
        }
        return isAtLeastOnePathSelected;
    }

    @Override
    protected void commit() {
        this.includeFileList = new ArrayList<String>();
        DefaultListModel dlm = (DefaultListModel)this.fileNameLstBox.getModel();
        Enumeration ele = dlm.elements();
        String obj = null;
        while (ele.hasMoreElements()) {
            obj = (String)ele.nextElement();
            this.includeFileList.add(obj);
        }
    }

    private String getFileNameText() {
        String fileName = this.fileNameTextBox.getText().trim();
        if (this.platform != 2 && fileName.contains("\\n")) {
            fileName = fileName.replace("\\n", "\\N");
        }
        return fileName;
    }

    private void enableAddButtonInCustomPanel() {
        if (this.prefixComboBox.getSelectedIndex() == 0 && this.getFileNameText().length() == 0) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    private void enableRemoveButtonInCustomPanel() {
        if (this.fileNameLstBox.getModel().getSize() == 0) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    private boolean isDuplicatePath(String customPath) {
        boolean result = false;
        if (customPath != null && customPath.length() > 0) {
            DefaultListModel dlm = (DefaultListModel)this.fileNameLstBox.getModel();
            String path = null;
            for (int cnt = 0; cnt < dlm.getSize(); ++cnt) {
                path = (String)dlm.getElementAt(cnt);
                if (this.isPathCaseSensitive) {
                    if (!customPath.equals(path)) continue;
                    result = true;
                    this.showValidationError("FileInclusionDialog.errMsg.duplicatePath");
                    break;
                }
                if (!customPath.equalsIgnoreCase(path)) continue;
                result = true;
                this.showValidationError("FileInclusionDialog.errMsg.duplicatePath");
                break;
            }
        }
        return result;
    }

    protected boolean isValidPath() {
        Matcher m = this.macFilePathPattern.matcher(this.getFileNameText());
        if (m.matches()) {
            this.showValidationError("FileInclusionDialog.errMsg.inValidPath");
            return false;
        }
        if (ConstantValue.getMacDirKeysByIndex((int)0).equals(this.prefixComboBox.getSelectedItem())) {
            if (this.getFileNameText().trim().charAt(0) != '/') {
                this.showValidationError("FileInclusionDialog.errMsg.inValidPath");
                return false;
            }
        } else if (!StringUtilities.isEmpty((String)this.getFileNameText()) && this.getFileNameText().trim().charAt(0) == '/') {
            this.showValidationError("FileInclusionDialog.errMsg.inValidPath");
            return false;
        }
        return true;
    }

    private void showValidationError(String errMsg) {
        JOptionPane.showMessageDialog(this, MSGRES.getString(AV_AP_PROP, errMsg), MSGRES.getString(AV_AP_PROP, this.errorMsgTitle), 0);
    }

    public List<String> getIncludeFileList() {
        return this.includeFileList;
    }

    public void setIncludeFileList(List<String> includeFileList) {
        PrivilegeContext context;
        if (null != includeFileList && includeFileList.size() > 0) {
            DefaultListModel dlm = (DefaultListModel)this.fileNameLstBox.getModel();
            for (String str : includeFileList) {
                dlm.addElement(str);
            }
        }
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)(context = DataobjectManager.getInstance().getCurrentPrivilegeContext()))) {
            return;
        }
        this.enableAddButtonInCustomPanel();
        this.enableRemoveButtonInCustomPanel();
    }

    private class CustomPathPanelEventListener
    implements ActionListener,
    DocumentListener {
        private CustomPathPanelEventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel dlm = (DefaultListModel)FileInclusionDialog.this.fileNameLstBox.getModel();
            if (e.getSource().equals(FileInclusionDialog.this.addButton)) {
                Object prefix = "";
                if (FileInclusionDialog.this.prefixComboBox.getSelectedIndex() != 0) {
                    prefix = "%" + FileInclusionDialog.this.prefixComboBox.getSelectedItem() + "%";
                }
                String finalStr = (String)prefix + FileInclusionDialog.this.getFileNameText();
                if (FileInclusionDialog.this.isValidPath() && !FileInclusionDialog.this.isDuplicatePath(finalStr)) {
                    dlm.addElement(finalStr);
                    FileInclusionDialog.this.enableRemoveButtonInCustomPanel();
                }
            } else if (e.getSource().equals(FileInclusionDialog.this.removeButton)) {
                List<String> selectedValues = FileInclusionDialog.this.fileNameLstBox.getSelectedValuesList();
                String[] selectedObjs = selectedValues.toArray(new String[selectedValues.size()]);
                if (selectedObjs != null && selectedObjs.length > 0) {
                    for (String obj : selectedObjs) {
                        dlm.removeElement(obj);
                    }
                }
                FileInclusionDialog.this.enableRemoveButtonInCustomPanel();
            } else if (e.getSource().equals(FileInclusionDialog.this.prefixComboBox)) {
                FileInclusionDialog.this.enableAddButtonInCustomPanel();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FileInclusionDialog.this.enableAddButtonInCustomPanel();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FileInclusionDialog.this.enableAddButtonInCustomPanel();
        }
    }
}

