/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.FileCache;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class FileCachePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FileCache fileCache;
    private AvTemplatePane contentPane;
    private JPanel settingPane;
    private LockCheckBox lockEnableChk;
    private JCheckBox enableChk;
    private JCheckBox enableRescanChk;
    private JRadioButton defaultRBtn;
    private JRadioButton customRBtn;
    private JSpinner entrySpinner;
    private JSpinner sizeSpinner;
    private JLabel entriesLabel;
    private JLabel bytesLabel;
    private int platformType = 1;

    public FileCachePanel(int platformType) {
        this.platformType = platformType;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getContentPanel(), "Center");
    }

    public void setObject(FileCache fileCache) {
        this.fileCache = fileCache;
        this.updatePanel();
        this.enableAppropriate();
    }

    public void setCustomRBtn(boolean selected) {
        this.customRBtn.setSelected(selected);
    }

    public void save() {
        this.fileCache.setOptLockEnableFileCache(Boolean.valueOf(this.lockEnableChk.isSelected()));
        this.fileCache.setOptEnable(Boolean.valueOf(this.enableChk.isSelected()));
        this.fileCache.setOptUseDefaultCacheSize(Boolean.valueOf(this.defaultRBtn.isSelected()));
        if (this.customRBtn.isSelected()) {
            Number i = (Number)this.entrySpinner.getValue();
            this.fileCache.setOptFileCacheEntries(Long.valueOf(i.longValue()));
            Number size = (Number)this.sizeSpinner.getValue();
            this.fileCache.setOptFileCacheSize(Long.valueOf(size.longValue()));
        }
        this.fileCache.setOptRescanOnDefReload(Boolean.valueOf(this.enableRescanChk.isSelected()));
    }

    private JPanel getContentPanel() {
        if (this.contentPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.label.fileCache");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.label.fileCacheDesc");
            this.contentPane = new AvTemplatePane(title, desc);
            this.contentPane.add(this.getSettingPane());
        }
        return this.contentPane;
    }

    private JPanel getSettingPane() {
        if (this.settingPane == null) {
            this.settingPane = new JPanel();
            this.settingPane.setLayout(new BorderLayout());
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            this.lockEnableChk = new LockCheckBox(Boolean.FALSE);
            this.lockEnableChk.setSelectedIcon(AvConstants.lockIcon);
            pane.add((Component)this.lockEnableChk, c);
            c.gridwidth = 2;
            c.gridx = 1;
            c.gridy = 0;
            this.enableChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.checkbox.enable"));
            this.enableChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileCachePanel.this.enableAppropriate();
                }
            });
            pane.add((Component)this.enableChk, c);
            this.defaultRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.radio.useDefault"));
            this.defaultRBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileCachePanel.this.enableAppropriate();
                }
            });
            this.customRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.radio.custom"));
            this.customRBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileCachePanel.this.enableAppropriate();
                }
            });
            ButtonGroup group = new ButtonGroup();
            group.add(this.defaultRBtn);
            group.add(this.customRBtn);
            c.gridwidth = 3;
            c.gridx = 1;
            c.gridy = 1;
            c.insets = new Insets(5, 20, 0, 0);
            pane.add((Component)this.defaultRBtn, c);
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 2;
            pane.add((Component)this.customRBtn, c);
            c.gridx = 2;
            c.gridy = 2;
            c.insets = new Insets(5, 5, 0, 0);
            SpinnerNumberModel entryModel = new SpinnerNumberModel(this.fileCache == null ? 3000 : this.fileCache.getDefFileCacheEntries().intValue(), 0, 65535, 1000);
            SpinnerNumberModel sizeModel = new SpinnerNumberModel(this.fileCache == null ? 0 : this.fileCache.getDefFileCacheSize().intValue(), 0, 65535, 1024);
            this.entrySpinner = new JSpinner(entryModel);
            this.sizeSpinner = new JSpinner(sizeModel);
            UIUtilities.enableOnlyValidEdits(this.entrySpinner);
            UIUtilities.enableOnlyValidEdits(this.sizeSpinner);
            pane.add((Component)this.entrySpinner, c);
            this.entriesLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.label.entries"));
            this.bytesLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.label.cacheSize"));
            this.enableRescanChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileCacheDlg.checkbox.enableRescan"));
            c.gridx = 3;
            c.gridy = 2;
            c.insets = new Insets(5, 5, 0, 0);
            if (1 == this.platformType) {
                pane.add((Component)this.entriesLabel, c);
                c.gridwidth = 2;
                c.gridx = 1;
                c.gridy = 3;
                pane.add((Component)this.enableRescanChk, c);
            } else if (3 == this.platformType) {
                pane.add((Component)this.entriesLabel, c);
            }
            this.settingPane.add((Component)pane, "Before");
        }
        return this.settingPane;
    }

    private void enableAppropriate() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return;
        }
        boolean allEnable = this.enableChk.isSelected();
        this.defaultRBtn.setEnabled(allEnable);
        this.customRBtn.setEnabled(allEnable);
        this.entrySpinner.setEnabled(allEnable && this.customRBtn.isSelected());
        this.sizeSpinner.setEnabled(allEnable && this.customRBtn.isSelected());
        this.enableRescanChk.setEnabled(allEnable);
    }

    public void updatePanel() {
        Boolean b = this.fileCache.getOptLockEnableFileCache();
        if (b == null) {
            b = this.fileCache.getDefLockEnableFileCache();
        }
        this.lockEnableChk.setSelected(b);
        b = this.fileCache.getOptEnable();
        if (b == null) {
            b = this.fileCache.getDefEnable();
        }
        this.enableChk.setSelected(b);
        b = this.fileCache.getOptRescanOnDefReload();
        if (b == null) {
            b = this.fileCache.getDefRescanOnDefReload();
        }
        this.enableRescanChk.setSelected(b);
        b = this.fileCache.getOptUseDefaultCacheSize();
        if (b == null) {
            b = this.fileCache.getDefUseDefaultCacheSize();
        }
        if (b.booleanValue()) {
            this.defaultRBtn.setSelected(true);
        } else {
            this.customRBtn.setSelected(true);
        }
        if (this.customRBtn.isSelected()) {
            this.entrySpinner.setValue(this.fileCache.getOptFileCacheEntries() == null ? this.fileCache.getDefFileCacheEntries() : this.fileCache.getOptFileCacheEntries());
            this.sizeSpinner.setValue(this.fileCache.getOptFileCacheSize() == null ? this.fileCache.getDefFileCacheSize() : this.fileCache.getOptFileCacheSize());
        }
        this.enableAppropriate();
    }
}

