/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.EmailServerConfig;
import com.sygate.scm.common.configobject.schema.InfectionInfo;
import com.sygate.scm.common.configobject.schema.MailContent;
import com.sygate.scm.common.configobject.schema.MailToOthers;
import com.sygate.scm.common.configobject.schema.MailToSender;
import com.sygate.scm.common.configobject.schema.MessageBody;
import com.sygate.scm.common.configobject.schema.WarningMessage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.EmailMessagesObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.NotificationConverter;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EmailMsgPane
extends AvTemplatePane {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.label.emailMsg");
    private static final String DESC = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.label.emailMsgDesc");
    public static final int WEB_MAIL_NOTIFICATION = 1;
    public static final int LOTUS_NOTES_NOTIFICATION = 2;
    public static final int EXCHANGE_NOTIFICATION = 3;
    private JPanel contentPane;
    private LockCheckBox lockInsertChk;
    private LockCheckBox lockSendToSenderChk;
    private LockCheckBox lockSendToOtherChk;
    private JCheckBox insertChk;
    private JCheckBox sendToSenderChk;
    private JCheckBox sendToOtherChk;
    private AlwaysEnabledButton insertComposeBtn;
    private AlwaysEnabledButton sendToSenderComposeBtn;
    private AlwaysEnabledButton sendToOtherComposeBtn;
    private EmailMessagesObject emailMsgObj;
    private WarningMessage warningMsg;
    private MailToSender mailToSender;
    private MailToOthers mailToOthers;
    private int ownerType;

    public EmailMsgPane() {
        super(TITLE, DESC);
        this.add(this.getContentPane());
    }

    public EmailMsgPane(int type) {
        super(TITLE, DESC);
        this.add(this.getContentPane());
        this.ownerType = type;
    }

    public EmailMessagesObject save() {
        this.emailMsgObj.setInsertWarningLocked(this.lockInsertChk.isSelected());
        this.emailMsgObj.setInsertWarning(this.insertChk.isSelected());
        this.emailMsgObj.setSendToSenderLocked(this.lockSendToSenderChk.isSelected());
        this.emailMsgObj.setSendToSender(this.sendToSenderChk.isSelected());
        this.emailMsgObj.setSendToOtherLocked(this.lockSendToOtherChk.isSelected());
        this.emailMsgObj.setSendToOther(this.sendToOtherChk.isSelected());
        this.emailMsgObj.setWarningMsg(this.warningMsg);
        this.emailMsgObj.setMailToSender(this.mailToSender);
        this.emailMsgObj.setMailToOthers(this.mailToOthers);
        return this.emailMsgObj;
    }

    private static String getTemplateRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.util.template.template", key);
    }

    private JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.lockInsertChk = new LockCheckBox(Boolean.FALSE);
            this.lockInsertChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockSendToSenderChk = new LockCheckBox(Boolean.FALSE);
            this.lockSendToSenderChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockSendToOtherChk = new LockCheckBox(Boolean.FALSE);
            this.lockSendToOtherChk.setSelectedIcon(AvConstants.lockIcon);
            this.insertChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.checkbox.insert"));
            this.insertChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmailMsgPane.this.insertComposeBtn.setEnabled(EmailMsgPane.this.insertChk.isSelected());
                }
            });
            this.sendToSenderChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.checkbox.sendToSender"));
            this.sendToSenderChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmailMsgPane.this.sendToSenderComposeBtn.setEnabled(EmailMsgPane.this.sendToSenderChk.isSelected());
                    if (EmailMsgPane.this.sendToSenderChk.isSelected() && EmailMsgPane.this.mailToSender.getOptMailContent() == null) {
                        MailContent mailContent = new MailContent();
                        EmailMsgPane.this.setDefaultMailContentsToSender(mailContent);
                        EmailMsgPane.this.mailToSender.setOptMailContent(mailContent);
                    }
                }
            });
            this.sendToOtherChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.checkbox.sendToOther"));
            this.sendToOtherChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmailMsgPane.this.sendToOtherComposeBtn.setEnabled(EmailMsgPane.this.sendToOtherChk.isSelected());
                    if (EmailMsgPane.this.sendToOtherChk.isSelected() && EmailMsgPane.this.mailToOthers.getOptMailContent() == null) {
                        MailContent mailContent = new MailContent();
                        EmailMsgPane.this.setDefaultMailContentsToOthers(mailContent);
                        EmailMsgPane.this.mailToOthers.setOptMailContent(mailContent);
                    }
                }
            });
            this.insertComposeBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.button.warning"));
            this.insertComposeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InsertWarningDialog iwd = new InsertWarningDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "InsertWarningDialog.label.warningTitle"));
                    iwd.setObject(EmailMsgPane.this.warningMsg);
                    ReadOnlyUtils.disableDialogIfNeeded(EmailMsgPane.this.insertComposeBtn, iwd);
                    iwd.setVisible(true);
                    if (iwd.isOk()) {
                        EmailMsgPane.this.warningMsg = iwd.getWarningMsg();
                    }
                }
            });
            this.sendToSenderComposeBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.button.sender"));
            this.sendToSenderComposeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComposeEmailDialog ced = new ComposeEmailDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ComposeEmailDialog.label.emailTitle"));
                    ced.setObject(EmailMsgPane.this.mailToSender);
                    ced.setVisible(true);
                    if (ced.isOk()) {
                        EmailMsgPane.this.mailToSender = ced.getMailToSender();
                    }
                }
            });
            this.sendToOtherComposeBtn = new AlwaysEnabledButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.button.recipient"));
            this.sendToOtherComposeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComposeEmailToAddressesDialog ced = new ComposeEmailToAddressesDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ComposeEmailToAddressesDialog.label.emailTitle"));
                    ced.setObject(EmailMsgPane.this.mailToOthers);
                    ced.setVisible(true);
                    if (ced.isOk()) {
                        EmailMsgPane.this.mailToOthers = ced.getMailToOthers();
                    }
                }
            });
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)this.lockInsertChk, c);
            c.gridx = 1;
            c.gridy = 0;
            pane.add((Component)this.insertChk, c);
            c.gridx = 2;
            c.gridy = 0;
            c.insets = new Insets(5, 20, 0, 0);
            pane.add((Component)this.insertComposeBtn, c);
            c.gridx = 0;
            c.gridy = 1;
            c.insets = new Insets(5, 0, 0, 0);
            pane.add((Component)this.lockSendToSenderChk, c);
            c.gridx = 1;
            c.gridy = 1;
            pane.add((Component)this.sendToSenderChk, c);
            c.gridx = 2;
            c.gridy = 1;
            c.insets = new Insets(5, 20, 0, 0);
            pane.add((Component)this.sendToSenderComposeBtn, c);
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(5, 0, 0, 0);
            pane.add((Component)this.lockSendToOtherChk, c);
            c.gridx = 1;
            c.gridy = 2;
            pane.add((Component)this.sendToOtherChk, c);
            c.gridx = 2;
            c.gridy = 2;
            c.insets = new Insets(5, 20, 0, 0);
            pane.add((Component)this.sendToOtherComposeBtn, c);
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.add((Component)pane, "Before");
        }
        return this.contentPane;
    }

    private void updatePanel() {
        this.lockInsertChk.setSelected(this.emailMsgObj.isInsertWarningLocked());
        this.insertChk.setSelected(this.emailMsgObj.isInsertWarning());
        this.lockSendToSenderChk.setSelected(this.emailMsgObj.isSendToSenderLocked());
        this.sendToSenderChk.setSelected(this.emailMsgObj.isSendToSender());
        this.lockSendToOtherChk.setSelected(this.emailMsgObj.isSendToOtherLocked());
        this.sendToOtherChk.setSelected(this.emailMsgObj.isSendToOther());
        this.warningMsg = this.emailMsgObj.getWarningMsg();
        this.mailToSender = this.emailMsgObj.getMailToSender();
        this.mailToOthers = this.emailMsgObj.getMailToOthers();
        this.insertComposeBtn.setEnabled(this.insertChk.isSelected());
        this.sendToSenderComposeBtn.setEnabled(this.sendToSenderChk.isSelected());
        this.sendToOtherComposeBtn.setEnabled(this.sendToOtherChk.isSelected());
    }

    private void setDefaultMailContentsToSender(MailContent mailContentToSender) {
        this.setDefaultMailContents(mailContentToSender, true);
    }

    private void setDefaultMailContentsToOthers(MailContent mailContentToOthers) {
        this.setDefaultMailContents(mailContentToOthers, false);
    }

    private void setDefaultMailContents(MailContent mailContent, boolean isSender) {
        String defaultDbSubject = EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailSubject$$");
        String defaultDbMsgBody = isSender ? EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailMsgBodyToSender$$") : EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailMsgBody$$");
        String defaultDbInfectionInfo = EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailInfectionInfo$$");
        mailContent.setOptSubject(defaultDbSubject);
        MessageBody messageBody = new MessageBody();
        messageBody.setContent(defaultDbMsgBody);
        mailContent.setOptMessageBody(messageBody);
        InfectionInfo infectionInfo = new InfectionInfo();
        infectionInfo.setContent(defaultDbInfectionInfo);
        mailContent.setOptInfectionInfo(infectionInfo);
    }

    private boolean showEmailServerConfig() {
        return this.ownerType != 2 && this.ownerType != 3 && this.ownerType != 1;
    }

    public void setObject(EmailMessagesObject emailMsgObj) {
        this.emailMsgObj = emailMsgObj;
        this.updatePanel();
    }

    public boolean valuesValid(String key) {
        if (this.sendToSenderChk.isSelected() && this.mailToSender.getOptMailContent() == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), key + "\n\n" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.label.senderMailEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.label.error"), 0);
            return false;
        }
        if (this.sendToOtherChk.isSelected() && (this.mailToOthers.getOptMailContent() == null || StringUtilities.isEmpty((String)this.mailToOthers.getEmailAddress()))) {
            JOptionPane.showMessageDialog(Manager.getFrame(), key + "\n\n" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.label.otherMailEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.label.error"), 0);
            return false;
        }
        return true;
    }

    private static class InsertWarningDialog
    extends AvDialogBase {
        private static final long serialVersionUID = 1L;
        private JCheckBox changeSubjBox;
        private EmailContentPanel mailPanel;
        private WarningMessage warningMessage;
        private MailContent mailContent;

        public InsertWarningDialog(String title) {
            super(title, true, true);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_auto_protect_notifications_email_msg_insert_warning";
        }

        @Override
        protected void commit() {
            this.warningMessage.setOptChangeSubject(Boolean.valueOf(this.changeSubjBox.isSelected()));
            this.mailPanel.saveObject();
            this.warningMessage.setOptMailContent(this.mailContent);
        }

        @Override
        protected JPanel getContentPanel() {
            this.setupComponents();
            AvTemplatePane result = new AvTemplatePane(this.getRes("label.warningTitle"), this.getRes("label.warningDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)this.changeSubjBox, c);
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 1;
            p.add((Component)this.mailPanel, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            result.add(temp);
            return result;
        }

        private void enableAppropriate() {
            this.mailPanel.enableSubjectField(this.changeSubjBox.isSelected());
        }

        private void updatePanel() {
            Boolean b = this.warningMessage.getOptChangeSubject();
            if (b == null) {
                b = this.warningMessage.getDefChangeSubject();
            }
            this.changeSubjBox.setSelected(b);
            this.mailPanel.setObject(this.mailContent);
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "InsertWarningDialog." + key);
        }

        private void setupComponents() {
            this.changeSubjBox = new JCheckBox(this.getRes("box.changeSubj"));
            this.changeSubjBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.enableAppropriate();
                }
            });
            this.mailPanel = new EmailContentPanel(true, false);
        }

        public void setObject(WarningMessage warningMsg) {
            this.warningMessage = warningMsg;
            this.mailContent = warningMsg.getOptMailContent();
            if (this.mailContent == null) {
                this.mailContent = new MailContent();
            }
            this.updatePanel();
            this.enableAppropriate();
        }

        public WarningMessage getWarningMsg() {
            return this.warningMessage;
        }
    }

    private static class EmailContentPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField subjectField;
        private JTextArea msgBodyArea;
        private JTextArea infectionArea;
        private MailContent mailContent;
        private MessageBody msgBody;
        private InfectionInfo infectionInfo;
        private boolean isToSender;
        private boolean showDefaults;
        private NotificationConverter msgConverter;

        public EmailContentPanel(boolean showDefaults, boolean toSender) {
            this.showDefaults = showDefaults;
            this.isToSender = toSender;
            this.msgConverter = new NotificationConverter(0);
            this.setupPanel();
        }

        public void saveObject() {
            String dbSubject = this.msgConverter.convertNotificationFormat(0, this.subjectField.getText());
            String dbMsgBody = this.msgConverter.convertNotificationFormat(0, this.msgBodyArea.getText());
            String dbInfectionInfo = this.msgConverter.convertNotificationFormat(0, this.infectionArea.getText());
            this.mailContent.setOptSubject(dbSubject);
            this.msgBody.setContent(dbMsgBody);
            this.mailContent.setOptMessageBody(this.msgBody);
            this.infectionInfo.setContent(dbInfectionInfo);
            this.mailContent.setOptInfectionInfo(this.infectionInfo);
        }

        private void updatePanel() {
            String defaultDbSubject = EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailSubject$$");
            String defaultDbMsgBody = this.isToSender ? EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailMsgBodyToSender$$") : EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailMsgBody$$");
            String defaultDbInfectionInfo = EmailMsgPane.getTemplateRes("$$I18N.PolicyTmpl.ApEmailInfectionInfo$$");
            String defaultUiSubject = this.msgConverter.convertNotificationFormat(1, defaultDbSubject);
            String defaultUiMsgBody = this.msgConverter.convertNotificationFormat(1, defaultDbMsgBody);
            String defaultUiInfectionInfo = this.msgConverter.convertNotificationFormat(1, defaultDbInfectionInfo);
            String dbSubject = this.mailContent.getOptSubject();
            if (dbSubject != null) {
                String uiSubject = this.msgConverter.convertNotificationFormat(1, dbSubject);
                this.subjectField.setText(uiSubject);
            } else if (this.showDefaults) {
                this.subjectField.setText(defaultUiSubject);
            }
            String dbMsgBody = this.msgBody.getContent();
            if (dbMsgBody != null) {
                String uiMsgBody = this.msgConverter.convertNotificationFormat(1, dbMsgBody);
                this.msgBodyArea.setText(uiMsgBody);
            } else if (this.showDefaults) {
                this.msgBodyArea.setText(defaultUiMsgBody);
            }
            String dbInfectionInfo = this.infectionInfo.getContent();
            if (dbInfectionInfo != null) {
                String uiInfectionInfo = this.msgConverter.convertNotificationFormat(1, dbInfectionInfo);
                this.infectionArea.setText(uiInfectionInfo);
            } else if (this.showDefaults) {
                this.infectionArea.setText(defaultUiInfectionInfo);
            }
        }

        private void setupComponents() {
            this.subjectField = new JTextField();
            this.msgBodyArea = new JTextArea();
            this.msgBodyArea.setRows(5);
            this.msgBodyArea.setLineWrap(true);
            this.msgBodyArea.setWrapStyleWord(true);
            this.infectionArea = new JTextArea();
            this.infectionArea.setRows(5);
            this.infectionArea.setColumns(45);
            this.infectionArea.setLineWrap(true);
            this.infectionArea.setWrapStyleWord(true);
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailContentPanel." + key);
        }

        private void setupPanel() {
            this.setupComponents();
            this.setLayout(new VerticalFlowLayout(5, 1));
            if (!this.showDefaults) {
                this.add(new JLabel(this.getRes("label.subj")));
            }
            this.add(this.subjectField);
            this.add(new JLabel(this.getRes("label.msgBody")));
            JScrollPane msgBodyAreaScrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)msgBodyAreaScrollPane, (JTextArea)this.msgBodyArea);
            this.add(msgBodyAreaScrollPane);
            this.add(new JLabel(this.getRes("label.infection")));
            JScrollPane infectionAreaScrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)infectionAreaScrollPane, (JTextArea)this.infectionArea);
            this.add(infectionAreaScrollPane);
        }

        public boolean valuesValid() {
            if (this.subjectField.getText().trim().length() == 0 || this.msgBodyArea.getText().trim().length() == 0 || this.infectionArea.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.errEnterSubjectMessageBodyInfectionInfo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.Error"), 0);
                return false;
            }
            return true;
        }

        public void enableSubjectField(boolean enable) {
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            if (enable && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
                return;
            }
            this.subjectField.setEnabled(enable);
        }

        public void setObject(MailContent mailContent) {
            this.mailContent = mailContent;
            this.msgBody = mailContent.getOptMessageBody();
            if (this.msgBody == null) {
                this.msgBody = new MessageBody();
            }
            this.infectionInfo = mailContent.getOptInfectionInfo();
            if (this.infectionInfo == null) {
                this.infectionInfo = new InfectionInfo();
            }
            this.updatePanel();
        }
    }

    private class ComposeEmailToAddressesDialog
    extends ComposeEmailDialog {
        private static final long serialVersionUID = 1L;
        private JTextField newAddressField;
        private DefaultListModel<String> model;
        private JList<String> addressList;
        private JButton addButton;
        private JButton removeButton;
        private JTabbedPane tabbedPane;
        private MailToOthers toOthers;

        public ComposeEmailToAddressesDialog(String title) {
            super(title);
        }

        @Override
        protected void help() {
            HelpUtil.showHelp(((ContentSensitiveHelpPage)((Object)this.tabbedPane.getSelectedComponent())).getContentSensitiveHelpToken());
        }

        @Override
        protected boolean isValidate() {
            if (this.model.getSize() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.errEnterEmailAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.Error"), 0);
                return false;
            }
            return super.isValidate();
        }

        @Override
        protected void updatePanel() {
            super.updatePanel();
            this.model.removeAllElements();
            if (this.toOthers.getEmailAddress() != null && this.toOthers.getEmailAddress().trim().length() > 0) {
                String[] addresses = this.toOthers.getEmailAddress().split(";");
                for (int i = 0; i < addresses.length; ++i) {
                    this.model.addElement(addresses[i]);
                }
            }
        }

        @Override
        protected void commit() {
            this.msgPanel.saveObject();
            this.toOthers.setOptMailContent(this.mailContent);
            if (EmailMsgPane.this.showEmailServerConfig()) {
                this.saveServerConfig();
                this.toOthers.setOptEmailServerConfig(this.serverConfig);
            }
            StringBuffer sb = new StringBuffer();
            int l = this.model.getSize();
            for (int i = 0; i < l; ++i) {
                sb.append(this.model.getElementAt(i)).append(";");
            }
            this.toOthers.setEmailAddress(sb.substring(0, sb.length() - 1));
        }

        @Override
        protected JTabbedPane getTabbedPane() {
            this.tabbedPane = super.getTabbedPane();
            this.setupComponents();
            int position = EmailMsgPane.this.ownerType == 1 ? 1 : 0;
            this.tabbedPane.insertTab(this.getRes("label.address"), null, new AddressPanel(), "", position);
            this.tabbedPane.setSelectedIndex(0);
            return this.tabbedPane;
        }

        private void setupComponents() {
            Dimension dimAdjust;
            this.newAddressField = new JTextField(20);
            this.model = new DefaultListModel();
            this.addressList = new JList<String>(this.model);
            this.addressList.setVisibleRowCount(10);
            this.addButton = new JButton(this.getRes("button.add"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newAdd = ComposeEmailToAddressesDialog.this.newAddressField.getText().trim();
                    if (newAdd.length() > 0) {
                        ComposeEmailToAddressesDialog.this.model.addElement(newAdd);
                        ComposeEmailToAddressesDialog.this.newAddressField.setText("");
                        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)ComposeEmailToAddressesDialog.this.newAddressField, true));
                    }
                }
            });
            this.removeButton = new JButton(this.getRes("button.remove"));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] selected = ComposeEmailToAddressesDialog.this.addressList.getSelectedValuesList().toArray();
                    for (int i = 0; i < selected.length; ++i) {
                        ComposeEmailToAddressesDialog.this.model.removeElement(selected[i]);
                    }
                }
            });
            Dimension dimAdd = this.addButton.getPreferredSize();
            Dimension dimRemove = this.removeButton.getPreferredSize();
            if (dimAdd.width > dimRemove.width) {
                dimAdjust = new Dimension(dimAdd.width, dimRemove.height);
                this.removeButton.setPreferredSize(dimAdjust);
            }
            if (dimAdd.width < dimRemove.width) {
                dimAdjust = new Dimension(dimRemove.width, dimAdd.height);
                this.addButton.setPreferredSize(dimAdjust);
            }
            dimAdd = this.addButton.getPreferredSize();
            dimRemove = this.removeButton.getPreferredSize();
            if (dimAdd.height > dimRemove.height) {
                dimAdjust = new Dimension(dimRemove.width, dimAdd.height);
                this.removeButton.setPreferredSize(dimAdjust);
            }
            if (dimAdd.height < dimRemove.height) {
                dimAdjust = new Dimension(dimAdd.width, dimRemove.height);
                this.addButton.setPreferredSize(dimAdjust);
            }
        }

        public void setObject(MailToOthers mto) {
            this.toOthers = mto;
            this.mailContent = this.toOthers.getOptMailContent();
            if (this.mailContent == null) {
                this.mailContent = new MailContent();
            }
            if (EmailMsgPane.this.showEmailServerConfig()) {
                this.serverConfig = this.toOthers.getOptEmailServerConfig();
                if (this.serverConfig == null) {
                    this.serverConfig = new EmailServerConfig();
                }
            }
            this.updatePanel();
        }

        public MailToOthers getMailToOthers() {
            return this.toOthers;
        }

        private class AddressPanel
        extends JPanel
        implements ContentSensitiveHelpPage {
            private static final long serialVersionUID = 1L;

            public AddressPanel() {
                AvTemplatePane result = new AvTemplatePane(ComposeEmailToAddressesDialog.this.getRes("label.addressTitle"), ComposeEmailToAddressesDialog.this.getRes("label.addressDesc"));
                JPanel p = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 21;
                c.fill = 1;
                c.insets = new Insets(5, 0, 0, 0);
                c.gridx = 0;
                c.gridy = 0;
                p.add((Component)new JLabel(ComposeEmailToAddressesDialog.this.getRes("label.email")), c);
                c.gridx = 0;
                c.gridy = 1;
                p.add((Component)ComposeEmailToAddressesDialog.this.newAddressField, c);
                c.gridx = 0;
                c.gridy = 2;
                JScrollPane jsp = new JScrollPane(ComposeEmailToAddressesDialog.this.addressList);
                jsp.setPreferredSize(ComposeEmailToAddressesDialog.this.addressList.getPreferredScrollableViewportSize());
                p.add((Component)jsp, c);
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 20, 0, 0);
                c.fill = 0;
                p.add((Component)ComposeEmailToAddressesDialog.this.addButton, c);
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 20, 0, 0);
                c.anchor = 11;
                p.add((Component)ComposeEmailToAddressesDialog.this.removeButton, c);
                JPanel temp = new JPanel(new BorderLayout());
                temp.add((Component)p, "Before");
                result.add(temp);
                this.setLayout(new BorderLayout());
                this.add((Component)result, "Center");
            }

            @Override
            public String getContentSensitiveHelpToken() {
                return "sesm_policies_dialog_av_auto_protect_notifications_send_to_other_address";
            }
        }
    }

    private class ComposeEmailDialog
    extends AvDialogBase {
        private static final long serialVersionUID = 1L;
        private JTextField serverField;
        private JTextField portField;
        private JTextField userField;
        private JTextField pathField;
        private JPasswordField pwField;
        private JTabbedPane tabbedPane;
        private MailToSender toSender;
        protected MailContent mailContent;
        protected EmailServerConfig serverConfig;
        protected EmailContentPanel msgPanel;

        public ComposeEmailDialog(String title) {
            super(title, true, true);
        }

        protected String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ComposeEmailDialog." + key);
        }

        protected void updatePanel() {
            this.msgPanel.setObject(this.mailContent);
            if (EmailMsgPane.this.showEmailServerConfig()) {
                this.serverField.setText(this.serverConfig.getSmtpServerAddress());
                Integer i = this.serverConfig.getOptSmtpServerPort();
                if (i == null) {
                    i = this.serverConfig.getDefSmtpServerPort();
                }
                this.portField.setText(String.valueOf(i));
                this.userField.setText(this.serverConfig.getOptUserName());
                this.pwField.setText("");
                this.pathField.setText(this.serverConfig.getOptReversePath());
            }
        }

        @Override
        protected void help() {
            HelpUtil.showHelp(((ContentSensitiveHelpPage)((Object)this.tabbedPane.getSelectedComponent())).getContentSensitiveHelpToken());
        }

        protected void saveServerConfig() {
            this.serverConfig.setSmtpServerAddress(this.serverField.getText());
            this.serverConfig.setOptSmtpServerPort(Integer.valueOf(this.portField.getText()));
            this.serverConfig.setRequireAuthentication(Boolean.valueOf(this.userField.getText().trim().length() > 0));
            this.serverConfig.setOptUserName(this.userField.getText());
            this.serverConfig.setOptUserPassword(new String(this.pwField.getPassword()));
            this.serverConfig.setOptReversePath(this.pathField.getText());
        }

        @Override
        protected boolean isValidate() {
            if (EmailMsgPane.this.showEmailServerConfig() && (this.serverField.getText().trim().length() == 0 || this.portField.getText().trim().length() == 0)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.errEnterEmailServerPort"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "EmailMsgPane.Error"), 0);
                return false;
            }
            return this.msgPanel.valuesValid();
        }

        @Override
        protected void commit() {
            this.msgPanel.saveObject();
            this.toSender.setOptMailContent(this.mailContent);
            if (EmailMsgPane.this.showEmailServerConfig()) {
                this.saveServerConfig();
                this.toSender.setOptEmailServerConfig(this.serverConfig);
            }
        }

        protected JTabbedPane getTabbedPane() {
            this.setupComponents();
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setTabLayoutPolicy(1);
            if (EmailMsgPane.this.showEmailServerConfig()) {
                this.tabbedPane.addTab(this.getRes("label.mailServer"), new MailPanel());
            }
            this.tabbedPane.addTab(this.getRes("label.message"), new MsgPanel());
            return this.tabbedPane;
        }

        @Override
        protected JPanel getContentPanel() {
            JPanel result = new JPanel(new BorderLayout());
            result.add((Component)this.getTabbedPane(), "Center");
            return result;
        }

        private void setObject(MailToSender mailToSender) {
            this.toSender = mailToSender;
            this.mailContent = this.toSender.getOptMailContent();
            if (this.mailContent == null) {
                this.mailContent = new MailContent();
            }
            if (EmailMsgPane.this.showEmailServerConfig()) {
                this.serverConfig = this.toSender.getOptEmailServerConfig();
                if (this.serverConfig == null) {
                    this.serverConfig = new EmailServerConfig();
                }
            }
            this.updatePanel();
        }

        private void setupComponents() {
            if (EmailMsgPane.this.showEmailServerConfig()) {
                this.serverField = new JTextField(20);
                this.portField = new JTextField();
                this.portField.setDocument(new NumberPlainDocument());
                this.userField = new JTextField();
                this.pwField = new SEPMPasswordField();
                this.pathField = new JTextField();
            }
            boolean isToSender = !(this instanceof ComposeEmailToAddressesDialog);
            this.msgPanel = new EmailContentPanel(true, isToSender);
        }

        public MailToSender getMailToSender() {
            return this.toSender;
        }

        private class MsgPanel
        extends AvTemplatePane
        implements ContentSensitiveHelpPage {
            private static final long serialVersionUID = 1L;

            public MsgPanel() {
                super(ComposeEmailDialog.this.getRes("label.msgTitle"), ComposeEmailDialog.this.getRes("label.msgDesc"));
                this.add(ComposeEmailDialog.this.msgPanel);
            }

            @Override
            public String getContentSensitiveHelpToken() {
                return "sesm_policies_dialog_av_auto_protect_notifications_email_msg_send_to_sender_msg";
            }
        }

        private class MailPanel
        extends AvTemplatePane
        implements ContentSensitiveHelpPage {
            private static final long serialVersionUID = 1L;

            public MailPanel() {
                super(ComposeEmailDialog.this.getRes("label.serverTitle"), ComposeEmailDialog.this.getRes("label.serverDesc"));
                JPanel p = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 21;
                c.fill = 2;
                c.insets = new Insets(5, 0, 0, 0);
                c.gridx = 0;
                c.gridy = 0;
                p.add((Component)new JLabel(ComposeEmailDialog.this.getRes("label.server")), c);
                c.insets = new Insets(5, 5, 0, 0);
                c.gridx = 1;
                c.gridy = 0;
                p.add((Component)ComposeEmailDialog.this.serverField, c);
                c.insets = new Insets(5, 0, 0, 0);
                c.gridx = 0;
                c.gridy = 1;
                p.add((Component)new JLabel(ComposeEmailDialog.this.getRes("label.port")), c);
                c.insets = new Insets(5, 5, 0, 0);
                c.gridx = 1;
                c.gridy = 1;
                p.add((Component)ComposeEmailDialog.this.portField, c);
                c.insets = new Insets(5, 0, 0, 0);
                c.gridx = 0;
                c.gridy = 2;
                p.add((Component)new JLabel(ComposeEmailDialog.this.getRes("label.user")), c);
                c.insets = new Insets(5, 5, 0, 0);
                c.gridx = 1;
                c.gridy = 2;
                p.add((Component)ComposeEmailDialog.this.userField, c);
                c.insets = new Insets(5, 0, 0, 0);
                c.gridx = 0;
                c.gridy = 3;
                p.add((Component)new JLabel(ComposeEmailDialog.this.getRes("label.password")), c);
                c.insets = new Insets(5, 5, 0, 0);
                c.gridx = 1;
                c.gridy = 3;
                p.add((Component)ComposeEmailDialog.this.pwField, c);
                c.insets = new Insets(5, 0, 0, 0);
                c.gridx = 0;
                c.gridy = 4;
                p.add((Component)new JLabel(ComposeEmailDialog.this.getRes("label.path")), c);
                c.insets = new Insets(5, 5, 0, 0);
                c.gridx = 1;
                c.gridy = 4;
                p.add((Component)ComposeEmailDialog.this.pathField, c);
                JPanel temp = new JPanel(new BorderLayout());
                temp.add((Component)p, "Before");
                this.add(temp);
            }

            @Override
            public String getContentSensitiveHelpToken() {
                return "sesm_policies_dialog_av_auto_protect_notifications_email_msg_send_to_sender_mail";
            }
        }
    }
}

