/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.DownloadAdvisorOptions;
import com.sygate.scm.common.configobject.schema.NotificationMessage;
import com.sygate.scm.common.configobject.schema.SecurityRiskGroup;
import com.sygate.scm.common.configobject.schema.SecurityRiskItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.ap.ApDownloadAdvisorPanel;
import com.sygate.scm.console.ui.policy.av.ap.DownloadAdvisorNotificationPane;
import com.sygate.scm.console.ui.policy.av.ap.MalwareActionPanel;
import com.sygate.scm.console.ui.policy.av.ap.interop.AutoProtectStateManager;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.DetectionNotificationObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.JTabbedPane;

public class DownloadProtectionPane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private ApDownloadAdvisorPanel downloadAdvisorPanel;
    private DownloadAdvisorNotificationPane notificationPanel;
    private DownloadAdvisorOptions downloadAdvisorOption;
    private NotificationMessage notificationMsg;
    private AutoProtectStateManager apStateManager;
    private DetectionNotificationObject dno;
    private MalwareActionPanel daActionPanel;
    private ApFileScanDetailsObject apFileScanObj;
    private ApActions apActions;

    public DownloadProtectionPane(AutoProtectStateManager apStateManager) {
        this.apStateManager = apStateManager;
        this.init();
    }

    public void init() {
        this.downloadAdvisorPanel = new ApDownloadAdvisorPanel(this);
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.downloadAdvisorSettings"), UIUtilities.createScrollPaneWithoutBoard(this.downloadAdvisorPanel));
        this.daActionPanel = new MalwareActionPanel();
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.action"), UIUtilities.createScrollPaneWithoutBoard(this.daActionPanel));
        this.notificationPanel = new DownloadAdvisorNotificationPane();
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.notification"), UIUtilities.createScrollPaneWithoutBoard(this.notificationPanel));
    }

    public void saveObject() throws ConsoleException {
        DetectionNotificationObject detectionNotificationObj = this.notificationPanel.save();
        this.downloadAdvisorOption.setOptDisplayNotification(Boolean.valueOf(detectionNotificationObj.getDisplayNotification()));
        this.downloadAdvisorOption.setOptLockDisplayNotification(Boolean.valueOf(detectionNotificationObj.getLockDisplayNotification()));
        this.notificationMsg.setOptContent(detectionNotificationObj.getNotificationMessage());
        this.downloadAdvisorOption.setOptNotificationMessage(this.notificationMsg);
        this.downloadAdvisorPanel.save();
        this.daActionPanel.save();
        if (this.daActionPanel.isActionsChanged()) {
            this.daActionPanel.updateApActions(this.apActions);
        }
    }

    public void setObject(DownloadAdvisorOptions downloadAdvisorOpt, ApFileScanDetailsObject fileScanObj, ApActions apActions) {
        String message;
        Boolean lock;
        this.downloadAdvisorOption = downloadAdvisorOpt;
        this.apFileScanObj = fileScanObj;
        this.downloadAdvisorPanel.setApStateManager(this.apStateManager);
        this.downloadAdvisorPanel.setObject(this.downloadAdvisorOption, this.apFileScanObj);
        this.daActionPanel.setDaObject(this.downloadAdvisorOption);
        this.apActions = apActions;
        ApAction downloadActions = this.getDownloadAction(apActions);
        this.daActionPanel.setObject(downloadActions);
        Boolean display = this.downloadAdvisorOption.getOptDisplayNotification();
        if (display == null) {
            display = this.downloadAdvisorOption.getDefDisplayNotification();
        }
        if ((lock = this.downloadAdvisorOption.getOptLockDisplayNotification()) == null) {
            lock = this.downloadAdvisorOption.getDefLockDisplayNotification();
        }
        this.notificationMsg = this.downloadAdvisorOption.getOptNotificationMessage();
        if (this.notificationMsg == null) {
            this.notificationMsg = new NotificationMessage();
            this.downloadAdvisorOption.setOptNotificationMessage(this.notificationMsg);
        }
        String notificationMessage = "";
        if (this.downloadAdvisorOption.getOptNotificationMessage() != null && (message = this.downloadAdvisorOption.getOptNotificationMessage().getOptContent()) != null) {
            notificationMessage = message;
        }
        this.dno = new DetectionNotificationObject(lock, display, notificationMessage);
        this.notificationPanel.setObject(this.dno, this.downloadAdvisorOption);
    }

    private ApAction getDownloadAction(ApActions apActions) {
        for (int i = 0; i < apActions.getSecurityRiskGroupCount(); ++i) {
            SecurityRiskGroup group = apActions.getSecurityRiskGroup(i);
            String groupKey = group.getName();
            if (!"1".equals(groupKey) && !"Malware".equals(groupKey)) continue;
            for (int j = 0; j < group.getSecurityRiskItemCount(); ++j) {
                SecurityRiskItem risk = group.getSecurityRiskItem(j);
                String riskKey = risk.getName();
                if (!"1:18".equals(riskKey) && !"DownloadAction".equals(riskKey)) continue;
                ApAction downloadAction = risk.getOptApAction();
                return downloadAction;
            }
        }
        return null;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }

    public boolean valuesValid() {
        return this.notificationPanel.valuesValid();
    }
}

