/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.DetectionNotificationObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.NotificationConverter;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DetectionNotificationPane
extends AvTemplatePane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String DA_DEFAULT_MSG = MessageResources.getInstance().getString("com.sygate.scm.util.template.template", "$$I18N.PolicyTmpl.DaNotificationMessage$$");
    private static final String DB_DEFAULT_MSG = MessageResources.getInstance().getString("com.sygate.scm.util.template.template", "$$I18N.PolicyTmpl.AvNotificationMessage$$");
    private static final String MAC_DEFAULT_NOTIFICATION_MSG = MessageResources.getInstance().getString("com.sygate.scm.util.template.template", "$$I18N.PolicyTmpl.MacAvNotificationMessage$$");
    private static final int MSG_TXT_AREA_ROW_CNT = 9;
    private static final String TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.label.detection");
    private static final String DESC = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.label.detectionDesc");
    private static final String LBL_NOTI_CHKBOX = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.checkbox.displayNotificationMsg");
    private static final String DA_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.label.detectionDADesc");
    private static final String LBL_CUSTOMADMIN_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.label.customAdminMsgDesc");
    private static final String LBL_DA_NOTI_CHKBOX = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.checkbox.displayDANotificationMsg");
    private JPanel contentPane;
    private LockCheckBox lockDisplayMsgChk;
    private JCheckBox displayMsgChk;
    private JTextArea msgTxtArea;
    private DetectionNotificationObject notificationObj;
    private JPanel lockDisplayPanel;
    private JScrollPane lockDisplayScrollPane;
    private PaneType paneType = PaneType.REALTIME;
    private boolean isMacNotification = false;

    public DetectionNotificationPane() {
        super(TITLE, DESC);
        this.add(this.getContentPane());
    }

    public DetectionNotificationPane(PaneType paneType) {
        super(TITLE, paneType == PaneType.DOWNLOAD_ADVISOR ? DA_DESC : DESC);
        this.paneType = paneType;
        this.add(this.getContentPane());
    }

    public void setObject(DetectionNotificationObject notificationObj) {
        this.notificationObj = notificationObj;
        this.updatePanel();
    }

    public void setObject(DetectionNotificationObject notificationObj, boolean isMacNotification) {
        this.isMacNotification = isMacNotification;
        this.setObject(notificationObj);
        this.updatePanelForMac();
    }

    public boolean valuesValid(String key) {
        int index;
        String notifMsg = this.msgTxtArea.getText().trim();
        if (this.displayMsgChk.isSelected() && notifMsg.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), key + "\n\n" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.label.msgEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.label.error"), 0);
            return false;
        }
        if (this.paneType != PaneType.DOWNLOAD_ADVISOR && (index = notifMsg.indexOf("~")) != -1) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.msgHasAgentPrefix");
            msg = MessageFormat.format(msg, "~");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "DetectionNotificationPane.label.error"), 0);
            return false;
        }
        return NotificationConverter.isConvertedAgentMessageLengthValid(key, 0, notifMsg, true, this);
    }

    public DetectionNotificationObject save() {
        this.notificationObj.setLockDisplayNotification(this.lockDisplayMsgChk.isSelected());
        this.notificationObj.setDisplayNotification(this.displayMsgChk.isSelected());
        String message = this.msgTxtArea.getText();
        if (this.paneType != PaneType.DOWNLOAD_ADVISOR) {
            NotificationConverter converter = new NotificationConverter(0);
            message = converter.convertNotificationFormat(0, message);
        }
        this.notificationObj.setNotificationMessage(message);
        return this.notificationObj;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_ads_scans_edit_scan_notifications";
    }

    private void enableAppropriate() {
        this.displayMsgChk.setFocusPainted(true);
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (this.displayMsgChk.isSelected() && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return;
        }
        this.msgTxtArea.setEnabled(this.displayMsgChk.isSelected());
    }

    private JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            this.lockDisplayMsgChk = new LockCheckBox(Boolean.FALSE);
            this.lockDisplayMsgChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockDisplayMsgChk.setVisible(this.paneType != PaneType.ADMIN_SCAN);
            this.lockDisplayMsgChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DetectionNotificationPane.this.lockDisplayMsgChk.setFocusPainted(true);
                }
            });
            this.displayMsgChk = new JCheckBox(this.paneType == PaneType.DOWNLOAD_ADVISOR ? LBL_DA_NOTI_CHKBOX : LBL_NOTI_CHKBOX);
            this.displayMsgChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DetectionNotificationPane.this.enableAppropriate();
                }
            });
            this.msgTxtArea = new JTextArea();
            this.msgTxtArea.setCaretPosition(0);
            this.msgTxtArea.setRows(9);
            this.msgTxtArea.setColumns(50);
            this.msgTxtArea.setLineWrap(true);
            this.msgTxtArea.setWrapStyleWord(true);
            NotificationConverter msgConverter = new NotificationConverter(0);
            String uiDefaultMsg = null;
            uiDefaultMsg = this.isMacNotification ? msgConverter.convertNotificationFormat(1, MAC_DEFAULT_NOTIFICATION_MSG) : (this.paneType == PaneType.DOWNLOAD_ADVISOR ? DA_DEFAULT_MSG : msgConverter.convertNotificationFormat(1, DB_DEFAULT_MSG));
            this.msgTxtArea.setText(uiDefaultMsg);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)this.lockDisplayMsgChk, c);
            c.gridx = 1;
            c.gridy = 0;
            pane.add((Component)this.displayMsgChk, c);
            c.gridx = 1;
            c.gridy = 1;
            c.insets = new Insets(5, 10, 0, 0);
            this.lockDisplayPanel = new JPanel(new BorderLayout());
            this.lockDisplayScrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)this.lockDisplayScrollPane, (JTextArea)this.msgTxtArea);
            if (this.paneType == PaneType.DOWNLOAD_ADVISOR) {
                Box vbox = Box.createVerticalBox();
                vbox.add(new JLabel(LBL_CUSTOMADMIN_DESC));
                vbox.add(Box.createRigidArea(new Dimension(0, 4)));
                this.lockDisplayPanel.add((Component)vbox, "North");
            }
            this.lockDisplayPanel.add((Component)this.lockDisplayScrollPane, "Center");
            this.lockDisplayPanel.setPreferredSize(new Dimension(419, 145));
            pane.add((Component)this.lockDisplayPanel, c);
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.add((Component)pane, "Before");
            this.contentPane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent event) {
                    List<Component> compsList = UIUtilities.getAllComponents((Container)event.getSource());
                    for (Component comp : compsList) {
                        if (!(comp instanceof JCheckBox)) continue;
                        ((JCheckBox)comp).setFocusPainted(false);
                    }
                }
            });
        }
        return this.contentPane;
    }

    private void updatePanel() {
        this.lockDisplayMsgChk.setSelected(this.notificationObj.getLockDisplayNotification());
        this.displayMsgChk.setSelected(this.notificationObj.getDisplayNotification());
        if (this.notificationObj.getNotificationMessage() != null && this.notificationObj.getNotificationMessage().length() > 0) {
            NotificationConverter converter = new NotificationConverter(0);
            String message = this.paneType == PaneType.DOWNLOAD_ADVISOR ? this.notificationObj.getNotificationMessage() : converter.convertNotificationFormat(1, this.notificationObj.getNotificationMessage());
            this.msgTxtArea.setText(message);
        }
        this.enableAppropriate();
    }

    private void updatePanelForMac() {
        if (this.isMacNotification) {
            this.lockDisplayMsgChk.setSelected(false);
            this.lockDisplayMsgChk.setVisible(false);
        }
    }

    public static enum PaneType {
        ADMIN_SCAN,
        REALTIME,
        DOWNLOAD_ADVISOR;

    }
}

