/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.ApWebMailAdvancedOptions;
import com.sygate.scm.common.configobject.schema.WebMailAp;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.ap.ActionsPane;
import com.sygate.scm.console.ui.policy.av.ap.ApWebMailAdvancedPanel;
import com.sygate.scm.console.ui.policy.av.ap.MailScanDetailsPane;
import com.sygate.scm.console.ui.policy.av.ap.WebMailNotificationPane;
import com.sygate.scm.console.ui.policy.av.logicobject.ApActionsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApMailScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MailNotificationObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.JTabbedPane;

public class ApWebMailPane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private WebMailAp mailAp;
    private MailScanDetailsPane scanDetailsPane;
    private ApMailScanDetailsObject scanDetailsObj;
    private ApActionsObject apActionsObj;
    private MailNotificationObject notificationObj;
    private ApWebMailAdvancedOptions advOptions;
    private ApWebMailAdvancedPanel advancedPanel;
    private ActionsPane actionsPane;
    private WebMailNotificationPane notificationPane;

    public ApWebMailPane() {
        this.init();
    }

    public void save() throws ConsoleException {
        this.saveData();
    }

    private void init() {
        this.scanDetailsPane = new MailScanDetailsPane(1);
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApWebMailPane.label.scanDetails"), UIUtilities.createScrollPaneWithoutBoard(this.scanDetailsPane));
        this.actionsPane = new ActionsPane(false);
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.action"), UIUtilities.createScrollPaneWithoutBoard(this.actionsPane));
        this.notificationPane = new WebMailNotificationPane();
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.notification"), UIUtilities.createScrollPaneWithoutBoard(this.notificationPane));
        this.advancedPanel = new ApWebMailAdvancedPanel();
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.advance"), UIUtilities.createScrollPaneWithoutBoard(this.advancedPanel));
        }
    }

    private void updateValues() throws ConsoleException {
        boolean isLocked = this.mailAp.getDefLockEnableEmailAp();
        boolean isEnabled = this.mailAp.getDefEnable();
        if (this.mailAp.getOptLockEnableEmailAp() != null) {
            isLocked = this.mailAp.getOptLockEnableEmailAp();
        }
        if (this.mailAp.getOptEnable() != null) {
            isEnabled = this.mailAp.getOptEnable();
        }
        this.scanDetailsObj = new ApMailScanDetailsObject(this.mailAp.getOptApMailScanDetails(), isLocked, isEnabled);
        this.scanDetailsPane.setObject(this.scanDetailsObj);
        ApActions apActions = this.mailAp.getOptApActions();
        this.apActionsObj = new ApActionsObject(apActions);
        this.actionsPane.setObject(this.apActionsObj);
        this.notificationObj = new MailNotificationObject(this.mailAp.getOptApMailNotifications());
        this.notificationPane.setObject(this.notificationObj);
        this.advOptions = this.mailAp.getOptApWebMailAdvancedOptions();
        if (this.advOptions == null) {
            this.advOptions = new ApWebMailAdvancedOptions();
        }
        this.advancedPanel.setObject(this.advOptions);
    }

    private void saveData() throws ConsoleException {
        this.scanDetailsPane.save();
        this.mailAp.setOptApMailScanDetails(this.scanDetailsObj.getSchemaObject());
        this.actionsPane.save();
        this.mailAp.setOptApActions(this.apActionsObj.getSchemaObject());
        this.notificationPane.save();
        this.mailAp.setOptApMailNotifications(this.notificationObj.getSchemaObject());
        this.mailAp.setOptLockEnableEmailAp(Boolean.valueOf(this.scanDetailsObj.isEnableEmailApLocked()));
        this.mailAp.setOptEnable(Boolean.valueOf(this.scanDetailsObj.isEmailApEnabled()));
        this.advancedPanel.saveObject();
        this.mailAp.setOptApWebMailAdvancedOptions(this.advOptions);
    }

    public void setMailApObject(WebMailAp mailAp) throws ConsoleException {
        if (mailAp == null) {
            mailAp = new WebMailAp();
        }
        this.mailAp = mailAp;
        this.updateValues();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }

    public boolean valuesValid() {
        if (!this.notificationPane.valuesValid()) {
            return false;
        }
        return this.advancedPanel.valuesValid();
    }
}

