/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApWebMailAdvancedOptions;
import com.sygate.scm.common.configobject.schema.WebMailHeuristics;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ApWebMailAdvancedPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private String[] actions = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailAdvancedPanel.action.QuarantineThreat"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailAdvancedPanel.action.DeleteThreat"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailAdvancedPanel.action.LeaveAlone")};
    private LockCheckBox lockMailPortBox;
    private JTextField pop3PortField;
    private JTextField smtpPortField;
    private JButton defaultsButton;
    private LockCheckBox lockEncPOP3Box;
    private LockCheckBox lockEncSMTPBox;
    private JCheckBox encPOP3Box;
    private JCheckBox encSMTPBox;
    private LockCheckBox lockHeurOutbound;
    private LockCheckBox lockFirstAction;
    private LockCheckBox lockFirstActionFail;
    private JCheckBox heurOutboundBox;
    private JComboBox<String> firstActionCbo = new JComboBox<String>(this.actions);
    private JComboBox<String> firstActionFailCbo = new JComboBox();
    JLabel firstLbl;
    JLabel firstFailLbl;
    private ApWebMailAdvancedOptions advOptions;
    private WebMailHeuristics webMailHeuristics;
    protected transient ItemListener firstActionListener;
    private HashMap<Integer, String> enumToStringMap = new HashMap();
    private HashMap<String, Integer> stringToEnumMap = new HashMap();

    public ApWebMailAdvancedPanel() {
        this.setupPanel();
    }

    public void saveObject() throws ConsoleException {
        this.advOptions.setOptLockMailServerPorts(Boolean.valueOf(this.lockMailPortBox.isSelected()));
        this.advOptions.setOptPop3Port(Integer.valueOf(this.pop3PortField.getText()));
        this.advOptions.setOptSmtpPort(Integer.valueOf(this.smtpPortField.getText()));
        this.advOptions.setOptLockAllowEncryptedPop3Connections(Boolean.valueOf(this.lockEncPOP3Box.isSelected()));
        this.advOptions.setOptAllowEncryptedPop3Connections(Boolean.valueOf(this.encPOP3Box.isSelected()));
        this.advOptions.setOptLockAllowEncryptedSMTPConnections(Boolean.valueOf(this.lockEncSMTPBox.isSelected()));
        this.advOptions.setOptAllowEncryptedSMTPConnections(Boolean.valueOf(this.encSMTPBox.isSelected()));
        if (this.webMailHeuristics == null) {
            this.webMailHeuristics = new WebMailHeuristics();
        }
        this.webMailHeuristics.setOptLockEnableOEH(Boolean.valueOf(this.lockHeurOutbound.isSelected()));
        this.webMailHeuristics.setOptLockFirstAction(Boolean.valueOf(this.lockFirstAction.isSelected()));
        this.webMailHeuristics.setOptLockSecondAction(Boolean.valueOf(this.lockFirstActionFail.isSelected()));
        this.webMailHeuristics.setOptEnableOEH(Boolean.valueOf(this.heurOutboundBox.isSelected()));
        this.webMailHeuristics.setOptFirstAction(this.stringToEnumMap.get(this.firstActionCbo.getSelectedItem()));
        this.webMailHeuristics.setOptSecondAction(this.stringToEnumMap.get(this.firstActionFailCbo.getSelectedItem()));
        this.advOptions.setOptWebMailHeuristics(this.webMailHeuristics);
    }

    private String getRes(String component, String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", component + key);
    }

    private String getRes(String key) {
        return this.getRes("WebMailAdvancedPanel.", key);
    }

    private void setupComponents() {
        this.lockMailPortBox = new LockCheckBox(Boolean.FALSE);
        this.lockMailPortBox.setSelectedIcon(AvConstants.lockIcon);
        this.pop3PortField = new JTextField();
        this.pop3PortField.setColumns(5);
        this.pop3PortField.setDocument(new NumberPlainDocument(65535L, true));
        this.smtpPortField = new JTextField();
        this.smtpPortField.setColumns(5);
        this.smtpPortField.setDocument(new NumberPlainDocument(65535L, true));
        this.defaultsButton = new JButton(this.getRes("button.defaultButton"));
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApWebMailAdvancedPanel.this.pop3PortField.setText(String.valueOf(ApWebMailAdvancedPanel.this.advOptions.getDefPop3Port()));
                ApWebMailAdvancedPanel.this.smtpPortField.setText(String.valueOf(ApWebMailAdvancedPanel.this.advOptions.getDefSmtpPort()));
                AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                    ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)ApWebMailAdvancedPanel.this.pop3PortField, true);
                    ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)ApWebMailAdvancedPanel.this.smtpPortField, true);
                });
            }
        });
        this.lockEncPOP3Box = new LockCheckBox(Boolean.FALSE);
        this.lockEncPOP3Box.setSelectedIcon(AvConstants.lockIcon);
        this.lockEncSMTPBox = new LockCheckBox(Boolean.FALSE);
        this.lockEncSMTPBox.setSelectedIcon(AvConstants.lockIcon);
        this.encPOP3Box = new JCheckBox(this.getRes("checkbox.allowEncPOP3"));
        this.encSMTPBox = new JCheckBox(this.getRes("checkbox.allowEncSMTP"));
    }

    private void enableAppropriate() {
    }

    private JPanel getConnectionPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.conSettings"), this.getRes("label.conSettingsDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.lockMailPortBox, c);
        c.insets = new Insets(10, 5, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        p.add((Component)new JLabel(this.getRes("label.pop3Server")), c);
        c.gridx = 2;
        c.gridy = 0;
        p.add((Component)this.pop3PortField, c);
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 1;
        c.gridy = 1;
        p.add((Component)new JLabel(this.getRes("label.smtpServer")), c);
        c.gridx = 2;
        c.gridy = 1;
        p.add((Component)this.smtpPortField, c);
        c.insets = new Insets(20, 5, 0, 0);
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 2;
        p.add((Component)this.defaultsButton, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getEncryptedPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.encSettings"), this.getRes("label.encSettingsDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.lockEncPOP3Box, c);
        c.insets = new Insets(10, 5, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        p.add((Component)this.encPOP3Box, c);
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)this.lockEncSMTPBox, c);
        c.insets = new Insets(10, 5, 0, 0);
        c.gridx = 1;
        c.gridy = 1;
        p.add((Component)this.encSMTPBox, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getHeuristicPane() {
        this.setupMap();
        AvTemplatePane result = new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailAdvancedPanel.label.heuristicDetection"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailAdvancedPanel.label.heuristicDetectionDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        this.firstLbl = new JLabel(this.getRes("label.firstAction"));
        this.firstFailLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailAdvancedPanel.label.ifFirstActionFails"));
        this.lockHeurOutbound = new LockCheckBox(Boolean.FALSE);
        this.lockHeurOutbound.setSelectedIcon(AvConstants.lockIcon);
        this.lockFirstAction = new LockCheckBox(Boolean.FALSE);
        this.lockFirstAction.setSelectedIcon(AvConstants.lockIcon);
        this.lockFirstActionFail = new LockCheckBox(Boolean.FALSE);
        this.lockFirstActionFail.setSelectedIcon(AvConstants.lockIcon);
        this.heurOutboundBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "WebMailAdvancedPanel.checkbox.outbondWormHeuristic"), true);
        this.heurOutboundBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApWebMailAdvancedPanel.this.setHeuristicControls();
            }
        });
        this.firstActionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ApWebMailAdvancedPanel.this.setFailActionCombo();
                }
            }
        };
        this.firstActionCbo.addItemListener(this.firstActionListener);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.lockHeurOutbound, c);
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 3;
        p.add((Component)this.heurOutboundBox, c);
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        p.add((Component)this.lockFirstAction, c);
        c.insets = new Insets(10, 5, 0, 0);
        c.gridx = 2;
        c.gridy = 1;
        p.add((Component)this.firstLbl, c);
        c.insets = new Insets(10, 5, 0, 0);
        c.gridx = 3;
        c.gridy = 1;
        p.add(this.firstActionCbo, c);
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 2;
        p.add((Component)this.lockFirstActionFail, c);
        c.insets = new Insets(10, 5, 0, 0);
        c.gridx = 2;
        c.gridy = 2;
        p.add((Component)this.firstFailLbl, c);
        this.setFailActionCombo();
        c.insets = new Insets(10, 5, 0, 0);
        c.gridx = 3;
        c.gridy = 2;
        p.add(this.firstActionFailCbo, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new VerticalFlowLayout());
        this.add(this.getConnectionPane());
        this.add(this.getEncryptedPane());
        this.add(this.getHeuristicPane());
    }

    private void updatePanel() {
        Boolean b = this.advOptions.getOptLockMailServerPorts();
        if (b == null) {
            b = this.advOptions.getDefLockMailServerPorts();
        }
        this.lockMailPortBox.setSelected(b);
        Integer i = this.advOptions.getOptPop3Port();
        if (i == null) {
            i = this.advOptions.getDefPop3Port();
        }
        this.pop3PortField.setText(String.valueOf(i));
        i = this.advOptions.getOptSmtpPort();
        if (i == null) {
            i = this.advOptions.getDefSmtpPort();
        }
        this.smtpPortField.setText(String.valueOf(i));
        b = this.advOptions.getOptLockAllowEncryptedPop3Connections();
        if (b == null) {
            b = this.advOptions.getDefLockAllowEncryptedPop3Connections();
        }
        this.lockEncPOP3Box.setSelected(b);
        b = this.advOptions.getOptAllowEncryptedPop3Connections();
        if (b == null) {
            b = this.advOptions.getDefAllowEncryptedPop3Connections();
        }
        this.encPOP3Box.setSelected(b);
        b = this.advOptions.getOptLockAllowEncryptedSMTPConnections();
        if (b == null) {
            b = this.advOptions.getDefLockAllowEncryptedSMTPConnections();
        }
        this.lockEncSMTPBox.setSelected(b);
        b = this.advOptions.getOptAllowEncryptedSMTPConnections();
        if (b == null) {
            b = this.advOptions.getDefAllowEncryptedSMTPConnections();
        }
        this.encSMTPBox.setSelected(b);
        if (this.webMailHeuristics != null) {
            this.lockHeurOutbound.setSelected(this.webMailHeuristics.getOptLockEnableOEH() != null ? this.webMailHeuristics.getOptLockEnableOEH() : this.webMailHeuristics.getDefLockEnableOEH());
            this.lockFirstAction.setSelected(this.webMailHeuristics.getOptLockFirstAction() != null ? this.webMailHeuristics.getOptLockFirstAction() : this.webMailHeuristics.getDefLockFirstAction());
            this.lockFirstActionFail.setSelected(this.webMailHeuristics.getOptLockSecondAction() != null ? this.webMailHeuristics.getOptLockSecondAction() : this.webMailHeuristics.getDefLockSecondAction());
            this.heurOutboundBox.setSelected(this.webMailHeuristics.getOptEnableOEH() != null ? this.webMailHeuristics.getOptEnableOEH() : this.webMailHeuristics.getDefEnableOEH());
            this.firstActionCbo.setSelectedItem(this.enumToStringMap.get(this.webMailHeuristics.getOptFirstAction() != null ? this.webMailHeuristics.getOptFirstAction() : this.webMailHeuristics.getDefFirstAction()));
            this.setFailActionCombo();
            try {
                if (this.webMailHeuristics.getOptSecondActionValue() != null) {
                    this.firstActionFailCbo.setSelectedItem(this.enumToStringMap.get(this.webMailHeuristics.getOptSecondAction()));
                } else {
                    int firstIndex = this.firstActionCbo.getSelectedIndex();
                    this.firstActionFailCbo.setSelectedIndex(firstIndex != 0 ? 0 : 1);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                LoggerUtilities.logException((Throwable)e);
                System.out.println(e.getMessage());
            }
            this.setHeuristicControls();
        }
    }

    private void setHeuristicControls() {
        this.firstLbl.setEnabled(this.heurOutboundBox.isSelected());
        this.firstFailLbl.setEnabled(this.heurOutboundBox.isSelected());
        this.firstActionCbo.setEnabled(this.heurOutboundBox.isSelected());
        String curSelectItem = (String)this.firstActionCbo.getSelectedItem();
        this.firstActionFailCbo.setEnabled(this.heurOutboundBox.isSelected() && !curSelectItem.equalsIgnoreCase(this.actions[2]));
        this.lockFirstAction.setEnabled(this.heurOutboundBox.isSelected());
        this.lockFirstActionFail.setEnabled(this.heurOutboundBox.isSelected());
    }

    private void setFailActionCombo() {
        this.firstActionFailCbo.removeAllItems();
        String curSelectItem = (String)this.firstActionCbo.getSelectedItem();
        for (String str : this.actions) {
            if (curSelectItem.equalsIgnoreCase(str)) continue;
            this.firstActionFailCbo.addItem(str);
        }
        if (curSelectItem.equalsIgnoreCase(this.actions[2])) {
            this.firstActionFailCbo.setEnabled(false);
        } else {
            this.firstActionFailCbo.setEnabled(true);
        }
    }

    private void setupMap() {
        this.enumToStringMap.put(WebMailHeuristics.QUARANTINE_THREAT, this.actions[0]);
        this.enumToStringMap.put(WebMailHeuristics.DELETE_THREAT, this.actions[1]);
        this.enumToStringMap.put(WebMailHeuristics.LEAVE_ALONE, this.actions[2]);
        this.stringToEnumMap.put(this.actions[0], WebMailHeuristics.QUARANTINE_THREAT);
        this.stringToEnumMap.put(this.actions[1], WebMailHeuristics.DELETE_THREAT);
        this.stringToEnumMap.put(this.actions[2], WebMailHeuristics.LEAVE_ALONE);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_internet_email_advanced";
    }

    public void setObject(ApWebMailAdvancedOptions object) {
        this.advOptions = object;
        this.webMailHeuristics = this.advOptions.getOptWebMailHeuristics();
        this.updatePanel();
        this.enableAppropriate();
    }

    public boolean valuesValid() {
        if (this.pop3PortField.getText() == null || this.pop3PortField.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("label.emailPortEmptyError"), this.getRes("label.error"), 0);
            return false;
        }
        if (this.smtpPortField.getText() == null || this.smtpPortField.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("label.emailPortEmptyError"), this.getRes("label.error"), 0);
            return false;
        }
        return true;
    }
}

