/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.ApFileAdvancedOptions;
import com.sygate.scm.common.configobject.schema.AvFileAp;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.ap.ActionsPane;
import com.sygate.scm.console.ui.policy.av.ap.ApFileAdvancedPanel;
import com.sygate.scm.console.ui.policy.av.ap.FileNotificationPane;
import com.sygate.scm.console.ui.policy.av.ap.FileScanDetailsPane;
import com.sygate.scm.console.ui.policy.av.ap.interop.AutoProtectStateManager;
import com.sygate.scm.console.ui.policy.av.logicobject.ApActionsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.FileNotificationObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class ApFilePane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    protected static JFrame frame = new JFrame();
    private FileScanDetailsPane fileScanDetailsPane;
    private ActionsPane actionsPane;
    private FileNotificationPane notificationPane;
    private ApFileAdvancedPanel advancedPanel;
    private ApFileScanDetailsObject fileScanObj;
    private ApActionsObject apActionsObj;
    private FileNotificationObject notificationObj;
    private ApFileAdvancedOptions advOptions;
    private AvFileAp fileAp;
    private int platformType = 1;
    private AutoProtectStateManager apStateManager;

    public ApFilePane(AutoProtectStateManager stateManager, int platformType) {
        this.apStateManager = stateManager;
        this.platformType = platformType;
        this.init();
    }

    public void save() throws ConsoleException {
        this.fileScanDetailsPane.save();
        this.fileAp.setOptApFileScanDetails(this.fileScanObj.getSchemaObject());
        this.actionsPane.save();
        this.fileAp.setOptApActions(this.apActionsObj.getSchemaObject());
        this.notificationPane.save();
        this.fileAp.setOptApFileNotifications(this.notificationObj.getSchemaObject());
        this.fileAp.setOptLockEnableFileAp(Boolean.valueOf(this.fileScanObj.isEnableApFileLocked()));
        this.fileAp.setOptEnable(Boolean.valueOf(this.fileScanObj.isApFileEnabled()));
        this.advancedPanel.saveObject();
        this.fileAp.setOptApFileAdvancedOptions(this.advOptions);
    }

    public FileScanDetailsPane getFileScanDetailsPane() {
        if (this.fileScanDetailsPane == null) {
            this.fileScanDetailsPane = new FileScanDetailsPane(this.platformType);
        }
        return this.fileScanDetailsPane;
    }

    private void init() {
        this.fileScanDetailsPane = this.getFileScanDetailsPane();
        this.fileScanDetailsPane.setApStateManager(this.apStateManager);
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.scanDetails"), UIUtilities.createScrollPaneWithoutBoard(this.fileScanDetailsPane));
        if (1 == this.platformType) {
            this.actionsPane = new ActionsPane(true);
        } else if (3 == this.platformType) {
            this.actionsPane = new ActionsPane(false, this.platformType);
        }
        String actions = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.action");
        if (3 != this.platformType) {
            this.addTab(actions, UIUtilities.createScrollPaneWithoutBoard(this.actionsPane));
        }
        this.notificationPane = new FileNotificationPane(this.platformType);
        String notifications = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.notification");
        this.addTab(notifications, UIUtilities.createScrollPaneWithoutBoard(this.notificationPane));
        this.advancedPanel = new ApFileAdvancedPanel(this.platformType);
        String advance = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.advance");
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.addTab(advance, UIUtilities.createScrollPaneWithoutBoard(this.advancedPanel));
        }
        if (this.platformType == 3) {
            this.setTabComponentAt(1, UIUtilities.getDeprecatedOnLinuxPanel(notifications, UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP));
            this.setTabComponentAt(2, UIUtilities.getDeprecatedOnLinuxPanel(advance, UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP));
        }
    }

    private void updateValues() throws ConsoleException {
        boolean isLocked = this.fileAp.getDefLockEnableFileAp();
        boolean isEnabled = this.fileAp.getDefEnable();
        if (this.fileAp.getOptLockEnableFileAp() != null) {
            isLocked = this.fileAp.getOptLockEnableFileAp();
        }
        if (this.fileAp.getOptEnable() != null) {
            isEnabled = this.fileAp.getOptEnable();
        }
        this.fileScanObj = new ApFileScanDetailsObject(this.fileAp.getOptApFileScanDetails(), isLocked, isEnabled);
        this.fileScanDetailsPane.setObject(this.fileScanObj);
        ApActions apActions = this.fileAp.getOptApActions();
        this.apActionsObj = new ApActionsObject(apActions);
        this.actionsPane.setObject(this.apActionsObj);
        this.notificationObj = new FileNotificationObject(this.fileAp.getOptApFileNotifications());
        this.notificationPane.setObject(this.notificationObj);
        this.advOptions = this.fileAp.getOptApFileAdvancedOptions();
        if (this.advOptions == null) {
            this.advOptions = new ApFileAdvancedOptions();
        }
        this.advancedPanel.setObject(this.advOptions);
    }

    public ApFileScanDetailsObject getApFileScanDetailsObject() {
        return this.fileScanObj;
    }

    public void setFileApObject(AvFileAp fileAp) throws ConsoleException {
        this.fileAp = fileAp;
        this.updateValues();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }

    public boolean valuesValid() {
        return this.notificationPane.valuesValid();
    }

    public ActionsPane getApActionsPane() {
        return this.actionsPane;
    }
}

