/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApFileAdvancedOptions;
import com.sygate.scm.common.configobject.schema.FileCache;
import com.sygate.scm.common.configobject.schema.RiskTracer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.ap.FileCacheDlg;
import com.sygate.scm.console.ui.policy.av.ap.FileCachePanel;
import com.sygate.scm.console.ui.policy.av.ap.RiskTracerDlg;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ApFileAdvancedPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private ApFileAdvancedOptions advOptions;
    private FileCache fileCache;
    private RiskTracer riskTracer;
    private LockCheckBox lockAutoLoadBox;
    private JRadioButton systemStartRButton;
    private JRadioButton savStartRButton;
    private LockCheckBox lockShutdownBox;
    private JCheckBox noFloppyBox;
    private LockCheckBox lockAutoReloadBox;
    private JRadioButton osRestartRButton;
    private JRadioButton reloadAPRButton;
    private LockCheckBox lockAPDisableBox;
    private JCheckBox enableAfterBox;
    private JSpinner enableAfterSpinner;
    private FileCachePanel fileCachePanel;
    private AlwaysEnabledButton fileCacheButton;
    private AlwaysEnabledButton riskTracerButton;
    private int platformType = 1;

    public ApFileAdvancedPanel(int platformType) {
        this.platformType = platformType;
        this.setupPanel();
    }

    public void saveObject() throws ConsoleException {
        this.advOptions.setOptFileCache(this.fileCache);
        this.advOptions.setOptRiskTracer(this.riskTracer);
        this.advOptions.setOptLockWhenToLoadAp(Boolean.valueOf(this.lockAutoLoadBox.isSelected()));
        if (this.systemStartRButton.isSelected()) {
            this.advOptions.setWhenToLoadAp(ApFileAdvancedOptions.SYSTEM_START);
        } else {
            this.advOptions.setWhenToLoadAp(ApFileAdvancedOptions.SAV_START);
        }
        this.advOptions.setOptLockCheckFloppyWhenOSDown(Boolean.valueOf(this.lockShutdownBox.isSelected()));
        this.advOptions.setOptCheckFloppyWhenOSDown(Boolean.valueOf(this.noFloppyBox.isSelected()));
        this.advOptions.setOptLockWhenToReloadAp(Boolean.valueOf(this.lockAutoReloadBox.isSelected()));
        if (this.osRestartRButton.isSelected()) {
            this.advOptions.setWhenToReloadAp(ApFileAdvancedOptions.SYSTEM_RESTART);
        } else {
            this.advOptions.setWhenToReloadAp(ApFileAdvancedOptions.AP_RESTART);
        }
        this.advOptions.setOptLockEnableApAutomatically(Boolean.valueOf(this.lockAPDisableBox.isSelected()));
        this.advOptions.setOptEnableApAutomatically(Boolean.valueOf(this.enableAfterBox.isSelected()));
        this.advOptions.setOptEnableApAfterMinutes((Integer)this.enableAfterSpinner.getValue());
        if (3 == this.platformType) {
            this.fileCachePanel.save();
        }
    }

    private String getRes(String component, String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", component + key);
    }

    private String getRes(String key) {
        return this.getRes("FileAdvancedPane.", key);
    }

    private void setupComponents() {
        this.lockAutoLoadBox = new LockCheckBox(Boolean.FALSE);
        this.lockAutoLoadBox.setSelectedIcon(AvConstants.lockIcon);
        this.lockAutoLoadBox.setHorizontalTextPosition(4);
        this.lockAutoLoadBox.setText(this.getRes("label.loadAp"));
        this.lockAutoLoadBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ApFileAdvancedPanel.this.lockAutoLoadBox.setFocusPainted(true);
            }
        });
        this.lockShutdownBox = new LockCheckBox(Boolean.FALSE);
        this.lockShutdownBox.setSelectedIcon(AvConstants.lockIcon);
        this.systemStartRButton = new JRadioButton(this.getRes("checkbox.osStart"));
        this.savStartRButton = new JRadioButton(this.getRes("checkbox.avStart"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.systemStartRButton);
        bg.add(this.savStartRButton);
        this.noFloppyBox = new JCheckBox(this.getRes("checkbox.donotCheckFloppy"));
        this.lockAutoReloadBox = new LockCheckBox(Boolean.FALSE);
        this.lockAutoReloadBox.setSelectedIcon(AvConstants.lockIcon);
        this.lockAutoReloadBox.setHorizontalTextPosition(4);
        this.lockAutoReloadBox.setText(this.getRes("label.whenAvReload"));
        this.osRestartRButton = new JRadioButton(this.getRes("checkbox.waitUtil"));
        this.reloadAPRButton = new JRadioButton(this.getRes("checkbox.stopAndReload"));
        bg = new ButtonGroup();
        bg.add(this.osRestartRButton);
        bg.add(this.reloadAPRButton);
        this.lockAPDisableBox = new LockCheckBox(Boolean.FALSE);
        this.lockAPDisableBox.setSelectedIcon(AvConstants.lockIcon);
        this.lockAPDisableBox.setHorizontalTextPosition(4);
        this.lockAPDisableBox.setText(this.getRes("label.whenAvDisable"));
        this.enableAfterBox = new JCheckBox(this.getRes("checkbox.enaleAfter"));
        this.enableAfterBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ApFileAdvancedPanel.this.enableAppropriate();
            }
        });
        SpinnerNumberModel model = new SpinnerNumberModel(30, 3, 60, 1);
        this.enableAfterSpinner = new JSpinner(model);
        UIUtilities.enableOnlyValidEdits(this.enableAfterSpinner);
        this.fileCacheButton = new AlwaysEnabledButton(this.getRes("button.fileCache"));
        this.fileCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileCacheDlg fcd = new FileCacheDlg(ApFileAdvancedPanel.this.getRes("FileCacheDlg.", "title"), ApFileAdvancedPanel.this.fileCache, ApFileAdvancedPanel.this.platformType);
                ReadOnlyUtils.disableDialogIfNeeded(ApFileAdvancedPanel.this.fileCacheButton, fcd);
                fcd.setVisible(true);
            }
        });
        this.riskTracerButton = new AlwaysEnabledButton(this.getRes("button.riskTracer"));
        this.riskTracerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RiskTracerDlg rtd = new RiskTracerDlg(ApFileAdvancedPanel.this.getRes("RiskTracerDlg.", "title"), ApFileAdvancedPanel.this.riskTracer);
                ReadOnlyUtils.disableDialogIfNeeded(ApFileAdvancedPanel.this.fileCacheButton, rtd);
                rtd.setVisible(true);
            }
        });
        this.fileCachePanel = new FileCachePanel(this.platformType);
    }

    private void enableAppropriate() {
        this.enableAfterSpinner.setEnabled(this.enableAfterBox.isSelected());
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new VerticalFlowLayout());
        if (1 == this.platformType) {
            this.add(this.getStartupPane());
            this.add(this.getReloadPane());
            this.add(this.getAdditionalPane());
        } else if (3 == this.platformType) {
            this.add(this.fileCachePanel);
        }
    }

    private JPanel getAdditionalPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.addiotionalOptions"), this.getRes("label.addiotionalOptionsDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(10, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.fileCacheButton, c);
        c.insets = new Insets(10, 40, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        p.add((Component)this.riskTracerButton, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getReloadPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.reloadEnable"), this.getRes("label.avReloadDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.lockAutoReloadBox, c);
        c.insets = new Insets(0, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)this.reloadAPRButton, c);
        c.insets = new Insets(0, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        p.add((Component)this.osRestartRButton, c);
        c.insets = new Insets(5, 50, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 3;
        p.add((Component)this.lockAPDisableBox, c);
        c.insets = new Insets(0, 70, 0, 0);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        p.add((Component)this.enableAfterBox, c);
        c.insets = new Insets(0, 10, 0, 0);
        c.gridx = 2;
        c.gridy = 1;
        p.add((Component)this.enableAfterSpinner, c);
        c.gridx = 3;
        c.gridy = 1;
        p.add((Component)new JLabel(this.getRes("label.minutes")), c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getStartupPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.startup"), this.getRes("label.startupDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        p.add((Component)this.lockAutoLoadBox, c);
        c.insets = new Insets(0, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        p.add((Component)this.systemStartRButton, c);
        c.insets = new Insets(0, 20, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        p.add((Component)this.savStartRButton, c);
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        p.add((Component)this.lockShutdownBox, c);
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        p.add((Component)this.noFloppyBox, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        result.addHierarchyListener(new HierarchyListenerImpl());
        return result;
    }

    private void updatePanel() {
        Boolean b = this.advOptions.getOptLockWhenToLoadAp();
        if (b == null) {
            b = this.advOptions.getDefLockWhenToLoadAp();
        }
        this.lockAutoLoadBox.setSelected(b);
        Integer i = this.advOptions.getWhenToLoadAp();
        if (i != null && i.equals(ApFileAdvancedOptions.SAV_START)) {
            this.savStartRButton.setSelected(true);
        } else {
            this.systemStartRButton.setSelected(true);
        }
        b = this.advOptions.getOptLockCheckFloppyWhenOSDown();
        if (b == null) {
            b = this.advOptions.getDefLockCheckFloppyWhenOSDown();
        }
        this.lockShutdownBox.setSelected(b);
        b = this.advOptions.getOptCheckFloppyWhenOSDown();
        if (b == null) {
            b = this.advOptions.getDefCheckFloppyWhenOSDown();
        }
        this.noFloppyBox.setSelected(b);
        b = this.advOptions.getOptLockWhenToReloadAp();
        if (b == null) {
            b = this.advOptions.getDefLockWhenToReloadAp();
        }
        this.lockAutoReloadBox.setSelected(b);
        i = this.advOptions.getWhenToReloadAp();
        if (i != null && i.equals(ApFileAdvancedOptions.SYSTEM_RESTART)) {
            this.osRestartRButton.setSelected(true);
        } else {
            this.reloadAPRButton.setSelected(true);
        }
        b = this.advOptions.getOptLockEnableApAutomatically();
        if (b == null) {
            b = this.advOptions.getDefLockEnableApAutomatically();
        }
        this.lockAPDisableBox.setSelected(b);
        b = this.advOptions.getOptEnableApAutomatically();
        if (b == null) {
            b = this.advOptions.getDefEnableApAutomatically();
        }
        this.enableAfterBox.setSelected(b);
        i = this.advOptions.getOptEnableApAfterMinutes();
        if (i == null) {
            i = this.advOptions.getDefEnableApAfterMinutes();
        }
        this.enableAfterSpinner.setValue(i);
        this.fileCachePanel.setObject(this.fileCache);
    }

    public void setObject(ApFileAdvancedOptions object) {
        this.advOptions = object;
        this.fileCache = this.advOptions.getOptFileCache();
        if (this.fileCache == null) {
            this.fileCache = new FileCache();
        }
        this.riskTracer = this.advOptions.getOptRiskTracer();
        if (this.riskTracer == null) {
            this.riskTracer = new RiskTracer();
        }
        this.updatePanel();
        this.enableAppropriate();
    }

    public boolean valuesValid() {
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platformType) {
            return "linux_sesm_policies_dialog_av_auto_protect_files_processes_advanced";
        }
        return "sesm_policies_dialog_av_auto_protect_files_processes_advanced";
    }
}

