/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.MsftExchangeAp;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.ap.ActionsPane;
import com.sygate.scm.console.ui.policy.av.ap.ExchangeNotificationPane;
import com.sygate.scm.console.ui.policy.av.ap.MailScanDetailsPane;
import com.sygate.scm.console.ui.policy.av.logicobject.ApActionsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApMailScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MailNotificationObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.JTabbedPane;

public class ApExchangePane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private MsftExchangeAp mailAp;
    private MailScanDetailsPane scanDetailsPane;
    private ApMailScanDetailsObject scanDetailsObj;
    private ApActionsObject apActionsObj;
    private MailNotificationObject notificationObj;
    private ActionsPane actionsPane;
    private ExchangeNotificationPane notificationPane;

    public ApExchangePane() {
        this.init();
    }

    public void save() {
        this.saveData();
    }

    private void init() {
        this.scanDetailsPane = new MailScanDetailsPane(2);
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApWebMailPane.label.scanDetails"), UIUtilities.createScrollPaneWithoutBoard(this.scanDetailsPane));
        this.actionsPane = new ActionsPane(false);
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.action"), UIUtilities.createScrollPaneWithoutBoard(this.actionsPane));
        this.notificationPane = new ExchangeNotificationPane();
        this.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApFilePane.title.notification"), UIUtilities.createScrollPaneWithoutBoard(this.notificationPane));
    }

    private void updateValues() throws ConsoleException {
        boolean isLocked = this.mailAp.getDefLockMsftExchangeAp();
        boolean isEnabled = this.mailAp.getDefEnable();
        if (this.mailAp.getOptLockMsftExchangeAp() != null) {
            isLocked = this.mailAp.getOptLockMsftExchangeAp();
        }
        if (this.mailAp.getOptEnable() != null) {
            isEnabled = this.mailAp.getOptEnable();
        }
        this.scanDetailsObj = new ApMailScanDetailsObject(this.mailAp.getOptApMailScanDetails(), isLocked, isEnabled);
        this.scanDetailsPane.setObject(this.scanDetailsObj);
        ApActions apActions = this.mailAp.getOptApActions();
        this.apActionsObj = new ApActionsObject(apActions);
        this.actionsPane.setObject(this.apActionsObj);
        this.notificationObj = new MailNotificationObject(this.mailAp.getOptApMailNotifications());
        this.notificationPane.setObject(this.notificationObj);
    }

    private void saveData() {
        this.scanDetailsPane.save();
        this.mailAp.setOptApMailScanDetails(this.scanDetailsObj.getSchemaObject());
        this.actionsPane.save();
        this.mailAp.setOptApActions(this.apActionsObj.getSchemaObject());
        this.notificationPane.save();
        this.mailAp.setOptApMailNotifications(this.notificationObj.getSchemaObject());
        this.mailAp.setOptLockMsftExchangeAp(Boolean.valueOf(this.scanDetailsObj.isEnableEmailApLocked()));
        this.mailAp.setOptEnable(Boolean.valueOf(this.scanDetailsObj.isEmailApEnabled()));
    }

    public void setMailApObject(MsftExchangeAp mailAp) throws ConsoleException {
        this.mailAp = mailAp;
        this.updateValues();
    }

    public boolean valuesValid() {
        return this.notificationPane.valuesValid();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }
}

