/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.DownloadAdvisorOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.ap.DownloadProtectionPane;
import com.sygate.scm.console.ui.policy.av.ap.interop.AutoProtectStateChangedListener;
import com.sygate.scm.console.ui.policy.av.ap.interop.AutoProtectStateManager;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.CloudLockPanel;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileDownloadAdvisorObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileScanDetailsObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ApDownloadAdvisorPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final int LOW_REPUTATION_THRESHOLD_LEVEL = 1;
    private static final int MAX_REPUTATION_THRESHOLD_LEVEL = 9;
    private static final int SLIDER_WIDTH = 420;
    private static final int ADDITIONAL_SLIDER_HEIGHT = 20;
    private static final int CONFIDENCE_DESCRIPTION_HEIGHT = 120;
    private JPanel enablePane;
    private JPanel thresholdSettingPanel;
    private JPanel reputationAttributesPanel;
    private JCheckBox enableChk;
    private JPanel trustedIntranetPanel;
    private LockCheckBox lockEnableChk;
    private LockCheckBox lockThresholdSettingEnableChk;
    private JLabel sensitivityLabel;
    private HtmlEnabledJLabel confidenceDescriptionTextLabel;
    private JSlider downloadAdvisorThresholdSlider;
    private ApFileDownloadAdvisorObject fileDaObject;
    private ApFileScanDetailsObject apFileScanDetails;
    private Map<Integer, String> confidanceDescMap;
    private AutoProtectStateManager autoProtectManager;
    private DaAutoProtectHandler daAutoProtectHandler;
    private JCheckBox prevalenceChk;
    private JCheckBox firstSeenTimeChk;
    private JCheckBox trustedIntranetSiteChk;
    private JCheckBox lockTrustedIntranetSiteChk;
    private JComboBox<String> prevalenceCombo;
    private JTextField firstSeenTimeTxt;
    private JLabel reputationActionLabel;
    private Hashtable<Integer, JLabel> sensitivityLabelMap = new Hashtable();

    public ApDownloadAdvisorPanel(DownloadProtectionPane parentPane) {
        this.fileDaObject = new ApFileDownloadAdvisorObject();
        this.initialize();
    }

    public void save() throws ConsoleException {
        ConsoleLogger.log("DownloadAdvisor settings are getting stored");
        this.isValidate();
        this.fileDaObject.setDAThreshold(this.downloadAdvisorThresholdSlider.getValue() * 100);
        this.fileDaObject.setDALockThreshold(this.lockThresholdSettingEnableChk.isSelected());
        this.fileDaObject.setDAPrevalenceThresholdEnable(this.prevalenceChk.isSelected());
        this.fileDaObject.setDAPrevalenceThreshold(this.prevalenceCombo.getSelectedIndex());
        this.fileDaObject.setDAFirstSeenThresholdEnable(this.firstSeenTimeChk.isSelected());
        this.fileDaObject.setDAFirstSeenDaysThreshold(Integer.parseInt(this.firstSeenTimeTxt.getText()));
        this.fileDaObject.setDATrustIntranet(this.trustedIntranetSiteChk.isSelected());
        this.fileDaObject.setLockDATrustIntranet(this.lockTrustedIntranetSiteChk.isSelected());
    }

    private JPanel getEnablePane() {
        if (this.enablePane == null) {
            this.enablePane = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            this.enablePane.setLayout(gridbag);
            this.lockEnableChk = new LockCheckBox(Boolean.FALSE);
            this.lockEnableChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockEnableChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ApDownloadAdvisorPanel.this.fileDaObject.setDALockEnabled(ApDownloadAdvisorPanel.this.lockEnableChk.isSelected());
                }
            });
            this.enablePane.add((Component)this.lockEnableChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.enableChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.checkbox.downloadAdvisor"));
            this.enableChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ApDownloadAdvisorPanel.this.fileDaObject.setDAEnabled(ApDownloadAdvisorPanel.this.enableChk.isSelected());
                    ApDownloadAdvisorPanel.this.enableAppropriate();
                }
            });
            this.enablePane.add((Component)this.enableChk, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 0, 0, 0), 0, 0));
            HtmlEnabledJLabel reputationLinkLabel = new HtmlEnabledJLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.descFileReputation.linkText"), true);
            reputationLinkLabel.setIcon((Icon)ConsoleMain.whatsThisIcon);
            reputationLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    HelpUtil.showHelpOrErrDlg("sesm_policies_dialog_av_auto_protect_files_download_advisor_whatis_filereputation");
                }
            });
            this.enablePane.add((Component)reputationLinkLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 18, new Insets(0, 18, 0, 0), 0, 0));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.enablePane);
        return panel;
    }

    private JPanel getIntranetTrustedPane() {
        if (this.trustedIntranetPanel == null) {
            this.trustedIntranetPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            this.trustedIntranetPanel.setLayout(gridbag);
            this.lockTrustedIntranetSiteChk = new LockCheckBox(Boolean.FALSE);
            this.lockTrustedIntranetSiteChk.setSelectedIcon(AvConstants.lockIcon);
            this.trustedIntranetPanel.add((Component)new CloudLockPanel(this.lockTrustedIntranetSiteChk), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 25, 0, 0), 0, 0));
            this.trustedIntranetSiteChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.checkbox.trustedIntranetSight"));
            this.trustedIntranetPanel.add((Component)this.trustedIntranetSiteChk, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 0, 0, 0), 0, 0));
        }
        if (this.isCloudEnrolled()) {
            this.trustedIntranetSiteChk.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.trustedIntranetPanel);
        return panel;
    }

    private void setDaLock(boolean apEnabled, boolean aplockLockEnabled) {
        if (!apEnabled && aplockLockEnabled) {
            this.lockEnableChk.setSelected(aplockLockEnabled);
        } else {
            this.lockEnableChk.setSelected(this.fileDaObject.getDALockEnabled());
        }
    }

    private void setDaEnabled(boolean enable) {
        this.enableChk.setEnabled(enable);
        this.lockEnableChk.setEnabled(enable);
        if (!enable) {
            this.enableChk.setSelected(enable);
        } else {
            this.enableChk.setSelected(this.fileDaObject.getDAEnabled());
            this.lockEnableChk.setSelected(this.fileDaObject.getDALockEnabled());
        }
        this.enableAppropriate();
    }

    private JPanel getAdditionalReputationAttributePanel() {
        if (this.reputationAttributesPanel == null) {
            this.reputationAttributesPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            this.reputationAttributesPanel.setLayout(gridbag);
            this.reputationActionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.label.additionalReputationAction"));
            this.reputationAttributesPanel.add((Component)this.reputationActionLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 18, new Insets(5, 50, 0, 0), 0, 0));
            this.prevalenceChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.userLabel"));
            this.reputationAttributesPanel.add((Component)this.prevalenceChk, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 18, new Insets(5, 60, 0, 0), 0, 0));
            this.prevalenceCombo = new JComboBox<String>(new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.unknown"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.5users"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.50users"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.100users"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.100susers"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.1000users"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.10000users"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.100000users"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.1000000users")});
            this.prevalenceChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ApDownloadAdvisorPanel.this.prevalenceCombo.setEnabled(ApDownloadAdvisorPanel.this.prevalenceChk.isSelected());
                }
            });
            JLabel prevalenceLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.usersLabel"));
            if (this.isCloudEnrolled()) {
                prevalenceLabel.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
                this.prevalenceChk.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
                this.prevalenceCombo.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            }
            this.reputationAttributesPanel.add(this.prevalenceCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 18, new Insets(5, 10, 0, 0), 0, 0));
            this.reputationAttributesPanel.add((Component)prevalenceLabel, new GridBagConstraints(2, 1, 3, 1, 0.0, 0.0, 18, 18, new Insets(5, 10, 0, 0), 0, 0));
            this.firstSeenTimeChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.timeLabel"));
            this.reputationAttributesPanel.add((Component)this.firstSeenTimeChk, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 18, new Insets(7, 60, 0, 0), 0, 0));
            this.firstSeenTimeTxt = new JTextField(17);
            this.firstSeenTimeTxt.setText("5");
            this.firstSeenTimeChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ApDownloadAdvisorPanel.this.firstSeenTimeTxt.setEnabled(ApDownloadAdvisorPanel.this.firstSeenTimeChk.isSelected());
                }
            });
            this.firstSeenTimeTxt.setDocument(new RestrictedPlainDocument(3, true));
            JLabel firstSeenLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.reputationPrevelance.daysLabel"));
            if (this.isCloudEnrolled()) {
                firstSeenLabel.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
                this.firstSeenTimeChk.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
                this.firstSeenTimeTxt.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            }
            this.reputationAttributesPanel.add((Component)this.firstSeenTimeTxt, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 18, new Insets(7, 12, 0, 0), 0, 0));
            this.reputationAttributesPanel.add((Component)firstSeenLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 18, new Insets(7, 12, 0, 0), 0, 0));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.reputationAttributesPanel);
        return panel;
    }

    private void setSliderAttibutes() {
        this.downloadAdvisorThresholdSlider = new JSlider(0, 1, 9, 3){
            private static final long serialVersionUID = 1L;

            @Override
            public String getUIClassID() {
                return "DASliderUI";
            }
        };
        this.downloadAdvisorThresholdSlider.setMinorTickSpacing(1);
        this.downloadAdvisorThresholdSlider.setMajorTickSpacing(1);
        this.downloadAdvisorThresholdSlider.setPaintTicks(false);
        this.downloadAdvisorThresholdSlider.setSnapToTicks(false);
        this.downloadAdvisorThresholdSlider.setPaintTrack(true);
        this.downloadAdvisorThresholdSlider.setPaintLabels(true);
        this.downloadAdvisorThresholdSlider.setOpaque(false);
        for (int index = 1; index <= 9; ++index) {
            if (1 == index || 5 == index || 9 == index) {
                this.sensitivityLabelMap.put(index, (JLabel)this.getHtmlLabel(index));
                continue;
            }
            this.sensitivityLabelMap.put(index, this.getLabel(index));
        }
        this.downloadAdvisorThresholdSlider.setLabelTable(this.sensitivityLabelMap);
        this.downloadAdvisorThresholdSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JSlider source = (JSlider)event.getSource();
                if (!source.getValueIsAdjusting()) {
                    int confidenceValue = source.getValue();
                    ApDownloadAdvisorPanel.this.setDescriptionText(confidenceValue);
                }
            }
        });
    }

    private void loadConfidanceDescMap() {
        this.confidanceDescMap = new HashMap<Integer, String>(14);
        for (int level = 1; level <= 9; ++level) {
            this.confidanceDescMap.put(level, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.confidanceLevel.desc.level" + level));
        }
    }

    private void enableAppropriate() {
        boolean isEnabled = this.enableChk.isSelected();
        this.downloadAdvisorThresholdSlider.setEnabled(isEnabled);
        this.lockThresholdSettingEnableChk.setEnabled(isEnabled);
        this.confidenceDescriptionTextLabel.setEnabled(isEnabled);
        this.firstSeenTimeChk.setEnabled(isEnabled);
        this.firstSeenTimeTxt.setEnabled(isEnabled);
        this.prevalenceChk.setEnabled(isEnabled);
        this.prevalenceCombo.setEnabled(isEnabled);
        if (this.prevalenceChk.isSelected()) {
            this.prevalenceCombo.setEnabled(isEnabled);
        } else {
            this.prevalenceCombo.setEnabled(false);
        }
        if (this.firstSeenTimeChk.isSelected()) {
            this.firstSeenTimeTxt.setEnabled(isEnabled);
        } else {
            this.firstSeenTimeTxt.setEnabled(false);
        }
    }

    private void initialize() {
        VerticalFlowLayout thisLayout = new VerticalFlowLayout();
        this.setLayout(thisLayout);
        HtmlEnabledJLabel descriptionLabel = new HtmlEnabledJLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.downloadprotection.description"));
        this.add((Component)descriptionLabel);
        this.add(this.getEnablePane());
        this.add(this.getThresholdPanel());
        this.add(this.getAdditionalReputationAttributePanel());
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        this.add(this.getIntranetTrustedPane());
        this.add(panel);
    }

    private void updatePanel() {
        ConsoleLogger.log("APdownloadAdvisor updatePanel method gets called ");
        this.enableChk.setSelected(this.fileDaObject.getDAEnabled());
        this.lockEnableChk.setSelected(this.fileDaObject.getDALockEnabled());
        this.lockThresholdSettingEnableChk.setSelected(this.fileDaObject.getDALockThreshold());
        this.downloadAdvisorThresholdSlider.setValue(this.fileDaObject.getDAThreshold() / 100);
        this.prevalenceChk.setSelected(this.fileDaObject.getDAPrevalenceThresholdEnable());
        this.prevalenceCombo.setSelectedIndex(this.fileDaObject.getDAPrevalenceThreshold());
        this.firstSeenTimeChk.setSelected(this.fileDaObject.getDAFirstSeenThresholdEnable());
        this.firstSeenTimeTxt.setText("" + this.fileDaObject.getDAFirstSeenDaysThreshold());
        this.trustedIntranetSiteChk.setSelected(this.fileDaObject.getDATrustIntranet());
        this.lockTrustedIntranetSiteChk.setSelected(this.fileDaObject.getLockDATrustIntranet());
        boolean apEnableState = this.apFileScanDetails.isApFileEnabled();
        this.setDaEnabled(apEnableState);
        this.setDaLock(apEnableState, this.apFileScanDetails.isEnableApFileLocked());
    }

    private void isValidate() throws NumberFormatException {
        if (this.firstSeenTimeTxt.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.message"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.error"), 0);
            this.firstSeenTimeTxt.setFocusable(true);
            throw new NumberFormatException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.message"));
        }
        try {
            int count = Integer.parseInt(this.firstSeenTimeTxt.getText());
            if (count <= 0 || count > 999) {
                throw new NumberFormatException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.error"));
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.outofbound.message"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.error"), 0);
            this.firstSeenTimeTxt.setFocusable(true);
            throw nfe;
        }
    }

    private String getConfidenceLevelText(int confidenceLevel) {
        Object title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.confidanceLevel.level" + confidenceLevel);
        if (1 == confidenceLevel || 5 == confidenceLevel || 9 == confidenceLevel) {
            title = (String)title + " " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.confidanceLevel.level" + confidenceLevel + ".subtitle");
        }
        return title;
    }

    public void setDescriptionText(int confidenceLevel) {
        String levelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.label.confidanceLevelText") + " " + this.getConfidenceLevelText(confidenceLevel) + ":";
        ConsoleLogger.log("Slider confidence level " + confidenceLevel);
        String confLevelDesc = this.confidanceDescMap.get(confidenceLevel);
        if (confLevelDesc != null) {
            this.confidenceDescriptionTextLabel.setText("<html><body><b>" + levelText + "</b><br><br>" + confLevelDesc + "</body></html>");
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_auto_protect_files_download_protection_da";
    }

    private boolean isCloudEnrolled() {
        return CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    }

    private JPanel getThresholdPanel() {
        if (this.thresholdSettingPanel == null) {
            this.thresholdSettingPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            this.thresholdSettingPanel.setLayout(gridbag);
            this.lockThresholdSettingEnableChk = new LockCheckBox(Boolean.FALSE);
            this.lockThresholdSettingEnableChk.setSelectedIcon(AvConstants.lockIcon);
            this.thresholdSettingPanel.add((Component)new CloudLockPanel(this.lockThresholdSettingEnableChk), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 18, new Insets(5, 25, 0, 0), 0, 0));
            if (this.isCloudEnrolled()) {
                this.lockThresholdSettingEnableChk.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            }
            JPanel panel1 = new JPanel();
            GridBagLayout gridBag1 = new GridBagLayout();
            panel1.setLayout(gridBag1);
            this.sensitivityLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.label.thresholdTitle"));
            this.thresholdSettingPanel.add((Component)this.sensitivityLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 18, new Insets(7, 2, 0, 0), 0, 0));
            if (this.isCloudEnrolled()) {
                this.sensitivityLabel.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            }
            this.setSliderAttibutes();
            this.loadConfidanceDescMap();
            HtmlEnabledJLabel goodReputationLabel = new HtmlEnabledJLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.label.sliderLavel"));
            if (this.isCloudEnrolled()) {
                goodReputationLabel.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            }
            panel1.add((Component)goodReputationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 18, new Insets(5, 5, 0, 5), 0, 0));
            this.downloadAdvisorThresholdSlider.setPreferredSize(new Dimension(420, this.downloadAdvisorThresholdSlider.getPreferredSize().height + 20));
            panel1.add((Component)this.downloadAdvisorThresholdSlider, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 18, new Insets(0, 0, 0, 0), 0, 0));
            if (this.isCloudEnrolled()) {
                this.downloadAdvisorThresholdSlider.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            }
            this.confidenceDescriptionTextLabel = new HtmlEnabledJLabel("");
            this.confidenceDescriptionTextLabel.setPreferredSize(new Dimension(420, 120));
            panel1.add((Component)this.confidenceDescriptionTextLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
            if (this.isCloudEnrolled()) {
                this.confidenceDescriptionTextLabel.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
            }
            this.setDescriptionText(this.downloadAdvisorThresholdSlider.getValue());
            this.thresholdSettingPanel.add((Component)panel1, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 18, 18, new Insets(0, 10, 0, 0), 0, 0));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.thresholdSettingPanel);
        return panel;
    }

    private JLabel getLabel(int confidenceLevel) {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.confidanceLevel.level" + confidenceLevel);
        JLabel label = new JLabel(title);
        if (this.isCloudEnrolled()) {
            label.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        return label;
    }

    private HtmlEnabledJLabel getHtmlLabel(int confidenceLevel) {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.confidanceLevel.level" + confidenceLevel);
        String title1 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "ApDownloadAdvisorPanel.confidanceLevel.level" + confidenceLevel + ".subtitle");
        String text = "<html><body><center>" + title + "</center><br><center>" + title1 + "</center></body></html>";
        HtmlEnabledJLabel label = new HtmlEnabledJLabel(text);
        if (this.isCloudEnrolled()) {
            label.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "GeneralHID.label.cloudEnrolled"));
        }
        return label;
    }

    public void setObject(DownloadAdvisorOptions fileDownloadAdvisorObj, ApFileScanDetailsObject apFileScanDetails) {
        ConsoleLogger.log("APdownloadAdvisorPanel Setting object");
        this.apFileScanDetails = apFileScanDetails;
        this.fileDaObject.setObject(fileDownloadAdvisorObj);
        this.updatePanel();
        this.enableAppropriate();
    }

    public void setApObject(ApFileScanDetailsObject apFileScan) {
        this.apFileScanDetails = apFileScan;
    }

    public void setApStateManager(AutoProtectStateManager apStatemanager) {
        this.autoProtectManager = apStatemanager;
        if (apStatemanager != null) {
            this.daAutoProtectHandler = new DaAutoProtectHandler();
            this.autoProtectManager.registerAutoProtectHandler(this.daAutoProtectHandler);
        }
    }

    private class DaAutoProtectHandler
    implements AutoProtectStateChangedListener {
        private DaAutoProtectHandler() {
        }

        @Override
        public void autoProtectStateChanged(boolean apEnabled, boolean aplockLockEnabled) {
            ApDownloadAdvisorPanel.this.setDaEnabled(apEnabled);
            ApDownloadAdvisorPanel.this.setDaLock(apEnabled, aplockLockEnabled);
        }
    }
}

