/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.ap;

import com.sygate.scm.common.configobject.schema.FileScanningOptions;
import com.sygate.scm.common.configobject.schema.FloppySettings;
import com.sygate.scm.common.configobject.schema.SafeProcessExclusionList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.av.ap.FloppySettingDlg;
import com.sygate.scm.console.ui.policy.av.ap.SafeProcessExclusionDialog;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CompressedFilesPane;
import com.sygate.scm.console.ui.policy.av.logicobject.AdvancedScanSettingsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.CompressedFilesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.DriveTypesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.FloppySettingsObject;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AdvancedScanningDlg
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private AvTemplatePane scanFilePane;
    private CompressedFilesPane compressedFilesPane;
    private AvTemplatePane otherPane;
    private LockCheckBox lockWhenToScanChk;
    private LockCheckBox lockWhenAccessedChk;
    private JCheckBox whenAccessedChk;
    private LockCheckBox lockSafeProcessExclusionChk;
    private JCheckBox safeProcessExclusionChk;
    private LockCheckBox lockLeaveAloneLogChk;
    private LockCheckBox lockPreserveFileTimesChk;
    private JCheckBox leaveAloneLogChk;
    private JCheckBox leaveAloneLogSRTChk;
    private JCheckBox preserveFileTimesChk;
    private JRadioButton whenOpenedRadioBtn;
    private JRadioButton whenModifiedRadioBtn;
    private FloppySettingDlg floppySettingDlg;
    private ApFileScanDetailsObject fileScanObj;
    private AdvancedScanSettingsObject advancedScanSettingsObj;
    private FloppySettingsObject floppyObj;
    private JCheckBox enableCustomProcessListChk;
    private JButton jBCustomProcessList;
    private SafeProcessExclusionList customProcessList;

    public AdvancedScanningDlg(String title, ApFileScanDetailsObject fileScanObj, int platformType) {
        super(title, true, true, true, false, platformType);
        this.fileScanObj = fileScanObj;
    }

    public void setObject(AdvancedScanSettingsObject advancedScanSettingsObj) {
        this.advancedScanSettingsObj = advancedScanSettingsObj;
        this.updatePanel();
    }

    @Override
    protected boolean isValidate() {
        if (this.enableCustomProcessListChk.isSelected() && (this.customProcessList == null || this.customProcessList.getSafeProcessNameCount() == 0)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.err.processListEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void commit() {
        this.saveData();
    }

    @Override
    protected JPanel getContentPanel() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new VerticalFlowLayout());
            this.contentPane.add(this.getScanFilePane());
            JPanel floppyPane = this.getFloppySettingPane();
            JPanel otherPane = this.getOtherPane();
            JPanel compressedPane = this.getScanFileCompressedPane();
            if (1 == this.getPlatFormType()) {
                this.contentPane.add(floppyPane);
                this.contentPane.add(otherPane);
            } else if (3 == this.getPlatFormType()) {
                this.contentPane.add(compressedPane);
            }
        }
        return this.contentPane;
    }

    private JPanel getFloppySettingPane() {
        if (this.floppySettingDlg == null) {
            this.floppySettingDlg = new FloppySettingDlg("");
        }
        return this.floppySettingDlg.getContentPanel();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.getPlatFormType()) {
            return "linux_sesm_policies_dialog_av_auto_protect_files_processes_scan_details_advanced_settings";
        }
        return "sesm_policies_dialog_av_auto_protect_files_processes_scan_details_advanced_settings";
    }

    private JPanel getScanFileCompressedPane() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.scanCompressedFileTitle");
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.scanCompressedFileDesc");
        AvTemplatePane pane = new AvTemplatePane(title, description);
        if (this.compressedFilesPane == null) {
            this.compressedFilesPane = new CompressedFilesPane(false, this.getPlatFormType());
        }
        pane.add(this.compressedFilesPane);
        return pane;
    }

    private JPanel getScanFilePane() {
        if (this.scanFilePane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.scanFile");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.scanFileDesc");
            this.scanFilePane = new AvTemplatePane(title, desc);
            this.lockWhenToScanChk = new LockCheckBox(Boolean.FALSE);
            this.lockWhenToScanChk.setSelectedIcon(AvConstants.lockIcon);
            this.whenOpenedRadioBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.radio.accessedOrModified"));
            this.whenModifiedRadioBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.radio.modified"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.whenOpenedRadioBtn);
            group.add(this.whenModifiedRadioBtn);
            this.lockWhenAccessedChk = new LockCheckBox(Boolean.FALSE);
            this.lockWhenAccessedChk.setSelectedIcon(AvConstants.lockIcon);
            this.whenAccessedChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.accessed"));
            this.lockSafeProcessExclusionChk = new LockCheckBox(Boolean.FALSE);
            this.lockSafeProcessExclusionChk.setSelectedIcon(AvConstants.lockIcon);
            this.safeProcessExclusionChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.processExclusion"));
            this.safeProcessExclusionChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AdvancedScanningDlg.this.safeProcessExclusionChanged();
                }
            });
            this.enableCustomProcessListChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.enableCustomProcessList"));
            this.jBCustomProcessList = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.button.CustomProcessList"));
            this.jBCustomProcessList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AdvancedScanningDlg.this.showProcessList();
                }
            });
            this.lockLeaveAloneLogChk = new LockCheckBox(Boolean.FALSE);
            this.lockLeaveAloneLogChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockPreserveFileTimesChk = new LockCheckBox(Boolean.FALSE);
            this.lockPreserveFileTimesChk.setSelectedIcon(AvConstants.lockIcon);
            this.leaveAloneLogChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.leaveAloneLog"));
            this.preserveFileTimesChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.preserveFileTimes"));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            JPanel pane = new JPanel(new GridBagLayout());
            pane.add((Component)this.lockWhenToScanChk, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 2;
            pane.add((Component)this.whenOpenedRadioBtn, c);
            c.gridx = 1;
            c.gridy = 1;
            pane.add((Component)this.whenModifiedRadioBtn, c);
            if (1 == this.getPlatFormType()) {
                c.gridx = 0;
                c.gridy = 2;
                c.gridwidth = 1;
                pane.add((Component)this.lockWhenAccessedChk, c);
                c.gridx = 1;
                c.gridy = 2;
                c.gridwidth = 2;
                pane.add((Component)this.whenAccessedChk, c);
                c.gridx = 0;
                c.gridy = 3;
                c.gridwidth = 1;
                pane.add((Component)this.lockSafeProcessExclusionChk, c);
                c.gridx = 1;
                c.gridy = 3;
                c.gridwidth = 2;
                pane.add((Component)this.safeProcessExclusionChk, c);
                c.insets = new Insets(5, 20, 0, 0);
                c.gridx = 1;
                c.gridy = 4;
                c.gridwidth = 1;
                pane.add((Component)this.enableCustomProcessListChk, c);
                c.insets = new Insets(5, 0, 0, 0);
                c.gridx = 2;
                c.gridy = 4;
                pane.add((Component)this.jBCustomProcessList, c);
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)pane, "Before");
            this.scanFilePane.add(panel);
        }
        return this.scanFilePane;
    }

    private void safeProcessExclusionChanged() {
        this.jBCustomProcessList.setEnabled(this.safeProcessExclusionChk.isSelected());
        this.enableCustomProcessListChk.setEnabled(this.safeProcessExclusionChk.isSelected());
    }

    private JPanel getOtherPane() {
        if (this.otherPane == null) {
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.label.otherOptions");
            this.otherPane = new AvTemplatePane(title, null);
            this.lockLeaveAloneLogChk = new LockCheckBox(Boolean.FALSE);
            this.lockLeaveAloneLogChk.setSelectedIcon(AvConstants.lockIcon);
            this.lockPreserveFileTimesChk = new LockCheckBox(Boolean.FALSE);
            this.lockPreserveFileTimesChk.setSelectedIcon(AvConstants.lockIcon);
            this.leaveAloneLogChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.leaveAloneLog"));
            this.leaveAloneLogChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AdvancedScanningDlg.this.resetLeaveAloneLogSRTChk(true);
                }
            });
            this.leaveAloneLogSRTChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.leaveAloneLog.SRT"));
            this.preserveFileTimesChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.checkbox.preserveFileTimes"));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            JPanel pane = new JPanel(new GridBagLayout());
            pane.add((Component)this.lockLeaveAloneLogChk, c);
            c.gridx = 1;
            c.gridy = 0;
            pane.add((Component)this.leaveAloneLogChk, c);
            c.insets = new Insets(5, 20, 0, 0);
            c.gridx = 1;
            c.gridy = 1;
            pane.add((Component)this.leaveAloneLogSRTChk, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 2;
            pane.add((Component)this.lockPreserveFileTimesChk, c);
            c.gridx = 1;
            c.gridy = 2;
            pane.add((Component)this.preserveFileTimesChk, c);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)pane, "Before");
            this.otherPane.add(panel);
        }
        return this.otherPane;
    }

    private void resetLeaveAloneLogSRTChk(boolean resetValue) {
        if (this.leaveAloneLogChk.isSelected()) {
            this.leaveAloneLogSRTChk.setEnabled(true);
        } else {
            this.leaveAloneLogSRTChk.setEnabled(false);
            if (resetValue) {
                this.leaveAloneLogSRTChk.setSelected(false);
            }
        }
    }

    private void updatePanel() {
        this.lockWhenToScanChk.setSelected(this.advancedScanSettingsObj.getLockWhenToScanFiles());
        this.lockWhenAccessedChk.setSelected(this.advancedScanSettingsObj.getLockScanFilesOpenedForBackup());
        this.whenAccessedChk.setSelected(this.advancedScanSettingsObj.getScanFilesOpenedForBackup());
        this.safeProcessExclusionChk.setSelected(this.advancedScanSettingsObj.getSafeProcessExclusion());
        this.lockSafeProcessExclusionChk.setSelected(this.advancedScanSettingsObj.getLockSafeProcessExclusion());
        this.enableCustomProcessListChk.setSelected(this.advancedScanSettingsObj.getEnableCustomProcessList());
        this.customProcessList = this.advancedScanSettingsObj.getCustomProcessList();
        if (FileScanningOptions.ON_MODIFIED.equals(this.advancedScanSettingsObj.getWhenToScanFiles())) {
            this.whenModifiedRadioBtn.setSelected(true);
        } else {
            this.whenOpenedRadioBtn.setSelected(true);
        }
        this.lockLeaveAloneLogChk.setSelected(this.advancedScanSettingsObj.getLockForLeaveAloneDeleteInfectedOnCreate());
        this.leaveAloneLogChk.setSelected(this.advancedScanSettingsObj.getForLeaveAloneDeleteInfectedOnCreate());
        this.leaveAloneLogSRTChk.setSelected(this.advancedScanSettingsObj.getForLeaveAloneDeleteInfectedOnCreateSRT());
        this.resetLeaveAloneLogSRTChk(false);
        this.preserveFileTimesChk.setSelected(this.advancedScanSettingsObj.getPreserveFileTimes());
        this.lockPreserveFileTimesChk.setSelected(this.advancedScanSettingsObj.getLockPreserveFileTimes());
        DriveTypesObject driveTypesObj = new DriveTypesObject(this.fileScanObj.getDriveTypes());
        this.floppyObj = driveTypesObj.getFloppySettings() == null ? new FloppySettingsObject(new FloppySettings()) : new FloppySettingsObject(driveTypesObj.getFloppySettings());
        this.floppySettingDlg.setObject(this.floppyObj);
        this.compressedFilesPane.setObject(new CompressedFilesObject(this.advancedScanSettingsObj.getCompressedFiles()));
    }

    private void saveData() {
        this.advancedScanSettingsObj.setLockWhenToScanFiles(this.lockWhenToScanChk.isSelected());
        this.advancedScanSettingsObj.setLockScanFilesOpenedForBackup(this.lockWhenAccessedChk.isSelected());
        this.advancedScanSettingsObj.setScanFilesOpenedForBackup(this.whenAccessedChk.isSelected());
        this.advancedScanSettingsObj.setLockSafeProcessExclusion(this.lockSafeProcessExclusionChk.isSelected());
        this.advancedScanSettingsObj.setSafeProcessExclusion(this.safeProcessExclusionChk.isSelected());
        this.advancedScanSettingsObj.setEnableCustomProcessList(this.enableCustomProcessListChk.isSelected());
        this.advancedScanSettingsObj.setCustomProcessList(this.customProcessList);
        if (this.whenOpenedRadioBtn.isSelected()) {
            this.advancedScanSettingsObj.setWhenToScanFiles(FileScanningOptions.ON_ACCESSED_OR_MODIFIED);
        } else {
            this.advancedScanSettingsObj.setWhenToScanFiles(FileScanningOptions.ON_MODIFIED);
        }
        this.advancedScanSettingsObj.setLockForLeaveAloneDeleteInfectedOnCreate(this.lockLeaveAloneLogChk.isSelected());
        this.advancedScanSettingsObj.setForLeaveAloneDeleteInfectedOnCreate(this.leaveAloneLogChk.isSelected());
        this.advancedScanSettingsObj.setForLeaveAloneDeleteInfectedOnCreateSRT(this.leaveAloneLogSRTChk.isSelected());
        this.advancedScanSettingsObj.setPreserveFileTimes(this.preserveFileTimesChk.isSelected());
        this.advancedScanSettingsObj.setLockPreserveFileTimes(this.lockPreserveFileTimesChk.isSelected());
        this.floppySettingDlg.saveData();
        this.compressedFilesPane.save();
    }

    private void showProcessList() {
        SafeProcessExclusionDialog hDialog = new SafeProcessExclusionDialog((JFrame)Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "AdvancedScanningDlg.title.CustomProcessList"), this.customProcessList == null ? null : this.customProcessList.getSafeProcessName());
        hDialog.setVisible(true);
        if (hDialog.isOk()) {
            this.customProcessList = hDialog.getCustomProcessList();
            if (this.customProcessList == null || this.customProcessList.getSafeProcessNameCount() == 0) {
                this.enableCustomProcessListChk.setSelected(false);
            }
        }
    }
}

