/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.schema.ScanSchedule;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminScanDialog;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ScanSchedulePanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private AdminScanDialog adminScanDialog;
    private JLabel dayOfWeekNONEBox;
    private JLabel labelScheduleNone;
    private JLabel labelScheduleOn;
    private JLabel labelScheduleOnDay;
    private DescriptionTextArea scheduleInfoNote;
    private JRadioButton dailyButton;
    private JRadioButton weeklyButton;
    private JRadioButton monthlyButton;
    private JSpinner dayOfMonthSpinner;
    private JComboBox<String> dayOfWeekBox;
    private TimeSpinner1 timeSpinner;
    private boolean hasHour;
    private boolean hasMinute;
    private boolean hasSecond;
    private boolean hasAmpm;
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private String hourPattern;
    private JCheckBox retryBox;
    private JSpinner retryTimeSpinner;
    private JLabel retryLabel;
    private JRadioButton scanUntilFinished;
    private JRadioButton scanUptoHours;
    private JCheckBox randomizeScanStartTime;
    private JSpinner scanUptoSpinner;
    private int platformType = 1;
    private static final int SCAN_UPTO_SECONDS_DAILY = 72000;
    private static final int SCAN_UPTO_SECONDS_WEEKLY = 601200;
    private static final int SCAN_UPTO_SECONDS_MONTHLY = 2415600;
    private static final int MAX_DALIY_MISSED_SCAN_TIME = 24;
    private static final int MAX_WEEKLY_MISSED_SCAN_TIME = 7;
    private static final int MAX_MONTHLY_MISSED_SCAN_TIME = 11;
    private SpinnerNumberModel scanUptoDailyModel;
    private SpinnerNumberModel scanUptoWeeklyModel;
    private SpinnerNumberModel scanUptoMonthlyModel;
    private Schedule schedule;
    private SpinnerNumberModel hourModel;
    private SpinnerNumberModel dayModel;
    private SpinnerNumberModel monthModel;

    public ScanSchedulePanel(AdminScanDialog adminScanDialog, int platformType) {
        this.platformType = platformType;
        this.adminScanDialog = adminScanDialog;
        this.timeSpinner = new TimeSpinner1(this.timePattern);
        if (this.timePattern.indexOf("h") != -1) {
            this.hourPattern = "h";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("H") != -1) {
            this.hourPattern = "H";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("k") != -1) {
            this.hourPattern = "k";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("K") != -1) {
            this.hourPattern = "K";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("m") != -1) {
            this.hasMinute = true;
        }
        if (this.timePattern.indexOf("s") != -1) {
            this.hasSecond = true;
        }
        if (this.timePattern.indexOf("a") != -1) {
            this.hasAmpm = true;
        }
        this.setupPanel();
    }

    public void updatePanel() {
        Integer min;
        String weekDay;
        Boolean b;
        ScanSchedule scanSchedule = this.adminScanDialog.getScanSchedule();
        if (2 == this.platformType) {
            scanSchedule = this.adminScanDialog.getMacScanSchedule();
        }
        this.schedule = scanSchedule.getSchedule();
        if (this.schedule == null) {
            this.schedule = new Schedule();
        }
        if ((b = scanSchedule.getOptRetryMissedScan()) == null) {
            b = scanSchedule.getDefRetryMissedScan();
        }
        this.retryBox.setSelected(b);
        Integer i = scanSchedule.getOptRetryWithinHours();
        if (i == null) {
            i = scanSchedule.getDefRetryWithinHours();
        }
        int retryTime = i;
        int defaultScanUptoSeconds = 0;
        String monthDay = this.schedule.getOptStartDayOfMonth();
        if (monthDay != null) {
            this.monthlyButton.setSelected(true);
            if (monthDay.indexOf(44) == -1) {
                this.dayOfMonthSpinner.setValue(Integer.valueOf(monthDay));
            }
            this.showCard(this.monthlyButton.getText());
            retryTime /= 24;
            defaultScanUptoSeconds = 2415600;
        }
        if ((weekDay = this.schedule.getOptStartDayOfWeek()) != null) {
            this.weeklyButton.setSelected(true);
            if (weekDay.indexOf(44) == -1) {
                this.dayOfWeekBox.setSelectedIndex((Integer.parseInt(weekDay) - Utility.getCalendarInstance().getFirstDayOfWeek() + 1 + 7) % 7);
            }
            this.showCard(this.weeklyButton.getText());
            retryTime /= 24;
            defaultScanUptoSeconds = 601200;
        }
        if (monthDay == null && weekDay == null) {
            this.dailyButton.setSelected(true);
            this.showCard(this.dailyButton.getText());
            defaultScanUptoSeconds = 72000;
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        String hourStr = this.schedule.getOptStartHour();
        if (hourStr == null) {
            hourStr = this.schedule.getDefStartHour();
        }
        hour = Integer.parseInt(hourStr);
        if (this.hasAmpm) {
            this.timeSpinner.setAmpm(Utility.getAmpmFrom_H_Pattern((int)hour, (String)this.hourPattern));
        }
        if (this.hasHour) {
            hour = Utility.convertHourFrom_H_Pattern((int)hour, (String)this.hourPattern);
        }
        if (this.hasMinute && (min = this.schedule.getOptStartMinute()) != null) {
            minute = min;
        }
        if (this.hasSecond) {
            // empty if block
        }
        this.timeSpinner.setHour(hour);
        this.timeSpinner.setMinute(minute);
        this.timeSpinner.setSecond(second);
        this.updateMissedScanControls();
        this.retryTimeSpinner.setValue(retryTime);
        if (this.dailyButton.isSelected() && retryTime > 24) {
            ((SpinnerNumberModel)this.retryTimeSpinner.getModel()).setMaximum(Integer.valueOf(24));
            this.retryTimeSpinner.setValue(24);
        } else if (this.weeklyButton.isSelected() && retryTime > 7) {
            ((SpinnerNumberModel)this.retryTimeSpinner.getModel()).setMaximum(Integer.valueOf(7));
            this.retryTimeSpinner.setValue(7);
        } else if (this.monthlyButton.isSelected() && retryTime > 11) {
            ((SpinnerNumberModel)this.retryTimeSpinner.getModel()).setMaximum(Integer.valueOf(11));
            this.retryTimeSpinner.setValue(11);
        }
        Integer scanTimeWindow = scanSchedule.getOptScanTimeWindow();
        if (scanTimeWindow == null) {
            scanTimeWindow = scanSchedule.getDefScanTimeWindow();
        }
        if (ScanSchedule.SCAN_UNTIL_FINISHED.equals(scanTimeWindow)) {
            this.scanUntilFinished.setSelected(true);
        } else if (ScanSchedule.SCAN_UPTO.equals(scanTimeWindow)) {
            this.scanUptoHours.setSelected(true);
            Boolean randomizeScanStartTime = scanSchedule.getOptRandomizeScanStartTime();
            if (randomizeScanStartTime == null) {
                randomizeScanStartTime = scanSchedule.getDefRandomizeScanStartTime();
            }
            this.randomizeScanStartTime.setSelected(randomizeScanStartTime);
        }
        Integer scanUpto = scanSchedule.getOptScanUptoSeconds();
        if (scanUpto == null) {
            scanUpto = defaultScanUptoSeconds;
        }
        this.updateScanDurationControls();
        this.scanUptoSpinner.setValue(scanUpto / 3600);
        this.enableAppropriate();
    }

    public void saveObject() {
        ScanSchedule scanSchedule = this.adminScanDialog.getScanSchedule();
        if (2 == this.platformType) {
            scanSchedule = this.adminScanDialog.getMacScanSchedule();
        }
        scanSchedule.setOptRetryMissedScan(Boolean.valueOf(this.retryBox.isSelected()));
        int time = (Integer)this.retryTimeSpinner.getValue();
        scanSchedule.setOptRetryWithinHours(Integer.valueOf(time));
        if (this.monthlyButton.isSelected()) {
            this.schedule.setOptStartDayOfMonth(String.valueOf(this.dayOfMonthSpinner.getValue()));
            scanSchedule.setOptRetryWithinHours(Integer.valueOf(time * 24));
        } else {
            this.schedule.setOptStartDayOfMonth(null);
        }
        if (this.weeklyButton.isSelected()) {
            this.schedule.setOptStartDayOfWeek(String.valueOf((this.dayOfWeekBox.getSelectedIndex() + Calendar.getInstance().getFirstDayOfWeek() - 1) % 7));
            scanSchedule.setOptRetryWithinHours(Integer.valueOf(time * 24));
        } else {
            this.schedule.setOptStartDayOfWeek(null);
        }
        int hour = 0;
        int minute = 0;
        int ampm = -1;
        if (this.hasHour) {
            hour = this.timeSpinner.getHour();
            if (this.hasAmpm) {
                ampm = this.timeSpinner.getAmpm();
            }
            hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
        }
        if (this.hasMinute) {
            minute = this.timeSpinner.getMinute();
        }
        this.schedule.setOptStartHour(String.valueOf(hour));
        this.schedule.setOptStartMinute(Integer.valueOf(minute));
        if (this.scanUntilFinished.isSelected()) {
            scanSchedule.setOptScanTimeWindow(ScanSchedule.SCAN_UNTIL_FINISHED);
        } else {
            scanSchedule.setOptScanTimeWindow(ScanSchedule.SCAN_UPTO);
            int scanUptoHours = (Integer)this.scanUptoSpinner.getValue();
            scanSchedule.setOptScanUptoSeconds(Integer.valueOf(scanUptoHours * 60 * 60));
            scanSchedule.setOptRandomizeScanStartTime(Boolean.valueOf(this.randomizeScanStartTime.isSelected()));
        }
        scanSchedule.setSchedule(this.schedule);
    }

    private void enableAppropriate() {
        boolean allEnable = true;
        this.dailyButton.setEnabled(allEnable);
        this.weeklyButton.setEnabled(allEnable);
        this.monthlyButton.setEnabled(allEnable);
        this.dayOfMonthSpinner.setEnabled(allEnable);
        this.timeSpinner.setEnabled(allEnable);
        this.dayOfWeekBox.setEnabled(allEnable);
        this.retryBox.setEnabled(allEnable);
        this.retryTimeSpinner.setEnabled(allEnable && this.retryBox.isSelected());
        this.scanUptoSpinner.setEnabled(allEnable && this.scanUptoHours.isSelected());
        this.randomizeScanStartTime.setEnabled(allEnable && this.scanUptoHours.isSelected());
    }

    private void showCard(String key) {
        if (key.equals(this.monthlyButton.getText())) {
            this.labelScheduleNone.setVisible(false);
            this.labelScheduleOn.setVisible(false);
            this.labelScheduleOnDay.setVisible(true);
            this.dayOfMonthSpinner.setVisible(true);
            this.dayOfWeekBox.setVisible(false);
            this.dayOfWeekNONEBox.setVisible(false);
            this.scheduleInfoNote.setText(AdminScanDialog.getRes("label.monthlyNote"));
        } else if (key.equals(this.weeklyButton.getText())) {
            this.labelScheduleNone.setVisible(false);
            this.labelScheduleOn.setVisible(true);
            this.labelScheduleOnDay.setVisible(false);
            this.dayOfMonthSpinner.setVisible(false);
            this.dayOfWeekBox.setVisible(true);
            this.dayOfWeekNONEBox.setVisible(false);
            this.scheduleInfoNote.setText("");
        } else if (key.equals(this.dailyButton.getText())) {
            this.labelScheduleNone.setVisible(true);
            this.labelScheduleOn.setVisible(false);
            this.labelScheduleOnDay.setVisible(false);
            this.dayOfMonthSpinner.setVisible(false);
            this.dayOfWeekBox.setVisible(false);
            this.dayOfWeekNONEBox.setVisible(true);
            this.scheduleInfoNote.setText(AdminScanDialog.getRes("label.dailyNote"));
        }
    }

    private void setupSchedPanes() {
        this.labelScheduleNone = new JLabel("");
        this.dayOfWeekNONEBox = new JLabel("");
        this.dayOfWeekNONEBox.setPreferredSize(this.dayOfWeekNONEBox.getPreferredSize());
        this.labelScheduleOn = new JLabel(AdminScanDialog.getRes("label.on"));
        this.labelScheduleOnDay = new JLabel(AdminScanDialog.getRes("label.onDay"));
        int maxWidth = Math.max(this.labelScheduleOnDay.getPreferredSize().width, this.labelScheduleOn.getPreferredSize().width);
        Dimension d = new Dimension(maxWidth, this.labelScheduleOnDay.getPreferredSize().height);
        this.labelScheduleNone.setPreferredSize(d);
        this.labelScheduleOn.setPreferredSize(d);
        this.labelScheduleOnDay.setPreferredSize(d);
        this.scheduleInfoNote = new DescriptionTextArea(null, 30);
    }

    private void setupComponents() {
        this.dailyButton = new JRadioButton(AdminScanDialog.getRes("rbutton.daily"));
        this.dailyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ScanSchedulePanel.this.dailyButton.setFocusPainted(true);
                ScanSchedulePanel.this.showCard(ScanSchedulePanel.this.dailyButton.getText());
                ScanSchedulePanel.this.updateMissedScanControls();
                ScanSchedulePanel.this.updateScanDurationControls();
            }
        });
        this.weeklyButton = new JRadioButton(AdminScanDialog.getRes("rbutton.weekly"));
        this.weeklyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ScanSchedulePanel.this.showCard(ScanSchedulePanel.this.weeklyButton.getText());
                ScanSchedulePanel.this.updateMissedScanControls();
                ScanSchedulePanel.this.updateScanDurationControls();
            }
        });
        this.monthlyButton = new JRadioButton(AdminScanDialog.getRes("rbutton.monthly"));
        this.monthlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ScanSchedulePanel.this.showCard(ScanSchedulePanel.this.monthlyButton.getText());
                ScanSchedulePanel.this.updateMissedScanControls();
                ScanSchedulePanel.this.updateScanDurationControls();
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.dailyButton);
        bg.add(this.weeklyButton);
        bg.add(this.monthlyButton);
        String[] days_of_week = new String[7];
        int iFirstDay = Utility.getCalendarInstance().getFirstDayOfWeek() - 1;
        for (int i = 0; i < 7; ++i) {
            days_of_week[i] = AdminScanDialog.DAYS_OF_WEEK[(iFirstDay + i) % 7];
        }
        this.dayOfWeekBox = new JComboBox<String>(days_of_week);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 28, 1);
        this.dayOfMonthSpinner = new JSpinner(model);
        UIUtilities.enableOnlyValidEdits(this.dayOfMonthSpinner);
        this.setupSchedPanes();
        this.retryBox = new JCheckBox(AdminScanDialog.getRes("checkbox.retry"));
        this.retryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanSchedulePanel.this.enableAppropriate();
            }
        });
        this.hourModel = new SpinnerNumberModel(8, 1, 24, 1);
        this.dayModel = new SpinnerNumberModel(3, 1, 7, 1);
        this.monthModel = new SpinnerNumberModel(11, 1, 11, 1);
        this.retryTimeSpinner = new JSpinner(this.hourModel);
        UIUtilities.enableOnlyValidEdits(this.retryTimeSpinner);
        this.scanUntilFinished = new JRadioButton(AdminScanDialog.getRes("rbutton.scanDuration.scanUntiFinished"));
        this.scanUptoHours = new JRadioButton(AdminScanDialog.getRes("rbutton.scanDuration.scanUpto"));
        ButtonGroup scanDurationButtonGroup = new ButtonGroup();
        scanDurationButtonGroup.add(this.scanUntilFinished);
        scanDurationButtonGroup.add(this.scanUptoHours);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanSchedulePanel.this.enableAppropriate();
            }
        };
        this.scanUntilFinished.addActionListener(listener);
        this.scanUptoHours.addActionListener(listener);
        this.randomizeScanStartTime = new JCheckBox(AdminScanDialog.getRes("checkbox.randomizeScanStartTime"));
        this.scanUptoDailyModel = new SpinnerNumberModel(20, 1, 23, 1);
        this.scanUptoWeeklyModel = new SpinnerNumberModel(167, 1, 167, 1);
        this.scanUptoMonthlyModel = new SpinnerNumberModel(671, 1, 671, 1);
        this.scanUptoSpinner = new JSpinner(this.scanUptoDailyModel);
        UIUtilities.enableOnlyValidEdits(this.scanUptoSpinner);
    }

    private JPanel getSchedulePane() {
        AvTemplatePane result = new AvTemplatePane(AdminScanDialog.getRes("label.scanSchedTitle"), AdminScanDialog.getRes("label.scanSchedDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)new JLabel(AdminScanDialog.getRes("label.scanInterval")), c);
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        p.add((Component)this.dailyButton, c);
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 2;
        c.gridy = 0;
        p.add((Component)this.weeklyButton, c);
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 3;
        c.gridy = 0;
        p.add((Component)this.monthlyButton, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)new JLabel(AdminScanDialog.getRes("label.intervalAt")), c);
        c.insets = new Insets(5, 8, 0, 0);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 0;
        p.add((Component)this.timeSpinner, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = new Insets(18, 0, 0, 0);
        p.add((Component)this.labelScheduleNone, c);
        c.insets = new Insets(10, 0, 0, 0);
        p.add((Component)this.labelScheduleOn, c);
        c.insets = new Insets(9, 0, 0, 0);
        p.add((Component)this.labelScheduleOnDay, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 3;
        c.insets = new Insets(18, 9, 0, 0);
        p.add((Component)this.dayOfWeekNONEBox, c);
        c.insets = new Insets(10, 9, 0, 0);
        p.add(this.dayOfWeekBox, c);
        c.insets = new Insets(9, 9, 0, 0);
        p.add((Component)this.dayOfMonthSpinner, c);
        if (2 == this.platformType) {
            c.gridx = 1;
            c.gridy = 3;
            p.add((Component)this.scheduleInfoNote, c);
        }
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        result.addHierarchyListener(new HierarchyListenerImpl());
        return result;
    }

    private JPanel getScanDurationPane() {
        AvTemplatePane result = new AvTemplatePane(AdminScanDialog.getRes("label.scanDuration"), null);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.scanUntilFinished, c);
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(this.scanUptoHours);
        panel.add(this.scanUptoSpinner);
        panel.add(new JLabel("  " + AdminScanDialog.getRes("scanDuration.Hours")));
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)panel, c);
        c.insets = new Insets(5, 15, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)this.randomizeScanStartTime, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getMissedPane() {
        JLabel additionalTitleLabel = null;
        AvTemplatePane result = new AvTemplatePane(AdminScanDialog.getRes("label.scanSchedMissedTitle"), AdminScanDialog.getRes("label.scanSchedMissedDesc"), additionalTitleLabel);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.retryBox, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        p.add((Component)this.retryTimeSpinner, c);
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 2;
        c.gridy = 0;
        this.retryLabel = new JLabel(AdminScanDialog.getRes("label.retry.days"));
        p.add((Component)this.retryLabel, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private void updateMissedScanControls() {
        String labelText = null;
        SpinnerNumberModel model = null;
        if (this.dailyButton.isSelected()) {
            labelText = AdminScanDialog.getRes("label.retry.hours");
            model = this.hourModel;
        } else if (this.weeklyButton.isSelected()) {
            labelText = AdminScanDialog.getRes("label.retry.days");
            model = this.dayModel;
        } else {
            labelText = AdminScanDialog.getRes("label.retry.days");
            model = this.monthModel;
        }
        this.retryLabel.setText(labelText);
        this.retryTimeSpinner.setModel(model);
        UIUtilities.enableOnlyValidEdits(this.retryTimeSpinner);
    }

    private void updateScanDurationControls() {
        SpinnerNumberModel model = null;
        model = this.dailyButton.isSelected() ? this.scanUptoDailyModel : (this.weeklyButton.isSelected() ? this.scanUptoWeeklyModel : this.scanUptoMonthlyModel);
        this.scanUptoSpinner.setModel(model);
        UIUtilities.enableOnlyValidEdits(this.scanUptoSpinner);
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new VerticalFlowLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        this.add(this.getSchedulePane());
        if (1 == this.platformType) {
            this.add(this.getScanDurationPane());
        }
        this.add(this.getMissedPane());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platformType) {
            return "sesm_policies_dialog_av_ads_scans_edit_scan_schedule";
        }
        if (2 == this.platformType) {
            return "sesm_policies_dialog_av_ads_scans_edit_scan_schedule";
        }
        return "sesm_policies_dialog_av_ads_scans_edit_scan_schedule";
    }
}

