/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AdvancedScanOptions;
import com.sygate.scm.common.configobject.schema.CompressedFiles;
import com.sygate.scm.common.configobject.schema.FileTypes;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.StorageMigration;
import com.sygate.scm.common.configobject.schema.Throttling;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminScanDialog;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdvancedScanningOptionsDialog;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.FolderScanPane;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.ScanDetailsAdditionalPane;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CompressedFilesPane;
import com.sygate.scm.console.ui.policy.av.common.DirectoryEditDialog;
import com.sygate.scm.console.ui.policy.av.common.FileTypesPane;
import com.sygate.scm.console.ui.policy.av.logicobject.CompressedFilesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.FileTypesObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ScanDetailsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String AV_ADS_AVSCAN = "com.sygate.scm.console.ui.policy.av.adminscan.avscan";
    private static final String scanDirsDisplayRes = MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.text.scanDirsDisplay");
    private AdminScanDialog adminScanDialog;
    private JComboBox<String> typeBox;
    private JTextArea directoryArea;
    private AlwaysEnabledButton editDirButton;
    private JLabel scanTypeLabel;
    private FolderScanPane folderScanPane;
    private FileTypesPane fileTypesPane;
    private JCheckBox memoryBox;
    private JCheckBox commonInfectBox;
    private JCheckBox wellknownBox;
    private AlwaysEnabledButton advScanButton;
    private FileTypes fileTypes;
    private AdvancedScanOptions advOptions;
    private String scanDirs;
    private CompressedFilesPane compressedFilesPane;
    private ScanDetailsAdditionalPane additionalPane;
    private int platFormType = 1;

    public ScanDetailsPanel(AdminScanDialog adminScanDialog, int platFormType) {
        this.adminScanDialog = adminScanDialog;
        this.platFormType = platFormType;
        this.setupPanel();
    }

    public void saveObject() {
        if (3 == this.platFormType) {
            this.adminScanDialog.getLinuxObject().setScanType(LinuxAdminDefinedScan.CUSTOM);
            this.folderScanPane.save();
            this.compressedFilesPane.save();
            this.additionalPane.save();
        } else if (1 == this.platFormType) {
            this.adminScanDialog.getObject().setScanType(Integer.valueOf(this.typeBox.getSelectedIndex()));
            this.adminScanDialog.getScanDetails().setOptScanDirectories(this.scanDirs);
        }
        this.fileTypesPane.save();
        this.adminScanDialog.getScanDetails().setFileTypes(this.fileTypes);
        this.adminScanDialog.getScanDetails().setOptCheckMemory(Boolean.valueOf(this.memoryBox.isSelected()));
        this.adminScanDialog.getScanDetails().setOptCheckCommonInfectionLocations(Boolean.valueOf(this.commonInfectBox.isSelected()));
        this.adminScanDialog.getScanDetails().setOptCheckWellKnownProblemLocations(Boolean.valueOf(this.wellknownBox.isSelected()));
        this.adminScanDialog.getScanDetails().setOptAdvancedScanOptions(this.advOptions);
    }

    private void enableAppropriate() {
        boolean isFull;
        this.directoryArea.setEnabled(false);
        this.editDirButton.setEnabled(false);
        this.memoryBox.setEnabled(false);
        this.commonInfectBox.setEnabled(false);
        this.wellknownBox.setEnabled(false);
        boolean isCustom = this.typeBox.getSelectedIndex() == AdminDefinedScan.CUSTOM.intValue();
        boolean isQuick = this.typeBox.getSelectedIndex() == AdminDefinedScan.QUICK.intValue();
        boolean bl = isFull = this.typeBox.getSelectedIndex() == AdminDefinedScan.FULL.intValue();
        if (isCustom) {
            this.directoryArea.setEnabled(true);
            this.editDirButton.setEnabled(true);
            this.memoryBox.setEnabled(true);
            this.commonInfectBox.setEnabled(true);
            this.wellknownBox.setEnabled(true);
        }
        if (isQuick) {
            this.memoryBox.setSelected(true);
            this.commonInfectBox.setSelected(true);
            this.wellknownBox.setEnabled(true);
            this.scanDirs = "";
            this.directoryArea.setText("");
        }
        if (isFull) {
            this.memoryBox.setSelected(true);
            this.commonInfectBox.setSelected(true);
            this.wellknownBox.setSelected(true);
            this.scanDirs = "[AllDrives]";
            this.directoryArea.setText(scanDirsDisplayRes);
        }
    }

    private void setupComponents() {
        this.typeBox = new JComboBox<String>(new String[]{AdminScanDialog.getRes("box.quick"), AdminScanDialog.getRes("box.full"), AdminScanDialog.getRes("box.custom")});
        this.typeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanDetailsPanel.this.enableAppropriate();
            }
        });
        this.directoryArea = new JTextArea();
        this.directoryArea.setRows(4);
        this.directoryArea.setColumns(22);
        this.directoryArea.setEditable(false);
        this.directoryArea.setLineWrap(true);
        this.editDirButton = new AlwaysEnabledButton(AdminScanDialog.getRes("button.editDir"));
        this.editDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryEditDialog ded = new DirectoryEditDialog(AdminScanDialog.getRes("label.dirEditTitle"));
                ded.setReadOnly(ScanDetailsPanel.this.editDirButton.isChildWindowReadOnly());
                ded.setObject(ScanDetailsPanel.this.scanDirs);
                ReadOnlyUtils.disableDialogIfNeeded(ScanDetailsPanel.this.editDirButton, ded);
                ded.setVisible(true);
                if (ded.isOk()) {
                    ScanDetailsPanel.this.scanDirs = ded.getObject();
                    if ("[AllDrives]".equals(ScanDetailsPanel.this.scanDirs)) {
                        ScanDetailsPanel.this.directoryArea.setText(scanDirsDisplayRes);
                    } else {
                        ScanDetailsPanel.this.directoryArea.setText(ScanDetailsPanel.this.scanDirs);
                    }
                }
            }
        });
        this.fileTypesPane = new FileTypesPane(false, false, this.platFormType, true);
        this.folderScanPane = new FolderScanPane();
        this.compressedFilesPane = new CompressedFilesPane(true, this.platFormType);
        this.additionalPane = new ScanDetailsAdditionalPane();
        this.memoryBox = new JCheckBox(AdminScanDialog.getRes("box.memory"));
        this.commonInfectBox = new JCheckBox(AdminScanDialog.getRes("box.commonInfect"));
        this.wellknownBox = new JCheckBox(AdminScanDialog.getRes("box.wellknown"));
        this.advScanButton = new AlwaysEnabledButton(AdminScanDialog.getRes("button.advScan"));
        this.advScanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedScanningOptionsDialog asod = new AdvancedScanningOptionsDialog(AdminScanDialog.getRes("label.advScanTitle"));
                asod.setObject(ScanDetailsPanel.this.advOptions);
                ReadOnlyUtils.disableDialogIfNeeded(ScanDetailsPanel.this.advScanButton, asod);
                asod.setVisible(true);
                if (asod.isOk()) {
                    ScanDetailsPanel.this.advOptions = asod.getObject();
                }
            }
        });
    }

    private JPanel getScanFileCompressedPane() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        JLabel titleLabel = new JLabel(AdminScanDialog.getRes("label.scanCompressedFileDesc"));
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)titleLabel, c);
        c.gridy = 1;
        p.add((Component)this.compressedFilesPane, c);
        return p;
    }

    private JPanel getTopDetailsPane() {
        this.scanTypeLabel = new JLabel(AdminScanDialog.getRes("label.scanType"));
        JPanel p = new JPanel(new GridBagLayout());
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)p, "Before");
        return result;
    }

    private JPanel getScanDetailsPane() {
        AvTemplatePane result = new AvTemplatePane(AdminScanDialog.getRes("label.scanDetailsTitle"), AdminScanDialog.getRes("label.scanDetailsDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.scanTypeLabel);
        panel.add(this.typeBox);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)panel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)new JLabel(AdminScanDialog.getRes("label.scanDirs")), c);
        JPanel scanP = new JPanel(new GridBagLayout());
        GridBagConstraints scanC = new GridBagConstraints();
        scanC.fill = 2;
        scanC.insets = new Insets(5, 0, 0, 0);
        scanC.gridx = 0;
        scanC.gridy = 1;
        scanC.weightx = 0.95;
        JScrollPane jsp = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jsp, (JTextArea)this.directoryArea);
        jsp.setPreferredSize(this.directoryArea.getPreferredSize());
        scanP.add((Component)jsp, scanC);
        scanC.insets = new Insets(5, 5, 0, 0);
        scanC.gridx = 1;
        scanC.gridy = 1;
        scanC.weightx = 0.05;
        scanC.anchor = 18;
        scanC.fill = 0;
        scanP.add((Component)this.editDirButton, scanC);
        c.insets = new Insets(2, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        p.add((Component)scanP, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 21;
        p.add((Component)this.fileTypesPane, c);
        c.gridwidth = 1;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 5;
        JLabel l = new JLabel(AdminScanDialog.getRes("label.enhanceScan"));
        p.add((Component)l, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 6;
        p.add((Component)this.memoryBox, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 7;
        p.add((Component)this.commonInfectBox, c);
        c.gridwidth = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 8;
        c.fill = 2;
        p.add((Component)this.wellknownBox, c);
        c.gridwidth = 1;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 10;
        c.fill = 0;
        p.add((Component)this.advScanButton, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getScanDetailsLinuxPane() {
        AvTemplatePane result = new AvTemplatePane(AdminScanDialog.getRes("label.scanDetailsTitle"), null);
        int gridy = 0;
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        ++gridy;
        c.gridy = gridy++;
        p.add((Component)this.folderScanPane, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridy = gridy++;
        p.add((Component)this.fileTypesPane, c);
        c.gridy = gridy++;
        p.add((Component)this.getScanFileCompressedPane(), c);
        c.gridy = gridy;
        p.add((Component)this.additionalPane, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private void updateTopPanel() {
        if (this.adminScanDialog.isCommand()) {
            this.typeBox.setSelectedIndex(AdminDefinedScan.CUSTOM);
            this.typeBox.setEnabled(false);
            this.typeBox.setVisible(false);
            this.scanTypeLabel.setVisible(false);
        } else {
            Integer i = null;
            if (3 == this.platFormType) {
                i = this.adminScanDialog.getLinuxObject().getScanType();
            } else if (1 == this.platFormType) {
                i = this.adminScanDialog.getObject().getScanType();
            }
            if (i == null) {
                i = 0;
            }
            this.typeBox.setSelectedIndex(i);
            this.typeBox.setVisible(true);
            this.scanTypeLabel.setVisible(true);
        }
    }

    public void updatePanel() {
        this.fileTypes = this.adminScanDialog.getScanDetails().getFileTypes();
        if (this.fileTypes == null) {
            this.fileTypes = new FileTypes();
        }
        this.advOptions = this.adminScanDialog.getScanDetails().getOptAdvancedScanOptions();
        if (this.advOptions == null) {
            this.advOptions = new AdvancedScanOptions();
            this.advOptions.setCompressedFiles(new CompressedFiles());
            this.advOptions.setStorageMigration(new StorageMigration());
            this.advOptions.setThrottling(new Throttling());
        }
        this.scanDirs = this.adminScanDialog.getScanDetails().getOptScanDirectories();
        if (this.scanDirs == null) {
            this.scanDirs = "";
        }
        this.updateTopPanel();
        this.updateTopPanel();
        if ("[AllDrives]".equals(this.scanDirs)) {
            this.directoryArea.setText(scanDirsDisplayRes);
        } else {
            this.directoryArea.setText(this.scanDirs);
        }
        this.fileTypesPane.setObject(new FileTypesObject(this.fileTypes));
        this.folderScanPane.setObject(this.adminScanDialog.getScanDetails());
        this.compressedFilesPane.setObject(new CompressedFilesObject(this.advOptions.getCompressedFiles()));
        this.additionalPane.setObject(this.adminScanDialog.getScanDetails());
        Boolean b = this.adminScanDialog.getScanDetails().getOptCheckMemory();
        if (b == null) {
            b = Boolean.TRUE;
        }
        this.memoryBox.setSelected(b);
        b = this.adminScanDialog.getScanDetails().getOptCheckCommonInfectionLocations();
        if (b == null) {
            b = Boolean.TRUE;
        }
        this.commonInfectBox.setSelected(b);
        b = this.adminScanDialog.getScanDetails().getOptCheckWellKnownProblemLocations();
        if (b == null) {
            b = Boolean.TRUE;
        }
        this.wellknownBox.setSelected(b);
        this.enableAppropriate();
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new VerticalFlowLayout());
        this.add(this.getTopDetailsPane());
        if (1 == this.platFormType) {
            this.add(this.getScanDetailsPane());
        } else if (3 == this.platFormType) {
            this.add(this.getScanDetailsLinuxPane());
        }
    }

    public boolean valuesValid() {
        if (1 == this.platFormType && this.typeBox.getSelectedIndex() != AdminDefinedScan.QUICK.intValue() && (this.scanDirs == null || this.scanDirs.trim().length() == 0)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), AdminScanDialog.getRes("label.emptyDirs"), AdminScanDialog.getRes("label.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (3 == this.platFormType) {
            return "linux_sesm_policies_dialog_av_ads_scans_edit_scan_scan_details";
        }
        return "sesm_policies_dialog_av_ads_scans_edit_scan_scan_details";
    }
}

