/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.AdminDefinedScanDetails;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScanDetailsAdditionalPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel additionLabel;
    private JCheckBox scanForSecurityRiskChk;
    private AdminDefinedScanDetails scanDetails;

    public ScanDetailsAdditionalPane() {
        this.setupPanel();
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 21;
        c1.fill = 2;
        c1.weightx = 5.0E-4;
        c1.insets = new Insets(0, 0, 0, 0);
        c1.gridx = 0;
        c1.gridy = 0;
        this.add((Component)this.additionLabel, c1);
        c1.gridx = 0;
        c1.gridy = 1;
        this.add((Component)this.scanForSecurityRiskChk, c1);
    }

    private void setupComponents() {
        this.additionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.label.additionalOptions"));
        this.scanForSecurityRiskChk = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.ap.avap", "FileScanDetailsPane.checkbox.scanForSecurityRisk"));
    }

    private void enableAppropriate() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        boolean enabled = !AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context);
        this.scanForSecurityRiskChk.setEnabled(enabled);
    }

    public void save() {
        this.scanDetails.setOptScanSecurityRisks(Boolean.valueOf(this.scanForSecurityRiskChk.isSelected()));
    }

    private void updatePanel() {
        if (this.scanDetails.getOptScanSecurityRisks() == null) {
            this.scanForSecurityRiskChk.setSelected(this.scanDetails.getDefScanSecurityRisks());
        } else {
            this.scanForSecurityRiskChk.setSelected(this.scanDetails.getOptScanSecurityRisks());
        }
        this.enableAppropriate();
    }

    public void setObject(AdminDefinedScanDetails scanDetails) {
        this.scanDetails = scanDetails;
        this.updatePanel();
        this.enableAppropriate();
    }
}

