/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.schema.MacAdminDefinedScanDetails;
import com.sygate.scm.common.configobject.schema.Throttling;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminScanDialog;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.MacAdvancedScanningOptionsDialog;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.MacScanDestinationSelectionPane;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class MacScanDetailsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private MacScanDestinationSelectionPane scanDestinationSelectionPane;
    private AdminScanDialog adminScanDialog;
    private Throttling advOptions;
    private AlwaysEnabledButton advScanButton;
    private JLabel jlIdleScanDescription;
    private JCheckBox jcbIdleScan;

    public MacScanDetailsPanel(AdminScanDialog adminScanDialog) {
        this.adminScanDialog = adminScanDialog;
        this.setupPanel();
    }

    public void saveObject() {
        MacAdminDefinedScanDetails macScanDetails = this.adminScanDialog.getMacScanDetails();
        this.scanDestinationSelectionPane.saveObject(macScanDetails);
        macScanDetails.setOptIdleTimeScan(Boolean.valueOf(this.jcbIdleScan.isSelected()));
    }

    public void updatePanel() {
        Boolean isSelected;
        MacAdminDefinedScanDetails macScanDetails = this.adminScanDialog.getMacScanDetails();
        this.scanDestinationSelectionPane.updatePanel(macScanDetails);
        this.advOptions = this.adminScanDialog.getMacScanDetails().getOptThrottling();
        if (this.advOptions == null) {
            this.advOptions = new Throttling();
        }
        this.jcbIdleScan.setSelected((isSelected = macScanDetails.getOptIdleTimeScan()) != null ? isSelected : true);
    }

    private void setupComponents() {
        this.scanDestinationSelectionPane = new MacScanDestinationSelectionPane();
        this.jlIdleScanDescription = new JLabel(AdminScanDialog.getMacRes("label.idleTimeScanDescription"));
        this.jcbIdleScan = new JCheckBox(AdminScanDialog.getMacRes("label.idleTimeScan"));
        this.advScanButton = new AlwaysEnabledButton(AdminScanDialog.getRes("button.advScan"));
        this.advScanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacAdvancedScanningOptionsDialog asod = new MacAdvancedScanningOptionsDialog(AdminScanDialog.getRes("label.advScanTitle"));
                asod.setObject(MacScanDetailsPanel.this.advOptions);
                asod.setVisible(true);
                if (asod.isOk()) {
                    MacScanDetailsPanel.this.advOptions = asod.getObject();
                }
            }
        });
    }

    private JPanel getTopDetailsPane() {
        JPanel p = new JPanel(new GridBagLayout());
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 20));
        result.add((Component)p, "Before");
        return result;
    }

    private JPanel getScanDetailsPane() {
        AvTemplatePane result = new AvTemplatePane(AdminScanDialog.getRes("MacAdminScanDialog.", "label.scanDetailsTitle"), null);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        p.add((Component)this.scanDestinationSelectionPane, c);
        c.anchor = 11;
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        p.add((Component)this.jlIdleScanDescription, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        p.add((Component)this.jcbIdleScan, c);
        c.insets = new Insets(35, 0, 0, 200);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        p.add((Component)this.advScanButton, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new VerticalFlowLayout());
        this.add(this.getTopDetailsPane());
        this.add(this.getScanDetailsPane());
    }

    public boolean valuesValid() {
        return this.scanDestinationSelectionPane.valuesValid();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_av_ads_scans_edit_scan_scan_details";
    }
}

