/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScanDetails;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.StringUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MacScanDestinationSelectionPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String AV_ADS_AVSCAN = "com.sygate.scm.console.ui.policy.av.adminscan.avscan";
    private JRadioButton drives;
    private JRadioButton folders;
    private JCheckBox hardDrives;
    private JCheckBox removableDrives;
    private JCheckBox homeFolder;
    private JCheckBox applicationFolder;
    private JCheckBox libraryFolder;

    public MacScanDestinationSelectionPane() {
        this.setupPanel();
    }

    private String getRes(String component, String key) {
        return MSGRES.getString(AV_ADS_AVSCAN, component + key);
    }

    private String getRes(String key) {
        return this.getRes("MacAdminScanDialog.", key);
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 5.0E-4;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.drives, c);
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.hardDrives, c);
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.removableDrives, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 3;
        this.add((Component)this.folders, c);
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 4;
        this.add((Component)this.homeFolder, c);
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.applicationFolder, c);
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.libraryFolder, c);
    }

    private void setupComponents() {
        ActionListener scanSelectionChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacScanDestinationSelectionPane.this.handleScanSelection();
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.drives = new JRadioButton(this.getRes("label.drives"));
        this.folders = new JRadioButton(this.getRes("label.folders"));
        buttonGroup.add(this.drives);
        buttonGroup.add(this.folders);
        this.drives.addActionListener(scanSelectionChanged);
        this.folders.addActionListener(scanSelectionChanged);
        this.hardDrives = new JCheckBox(this.getRes("label.hardDrives"));
        this.removableDrives = new JCheckBox(this.getRes("label.removableDrives"));
        this.homeFolder = new JCheckBox(this.getRes("label.homeFolder"));
        this.applicationFolder = new JCheckBox(this.getRes("label.applicationFolder"));
        this.libraryFolder = new JCheckBox(this.getRes("label.libraryFolder"));
    }

    private void handleScanSelection() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (this.drives.isSelected()) {
            if (!AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
                this.hardDrives.setEnabled(true);
                this.removableDrives.setEnabled(true);
            }
            this.homeFolder.setEnabled(false);
            this.applicationFolder.setEnabled(false);
            this.libraryFolder.setEnabled(false);
        } else if (this.folders.isSelected()) {
            this.hardDrives.setEnabled(false);
            this.removableDrives.setEnabled(false);
            if (!AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
                this.homeFolder.setEnabled(true);
                this.applicationFolder.setEnabled(true);
                this.libraryFolder.setEnabled(true);
            }
        }
    }

    public void saveObject(MacAdminDefinedScanDetails scanDetails) {
        if (this.drives.isSelected()) {
            scanDetails.setOptScanSelection(MacAdminDefinedScanDetails.DRIVES);
            scanDetails.setOptHardDrives(Boolean.valueOf(this.hardDrives.isSelected()));
            scanDetails.setOptRemovableDrives(Boolean.valueOf(this.removableDrives.isSelected()));
            scanDetails.setOptScanDirectories(null);
        } else if (this.folders.isSelected()) {
            scanDetails.setOptScanSelection(MacAdminDefinedScanDetails.FOLDERS);
            StringBuffer scanDirectoriesBuffer = new StringBuffer();
            if (this.homeFolder.isSelected()) {
                scanDirectoriesBuffer.append(ConstantValue.getMacDirKeysByIndex((int)1)).append(';');
            }
            if (this.applicationFolder.isSelected()) {
                scanDirectoriesBuffer.append(ConstantValue.getMacDirKeysByIndex((int)2)).append(';');
            }
            if (this.libraryFolder.isSelected()) {
                scanDirectoriesBuffer.append(ConstantValue.getMacDirKeysByIndex((int)3)).append(';');
            }
            scanDetails.setOptScanDirectories(scanDirectoriesBuffer.toString());
            scanDetails.setOptHardDrives(null);
            scanDetails.setOptRemovableDrives(null);
        }
    }

    public void updatePanel(MacAdminDefinedScanDetails scanDetails) {
        if (MacAdminDefinedScanDetails.FOLDERS.equals(scanDetails.getOptScanSelection())) {
            this.folders.setSelected(true);
            this.updateScanDirectoryCheckBoxes(scanDetails.getOptScanDirectories());
        } else {
            this.drives.setSelected(true);
            if (Boolean.TRUE.equals(scanDetails.getOptHardDrives())) {
                this.hardDrives.setSelected(true);
            }
            if (Boolean.TRUE.equals(scanDetails.getOptRemovableDrives())) {
                this.removableDrives.setSelected(true);
            }
        }
        this.handleScanSelection();
    }

    private void updateScanDirectoryCheckBoxes(String scanDirectories) {
        if (scanDirectories != null) {
            String[] directories = StringUtilities.parse((String)scanDirectories, (String)";");
            int i = 0;
            int j = 0;
            for (i = 0; i < directories.length; ++i) {
                block6: for (j = 0; j < ConstantValue.getMacDirKeys().length; ++j) {
                    if (!directories[i].equals(ConstantValue.getMacDirKeysByIndex((int)j))) continue;
                    switch (j) {
                        case 1: {
                            this.homeFolder.setSelected(true);
                            continue block6;
                        }
                        case 2: {
                            this.applicationFolder.setSelected(true);
                            continue block6;
                        }
                        case 3: {
                            this.libraryFolder.setSelected(true);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    public boolean valuesValid() {
        if (this.drives.isSelected()) {
            if (!this.hardDrives.isSelected() && !this.removableDrives.isSelected()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("message.SelectAtLeastOneDirves"), this.getRes("title.selectAtLeastOne"), 0);
                return false;
            }
        } else if (this.folders.isSelected() && !this.homeFolder.isSelected() && !this.applicationFolder.isSelected() && !this.libraryFolder.isSelected()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("message.SelectAtLeastOneFolders"), this.getRes("title.selectAtLeastOne"), 0);
            return false;
        }
        return true;
    }
}

