/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.schema.Throttling;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.ClickableSlider;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;

public class MacAdvancedScanningOptionsDialog
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String AV_ADS_AVSCAN = "com.sygate.scm.console.ui.policy.av.adminscan.avscan";
    private Throttling throttling;
    private JTabbedPane tabbedPane;
    private JSlider performanceSlider;
    private HtmlEnabledJLabel throttlingLabel;
    private HtmlEnabledJLabel throttlingLabelBal;
    private HtmlEnabledJLabel throttlingLabelApp;
    private JPanel throttlingPane;

    public MacAdvancedScanningOptionsDialog(String title) {
        super(title, true, true);
    }

    public void setReadonly() {
        UIUtilities.setContainerStatus(this.throttlingPane, false);
        this.resetOKButton(false);
    }

    @Override
    protected void help() {
        HelpUtil.showHelp(((ContentSensitiveHelpPage)((Object)this.tabbedPane.getSelectedComponent())).getContentSensitiveHelpToken());
    }

    @Override
    protected void commit() {
        int scanVal = this.performanceSlider.getValue();
        this.throttling.setOptScanTuning(Long.valueOf(5L * (long)scanVal));
    }

    @Override
    protected JPanel getContentPanel() {
        JPanel result = new JPanel(new BorderLayout());
        this.setupComponents();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.throttlingPane = new ThrottlingPane();
        this.tabbedPane.addTab(this.getRes("label.throttling"), new ThrottlingPane());
        result.add((Component)this.tabbedPane, "Center");
        return result;
    }

    private void updatePanel() {
        Long th = this.throttling.getOptScanTuning();
        if (th == null) {
            th = this.throttling.getDefScanTuning();
        }
        this.performanceSlider.setValue(th.intValue() / 5);
    }

    private void setupComponents() {
        this.performanceSlider = new ClickableSlider(1, 0, 2, 0);
        this.performanceSlider.setSnapToTicks(true);
        this.performanceSlider.setMajorTickSpacing(1);
        this.performanceSlider.setPaintTicks(true);
        this.performanceSlider.setPaintLabels(true);
        this.performanceSlider.setInverted(true);
        this.performanceSlider.setOpaque(false);
    }

    public void setObject(Throttling throttling) {
        this.throttling = throttling;
        this.updatePanel();
    }

    public Throttling getObject() {
        return this.throttling;
    }

    private String getRes(String key) {
        return MSGRES.getString(AV_ADS_AVSCAN, "AdvScanningOptionsDialog." + key);
    }

    private class ThrottlingPane
    extends AvTemplatePane
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        public ThrottlingPane() {
            super(MacAdvancedScanningOptionsDialog.this.getRes("label.tuneopt"), MacAdvancedScanningOptionsDialog.this.getRes("throttling.scanlabel"));
            this.init();
        }

        void init() {
            if (MacAdvancedScanningOptionsDialog.this.throttlingLabel == null) {
                MacAdvancedScanningOptionsDialog.this.throttlingLabel = new HtmlEnabledJLabel("<html>&nbsp;&nbsp;<B>" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.label10") + "</B><BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.desc10") + "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.desc210") + "</html>");
                MacAdvancedScanningOptionsDialog.this.throttlingLabelBal = new HtmlEnabledJLabel("<html>&nbsp;&nbsp;<B>" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.label5") + "</B><BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.desc5") + "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.desc25") + "</html>");
                MacAdvancedScanningOptionsDialog.this.throttlingLabelApp = new HtmlEnabledJLabel("<html>&nbsp;&nbsp;<B>" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.label0") + "</B><BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.desc0") + "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MacAdvancedScanningOptionsDialog.this.getRes("throttling.desc20") + "</html>");
                int widest = MacAdvancedScanningOptionsDialog.this.throttlingLabel.getPreferredSize().width;
                if (MacAdvancedScanningOptionsDialog.this.throttlingLabelApp.getPreferredSize().width > widest) {
                    widest = MacAdvancedScanningOptionsDialog.this.throttlingLabelApp.getPreferredSize().width;
                }
                if (MacAdvancedScanningOptionsDialog.this.throttlingLabelBal.getPreferredSize().width > widest) {
                    widest = MacAdvancedScanningOptionsDialog.this.throttlingLabelBal.getPreferredSize().width;
                }
                MacAdvancedScanningOptionsDialog.this.throttlingLabel.setPreferredSize(new Dimension(widest, MacAdvancedScanningOptionsDialog.this.throttlingLabel.getPreferredSize().height));
                MacAdvancedScanningOptionsDialog.this.throttlingLabelApp.setPreferredSize(new Dimension(widest, MacAdvancedScanningOptionsDialog.this.throttlingLabelApp.getPreferredSize().height));
                MacAdvancedScanningOptionsDialog.this.throttlingLabelBal.setPreferredSize(new Dimension(widest, MacAdvancedScanningOptionsDialog.this.throttlingLabelBal.getPreferredSize().height));
            }
            Hashtable<Integer, HtmlEnabledJLabel> performanceLabelTable = new Hashtable<Integer, HtmlEnabledJLabel>();
            performanceLabelTable.put(0, MacAdvancedScanningOptionsDialog.this.throttlingLabelApp);
            performanceLabelTable.put(1, MacAdvancedScanningOptionsDialog.this.throttlingLabelBal);
            performanceLabelTable.put(2, MacAdvancedScanningOptionsDialog.this.throttlingLabel);
            MacAdvancedScanningOptionsDialog.this.performanceSlider.setLabelTable(performanceLabelTable);
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 3;
            c.anchor = 21;
            c.fill = 3;
            c.insets = new Insets(5, 0, 0, 0);
            p.add((Component)MacAdvancedScanningOptionsDialog.this.performanceSlider, c);
            this.add(p);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans_edit_scan_scan_details_advanced_options_throttling";
        }
    }
}

