/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.schema.MacGeneralScanSettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.SimpleRiskActionsPanel;
import com.sygate.scm.console.ui.policy.av.logicobject.MacGeneralScanSettingsObject;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MacAdminScanCommonSettingsPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JCheckBox scanCompressedChk;
    private JCheckBox allowScanSnoozeChk;
    private JCheckBox allowScanCancelChk;
    private SimpleRiskActionsPanel simpleRiskActionsPanel;
    private JRadioButton showResultIfVirusFound;
    private JRadioButton showResultAlways;
    private Map<Integer, JRadioButton> radioMap;
    private static final String MSG_RESOURCE = "com.sygate.scm.console.ui.policy.av.adminscan.avscan";
    private MacGeneralScanSettingsObject macGeneralScanSettings;

    public MacAdminScanCommonSettingsPane() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(this.getPanel());
        this.enableAllComponents(true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "mac_sesm_policies_dialog_av_ads_advanced";
    }

    public void setObject(MacGeneralScanSettingsObject macGeneralScanSettings) {
        this.macGeneralScanSettings = macGeneralScanSettings;
        this.updatePanel();
    }

    public void save() {
        this.saveData();
    }

    private JPanel getPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        MessageResources msgRsc = MessageResources.getInstance();
        this.scanCompressedChk = new JCheckBox(msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.scanCompressedFiles"));
        this.scanCompressedChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MacAdminScanCommonSettingsPane.this.scanCompressedChk.setFocusPainted(true);
            }
        });
        this.allowScanSnoozeChk = new JCheckBox(msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.allowScanSnooze"));
        this.allowScanCancelChk = new JCheckBox(msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.allowScanCancel"));
        this.simpleRiskActionsPanel = new SimpleRiskActionsPanel(true);
        this.showResultIfVirusFound = new JRadioButton(msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.showResultsOnlyInfected"));
        this.showResultAlways = new JRadioButton(msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.showResultsAll"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.showResultIfVirusFound);
        group.add(this.showResultAlways);
        this.radioMap = new HashMap<Integer, JRadioButton>();
        this.radioMap.put(MacGeneralScanSettings.SHOW_ONLY_WHEN_INFECTED_FILES_FOUND, this.showResultIfVirusFound);
        this.radioMap.put(MacGeneralScanSettings.SHOW_ALL_SCHEDULED_SCAN_RESULTS, this.showResultAlways);
        int xx = 0;
        int yy = 0;
        int widthy = 1;
        double weightx = 1.0;
        double weighty = 1.0;
        Insets insetsTopLabel = new Insets(0, 5, 0, 0);
        xx = 0;
        yy = 0;
        String topLabelStr = msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.label.topLabel");
        JLabel topLabel = new JLabel(topLabelStr);
        this.addComponent(mainPanel, topLabel, xx, yy, 0, widthy, weightx, weighty, 18, 0, insetsTopLabel);
        xx = 0;
        yy += widthy;
        widthy = 1;
        String scanOptionsHeader = msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.label.scanOptions");
        AvTemplatePane scanOptionsheaderPane = new AvTemplatePane(scanOptionsHeader, null);
        Insets insetsHeader = new Insets(0, 0, 0, 0);
        this.addComponent(mainPanel, scanOptionsheaderPane, xx, yy, 0, widthy, weightx, weighty, 18, 2, insetsHeader);
        xx = 0;
        yy += widthy;
        widthy = 1;
        int widthx = 1;
        Insets insetsLeft = new Insets(0, 20, 0, 0);
        this.addComponent(mainPanel, this.scanCompressedChk, xx, yy, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        xx = 0;
        this.addComponent(mainPanel, this.allowScanSnoozeChk, xx, yy += widthy, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        xx = 0;
        this.addComponent(mainPanel, this.allowScanCancelChk, xx, yy += widthy, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        xx = 0;
        yy += widthy;
        widthy = 1;
        String actionsHeader = msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.label.actions");
        AvTemplatePane actionsHeaderPane = new AvTemplatePane(actionsHeader, null);
        this.addComponent(mainPanel, actionsHeaderPane, xx, yy, 0, widthy, weightx, weighty, 18, 2, insetsHeader);
        xx = 0;
        yy += widthy;
        widthy = 1;
        this.addComponent(mainPanel, this.simpleRiskActionsPanel, xx, yy, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        xx = 0;
        yy += widthy;
        widthy = 1;
        String alertsHeader = msgRsc.getString(MSG_RESOURCE, "AdminScanCommonSettingsPanMac.label.alerts");
        AvTemplatePane alertsHeaderPane = new AvTemplatePane(alertsHeader, null);
        this.addComponent(mainPanel, alertsHeaderPane, xx, yy, 0, widthy, weightx, weighty, 18, 2, insetsHeader);
        xx = 0;
        yy += widthy;
        widthy = 1;
        this.addComponent(mainPanel, this.showResultIfVirusFound, xx, yy, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        xx = 0;
        this.addComponent(mainPanel, this.showResultAlways, xx, yy += widthy, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        insetsLeft = new Insets(0, 0, 30, 0);
        xx = 0;
        this.addComponent(mainPanel, new JPanel(), xx, yy += widthy, widthx, widthy, weightx, weighty, 18, 0, insetsLeft);
        return mainPanel;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    private void enableAllComponents(boolean enabled) {
        this.scanCompressedChk.setEnabled(enabled);
        this.allowScanSnoozeChk.setEnabled(enabled);
        this.allowScanCancelChk.setEnabled(enabled);
        this.simpleRiskActionsPanel.enableAppropriate(enabled);
        this.showResultIfVirusFound.setEnabled(enabled);
        this.showResultAlways.setEnabled(enabled);
    }

    private void selectRadioButton(Integer radioIdx) {
        this.radioMap.get(radioIdx).setSelected(true);
    }

    private Integer getSelectedRadioIdx() {
        Integer selectedIdx = null;
        if (this.showResultIfVirusFound.isSelected()) {
            selectedIdx = MacGeneralScanSettings.SHOW_ONLY_WHEN_INFECTED_FILES_FOUND;
        } else if (this.showResultAlways.isSelected()) {
            selectedIdx = MacGeneralScanSettings.SHOW_ALL_SCHEDULED_SCAN_RESULTS;
        }
        return selectedIdx;
    }

    private void updatePanel() {
        this.scanCompressedChk.setSelected(this.macGeneralScanSettings.getCompressedFilesObject().getScanInsideCompressedFiles());
        this.allowScanSnoozeChk.setSelected(this.macGeneralScanSettings.getAllowScanSnooze());
        this.allowScanCancelChk.setSelected(this.macGeneralScanSettings.getAllowScanCancel());
        this.simpleRiskActionsPanel.setObject(this.macGeneralScanSettings.getApActionsObject().getMacApAction());
        this.selectRadioButton(this.macGeneralScanSettings.getScanResultsDisplay());
    }

    private void saveData() {
        this.macGeneralScanSettings.getCompressedFilesObject().setScanInsideCompressedFiles(this.scanCompressedChk.isSelected());
        this.macGeneralScanSettings.setAllowScanSnooze(this.allowScanSnoozeChk.isSelected());
        this.macGeneralScanSettings.setAllowScanCancel(this.allowScanCancelChk.isSelected());
        this.macGeneralScanSettings.getApActionsObject().setMacApAction(this.simpleRiskActionsPanel.save());
        this.macGeneralScanSettings.setScanResultsDisplay(this.getSelectedRadioIdx());
    }
}

