/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAvScanPolicy;
import com.sygate.scm.common.configobject.schema.MacCommandScan;
import com.sygate.scm.common.configobject.schema.MacGeneralScanSettings;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ScanSchedule;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminScanDialog;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.MacAdminScanCommonSettingsPane;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacGeneralScanSettingsObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.xml.sax.SAXException;

public class MacAdminDefinedScanPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private MacAvScanPolicy scanPolicy;
    private MacGeneralScanSettings advSettings;
    private MacGeneralScanSettingsObject macintoshGeneralSettingsObject;
    private MacGeneralScanSettings onDemandScanGeneralSettings;
    private MacGeneralScanSettingsObject onDemandScanGeneralSettingsObject;
    private MacCommandScan commandScan;
    private MacAdminDefinedScan macintoshDefinedAdminDefinedScan;
    private MacAdminDefinedScanPoolObject scanPoolObj;
    private AvPolicyObject avObj;
    private Vector<ObjReference> definedScansObjRefs;
    private Vector<ConfigObject> definedScans;
    private List<MacAdminDefinedScan> deletedScans = new ArrayList<MacAdminDefinedScan>();
    private SortableTableModel model;
    private JTable scansTable;
    private JButton addScanButton;
    private JButton editScanButton;
    private JButton deleteScanButton;
    private AlwaysEnabledButton commandScanButton;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem addScanMenuItem;
    private Action addScanAction;
    private JMenuItem editScanMenuItem;
    private Action editScanAction;
    private JMenuItem deleteScanMenuItem;
    private Action deleteScanAction;
    private String newScanName;
    private int newLastNumber = 0;
    private MacAdminScanCommonSettingsPane commonSetttingsPane;
    private boolean isCommandScanNew = false;
    private JTabbedPane macAdminDefinedScanTabbedPane = new JTabbedPane();
    private JPanel commandScanPanel = null;

    public MacAdminDefinedScanPane() {
        this.setLayout(new VerticalFlowLayout(0, 0, 0, true, false));
        this.setupPanel();
    }

    public void saveObject() throws ConsoleException {
        this.commonSetttingsPane.save();
        this.scanPolicy.setOptMacGeneralScanSettings(this.advSettings);
        this.saveObjReferences();
        this.deleteScansAndReferences();
        this.saveAvScanPolicyObjRef();
        this.scanPolicy.setOptMacCommandScan(this.commandScan);
    }

    private static MacAdminDefinedScan getNewScan(String name) {
        MacAdminDefinedScan defaultScan = null;
        try {
            defaultScan = PolicyHandler.getDefaultMacAdminDefinedScan();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            defaultScan = new MacAdminDefinedScan();
        }
        defaultScan.setName(name);
        defaultScan.setId(GUIDGenerator.getInstance().getGUIDString());
        return defaultScan;
    }

    private void initCommandScan() throws ConsoleException {
        ObjReference obj = this.commandScan.getOptObjReference();
        if (obj != null) {
            this.macintoshDefinedAdminDefinedScan = (MacAdminDefinedScan)PolicyHandler.getObject(obj.getTargetType(), obj.getTargetId());
        }
        if (this.macintoshDefinedAdminDefinedScan == null) {
            this.macintoshDefinedAdminDefinedScan = MacAdminDefinedScanPane.getNewScan("COMMAND_SCAN");
            MetadataAttributes mda = new MetadataAttributes();
            mda.setOwner(new GUID(this.avObj.getId()));
            this.macintoshDefinedAdminDefinedScan.setMetadataAttributes(mda);
            this.avObj.getNewObjSet().put(this.macintoshDefinedAdminDefinedScan.getId(), (TopLevelObject)this.macintoshDefinedAdminDefinedScan);
            this.isCommandScanNew = true;
        }
    }

    private void resolveObjReferences() throws ConsoleException {
        this.initCommandScan();
        this.definedScans = new Vector();
        for (ObjReference obj : this.definedScansObjRefs) {
            MacAdminDefinedScan ads = (MacAdminDefinedScan)PolicyHandler.getObject(obj.getTargetType(), obj.getTargetId());
            this.definedScans.add((ConfigObject)ads);
        }
    }

    private boolean objRefAlreadyDefinedFor(MacAdminDefinedScan ads) {
        for (ObjReference obj : this.definedScansObjRefs) {
            if (!obj.getTargetId().equals(ads.getId())) continue;
            return true;
        }
        return false;
    }

    private void saveCommandScan() throws ConsoleException {
        ObjReference obj = this.commandScan.getOptObjReference();
        if (obj == null) {
            this.commandScan.setOptObjReference(this.saveOneScanAndGetObjRef(this.macintoshDefinedAdminDefinedScan));
            this.commandScan.setOptMacGeneralScanSettings(this.onDemandScanGeneralSettingsObject.getSchemaObject());
        }
    }

    private ObjReference saveOneScanAndGetObjRef(MacAdminDefinedScan scan) throws ConsoleException {
        ObjReference or = new ObjReference();
        or.setTargetId(scan.getId());
        or.setTargetType(scan.getObjectTypeName());
        or.setName("AdminDefinedScanApplied");
        return or;
    }

    private void saveObjReferences() throws ConsoleException {
        this.saveCommandScan();
        for (MacAdminDefinedScan macAdminDefinedScan : this.definedScans) {
            if (this.objRefAlreadyDefinedFor(macAdminDefinedScan)) continue;
            this.definedScansObjRefs.add(this.saveOneScanAndGetObjRef(macAdminDefinedScan));
        }
    }

    private void removeObjRef(String scanID) {
        Iterator<ObjReference> i = this.definedScansObjRefs.iterator();
        while (i.hasNext()) {
            ObjReference or = i.next();
            if (!or.getTargetId().equals(scanID)) continue;
            i.remove();
        }
    }

    private void deleteScansAndReferences() throws ConsoleException {
        for (MacAdminDefinedScan ads : this.deletedScans) {
            this.removeObjRef(ads.getId());
        }
    }

    private void saveAvScanPolicyObjRef() {
        int j;
        boolean isExist;
        ObjReference objRef;
        int i = this.scanPolicy.getObjReferenceCount();
        while (--i >= 0) {
            objRef = this.scanPolicy.getObjReference(i);
            isExist = false;
            for (j = 0; j < this.definedScansObjRefs.size(); ++j) {
                ObjReference ref = this.definedScansObjRefs.get(j);
                if (!objRef.getTargetId().equals(ref.getTargetId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.scanPolicy.removeObjReference(objRef);
        }
        for (i = 0; i < this.definedScansObjRefs.size(); ++i) {
            objRef = this.definedScansObjRefs.get(i);
            isExist = false;
            for (j = 0; j < this.scanPolicy.getObjReferenceCount(); ++j) {
                if (!objRef.getTargetId().equals(this.scanPolicy.getObjReference(j).getTargetId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.scanPolicy.addObjReference(objRef);
        }
    }

    private String getRes(String component, String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", component + key);
    }

    private String getRes(String key) {
        return this.getRes("MacAdminDefinedScanPane.", key);
    }

    private void setupTable() {
        String[] colNames = new String[]{this.getRes("table.column.head.name"), this.getRes("table.column.head.enabled"), this.getRes("table.column.head.when"), this.getRes("table.column.head.desc")};
        this.model = new SortableTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }
        };
        this.model.setColumnNames(colNames);
        this.scansTable = new StripesTable(this.model, false, false);
        this.scansTable.putClientProperty("dynamicEventsEnabled", true);
        this.model.addMouseListenerToHeaderInTable(this.scansTable);
        this.scansTable.getSelectionModel().setSelectionMode(0);
        UIUtilities.setTableColumnWidth(this.scansTable, new float[]{0.4f, 0.1f, 0.25f, 0.25f}, (int)this.scansTable.getPreferredScrollableViewportSize().getWidth());
        this.scansTable.setPreferredScrollableViewportSize(new Dimension(10, 200));
        this.scansTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MacAdminDefinedScanPane.this.scansTable.isEnabled()) {
                    this.maybeShowPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MacAdminDefinedScanPane.this.scansTable.isEnabled()) {
                    this.maybeShowPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && MacAdminDefinedScanPane.this.scansTable.isEnabled() && MacAdminDefinedScanPane.this.scansTable.getSelectedColumn() != 1) {
                    MacAdminDefinedScanPane.this.editScan();
                }
            }

            private void maybeShowPopup(MouseEvent e) {
                Point p = e.getPoint();
                int row = MacAdminDefinedScanPane.this.scansTable.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    return;
                }
                MacAdminDefinedScanPane.this.scansTable.setRowSelectionInterval(row, row);
                TableRow asto = MacAdminDefinedScanPane.this.model.getRow(row);
                if (asto == null) {
                    return;
                }
                MacAdminDefinedScanPane.this.popup.show(MacAdminDefinedScanPane.this.scansTable, e.getX(), e.getY());
            }
        });
    }

    private void saveCopyAsTemplate(MacAdminDefinedScan ads) throws ConsoleException {
        try {
            WashIDHandler idHandler = new WashIDHandler();
            MacAdminDefinedScan tempCopy = (MacAdminDefinedScan)idHandler.duplicateObject((ConfigObject)ads, new HashMap<String, TopLevelObject>());
            this.getScanPoolObj().addPolicyObject(new MacAdminDefinedScanObject(tempCopy));
        }
        catch (SAXException saxe) {
            throw new ConsoleException(saxe);
        }
        catch (ValidationException ve) {
            throw new ConsoleException(ve);
        }
        catch (IOException ioe) {
            throw new ConsoleException(ioe);
        }
    }

    private void addScan() {
        AddScanTypeDialog astd = new AddScanTypeDialog(this.getRes("label.adminScanDialogNewTitle"));
        astd.setPoolObj(this.getScanPoolObj());
        astd.setVisible(true);
        if (astd.isOk()) {
            Vector<MacAdminDefinedScan> result = astd.getObject();
            this.definedScans.addAll(result);
            for (MacAdminDefinedScan scan : result) {
                MetadataAttributes mda = new MetadataAttributes();
                mda.setOwner(new GUID(this.avObj.getId()));
                scan.setMetadataAttributes(mda);
                this.avObj.getNewObjSet().put(scan.getId(), (TopLevelObject)scan);
                AdminScanTableObject asto = new AdminScanTableObject(scan);
                this.model.addRow(asto);
                this.setBtnState();
            }
        }
    }

    private void editScan() {
        MacAdminDefinedScan newObj;
        int selected = this.scansTable.getSelectedRow();
        if (selected == -1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("message.SelectAtLeastOne"), this.getRes("title.selectAtLeastOne"), 1);
            return;
        }
        AdminScanTableObject asto = (AdminScanTableObject)this.model.getRow(selected);
        Vector<TableRow> datavect = this.model.getDataVector();
        Vector<String> allScanNames = new Vector<String>();
        MacAdminDefinedScan tempScan = null;
        for (int i = 0; i < datavect.size(); ++i) {
            tempScan = ((AdminScanTableObject)datavect.get(i)).getAdminScan();
            allScanNames.add(tempScan.getName());
        }
        AdminScanDialog asd = new AdminScanDialog(this.getRes("label.adminScanDialogEditTitle"), false, false, this.getScanPoolObj(), allScanNames, true, false);
        MacAdminDefinedScan oldObj = asto.getAdminScan();
        asd.setObject((MacAdminDefinedScan)oldObj.clone());
        asd.setVisible(true);
        if (asd.isOk() && !ConfigObjectUtils.isEqualObj((Object)(newObj = asd.getMacObject()), (Object)oldObj)) {
            this.avObj.getChangedObjSet().put(newObj.getId(), (TopLevelObject)newObj);
            if (asd.getSaveAsTemplate()) {
                try {
                    this.saveCopyAsTemplate(newObj);
                }
                catch (ConsoleException ce) {
                    LoggerUtilities.logException((Throwable)ce);
                }
            }
            this.model.setRow(selected, new AdminScanTableObject(newObj));
            this.model.fireTableRowsUpdated(selected, selected);
        }
    }

    private void deleteScan() {
        int selected = this.scansTable.getSelectedRow();
        if (selected != -1) {
            int choice = JOptionPane.showConfirmDialog(Manager.getFrame(), this.getRes("label.removeScheduledScan"), this.getRes("title.confirm"), 0);
            if (choice == 0) {
                AdminScanTableObject asto = (AdminScanTableObject)this.model.getRow(selected);
                MacAdminDefinedScan ads = asto.getAdminScan();
                this.deletedScans.add(ads);
                this.avObj.getDeletedObjSet().put(ads.getId(), (TopLevelObject)ads);
                this.model.removeRow(selected);
                this.setBtnState();
            }
        } else {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.getRes("message.SelectAtLeastOne"), this.getRes("title.selectAtLeastOne"), 1);
            return;
        }
    }

    private void setupComponents() {
        this.setupTable();
        this.addScanAction = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacAdminDefinedScanPane.this.addScan();
            }
        };
        this.addScanButton = new JButton(this.addScanAction);
        this.addScanButton.setText(this.getRes("button.addScan"));
        this.addScanMenuItem = new JMenuItem(this.addScanAction);
        this.editScanAction = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacAdminDefinedScanPane.this.editScan();
            }
        };
        this.editScanButton = new JButton(this.editScanAction);
        this.editScanButton.setText(this.getRes("button.editScan"));
        this.editScanMenuItem = new JMenuItem(this.editScanAction);
        this.deleteScanAction = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacAdminDefinedScanPane.this.deleteScan();
            }
        };
        this.deleteScanButton = new JButton(this.deleteScanAction);
        this.deleteScanButton.setText(this.getRes("button.deleteScan"));
        this.setBtnState();
        this.deleteScanMenuItem = new JMenuItem(this.deleteScanAction);
        this.commandScanButton = new AlwaysEnabledButton(this.getRes("button.editScan"));
        this.commandScanButton.setEnabled(true);
        this.commandScanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacAdminDefinedScan newScan;
                AdminScanDialog asd = new AdminScanDialog(MacAdminDefinedScanPane.this.getRes("label.adminScanDialogCommandTitle"));
                try {
                    asd.setObject((MacAdminDefinedScan)MacAdminDefinedScanPane.this.macintoshDefinedAdminDefinedScan.clone(), MacAdminDefinedScanPane.this.onDemandScanGeneralSettingsObject);
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
                ReadOnlyUtils.disableDialogIfNeeded(MacAdminDefinedScanPane.this.commandScanButton, asd);
                asd.setVisible(true);
                if (asd.isOk() && !ConfigObjectUtils.isEqualObj((Object)(newScan = asd.getMacObject()), (Object)MacAdminDefinedScanPane.this.macintoshDefinedAdminDefinedScan)) {
                    MacAdminDefinedScanPane.this.macintoshDefinedAdminDefinedScan = newScan;
                    if (MacAdminDefinedScanPane.this.isCommandScanNew) {
                        MacAdminDefinedScanPane.this.avObj.getNewObjSet().put(MacAdminDefinedScanPane.this.macintoshDefinedAdminDefinedScan.getId(), (TopLevelObject)MacAdminDefinedScanPane.this.macintoshDefinedAdminDefinedScan);
                    } else {
                        MacAdminDefinedScanPane.this.avObj.getChangedObjSet().put(MacAdminDefinedScanPane.this.macintoshDefinedAdminDefinedScan.getId(), (TopLevelObject)MacAdminDefinedScanPane.this.macintoshDefinedAdminDefinedScan);
                    }
                }
            }
        });
        this.popup.add(this.addScanMenuItem);
        this.popup.add(this.editScanMenuItem);
        this.popup.add(this.deleteScanMenuItem);
    }

    private void setupPanel() {
        this.setupComponents();
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BoxLayout(basePanel, 1));
        this.macAdminDefinedScanTabbedPane.addTab(this.getRes("label.scanDetails"), UIUtilities.createScrollPaneWithoutBoard(this.getScanDetailsPanel()));
        this.macAdminDefinedScanTabbedPane.addTab(this.getRes("label.commonSettings"), UIUtilities.createScrollPaneWithoutBoard(this.getCommonSettingsPanel()));
        this.getCommonSettingsPanel().addHierarchyListener(new HierarchyListenerImpl());
        basePanel.add(this.macAdminDefinedScanTabbedPane);
        basePanel.add(this.getCommandScanPane());
        this.add(basePanel);
    }

    private MacAdminScanCommonSettingsPane getCommonSettingsPanel() {
        if (this.commonSetttingsPane == null) {
            this.commonSetttingsPane = new MacAdminScanCommonSettingsPane();
        }
        return this.commonSetttingsPane;
    }

    private JPanel getScanDetailsPanel() {
        ScanDetailsPanel result = new ScanDetailsPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.add(this.getScheduledScansPane());
        return result;
    }

    private JPanel getScheduledScansPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.schedTitle"), this.getRes("label.schedDesc"));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.scansTable), "Center");
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.addScanButton, this.editScanButton, this.deleteScanButton}, 0, 2, true);
        p.add((Component)buttonPanel, "South");
        result.add(p);
        return result;
    }

    private JPanel getCommandScanPane() {
        if (this.commandScanPanel == null) {
            this.commandScanPanel = new AvTemplatePane(this.getRes("label.commandTitle"), this.getRes("label.commandDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)new JLabel(this.getRes("label.commandScan")), c);
            c.insets = new Insets(5, 10, 0, 0);
            c.gridx = 1;
            c.gridy = 0;
            p.add((Component)this.commandScanButton, c);
            c.insets = new Insets(5, 10, 160, 0);
            c.gridx = 1;
            c.gridy = 2;
            JPanel blankPanel = new JPanel();
            p.add((Component)blankPanel, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            this.commandScanPanel.add(temp);
        }
        return this.commandScanPanel;
    }

    public void setReadOnly() {
        UIUtilities.setContainerStatus(this.getMacAdminDefinedScanTabbedPane(), false);
        UIUtilities.setContainerStatus(this.getCommandScanPane(), false);
    }

    private JTabbedPane getMacAdminDefinedScanTabbedPane() {
        if (this.macAdminDefinedScanTabbedPane == null) {
            this.macAdminDefinedScanTabbedPane = new JTabbedPane();
            this.macAdminDefinedScanTabbedPane.addTab(this.getRes("label.scanDetails"), UIUtilities.createScrollPaneWithoutBoard(this.getScanDetailsPanel()));
            this.macAdminDefinedScanTabbedPane.addTab(this.getRes("label.commonSettings"), UIUtilities.createScrollPaneWithoutBoard(this.getCommonSettingsPanel()));
        }
        return this.macAdminDefinedScanTabbedPane;
    }

    private void updateValues() {
        Iterator<ConfigObject> it = this.definedScans.iterator();
        while (it.hasNext()) {
            AdminScanTableObject asto = new AdminScanTableObject((MacAdminDefinedScan)it.next());
            this.model.addRow(asto);
            String name = asto.getAdminScan().getName();
            if (!name.startsWith(this.getNewScanName())) continue;
            if (name.length() == this.getNewScanName().length()) {
                this.newLastNumber = Math.max(1, this.newLastNumber);
            }
            String prepend = name.substring(this.getNewScanName().length()).trim();
            try {
                if (prepend.length() <= 0) continue;
                int number = Integer.parseInt(prepend);
                this.newLastNumber = Math.max(number, this.newLastNumber);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.setBtnState();
    }

    private String getNewScanName() {
        if (this.newScanName != null) {
            return this.newScanName;
        }
        this.newScanName = this.getRes("name.newAdminScan");
        return this.newScanName;
    }

    private void setBtnState() {
        boolean value = false;
        if (this.scansTable != null && this.scansTable.getRowCount() > 0) {
            value = true;
        }
        this.editScanButton.setEnabled(value);
        this.deleteScanButton.setEnabled(value);
    }

    private MacAdminDefinedScanPoolObject getScanPoolObj() {
        if (this.scanPoolObj == null) {
            try {
                this.scanPoolObj = MacAdminDefinedScanPoolObject.getPolicyPool();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return this.scanPoolObj;
    }

    public void setObject(MacAvScanPolicy avsp, AvPolicyObject avObj) throws ConsoleException {
        this.scanPolicy = avsp;
        this.avObj = avObj;
        this.advSettings = avsp.getOptMacGeneralScanSettings();
        if (this.advSettings == null) {
            this.advSettings = new MacGeneralScanSettings();
        }
        if (this.macintoshGeneralSettingsObject == null) {
            this.macintoshGeneralSettingsObject = new MacGeneralScanSettingsObject(this.advSettings);
            this.commonSetttingsPane.setObject(this.macintoshGeneralSettingsObject);
        }
        this.definedScansObjRefs = avsp.getObjReference();
        this.commandScan = avsp.getOptMacCommandScan();
        if (this.commandScan == null) {
            this.commandScan = new MacCommandScan();
        }
        this.onDemandScanGeneralSettings = this.commandScan.getOptMacGeneralScanSettings();
        if (this.onDemandScanGeneralSettings == null) {
            this.onDemandScanGeneralSettings = new MacGeneralScanSettings();
        }
        if (this.onDemandScanGeneralSettingsObject == null) {
            this.onDemandScanGeneralSettingsObject = new MacGeneralScanSettingsObject(this.onDemandScanGeneralSettings);
        }
        this.resolveObjReferences();
        this.updateValues();
    }

    public boolean valuesValid() {
        if (this.macintoshDefinedAdminDefinedScan.getName() == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), "Must define command scan settings.\nPlease specify command scan settings from the Mac Admin-defined Scan tab.", this.getRes("label.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.macAdminDefinedScanTabbedPane.getSelectedComponent());
    }

    private static class ScanDetailsPanel
    extends JPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans";
        }
    }

    private class AddScanTypeDialog
    extends AvDialogBase {
        private static final long serialVersionUID = 1L;
        private JPanel contentPane;
        private JRadioButton newScanButton;
        private JRadioButton templateButton;
        private JTable templateTable;
        private SortableTableModel templateModel;
        private Vector<MacAdminDefinedScan> newScans;

        public AddScanTypeDialog(String title) {
            super(title, true, true);
            this.newScans = new Vector();
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans_add_scan";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean ok() {
            if (this.newScanButton.isSelected()) {
                this.setVisible(false);
                Vector<TableRow> datavect = MacAdminDefinedScanPane.this.model.getDataVector();
                Vector<String> allScanNames = new Vector<String>();
                MacAdminDefinedScan tempScan = null;
                for (int i = 0; i < datavect.size(); ++i) {
                    tempScan = ((AdminScanTableObject)datavect.get(i)).getAdminScan();
                    allScanNames.add(tempScan.getName());
                }
                AdminScanDialog asd = new AdminScanDialog(this.getRes("label.adminScanDialogNewTitle"), true, false, MacAdminDefinedScanPane.this.getScanPoolObj(), allScanNames, false, false);
                MacAdminDefinedScan defaultScan = null;
                try {
                    defaultScan = PolicyHandler.getDefaultMacAdminDefinedScan();
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    defaultScan = new MacAdminDefinedScan();
                }
                defaultScan.setOptDescription(null);
                boolean usedNumber = false;
                Object newName = MacAdminDefinedScanPane.this.getNewScanName();
                if (MacAdminDefinedScanPane.this.newLastNumber >= 1) {
                    newName = (String)newName + " " + (MacAdminDefinedScanPane.this.newLastNumber + 1);
                    usedNumber = true;
                } else {
                    MacAdminDefinedScanPane.this.newLastNumber = 1;
                }
                defaultScan.setName((String)newName);
                defaultScan.setOptDisplayName(null);
                asd.setObject(defaultScan);
                asd.setVisible(true);
                if (!asd.isOk()) return true;
                MacAdminDefinedScan ads = asd.getMacObject();
                ads.setId(GUIDGenerator.getInstance().getGUIDString());
                this.newScans.add(ads);
                if (usedNumber) {
                    if (((String)newName).equals(ads.getName())) {
                        ++MacAdminDefinedScanPane.this.newLastNumber;
                    }
                    if (MacAdminDefinedScanPane.this.newLastNumber < 2) {
                        MacAdminDefinedScanPane.this.newLastNumber = 1;
                    }
                }
                if (asd.getSaveAsTemplate()) {
                    try {
                        MacAdminDefinedScanPane.this.saveCopyAsTemplate(ads);
                    }
                    catch (ConsoleException ce) {
                        LoggerUtilities.logException((Throwable)ce);
                    }
                }
            } else {
                for (int i = 0; i < this.templateModel.getRowCount(); ++i) {
                    TemplateTableObject tto = (TemplateTableObject)this.templateModel.getRow(i);
                    if (!tto.getSelected()) continue;
                    ObjInfoObject oio = tto.getInfoObject();
                    MacAdminDefinedScanObject adso = (MacAdminDefinedScanObject)PolicyHelper.getPolicyObject(oio);
                    try {
                        MacAdminDefinedScan ads = (MacAdminDefinedScan)adso.getCopyOfPolicyObject();
                        Object newName = ads.getOptDisplayName() == null ? ads.getName() : ads.getOptDisplayName();
                        ads.setId(GUIDGenerator.getInstance().getGUIDString());
                        int testLastNumber = 0;
                        for (int index = 0; index < MacAdminDefinedScanPane.this.model.getRowCount(); ++index) {
                            String testName;
                            AdminScanTableObject asto = (AdminScanTableObject)MacAdminDefinedScanPane.this.model.getRow(index);
                            String string = testName = asto.getAdminScan().getOptDisplayName() == null ? asto.getAdminScan().getName() : asto.getAdminScan().getOptDisplayName();
                            if (!testName.startsWith((String)newName)) continue;
                            if (testName.length() == ((String)newName).length()) {
                                testLastNumber = Math.max(1, testLastNumber);
                            }
                            String prepend = testName.substring(((String)newName).length()).trim();
                            try {
                                if (prepend.length() <= 0) continue;
                                int number = Integer.parseInt(prepend);
                                testLastNumber = Math.max(number, testLastNumber);
                                continue;
                            }
                            catch (NumberFormatException e) {
                                LoggerUtilities.logException((Throwable)e);
                            }
                        }
                        if (testLastNumber >= 1) {
                            newName = (String)newName + " " + (testLastNumber + 1);
                            ads.setName((String)newName);
                            ads.setOptDisplayName(null);
                        }
                        this.newScans.add(ads);
                        continue;
                    }
                    catch (ConsoleException ce) {
                        LoggerUtilities.logException((Throwable)ce);
                    }
                }
                if (this.newScans.size() == 0) {
                    JOptionPane.showMessageDialog(this, this.getRes("message.SelectAtLeastOne"), this.getRes("title.selectAtLeastOne"), 1);
                    return false;
                }
                this.setVisible(false);
            }
            this.isOk = true;
            return true;
        }

        @Override
        protected JPanel getContentPanel() {
            if (this.contentPane == null) {
                this.contentPane = new JPanel(new VerticalFlowLayout());
                this.setupComponents();
                this.contentPane.add(this.getAddScanPane());
            }
            return this.contentPane;
        }

        private Vector<TopLevelObject> getConfigObjsFromObjInfo(Vector<ObjInfoObject> objInfos) {
            Vector<TopLevelObject> result = new Vector<TopLevelObject>();
            for (ObjInfoObject oio : objInfos) {
                MacAdminDefinedScanObject adso = (MacAdminDefinedScanObject)PolicyHelper.getPolicyObject(oio);
                result.add(adso.getSchemaObj());
            }
            return result;
        }

        private void enableAppropriate() {
            this.templateButton.setEnabled(this.templateTable.getRowCount() > 0);
            this.templateTable.setEnabled(this.templateButton.isSelected());
            if (!this.templateButton.isSelected()) {
                this.templateTable.clearSelection();
            }
        }

        private void setupTable() {
            String[] colNames = new String[]{this.getRes("table.column.head.copy"), this.getRes("table.column.head.templateName"), this.getRes("table.column.head.lastUpdate")};
            this.templateModel = new SortableTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == 0;
                }
            };
            this.templateModel.setColumnNames(colNames);
            this.templateTable = new StripesTable(this.templateModel, false, false);
            this.templateTable.putClientProperty("dynamicEventsEnabled", true);
            this.templateModel.addMouseListenerToHeaderInTable(this.templateTable);
            this.templateTable.getSelectionModel().setSelectionMode(0);
            this.templateTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        TemplateTableObject tto;
                        int column = AddScanTypeDialog.this.templateTable.getSelectedColumn();
                        if (column == 0) {
                            return;
                        }
                        int row = AddScanTypeDialog.this.templateTable.getSelectedRow();
                        if (row == -1) {
                            return;
                        }
                        tto.setSelected(!(tto = (TemplateTableObject)AddScanTypeDialog.this.templateModel.getRow(row)).getSelected());
                        AddScanTypeDialog.this.templateModel.fireTableCellUpdated(row, 0);
                    }
                }
            });
            UIUtilities.setTableColumnWidth(this.templateTable, new float[]{0.1f, 0.5f, 0.4f}, (int)this.templateTable.getPreferredScrollableViewportSize().getWidth());
            this.templateTable.setPreferredScrollableViewportSize(new Dimension(500, 150));
            TableColumn column = this.templateTable.getColumnModel().getColumn(0);
            column.setCellRenderer(new CheckBoxRenderer(true));
            column.setCellEditor(new CheckBoxEditor(this.templateTable){
                private static final long serialVersionUID = 1L;

                @Override
                protected void updateModel(TableModel tableModel, int selIndex) {
                }
            });
        }

        private void setupComponents() {
            this.setupTable();
            this.newScanButton = new JRadioButton(this.getRes("rbutton.newscan"));
            this.newScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AddScanTypeDialog.this.newScanButton.setFocusPainted(true);
                    AddScanTypeDialog.this.enableAppropriate();
                }
            });
            this.templateButton = new JRadioButton(this.getRes("rbutton.template"));
            this.templateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddScanTypeDialog.this.enableAppropriate();
                }
            });
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.newScanButton);
            bg.add(this.templateButton);
            this.newScanButton.setSelected(true);
            this.enableAppropriate();
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AddScanTypeDialog." + key);
        }

        private JPanel getAddScanPane() {
            AvTemplatePane result = new AvTemplatePane(this.getRes("label.scanTypeTitle"), this.getRes("label.scanTypeDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)this.newScanButton, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 1;
            p.add((Component)this.templateButton, c);
            c.insets = new Insets(5, 25, 0, 0);
            c.gridx = 0;
            c.gridy = 2;
            p.add((Component)new JLabel(this.getRes("label.templateDesc")), c);
            c.insets = new Insets(5, 20, 0, 0);
            c.gridx = 0;
            c.gridy = 3;
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)this.templateTable);
            p.add((Component)scrollPane, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            result.add(temp);
            result.addHierarchyListener(new HierarchyListenerImpl());
            return result;
        }

        public Vector<MacAdminDefinedScan> getObject() {
            return this.newScans;
        }

        public void setPoolObj(final MacAdminDefinedScanPoolObject poolObj) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    final Vector<ObjInfoObject> data = new Vector<ObjInfoObject>(Arrays.asList(poolObj.getInfoObjectList()));
                    final Vector<TopLevelObject> configObjs = AddScanTypeDialog.this.getConfigObjsFromObjInfo(data);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Vector<TableRow> tableRows = new Vector<TableRow>();
                            for (int i = 0; i < data.size(); ++i) {
                                TemplateTableObject tto = new TemplateTableObject((ObjInfoObject)data.get(i), (ConfigObject)configObjs.get(i));
                                tableRows.add(tto);
                            }
                            AddScanTypeDialog.this.templateModel.setDataVector(tableRows);
                            AddScanTypeDialog.this.templateModel.fireTableDataChanged();
                            AddScanTypeDialog.this.enableAppropriate();
                        }
                    });
                }
            };
            t.start();
        }

        private class TemplateTableObject
        implements TableRow {
            private static final int SELECTED = 0;
            private static final int DISPLAY_NAME = 1;
            private static final int DATE = 2;
            private ObjInfoObject oio;
            private ConfigObject co;
            private boolean selected = false;

            public TemplateTableObject(ObjInfoObject oio, ConfigObject co) {
                this.oio = oio;
                this.co = co;
            }

            public ObjInfoObject getInfoObject() {
                return this.oio;
            }

            @Override
            public Object getValueAt(int index) {
                switch (index) {
                    case 0: {
                        return this.selected;
                    }
                    case 1: {
                        MacAdminDefinedScanObject adso = (MacAdminDefinedScanObject)PolicyHelper.getPolicyObject(this.oio);
                        try {
                            MacAdminDefinedScan ads = (MacAdminDefinedScan)adso.getCopyOfPolicyObject();
                            return ads.getOptDisplayName() == null ? ads.getName() : ads.getOptDisplayName();
                        }
                        catch (ConsoleException e) {
                            LoggerUtilities.logException((Throwable)e);
                            return "";
                        }
                    }
                    case 2: {
                        DateFormat df = DateFormat.getDateInstance(1);
                        df.setTimeZone(Utility.getLocalTimeZone());
                        return df.format(new Date(this.co.getT()));
                    }
                }
                return "";
            }

            @Override
            public Class<?> getValueTypeAt(int index) {
                switch (index) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Date.class;
                    }
                }
                return String.class;
            }

            public boolean getSelected() {
                return this.selected;
            }

            public void setSelected(boolean b) {
                this.selected = b;
            }

            @Override
            public void setValueAt(Object value, int index) {
                if (index == 0) {
                    this.selected = (Boolean)value;
                }
            }
        }
    }

    private class AdminScanTableObject
    implements TableRow {
        private static final int DISPLAY_NAME = 0;
        private static final int SCAN_SCHEDULE_ENABLED = 1;
        private static final int SCAN_SCHEDULE = 2;
        private static final int DESCRIPTION = 3;
        private MacAdminDefinedScan scan;

        public AdminScanTableObject(MacAdminDefinedScan scan) {
            this.scan = scan;
        }

        private String getScanSchedule() {
            Object[] arr;
            String monthDay;
            ScanSchedule ss = this.scan.getOptScanSchedule();
            if (ss == null) {
                return MacAdminDefinedScanPane.this.getRes("label.na");
            }
            Schedule schedule = ss.getSchedule();
            if (schedule == null) {
                return MacAdminDefinedScanPane.this.getRes("label.na");
            }
            String hourMinute = MacAdminDefinedScanPane.this.getRes("label.na");
            String dayHour = schedule.getOptStartHour();
            if (dayHour != null) {
                Calendar calendar = Utility.getCalendarInstance();
                TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
                calendar.setTimeZone(gmtTimeZone);
                calendar.set(11, Integer.parseInt(dayHour));
                Integer minutes = schedule.getOptStartMinute();
                if (minutes != null) {
                    calendar.set(12, minutes);
                }
                SimpleDateFormat formater = new SimpleDateFormat(MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern"));
                formater.setTimeZone(gmtTimeZone);
                hourMinute = formater.format(calendar.getTime());
            }
            if ((monthDay = schedule.getOptStartDayOfMonth()) != null) {
                Object[] arr2 = new Object[]{monthDay.indexOf(44) == -1 ? monthDay : MacAdminDefinedScanPane.this.getRes("label.na"), hourMinute};
                return MessageFormat.format(MacAdminDefinedScanPane.this.getRes("label.monthlySchedStr"), arr2);
            }
            String weekDay = schedule.getOptStartDayOfWeek();
            if (weekDay != null) {
                arr = new Object[]{weekDay.indexOf(44) == -1 ? AdminScanDialog.DAYS_OF_WEEK[Integer.parseInt(weekDay)] : MacAdminDefinedScanPane.this.getRes("label.na"), hourMinute};
                return MessageFormat.format(MacAdminDefinedScanPane.this.getRes("label.weeklySchedStr"), arr);
            }
            arr = new Object[]{hourMinute};
            return MessageFormat.format(MacAdminDefinedScanPane.this.getRes("label.dailySchedStr"), arr);
        }

        public MacAdminDefinedScan getAdminScan() {
            return this.scan;
        }

        @Override
        public Object getValueAt(int index) {
            switch (index) {
                case 0: {
                    return this.scan.getOptDisplayName() == null ? this.scan.getName() : this.scan.getOptDisplayName();
                }
                case 1: {
                    if (this.scan.getOptScanSchedule() != null) {
                        if (this.scan.getOptScanSchedule().getOptEnable() != null) {
                            return this.scan.getOptScanSchedule().getOptEnable();
                        }
                        return this.scan.getOptScanSchedule().getDefEnable();
                    }
                    return Boolean.FALSE;
                }
                case 2: {
                    return this.getScanSchedule();
                }
                case 3: {
                    return this.scan.getOptDescription();
                }
            }
            return MacAdminDefinedScanPane.this.getRes("label.na");
        }

        @Override
        public Class<?> getValueTypeAt(int index) {
            switch (index) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int index) {
            switch (index) {
                case 1: {
                    if (value == null || !(value instanceof Boolean) || this.scan.getOptScanSchedule() == null) break;
                    this.scan.getOptScanSchedule().setOptEnable((Boolean)value);
                    MacAdminDefinedScanPane.this.avObj.getChangedObjSet().put(this.scan.getId(), (TopLevelObject)this.scan);
                    break;
                }
            }
        }
    }
}

