/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.AdminDefinedScanDetails;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FolderScanPane
extends JPanel {
    public static final String folderSeprator = ";";
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String AV_ADS_AVSCAN = "com.sygate.scm.console.ui.policy.av.adminscan.avscan";
    private JLabel titleLabel;
    private LockCheckBox lockFolderTypesBox;
    private JCheckBox allFolderBox;
    private JCheckBox rootFolderBox;
    private JCheckBox homeFolderBox;
    private JCheckBox etcFolderBox;
    private JCheckBox binFolderBox;
    private JCheckBox usrFolderBox;
    private JCheckBox optFolderBox;
    private AdminDefinedScanDetails scanDetails;

    public FolderScanPane() {
        this.setupPanel();
    }

    private String getRes(String component, String key) {
        return MSGRES.getString(AV_ADS_AVSCAN, component + key);
    }

    private String getRes(String key) {
        return this.getRes("AdminScanDialog.", key);
    }

    private void setupPanel() {
        this.setupComponents();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 5.0E-4;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.titleLabel, c);
        c.gridy = 1;
        this.add((Component)this.allFolderBox, c);
        c.insets = new Insets(0, 20, 0, 0);
        c.gridy = 2;
        this.add((Component)this.rootFolderBox, c);
        c.gridy = 3;
        this.add((Component)this.homeFolderBox, c);
        c.gridy = 4;
        this.add((Component)this.binFolderBox, c);
        c.gridy = 5;
        this.add((Component)this.usrFolderBox, c);
        c.gridy = 6;
        this.add((Component)this.etcFolderBox, c);
        c.gridy = 7;
        this.add((Component)this.optFolderBox, c);
        this.addHierarchyListener(new HierarchyListenerImpl());
    }

    private void setupComponents() {
        ActionListener scanSelectionChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FolderScanPane.this.allFolderBox.setFocusPainted(true);
                FolderScanPane.this.enableAppropriate();
            }
        };
        this.titleLabel = new JLabel(this.getRes("label.scanDirsTitle"));
        this.lockFolderTypesBox = new LockCheckBox(Boolean.FALSE);
        this.allFolderBox = new JCheckBox(this.getRes("label.scanDirsAllFolder"));
        this.allFolderBox.addActionListener(scanSelectionChanged);
        this.rootFolderBox = new JCheckBox(this.getRes("label.scanDirsRootFolder"));
        this.homeFolderBox = new JCheckBox(this.getRes("label.scanDirsHomeFolder"));
        this.etcFolderBox = new JCheckBox(this.getRes("label.scanDirsEtcFolder"));
        this.binFolderBox = new JCheckBox(this.getRes("label.scanDirsBinFolder"));
        this.usrFolderBox = new JCheckBox(this.getRes("label.scanDirsUsrFolder"));
        this.optFolderBox = new JCheckBox(this.getRes("label.scanDirsOptFolder"));
    }

    private void enableAppropriate() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        boolean enabled = !this.allFolderBox.isSelected() && !AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context);
        this.lockFolderTypesBox.setEnabled(enabled);
        this.rootFolderBox.setEnabled(enabled);
        this.homeFolderBox.setEnabled(enabled);
        this.etcFolderBox.setEnabled(enabled);
        this.binFolderBox.setEnabled(enabled);
        this.usrFolderBox.setEnabled(enabled);
        this.optFolderBox.setEnabled(enabled);
        if (this.allFolderBox.isSelected()) {
            this.rootFolderBox.setSelected(true);
            this.homeFolderBox.setSelected(true);
            this.etcFolderBox.setSelected(true);
            this.binFolderBox.setSelected(true);
            this.usrFolderBox.setSelected(true);
            this.optFolderBox.setSelected(true);
        }
    }

    public void save() {
        this.scanDetails.setOptScanDirectories("");
        if (this.allFolderBox.isSelected()) {
            this.scanDetails.setOptScanDirectories("[AllDrives]");
        } else {
            StringBuffer selectedFolder = new StringBuffer();
            if (this.rootFolderBox.isSelected()) {
                selectedFolder.append(folderSeprator).append("[ROOT]");
            }
            if (this.homeFolderBox.isSelected()) {
                selectedFolder.append(folderSeprator).append("[HOME]");
            }
            if (this.binFolderBox.isSelected()) {
                selectedFolder.append(folderSeprator).append("[BIN]");
            }
            if (this.etcFolderBox.isSelected()) {
                selectedFolder.append(folderSeprator).append("[ETC]");
            }
            if (this.usrFolderBox.isSelected()) {
                selectedFolder.append(folderSeprator).append("[USR]");
            }
            if (this.optFolderBox.isSelected()) {
                selectedFolder.append(folderSeprator).append("[OPT]");
            }
            if (selectedFolder.length() > 1 && selectedFolder.indexOf(folderSeprator) == 0) {
                selectedFolder = new StringBuffer(selectedFolder.substring(1));
            }
            this.scanDetails.setOptScanDirectories(selectedFolder.toString());
        }
    }

    public boolean isScanAllSelected() {
        return this.allFolderBox.isSelected();
    }

    private void updatePanel() {
        this.allFolderBox.setSelected(this.getAllFolderEnabled());
        this.rootFolderBox.setSelected(this.getRootFolderEnabled());
        this.homeFolderBox.setSelected(this.getHomeFolderEnabled());
        this.etcFolderBox.setSelected(this.getEtcFolderEnabled());
        this.binFolderBox.setSelected(this.getBinFolderEnabled());
        this.usrFolderBox.setSelected(this.getUsrFolderEnabled());
        this.optFolderBox.setSelected(this.getOptFolderEnabled());
        this.enableAppropriate();
    }

    private boolean getAllFolderEnabled() {
        boolean enabled = false;
        String scanDirectories = this.scanDetails.getOptScanDirectories();
        if ("[AllDrives]".equals(scanDirectories)) {
            enabled = true;
        }
        return enabled;
    }

    private boolean getRootFolderEnabled() {
        boolean enabled = false;
        String scanDirectories = this.scanDetails.getOptScanDirectories();
        if (!"[AllDrives]".equals(scanDirectories) && scanDirectories.indexOf("[ROOT]") >= 0) {
            enabled = true;
        }
        return enabled;
    }

    private boolean getHomeFolderEnabled() {
        boolean enabled = false;
        String scanDirectories = this.scanDetails.getOptScanDirectories();
        if (!"[AllDrives]".equals(scanDirectories) && scanDirectories.indexOf("[HOME]") >= 0) {
            enabled = true;
        }
        return enabled;
    }

    private boolean getBinFolderEnabled() {
        boolean enabled = false;
        String scanDirectories = this.scanDetails.getOptScanDirectories();
        if (!"[AllDrives]".equals(scanDirectories) && scanDirectories.indexOf("[BIN]") >= 0) {
            enabled = true;
        }
        return enabled;
    }

    private boolean getEtcFolderEnabled() {
        boolean enabled = false;
        String scanDirectories = this.scanDetails.getOptScanDirectories();
        if (!"[AllDrives]".equals(scanDirectories) && scanDirectories.indexOf("[ETC]") >= 0) {
            enabled = true;
        }
        return enabled;
    }

    private boolean getUsrFolderEnabled() {
        boolean enabled = false;
        String scanDirectories = this.scanDetails.getOptScanDirectories();
        if (!"[AllDrives]".equals(scanDirectories) && scanDirectories.indexOf("[USR]") >= 0) {
            enabled = true;
        }
        return enabled;
    }

    private boolean getOptFolderEnabled() {
        boolean enabled = false;
        String scanDirectories = this.scanDetails.getOptScanDirectories();
        if (!"[AllDrives]".equals(scanDirectories) && scanDirectories.indexOf("[OPT]") >= 0) {
            enabled = true;
        }
        return enabled;
    }

    public void setObject(AdminDefinedScanDetails scanDetails) {
        this.scanDetails = scanDetails;
        this.updatePanel();
        this.enableAppropriate();
    }
}

