/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.schema.AdvancedScanOptions;
import com.sygate.scm.common.configobject.schema.CompressedFiles;
import com.sygate.scm.common.configobject.schema.StorageMigration;
import com.sygate.scm.common.configobject.schema.Throttling;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.common.CompressedFilesPane;
import com.sygate.scm.console.ui.policy.av.logicobject.CompressedFilesObject;
import com.sygate.scm.console.ui.util.ClickableSlider;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;

public class AdvancedScanningOptionsDialog
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String AV_ADS_AVSCAN = "com.sygate.scm.console.ui.policy.av.adminscan.avscan";
    private AdvancedScanOptions advOptions;
    private CompressedFiles compressedFiles;
    private StorageMigration storageMig;
    private Throttling throttling;
    private CompressedFilesPane compressedPane;
    private JTabbedPane tabbedPane;
    private JComboBox<String> migrationOptionBox;
    private JCheckBox backupBox;
    private JComboBox<String> accessTypeBox;
    private JSpinner accessDaySpinner;
    private JSlider performanceSlider;
    private HtmlEnabledJLabel throttlingLabel;
    private HtmlEnabledJLabel throttlingLabelBal;
    private HtmlEnabledJLabel throttlingLabelApp;
    private JPanel filesPane;
    private JPanel storagePane;
    private JPanel throttlingPane;

    public AdvancedScanningOptionsDialog(String title) {
        super(title, true, true);
    }

    public void setReadonly() {
        UIUtilities.setContainerStatus(this.filesPane, false);
        UIUtilities.setContainerStatus(this.storagePane, false);
        UIUtilities.setContainerStatus(this.throttlingPane, false);
        this.resetOKButton(false);
    }

    @Override
    protected void help() {
        HelpUtil.showHelp(((ContentSensitiveHelpPage)((Object)this.tabbedPane.getSelectedComponent())).getContentSensitiveHelpToken());
    }

    @Override
    protected void commit() {
        this.compressedPane.save();
        this.advOptions.setCompressedFiles(this.compressedFiles);
        this.storageMig.setOptStorageMigrationOption(Integer.valueOf(this.migrationOptionBox.getSelectedIndex()));
        this.storageMig.setOptOpenFileUsingBackupSemantics(Boolean.valueOf(this.backupBox.isSelected()));
        this.storageMig.setOptAccessType(Integer.valueOf(this.accessTypeBox.getSelectedIndex()));
        this.storageMig.setOptAccessDays((Integer)this.accessDaySpinner.getValue());
        this.advOptions.setStorageMigration(this.storageMig);
        int scanVal = this.performanceSlider.getValue();
        this.throttling.setOptScanTuning(Long.valueOf(5 * scanVal));
        this.advOptions.setThrottling(this.throttling);
    }

    @Override
    protected JPanel getContentPanel() {
        JPanel result = new JPanel(new BorderLayout());
        this.setupComponents();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.compressedPane = new CompressedFilesPane(true, this.getPlatFormType());
        this.filesPane = new FilesPane();
        this.storagePane = new StoragePane();
        this.throttlingPane = new ThrottlingPane();
        this.tabbedPane.addTab(this.getRes("label.compressedFiles"), new FilesPane());
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.tabbedPane.addTab(this.getRes("label.storage"), new StoragePane());
        }
        this.tabbedPane.addTab(this.getRes("label.throttling"), new ThrottlingPane());
        result.add((Component)this.tabbedPane, "Center");
        return result;
    }

    private void enableAppropriate() {
        boolean enableFileAccess = this.migrationOptionBox.getSelectedIndex() == StorageMigration.SCAN_RECENT_NO_DEMIGRATION.intValue();
        this.accessTypeBox.setEnabled(enableFileAccess);
        this.accessDaySpinner.setEnabled(enableFileAccess);
    }

    private void updatePanel() {
        this.compressedPane.setObject(new CompressedFilesObject(this.compressedFiles));
        Integer i = this.storageMig.getOptStorageMigrationOption();
        if (i == null) {
            i = this.storageMig.getDefStorageMigrationOption();
        }
        this.migrationOptionBox.setSelectedIndex(i);
        Boolean b = this.storageMig.getOptOpenFileUsingBackupSemantics();
        if (b == null) {
            b = this.storageMig.getDefOpenFileUsingBackupSemantics();
        }
        this.backupBox.setSelected(b);
        i = this.storageMig.getOptAccessType();
        if (i == null) {
            i = this.storageMig.getDefAccessType();
        }
        this.accessTypeBox.setSelectedIndex(i);
        i = this.storageMig.getOptAccessDays();
        if (i == null) {
            i = this.storageMig.getDefAccessDays();
        }
        this.accessDaySpinner.setValue(i);
        Long th = this.throttling.getOptScanTuning();
        if (th == null) {
            th = this.throttling.getDefScanTuning();
        }
        this.performanceSlider.setValue(th.intValue() / 5);
    }

    private void setupComponents() {
        this.migrationOptionBox = new JComboBox<String>(new String[]{this.getRes("box.offlineFile"), this.getRes("box.sparseFile"), this.getRes("box.reparse"), this.getRes("box.resident"), this.getRes("box.allDemig"), this.getRes("box.allNoDemig"), this.getRes("box.recentFiles")});
        this.migrationOptionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedScanningOptionsDialog.this.enableAppropriate();
            }
        });
        this.backupBox = new JCheckBox(this.getRes("box.backupSemantics"));
        this.accessTypeBox = new JComboBox<String>(new String[]{this.getRes("box.accessed"), this.getRes("box.modified"), this.getRes("box.created")});
        SpinnerNumberModel model = new SpinnerNumberModel(30, 1, 9999, 1);
        this.accessDaySpinner = new JSpinner(model);
        UIUtilities.enableOnlyValidEdits(this.accessDaySpinner);
        this.performanceSlider = new ClickableSlider(1, 0, 2, 0);
        this.performanceSlider.setSnapToTicks(true);
        this.performanceSlider.setMajorTickSpacing(1);
        this.performanceSlider.setPaintTicks(true);
        this.performanceSlider.setPaintLabels(true);
        this.performanceSlider.setInverted(true);
        this.performanceSlider.setOpaque(false);
    }

    public void setObject(AdvancedScanOptions advOptions) {
        this.advOptions = advOptions;
        this.compressedFiles = advOptions.getCompressedFiles();
        if (this.compressedFiles == null) {
            this.compressedFiles = new CompressedFiles();
        }
        this.storageMig = advOptions.getStorageMigration();
        if (this.storageMig == null) {
            this.storageMig = new StorageMigration();
        }
        this.throttling = advOptions.getThrottling();
        if (this.throttling == null) {
            this.throttling = new Throttling();
        }
        this.updatePanel();
        this.enableAppropriate();
    }

    public AdvancedScanOptions getObject() {
        return this.advOptions;
    }

    private String getRes(String key) {
        return MSGRES.getString(AV_ADS_AVSCAN, "AdvScanningOptionsDialog." + key);
    }

    private class ThrottlingPane
    extends AvTemplatePane
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        public ThrottlingPane() {
            super(AdvancedScanningOptionsDialog.this.getRes("label.tuneopt"), AdvancedScanningOptionsDialog.this.getRes("throttling.scanlabel"));
            this.init();
        }

        void init() {
            if (AdvancedScanningOptionsDialog.this.throttlingLabel == null) {
                AdvancedScanningOptionsDialog.this.throttlingLabel = new HtmlEnabledJLabel("<html>&nbsp;&nbsp;<B>" + AdvancedScanningOptionsDialog.this.getRes("throttling.label10") + "</B><BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + AdvancedScanningOptionsDialog.this.getRes("throttling.desc10") + "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + AdvancedScanningOptionsDialog.this.getRes("throttling.desc210") + "</html>");
                AdvancedScanningOptionsDialog.this.throttlingLabelBal = new HtmlEnabledJLabel("<html>&nbsp;&nbsp;<B>" + AdvancedScanningOptionsDialog.this.getRes("throttling.label5") + "</B><BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + AdvancedScanningOptionsDialog.this.getRes("throttling.desc5") + "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + AdvancedScanningOptionsDialog.this.getRes("throttling.desc25") + "</html>");
                AdvancedScanningOptionsDialog.this.throttlingLabelApp = new HtmlEnabledJLabel("<html>&nbsp;&nbsp;<B>" + AdvancedScanningOptionsDialog.this.getRes("throttling.label0") + "</B><BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + AdvancedScanningOptionsDialog.this.getRes("throttling.desc0") + "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + AdvancedScanningOptionsDialog.this.getRes("throttling.desc20") + "</html>");
                int widest = AdvancedScanningOptionsDialog.this.throttlingLabel.getPreferredSize().width;
                if (AdvancedScanningOptionsDialog.this.throttlingLabelApp.getPreferredSize().width > widest) {
                    widest = AdvancedScanningOptionsDialog.this.throttlingLabelApp.getPreferredSize().width;
                }
                if (AdvancedScanningOptionsDialog.this.throttlingLabelBal.getPreferredSize().width > widest) {
                    widest = AdvancedScanningOptionsDialog.this.throttlingLabelBal.getPreferredSize().width;
                }
                AdvancedScanningOptionsDialog.this.throttlingLabel.setPreferredSize(new Dimension(widest, AdvancedScanningOptionsDialog.this.throttlingLabel.getPreferredSize().height));
                AdvancedScanningOptionsDialog.this.throttlingLabelApp.setPreferredSize(new Dimension(widest, AdvancedScanningOptionsDialog.this.throttlingLabelApp.getPreferredSize().height));
                AdvancedScanningOptionsDialog.this.throttlingLabelBal.setPreferredSize(new Dimension(widest, AdvancedScanningOptionsDialog.this.throttlingLabelBal.getPreferredSize().height));
            }
            Hashtable<Integer, HtmlEnabledJLabel> performanceLabelTable = new Hashtable<Integer, HtmlEnabledJLabel>();
            performanceLabelTable.put(0, AdvancedScanningOptionsDialog.this.throttlingLabelApp);
            performanceLabelTable.put(1, AdvancedScanningOptionsDialog.this.throttlingLabelBal);
            performanceLabelTable.put(2, AdvancedScanningOptionsDialog.this.throttlingLabel);
            AdvancedScanningOptionsDialog.this.performanceSlider.setLabelTable(performanceLabelTable);
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 3;
            c.anchor = 21;
            c.fill = 3;
            c.insets = new Insets(5, 0, 0, 0);
            p.add((Component)AdvancedScanningOptionsDialog.this.performanceSlider, c);
            this.add(p);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans_edit_scan_scan_details_advanced_options_throttling";
        }
    }

    private class StoragePane
    extends AvTemplatePane
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        public StoragePane() {
            super(AdvancedScanningOptionsDialog.this.getRes("label.storageTitle"), AdvancedScanningOptionsDialog.this.getRes("label.storageDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            p.add(AdvancedScanningOptionsDialog.this.migrationOptionBox, c);
            c.insets = new Insets(15, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 0;
            p.add((Component)AdvancedScanningOptionsDialog.this.backupBox, c);
            c.insets = new Insets(15, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 2;
            p.add((Component)new JLabel(AdvancedScanningOptionsDialog.this.getRes("label.typeOfAccess")), c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 1;
            p.add(AdvancedScanningOptionsDialog.this.accessTypeBox, c);
            c.insets = new Insets(5, 5, 0, 0);
            c.gridx = 1;
            c.gridy = 3;
            p.add((Component)AdvancedScanningOptionsDialog.this.accessDaySpinner, c);
            c.gridx = 2;
            c.gridy = 3;
            p.add((Component)new JLabel(AdvancedScanningOptionsDialog.this.getRes("label.days")), c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            this.add(temp);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans_edit_scan_scan_details_advanced_options_storage";
        }
    }

    private class FilesPane
    extends AvTemplatePane
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        public FilesPane() {
            super(AdvancedScanningOptionsDialog.this.getRes("label.compressedTitle"), AdvancedScanningOptionsDialog.this.getRes("label.compressedDesc"));
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)AdvancedScanningOptionsDialog.this.compressedPane, c);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)pane, "Before");
            this.add(p);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans_edit_scan_scan_details_advanced_options_compressed_files";
        }
    }
}

