/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AdminDefinedScanDetails;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScanDetails;
import com.sygate.scm.common.configobject.schema.NotificationMessage;
import com.sygate.scm.common.configobject.schema.ScanSchedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.MacOnDemandScanDetailsPanel;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.MacScanDetailsPanel;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.ScanDetailsPanel;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.ScanSchedulePanel;
import com.sygate.scm.console.ui.policy.av.ap.ActionsPane;
import com.sygate.scm.console.ui.policy.av.ap.DetectionNotificationPane;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.CommonActionsPanel;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ApActionsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.CompressedFilesObject;
import com.sygate.scm.console.ui.policy.av.logicobject.DetectionNotificationObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacGeneralScanSettingsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ScheduleScanPoolObject;
import com.sygate.scm.console.ui.policy.explorer.av.AVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.BaseAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.LinuxAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.MacAVScanPoolHandler;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AdminScanDialog
extends AvDialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String AV_ADS_AVSCAN = "com.sygate.scm.console.ui.policy.av.adminscan.avscan";
    public static final String COMMAND_SCAN_NAME = "COMMAND_SCAN";
    public static final int MAX_NAME = 128;
    public static final int MAX_DESC = 255;
    static final String[] DAYS_OF_WEEK = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.label.sunday"), MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.label.monday"), MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.label.tuesday"), MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.label.wednesday"), MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.label.thursday"), MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.label.friday"), MSGRES.getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AdminScanDialog.label.saturday")};
    private JPanel contentPane;
    private ScanDetailsPanel detailsPanel;
    private MacScanDetailsPanel macDetailsPanel;
    private ScanDetailsPanel linuxDetailsPanel;
    private MacOnDemandScanDetailsPanel macOnDemandDetailsPanel;
    private JComboBox<String> operatingSystemCombo;
    private AdminScanTopPanel titlePanel;
    private ScanSchedulePanel schedPanel;
    private ScanSchedulePanel linuxSchedPanel;
    private ScanSchedulePanel macSchedPanel;
    private ActionsPane actionsPanel;
    private ActionsPane linuxActionsPanel;
    private DetectionNotificationPane notificationPanel;
    private DetectionNotificationPane linuxNotificationPanel;
    private AdminDefinedScan adminScan;
    private AdminDefinedScanDetails scanDetails;
    private ScanSchedule scanSchedule;
    private ApActions apActions;
    private NotificationMessage notificationMsg;
    private ScheduleScanPoolObject poolObj;
    private AdminDefinedScanPoolObject scanPoolObj;
    private MacAdminDefinedScanPoolObject macScanPoolObj;
    private LinuxAdminDefinedScanPoolObject linuxScanPoolObj;
    private MacAdminDefinedScan macAdminScan;
    private MacAdminDefinedScanDetails macScanDetails;
    private ScanSchedule macScanSchedule;
    private MacGeneralScanSettingsObject macGeneralScanSettingsObject;
    private LinuxAdminDefinedScan linuxAdminScan;
    private CompressedFilesObject macCompressedFilesObject;
    private JCheckBox saveAsTemplateBox;
    private boolean isCommand;
    private boolean showSaveTemplate = false;
    private JTabbedPane jtp;
    private Vector<String> adminScanNames = null;
    private boolean isEdit = false;
    private String oldName = null;
    private boolean isPoolObj = false;
    private boolean isOperatingSystemComboEnable = false;

    public AdminScanDialog(String title, boolean showSaveTemplate, boolean isCommand, boolean isEdit, ScheduleScanPoolObject poolObj, int platFormType) {
        super(title, true, true, false);
        this.isEdit = isEdit;
        this.setOsType(platFormType);
        this.isCommand = isCommand;
        this.isOperatingSystemComboEnable = !this.isCommand;
        this.showSaveTemplate = showSaveTemplate;
        this.poolObj = poolObj;
        switch (this.getPlatFormType()) {
            case 1: {
                this.scanPoolObj = (AdminDefinedScanPoolObject)BaseAVScanPoolHandler.getOSSpecificPoolObject(this.getPlatFormType(), poolObj);
                break;
            }
            case 2: {
                this.macScanPoolObj = (MacAdminDefinedScanPoolObject)BaseAVScanPoolHandler.getOSSpecificPoolObject(this.getPlatFormType(), poolObj);
                break;
            }
            case 3: {
                this.linuxScanPoolObj = (LinuxAdminDefinedScanPoolObject)BaseAVScanPoolHandler.getOSSpecificPoolObject(this.getPlatFormType(), poolObj);
                break;
            }
        }
        this.initAndPosition();
    }

    public AdminScanDialog(String title, boolean showSaveTemplate, boolean isCommand, ScheduleScanPoolObject poolObj, int platFormType) {
        this(title, showSaveTemplate, isCommand, false, poolObj, platFormType);
    }

    public AdminScanDialog(String title, boolean showSaveTemplate, AdminDefinedScanPoolObject scanPoolObj, Vector<String> adminScanNames, boolean isEdit, boolean isPoolObj, boolean isCommand, boolean isOperatingSystemComboEnable, int platFormType) {
        super(title, true, true, false, false, platFormType);
        this.showSaveTemplate = showSaveTemplate;
        this.scanPoolObj = scanPoolObj;
        this.adminScanNames = adminScanNames;
        this.isEdit = isEdit;
        this.isPoolObj = isPoolObj;
        this.isCommand = isCommand;
        this.isOperatingSystemComboEnable = isCommand ? false : isOperatingSystemComboEnable;
        this.initAndPosition();
    }

    public AdminScanDialog(String title, boolean showSaveTemplate, boolean isCommand, AdminDefinedScanPoolObject scanPoolObj) {
        this(title, showSaveTemplate, scanPoolObj, null, false, false, isCommand, true, 1);
    }

    public AdminScanDialog(String title, boolean showSaveTemplate, AdminDefinedScanPoolObject scanPoolObj, Vector<String> adminScanNames, boolean isEdit, boolean isPoolObj, int platFormType) {
        this(title, showSaveTemplate, scanPoolObj, adminScanNames, isEdit, isPoolObj, false, false, platFormType);
    }

    private AdminScanDialog(String title, boolean showSaveTemplate, MacAdminDefinedScanPoolObject scanPoolObj, Vector<String> macAdminScanNames, boolean isEdit, boolean isPoolObj, boolean isCommand, boolean isOperatingSystemComboEnable) {
        super(title, true, true, false, false, 2);
        this.setPlatFormType(2);
        this.showSaveTemplate = showSaveTemplate;
        this.macScanPoolObj = scanPoolObj;
        this.adminScanNames = macAdminScanNames;
        this.isEdit = isEdit;
        this.isPoolObj = isPoolObj;
        this.isCommand = isCommand;
        this.isOperatingSystemComboEnable = isOperatingSystemComboEnable;
        this.initAndPosition();
    }

    public void setOsType(int osType) {
        this.setPlatFormType(osType);
    }

    public AdminScanDialog(String title, boolean showSaveTemplate, boolean isCommand, MacAdminDefinedScanPoolObject scanPoolObj) {
        this(title, showSaveTemplate, scanPoolObj, null, false, false, isCommand, true);
    }

    public AdminScanDialog(String title, boolean showSaveTemplate, boolean isCommand, MacAdminDefinedScanPoolObject scanPoolObj, Vector<String> adminScanNames, boolean isEdit, boolean isPoolObj) {
        this(title, showSaveTemplate, scanPoolObj, adminScanNames, isEdit, isPoolObj, isCommand, false);
    }

    public AdminScanDialog(String title) {
        this(title, false, true, null, null, false, false);
    }

    @Override
    protected void setReadOnlyStatus() {
        super.setReadOnlyStatus();
        if (this.isReadOnly()) {
            this.isOperatingSystemComboEnable = false;
        }
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.operatingSystemCombo, this.titlePanel, this.detailsPanel, this.linuxDetailsPanel, this.macDetailsPanel, this.macOnDemandDetailsPanel, this.schedPanel, this.linuxSchedPanel, this.macSchedPanel, this.actionsPanel, this.linuxActionsPanel, this.notificationPanel, this.linuxNotificationPanel};
    }

    @Override
    protected boolean isValidate() {
        switch (this.getPlatFormType()) {
            case 1: {
                if (!this.detailsPanel.valuesValid()) {
                    return false;
                }
                if (!this.titlePanel.valuesValid()) {
                    return false;
                }
                if (this.notificationPanel.valuesValid(AdminScanDialog.getRes("label.adminScan"))) break;
                return false;
            }
            case 3: {
                if (!this.linuxDetailsPanel.valuesValid()) {
                    return false;
                }
                if (!this.titlePanel.valuesValid()) {
                    return false;
                }
                if (this.linuxNotificationPanel.valuesValid(AdminScanDialog.getRes("label.adminScan"))) break;
                return false;
            }
            case 2: {
                if (this.isCommand) {
                    if (this.macOnDemandDetailsPanel.valuesValid()) break;
                    return false;
                }
                if (!this.titlePanel.valuesValid()) {
                    return false;
                }
                if (this.macDetailsPanel.valuesValid()) break;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void help() {
        HelpUtil.showHelp(((ContentSensitiveHelpPage)((Object)this.jtp.getSelectedComponent())).getContentSensitiveHelpToken());
    }

    @Override
    protected void commit() {
        this.titlePanel.saveObject();
        switch (this.getPlatFormType()) {
            case 1: {
                this.detailsPanel.saveObject();
                this.adminScan.setOptAdminDefinedScanDetails(this.scanDetails);
                if (!this.isCommand) {
                    this.schedPanel.saveObject();
                    this.adminScan.setOptScanSchedule(this.scanSchedule);
                }
                this.actionsPanel.save();
                this.adminScan.setOptApActions(this.apActions);
                DetectionNotificationObject dno = this.notificationPanel.save();
                this.adminScan.setOptDisplayNotification(Boolean.valueOf(dno.getDisplayNotification()));
                this.adminScan.setOptLockDisplayNotification(Boolean.valueOf(dno.getLockDisplayNotification()));
                this.notificationMsg.setOptContent(dno.getNotificationMessage());
                this.adminScan.setOptNotificationMessage(this.notificationMsg);
                break;
            }
            case 2: {
                if (this.isCommand) {
                    this.macOnDemandDetailsPanel.saveObject();
                    this.macAdminScan.setOptMacAdminDefinedScanDetails(this.macScanDetails);
                    break;
                }
                this.macDetailsPanel.saveObject();
                this.macAdminScan.setOptMacAdminDefinedScanDetails(this.macScanDetails);
                this.macSchedPanel.saveObject();
                this.macAdminScan.setOptScanSchedule(this.macScanSchedule);
                break;
            }
            case 3: {
                this.linuxDetailsPanel.saveObject();
                this.linuxAdminScan.setOptAdminDefinedScanDetails(this.scanDetails);
                if (!this.isCommand) {
                    this.linuxSchedPanel.saveObject();
                    this.linuxAdminScan.setOptScanSchedule(this.scanSchedule);
                }
                this.linuxActionsPanel.save();
                this.linuxAdminScan.setOptApActions(this.apActions);
                DetectionNotificationObject dnoLinux = this.linuxNotificationPanel.save();
                this.linuxAdminScan.setOptDisplayNotification(Boolean.valueOf(dnoLinux.getDisplayNotification()));
                this.linuxAdminScan.setOptLockDisplayNotification(Boolean.valueOf(dnoLinux.getLockDisplayNotification()));
                this.notificationMsg.setOptContent(dnoLinux.getNotificationMessage());
                this.linuxAdminScan.setOptNotificationMessage(this.notificationMsg);
                break;
            }
        }
    }

    static String getRes(String component, String key) {
        return MSGRES.getString(AV_ADS_AVSCAN, component + key);
    }

    static String getRes(String key) {
        return AdminScanDialog.getRes("AdminScanDialog.", key);
    }

    static String getMacRes(String key) {
        return AdminScanDialog.getRes("MacAdminScanDialog.", key);
    }

    static String getMacOnDemandRes(String key) {
        return AdminScanDialog.getRes("MacOnDemandScanDialog.", key);
    }

    @Override
    protected JPanel getContentPanel() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel(new VerticalFlowLayout());
            this.setupComponents();
            this.jtp = new JTabbedPane();
            this.jtp.setTabLayoutPolicy(1);
            this.initTabs();
            this.contentPane.add((Component)this.jtp, "Center");
            if (!LicenseObject.getInstance().isSBProduct()) {
                this.contentPane.add((Component)this.getSaveAsTemplatePanel(), "South");
            }
        }
        JPanel osComboPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        osComboPanel.add((Component)new JLabel(AdminScanDialog.getRes("label.osType")), c);
        c.insets = new Insets(0, 20, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        osComboPanel.add(this.operatingSystemCombo, c);
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(osComboPanel);
        this.titlePanel = new AdminScanTopPanel();
        JPanel panel = new JPanel(new VerticalFlowLayout(5, 0));
        if (this.isOperatingSystemComboEnable) {
            panel.add(p);
        }
        panel.add(this.titlePanel);
        panel.add(this.contentPane);
        Dimension pDim = p.getPreferredSize();
        Dimension titlePanelDim = this.titlePanel.getPreferredSize();
        Dimension contentPaneDim = this.contentPane.getPreferredSize();
        Dimension panelDim = new Dimension();
        panelDim.setSize(contentPaneDim.getWidth(), pDim.getHeight() + titlePanelDim.getHeight() + contentPaneDim.getHeight() + 35.0);
        return panel;
    }

    private void changeToWindows() {
        this.setPlatFormType(1);
        this.scanPoolObj = (AdminDefinedScanPoolObject)BaseAVScanPoolHandler.getOSSpecificPoolObject(this.getPlatFormType(), this.poolObj);
        this.initTabs();
        if (this.adminScan == null) {
            AVScanPoolHandler poolHandler = (AVScanPoolHandler)BaseAVScanPoolHandler.getBasePolicyHandler(this.getPlatFormType());
            AdminDefinedScan ads = poolHandler.getDefaultAdminDefinedScan(this.scanPoolObj);
            try {
                this.setObject(ads);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        this.pack();
    }

    private void changeToLinux() {
        this.setPlatFormType(3);
        this.linuxScanPoolObj = (LinuxAdminDefinedScanPoolObject)BaseAVScanPoolHandler.getOSSpecificPoolObject(this.getPlatFormType(), this.poolObj);
        this.initTabs();
        if (this.linuxAdminScan == null) {
            LinuxAVScanPoolHandler poolHandler = (LinuxAVScanPoolHandler)BaseAVScanPoolHandler.getBasePolicyHandler(this.getPlatFormType());
            LinuxAdminDefinedScan ads = poolHandler.getDefaultLinuxAdminDefinedScan(this.linuxScanPoolObj);
            try {
                this.setObject(ads);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        this.pack();
    }

    private void changeToMac() {
        this.setPlatFormType(2);
        this.macScanPoolObj = (MacAdminDefinedScanPoolObject)BaseAVScanPoolHandler.getOSSpecificPoolObject(this.getPlatFormType(), this.poolObj);
        this.initTabs();
        if (this.macAdminScan == null) {
            MacAVScanPoolHandler poolHandler = (MacAVScanPoolHandler)BaseAVScanPoolHandler.getBasePolicyHandler(this.getPlatFormType());
            MacAdminDefinedScan macAds = poolHandler.getDefaultMacAdminDefinedScan(this.macScanPoolObj);
            this.setObject(macAds);
        }
        this.pack();
    }

    private void updateCommonPanel() {
        this.operatingSystemCombo.setEnabled(this.isOperatingSystemComboEnable);
        this.saveAsTemplateBox.setVisible(this.showSaveTemplate);
        this.titlePanel.updatePanel();
    }

    private void updatePanel() throws ConsoleException {
        if (this.isCommand) {
            this.jtp.remove(this.schedPanel);
        }
        this.updateCommonPanel();
        this.detailsPanel.updatePanel();
        this.titlePanel.updatePanel();
        if (this.apActions.getSecurityRiskGroupCount() <= 2) {
            try {
                this.apActions = CommonActionsPanel.getDefaultApActions();
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            System.out.println("Adding Security risk items ");
        }
        this.actionsPanel.setObject(new ApActionsObject(this.apActions));
        this.schedPanel.updatePanel();
        Boolean display = Boolean.TRUE;
        Boolean lock = Boolean.FALSE;
        if (3 == this.getPlatFormType()) {
            display = Utility.getBooleanValue((Boolean)this.linuxAdminScan.getOptDisplayNotification(), (Boolean)this.linuxAdminScan.getDefDisplayNotification());
            lock = Utility.getBooleanValue((Boolean)this.linuxAdminScan.getOptLockDisplayNotification(), (Boolean)this.linuxAdminScan.getDefLockDisplayNotification());
        } else if (1 == this.getPlatFormType()) {
            display = Utility.getBooleanValue((Boolean)this.adminScan.getOptDisplayNotification(), (Boolean)this.adminScan.getDefDisplayNotification());
            lock = Utility.getBooleanValue((Boolean)this.adminScan.getOptLockDisplayNotification(), (Boolean)this.adminScan.getDefLockDisplayNotification());
        }
        DetectionNotificationObject dno = new DetectionNotificationObject(lock, display, this.notificationMsg.getOptContent());
        this.notificationPanel.setObject(dno);
        this.setReadOnlyStatus();
    }

    private void updateLinuxPanel() throws ConsoleException {
        if (this.isCommand) {
            this.jtp.remove(this.linuxSchedPanel);
        }
        this.updateCommonPanel();
        this.linuxDetailsPanel.updatePanel();
        this.titlePanel.updatePanel();
        if (this.apActions.getSecurityRiskGroupCount() <= 2) {
            try {
                this.apActions = CommonActionsPanel.getDefaultApActions();
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            System.out.println("Adding Security risk items ");
        }
        this.linuxActionsPanel.setObject(new ApActionsObject(this.apActions));
        this.linuxSchedPanel.updatePanel();
        Boolean display = Boolean.TRUE;
        Boolean lock = Boolean.FALSE;
        if (3 == this.getPlatFormType()) {
            display = Utility.getBooleanValue((Boolean)this.linuxAdminScan.getOptDisplayNotification(), (Boolean)this.linuxAdminScan.getDefDisplayNotification());
            lock = Utility.getBooleanValue((Boolean)this.linuxAdminScan.getOptLockDisplayNotification(), (Boolean)this.linuxAdminScan.getDefLockDisplayNotification());
        } else if (1 == this.getPlatFormType()) {
            display = Utility.getBooleanValue((Boolean)this.adminScan.getOptDisplayNotification(), (Boolean)this.adminScan.getDefDisplayNotification());
            lock = Utility.getBooleanValue((Boolean)this.adminScan.getOptLockDisplayNotification(), (Boolean)this.adminScan.getDefLockDisplayNotification());
        }
        DetectionNotificationObject dno = new DetectionNotificationObject(lock, display, this.notificationMsg.getOptContent());
        this.linuxNotificationPanel.setObject(dno);
        this.setReadOnlyStatus();
    }

    private void updateMacPanel() {
        this.updateCommonPanel();
        if (this.isCommand) {
            this.macOnDemandDetailsPanel.updatePanel();
        } else {
            this.macDetailsPanel.updatePanel();
            this.macSchedPanel.updatePanel();
        }
        this.setReadOnlyStatus();
    }

    private void setupComponents() {
        this.saveAsTemplateBox = new JCheckBox(AdminScanDialog.getRes("box.saveAsTemplate"));
        this.operatingSystemCombo = new JComboBox<String>(new String[]{AdminScanDialog.getRes("box.ostype.windows"), AdminScanDialog.getRes("box.ostype.mac"), AdminScanDialog.getRes("box.ostype.linux")});
        switch (this.getPlatFormType()) {
            case 1: {
                this.operatingSystemCombo.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.operatingSystemCombo.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.operatingSystemCombo.setSelectedIndex(2);
                break;
            }
        }
        this.operatingSystemCombo.setEnabled(this.isOperatingSystemComboEnable);
        this.operatingSystemCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    String selectedOS = (String)AdminScanDialog.this.operatingSystemCombo.getSelectedItem();
                    if (AdminScanDialog.getRes("box.ostype.windows").equals(selectedOS)) {
                        AdminScanDialog.this.changeToWindows();
                    } else if (AdminScanDialog.getRes("box.ostype.mac").equals(selectedOS)) {
                        AdminScanDialog.this.changeToMac();
                    } else if (AdminScanDialog.getRes("box.ostype.linux").equals(selectedOS)) {
                        AdminScanDialog.this.changeToLinux();
                    }
                }
            }
        });
    }

    private JPanel getSaveAsTemplatePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.saveAsTemplateBox, "West");
        return result;
    }

    private void initTabs() {
        this.jtp.removeAll();
        if (3 == this.getPlatFormType()) {
            if (this.linuxDetailsPanel == null) {
                this.linuxDetailsPanel = new ScanDetailsPanel(this, this.getPlatFormType());
                this.linuxSchedPanel = new ScanSchedulePanel(this, this.getPlatFormType());
                this.linuxActionsPanel = new ActionsPane(true, false, this.getPlatFormType());
                this.linuxNotificationPanel = new DetectionNotificationPane(DetectionNotificationPane.PaneType.ADMIN_SCAN);
            }
            String scanDetails = AdminScanDialog.getRes("label.scanDetails");
            this.jtp.addTab(scanDetails, this.linuxDetailsPanel);
            this.jtp.addTab(AdminScanDialog.getRes("label.schedule"), this.linuxSchedPanel);
            String actions = AdminScanDialog.getRes("label.actions");
            this.jtp.addTab(actions, this.linuxActionsPanel);
            this.jtp.setTabComponentAt(2, UIUtilities.getDeprecatedOnLinuxPanel(actions, UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP));
            String notifications = AdminScanDialog.getRes("label.notifications");
            this.jtp.addTab(notifications, this.linuxNotificationPanel);
        } else if (1 == this.getPlatFormType()) {
            if (this.detailsPanel == null) {
                this.detailsPanel = new ScanDetailsPanel(this, this.getPlatFormType());
                this.schedPanel = new ScanSchedulePanel(this, this.getPlatFormType());
                this.actionsPanel = new ActionsPane(true, true);
                this.notificationPanel = new DetectionNotificationPane(DetectionNotificationPane.PaneType.ADMIN_SCAN);
            }
            this.jtp.addTab(AdminScanDialog.getRes("label.scanDetails"), this.detailsPanel);
            this.jtp.addTab(AdminScanDialog.getRes("label.schedule"), this.schedPanel);
            this.jtp.addTab(AdminScanDialog.getRes("label.actions"), this.actionsPanel);
            this.jtp.addTab(AdminScanDialog.getRes("label.notifications"), this.notificationPanel);
        } else if (2 == this.getPlatFormType()) {
            if (this.isCommand) {
                if (this.macOnDemandDetailsPanel == null) {
                    this.macOnDemandDetailsPanel = new MacOnDemandScanDetailsPanel(this);
                    this.jtp.addTab(AdminScanDialog.getRes("label.scanDetails"), this.macOnDemandDetailsPanel);
                }
            } else {
                if (this.macDetailsPanel == null) {
                    this.macDetailsPanel = new MacScanDetailsPanel(this);
                    this.macSchedPanel = new ScanSchedulePanel(this, this.getPlatFormType());
                }
                this.jtp.addTab(AdminScanDialog.getRes("label.scanDetails"), this.macDetailsPanel);
                this.jtp.addTab(AdminScanDialog.getRes("label.schedule"), this.macSchedPanel);
            }
        }
    }

    public ScanDetailsPanel getLinuxDetailsPanel() {
        return this.linuxDetailsPanel;
    }

    public MacAdminDefinedScanDetails getMacScanDetails() {
        return this.macScanDetails;
    }

    public ScanSchedule getMacScanSchedule() {
        return this.macScanSchedule;
    }

    public MacGeneralScanSettingsObject getMacGeneralScanSettingsObject() {
        return this.macGeneralScanSettingsObject;
    }

    public CompressedFilesObject getMacCompressedFilesObject() {
        return this.macCompressedFilesObject;
    }

    public AdminDefinedScan getObject() {
        return this.adminScan;
    }

    public MacAdminDefinedScan getMacObject() {
        return this.macAdminScan;
    }

    public LinuxAdminDefinedScan getLinuxObject() {
        return this.linuxAdminScan;
    }

    public int getSelectedPlatFormType() {
        return this.getPlatFormType();
    }

    public ScanSchedule getScanSchedule() {
        return this.scanSchedule;
    }

    public AdminDefinedScanPoolObject getScanPoolObject() {
        return this.scanPoolObj;
    }

    public MacAdminDefinedScanPoolObject getMacScanPoolObject() {
        return this.macScanPoolObj;
    }

    public LinuxAdminDefinedScanPoolObject getLinuxScanPoolObject() {
        return this.linuxScanPoolObj;
    }

    public AdminDefinedScanDetails getScanDetails() {
        return this.scanDetails;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public void setObject(AdminDefinedScan adminScan) throws ConsoleException {
        this.adminScan = adminScan;
        if (this.isEdit) {
            this.oldName = adminScan.getOptDisplayName() == null ? adminScan.getName() : adminScan.getOptDisplayName();
        }
        this.scanDetails = adminScan.getOptAdminDefinedScanDetails();
        if (this.scanDetails == null) {
            this.scanDetails = new AdminDefinedScanDetails();
        }
        this.scanSchedule = adminScan.getOptScanSchedule();
        if (this.scanSchedule == null) {
            this.scanSchedule = new ScanSchedule();
        }
        this.apActions = adminScan.getOptApActions();
        if (this.apActions == null) {
            this.apActions = new ApActions();
        }
        this.notificationMsg = adminScan.getOptNotificationMessage();
        if (this.notificationMsg == null) {
            this.notificationMsg = new NotificationMessage();
        }
        this.updatePanel();
        this.pack();
    }

    public void setObject(LinuxAdminDefinedScanPoolObject scanPoolObject) {
        this.linuxScanPoolObj = scanPoolObject;
    }

    public void setObject(LinuxAdminDefinedScan linuxAdminScan) throws ConsoleException {
        this.linuxAdminScan = linuxAdminScan;
        if (this.isEdit) {
            this.oldName = linuxAdminScan.getOptDisplayName() == null ? linuxAdminScan.getName() : linuxAdminScan.getOptDisplayName();
        }
        this.scanDetails = linuxAdminScan.getOptAdminDefinedScanDetails();
        if (this.scanDetails == null) {
            this.scanDetails = new AdminDefinedScanDetails();
        }
        this.scanSchedule = linuxAdminScan.getOptScanSchedule();
        if (this.scanSchedule == null) {
            this.scanSchedule = new ScanSchedule();
        }
        this.apActions = linuxAdminScan.getOptApActions();
        if (this.apActions == null) {
            this.apActions = new ApActions();
        }
        this.notificationMsg = linuxAdminScan.getOptNotificationMessage();
        if (this.notificationMsg == null) {
            this.notificationMsg = new NotificationMessage();
        }
        this.updateLinuxPanel();
        this.pack();
    }

    public void setObject(MacAdminDefinedScan adminScan) {
        this.macAdminScan = adminScan;
        if (this.isEdit) {
            this.oldName = this.macAdminScan.getOptDisplayName() == null ? this.macAdminScan.getName() : this.macAdminScan.getOptDisplayName();
        }
        this.macScanDetails = adminScan.getOptMacAdminDefinedScanDetails();
        if (this.macScanDetails == null) {
            this.macScanDetails = new MacAdminDefinedScanDetails();
        }
        this.macScanSchedule = adminScan.getOptScanSchedule();
        if (this.macScanSchedule == null) {
            this.macScanSchedule = new ScanSchedule();
        }
        this.updateMacPanel();
        this.pack();
    }

    public void setObject(MacAdminDefinedScan adminScan, MacGeneralScanSettingsObject generalScanSettingsObject) throws ConsoleException {
        this.macAdminScan = adminScan;
        this.macGeneralScanSettingsObject = generalScanSettingsObject;
        this.macCompressedFilesObject = generalScanSettingsObject.getCompressedFilesObject();
        this.macScanDetails = this.macAdminScan.getOptMacAdminDefinedScanDetails();
        if (this.macScanDetails == null) {
            this.macScanDetails = new MacAdminDefinedScanDetails();
        }
        this.updateMacPanel();
        this.pack();
    }

    public boolean getSaveAsTemplate() {
        return this.saveAsTemplateBox.isSelected();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        int selectedTab = this.jtp.getSelectedIndex();
        switch (selectedTab) {
            case 0: {
                return "sesm_policies_dialog_av_scan_scan_details";
            }
            case 1: {
                return "sesm_policies_dialog_av_scan_schedule";
            }
            case 2: {
                return "sesm_policies_dialog_av_scan_actions";
            }
            case 3: {
                return "sesm_policies_dialog_av_scan_notifications";
            }
        }
        return null;
    }

    private class AdminScanTopPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField nameField;
        private JTextArea descArea;

        public AdminScanTopPanel() {
            this.setupPanel();
        }

        private void setupPanel() {
            this.setupComponents();
            this.setLayout(new VerticalFlowLayout());
            this.add(this.getTopDetailsPanel());
        }

        public void saveObject() {
            if (!AdminScanDialog.this.isCommand) {
                if (AdminScanDialog.this.getPlatFormType() == 1) {
                    AdminScanDialog.this.adminScan.setName(this.nameField.getText());
                    AdminScanDialog.this.adminScan.setOptDisplayName(null);
                    String desc = this.descArea.getText().trim();
                    if (desc.length() > 0) {
                        AdminScanDialog.this.adminScan.setOptDescription(desc);
                    } else {
                        AdminScanDialog.this.adminScan.setOptDescription(null);
                    }
                } else if (AdminScanDialog.this.getPlatFormType() == 2) {
                    AdminScanDialog.this.macAdminScan.setName(this.nameField.getText());
                    AdminScanDialog.this.macAdminScan.setOptDisplayName(null);
                    String desc = this.descArea.getText().trim();
                    if (desc.length() > 0) {
                        AdminScanDialog.this.macAdminScan.setOptDescription(desc);
                    } else {
                        AdminScanDialog.this.macAdminScan.setOptDescription(null);
                    }
                } else if (AdminScanDialog.this.getPlatFormType() == 3) {
                    AdminScanDialog.this.linuxAdminScan.setName(this.nameField.getText());
                    AdminScanDialog.this.linuxAdminScan.setOptDisplayName(null);
                    String desc = this.descArea.getText().trim();
                    if (desc.length() > 0) {
                        AdminScanDialog.this.linuxAdminScan.setOptDescription(desc);
                    } else {
                        AdminScanDialog.this.linuxAdminScan.setOptDescription(null);
                    }
                }
            }
        }

        public void updatePanel() {
            if (AdminScanDialog.this.isCommand) {
                this.nameField.setEnabled(false);
                this.descArea.setEnabled(false);
                this.descArea.setLineWrap(true);
                this.descArea.setWrapStyleWord(true);
                if (AdminScanDialog.this.getPlatFormType() == 1) {
                    this.nameField.setText(AdminScanDialog.this.adminScan.getOptDisplayName() == null ? AdminScanDialog.this.adminScan.getName() : AdminScanDialog.this.adminScan.getOptDisplayName());
                    this.descArea.setText(AdminScanDialog.this.adminScan.getOptDescription());
                } else if (AdminScanDialog.this.getPlatFormType() == 2) {
                    this.nameField.setText(AdminScanDialog.this.macAdminScan.getOptDisplayName() == null ? AdminScanDialog.this.macAdminScan.getName() : AdminScanDialog.this.macAdminScan.getOptDisplayName());
                    this.descArea.setText(AdminScanDialog.this.macAdminScan.getOptDescription());
                } else if (AdminScanDialog.this.getPlatFormType() == 3) {
                    this.nameField.setText(AdminScanDialog.this.linuxAdminScan.getOptDisplayName() == null ? AdminScanDialog.this.linuxAdminScan.getName() : AdminScanDialog.this.linuxAdminScan.getOptDisplayName());
                    this.descArea.setText(AdminScanDialog.this.linuxAdminScan.getOptDescription());
                }
            } else {
                String name = null;
                String description = null;
                if (AdminScanDialog.this.getPlatFormType() == 1) {
                    name = AdminScanDialog.this.adminScan.getOptDisplayName() == null ? AdminScanDialog.this.adminScan.getName() : AdminScanDialog.this.adminScan.getOptDisplayName();
                    description = AdminScanDialog.this.adminScan.getOptDescription();
                } else if (AdminScanDialog.this.getPlatFormType() == 2) {
                    name = AdminScanDialog.this.macAdminScan.getOptDisplayName() == null ? AdminScanDialog.this.macAdminScan.getName() : AdminScanDialog.this.macAdminScan.getOptDisplayName();
                    description = AdminScanDialog.this.macAdminScan.getOptDescription();
                } else if (AdminScanDialog.this.getPlatFormType() == 3) {
                    name = AdminScanDialog.this.linuxAdminScan.getOptDisplayName() == null ? AdminScanDialog.this.linuxAdminScan.getName() : AdminScanDialog.this.linuxAdminScan.getOptDisplayName();
                    description = AdminScanDialog.this.linuxAdminScan.getOptDescription();
                }
                this.nameField.setText(name);
                if (description != null) {
                    this.descArea.setText(description);
                }
            }
        }

        private JPanel getTopDetailsPanel() {
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 1;
            p.add((Component)new JLabel(AdminScanDialog.getRes("label.scanName")), c);
            c.insets = new Insets(0, 20, 0, 0);
            c.gridx = 1;
            c.gridy = 1;
            c.fill = 2;
            p.add((Component)this.nameField, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 2;
            p.add((Component)new JLabel(AdminScanDialog.getRes("label.scanDesc")), c);
            c.insets = new Insets(5, 20, 0, 0);
            c.gridx = 1;
            c.gridy = 2;
            c.fill = 2;
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.descArea);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(31);
            p.add((Component)scrollPane, c);
            JPanel result = new JPanel(new BorderLayout());
            result.add((Component)p, "Before");
            return result;
        }

        private void setupComponents() {
            this.nameField = new JTextField();
            this.descArea = new JTextArea(3, 50);
            this.descArea.setLineWrap(true);
            this.descArea.setWrapStyleWord(true);
            Dimension dimension = this.nameField.getPreferredSize();
            dimension.width = this.descArea.getPreferredSize().width + 4;
            this.nameField.setPreferredSize(dimension);
        }

        private String getName(TopLevelObject adminDefinedObj, boolean displayName) {
            String name = "";
            if (AdminScanDialog.this.getPlatFormType() == 1) {
                AdminDefinedScan obj = (AdminDefinedScan)adminDefinedObj;
                name = displayName ? obj.getOptDisplayName() : obj.getName();
            } else if (AdminScanDialog.this.getPlatFormType() == 2) {
                MacAdminDefinedScan obj = (MacAdminDefinedScan)adminDefinedObj;
                name = displayName ? obj.getOptDisplayName() : obj.getName();
            } else if (AdminScanDialog.this.getPlatFormType() == 3) {
                LinuxAdminDefinedScan obj = (LinuxAdminDefinedScan)adminDefinedObj;
                name = displayName ? obj.getOptDisplayName() : obj.getName();
            }
            return name;
        }

        private boolean checkName() {
            int i;
            List<ObjInfoObject> objInfoList = null;
            String objectType = null;
            if (AdminScanDialog.this.getPlatFormType() == 1) {
                objInfoList = Arrays.asList(AdminScanDialog.this.scanPoolObj.getInfoObjectList());
                objectType = "AdminDefinedScan";
            } else if (AdminScanDialog.this.getPlatFormType() == 2) {
                objInfoList = Arrays.asList(AdminScanDialog.this.macScanPoolObj.getInfoObjectList());
                objectType = "MacAdminDefinedScan";
            } else if (AdminScanDialog.this.getPlatFormType() == 3) {
                objInfoList = Arrays.asList(AdminScanDialog.this.linuxScanPoolObj.getInfoObjectList());
                objectType = "LinuxAdminDefinedScan";
            }
            if (objInfoList == null) {
                return true;
            }
            ArrayList<String> displaynameList = new ArrayList<String>();
            for (i = 0; i < objInfoList.size(); ++i) {
                ObjInfoObject objInfo = objInfoList.get(i);
                try {
                    TopLevelObject obj = DataobjectManager.getInstance().getObjectByGUID(objectType, objInfo.getId());
                    displaynameList.add(this.getName(obj, true) == null ? this.getName(obj, false) : this.getName(obj, true));
                    continue;
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    ConsoleLogger.log(ex);
                    if (!ex.needRelogin()) continue;
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.util.consoleutil", "DataobjectManager.msg.information"), 1);
                    Manager.getFrame().showLoginPanel();
                    return false;
                }
            }
            if (AdminScanDialog.this.adminScanNames != null) {
                for (String adsName : AdminScanDialog.this.adminScanNames) {
                    if (!adsName.equals(this.nameField.getText())) continue;
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(AdminScanDialog.getRes("label.ScanNameExists"), adsName), AdminScanDialog.getRes("label.error"), 0);
                    return false;
                }
                for (int i2 = 0; i2 < displaynameList.size(); ++i2) {
                    if (!((String)displaynameList.get(i2)).equals(this.nameField.getText())) continue;
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(AdminScanDialog.getRes("label.ScanNameExists"), displaynameList.get(i2)), AdminScanDialog.getRes("label.error"), 0);
                    return false;
                }
            }
            if (AdminScanDialog.this.saveAsTemplateBox.isSelected() || AdminScanDialog.this.isPoolObj) {
                for (i = 0; i < objInfoList.size(); ++i) {
                    ObjInfoObject objInfo = objInfoList.get(i);
                    if (!objInfo.getName().equals(this.nameField.getText())) continue;
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(AdminScanDialog.getRes("label.templateUsedName"), objInfo.getName()), AdminScanDialog.getRes("label.error"), 0);
                    return false;
                }
                for (i = 0; i < displaynameList.size(); ++i) {
                    if (!((String)displaynameList.get(i)).equals(this.nameField.getText())) continue;
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(AdminScanDialog.getRes("label.templateUsedName"), displaynameList.get(i)), AdminScanDialog.getRes("label.error"), 0);
                    return false;
                }
            }
            if (displaynameList != null) {
                for (i = 0; i < displaynameList.size(); ++i) {
                    if (!((String)displaynameList.get(i)).equals(this.nameField.getText())) continue;
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(AdminScanDialog.getRes("label.ScanNameExists"), displaynameList.get(i)), AdminScanDialog.getRes("label.error"), 0);
                    return false;
                }
            }
            return true;
        }

        public boolean valuesValid() {
            if (this.nameField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), AdminScanDialog.getRes("label.emptyName"), AdminScanDialog.getRes("label.error"), 0);
                return false;
            }
            if (this.nameField.getText().trim().length() > 128) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(AdminScanDialog.getRes("label.MaxName"), String.valueOf(128)), AdminScanDialog.getRes("label.error"), 0);
                return false;
            }
            if (this.descArea.getText().trim().length() > 255) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(AdminScanDialog.getRes("label.MaxDesc"), String.valueOf(255)), AdminScanDialog.getRes("label.error"), 0);
                return false;
            }
            if (AdminScanDialog.this.isEdit) {
                if (!AdminScanDialog.this.oldName.equals(this.nameField.getText())) {
                    return this.checkName();
                }
            } else {
                return this.checkName();
            }
            return true;
        }
    }
}

