/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av.admindefinedscan;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AvScanPolicy;
import com.sygate.scm.common.configobject.schema.AvScanSettings;
import com.sygate.scm.common.configobject.schema.CommandScan;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PauseOptions;
import com.sygate.scm.common.configobject.schema.ScanProgressOptions;
import com.sygate.scm.common.configobject.schema.ScanSchedule;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.JOptionPaneUtil;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminScanDialog;
import com.sygate.scm.console.ui.policy.av.common.AvDialogBase;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.HierarchyListenerImpl;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.xml.sax.SAXException;

public class AdminDefinedScanPane
extends JTabbedPane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private AvScanPolicy scanPolicy;
    private AvScanSettings advSettings;
    private ScanProgressOptions progressOptions;
    private PauseOptions pauseOptions;
    private Vector<ObjReference> definedScansObjRefs;
    private Vector<ConfigObject> definedScans;
    private List<AdminDefinedScan> deletedScans = new ArrayList<AdminDefinedScan>();
    private CommandScan commandScan;
    private AdminDefinedScan definedCommandScan;
    private AdminDefinedScanPoolObject scanPoolObj;
    private AvPolicyObject avObj;
    private SortableTableModel model;
    private JTable scansTable;
    private JButton addScanButton;
    private JButton editScanButton;
    private JButton deleteScanButton;
    private AlwaysEnabledButton commandScanButton;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem addScanMenuItem;
    private Action addScanAction;
    private JMenuItem editScanMenuItem;
    private Action editScanAction;
    private JMenuItem deleteScanMenuItem;
    private Action deleteScanAction;
    private JCheckBox delayBatteryBox;
    private JCheckBox notLoggedOnBox;
    private JCheckBox startupScanBox;
    private JCheckBox allowModBox;
    private JCheckBox quickScanBox;
    private JComboBox<String> userOptionsBox;
    private JCheckBox closeBox;
    private JCheckBox stopBox;
    private AlwaysEnabledButton pauseButton;
    private JCheckBox pauseOrSnoozeBox;
    private String newScanName;
    private int newLastNumber = 0;

    public AdminDefinedScanPane() {
        this.setupPanel();
    }

    public void saveObject() throws ConsoleException {
        this.saveAdvSettings();
        this.scanPolicy.setOptAvScanSettings(this.advSettings);
        this.saveObjReferences();
        this.deleteScansAndReferences();
        this.saveAvScanPolicyObjRef();
        this.scanPolicy.setCommandScan(this.commandScan);
    }

    private static AdminDefinedScan getNewScan(String name) {
        AdminDefinedScan ads = new AdminDefinedScan();
        ads.setName(name);
        ads.setId(GUIDGenerator.getInstance().getGUIDString());
        ads.setScanType(AdminDefinedScan.CUSTOM);
        return ads;
    }

    private void initCommandScan() throws ConsoleException {
        ObjReference obj = this.commandScan.getObjReference();
        if (obj != null) {
            this.definedCommandScan = (AdminDefinedScan)PolicyHandler.getObject(obj.getTargetType(), obj.getTargetId());
        }
        if (this.definedCommandScan == null) {
            this.definedCommandScan = AdminDefinedScanPane.getNewScan("COMMAND_SCAN");
        }
    }

    private void resolveObjReferences() throws ConsoleException {
        this.initCommandScan();
        this.definedScans = new Vector();
        for (ObjReference obj : this.definedScansObjRefs) {
            AdminDefinedScan ads = (AdminDefinedScan)PolicyHandler.getObject(obj.getTargetType(), obj.getTargetId());
            this.definedScans.add((ConfigObject)ads);
        }
    }

    private boolean objRefAlreadyDefinedFor(AdminDefinedScan ads) {
        for (ObjReference obj : this.definedScansObjRefs) {
            if (!obj.getTargetId().equals(ads.getId())) continue;
            return true;
        }
        return false;
    }

    private void saveCommandScan() throws ConsoleException {
        ObjReference obj = this.commandScan.getObjReference();
        if (obj == null) {
            this.commandScan.setObjReference(this.saveOneScanAndGetObjRef(this.definedCommandScan));
        }
    }

    private ObjReference saveOneScanAndGetObjRef(AdminDefinedScan scan) throws ConsoleException {
        ObjReference or = new ObjReference();
        or.setTargetId(scan.getId());
        or.setTargetType(scan.getObjectTypeName());
        or.setName("AdminDefinedScanApplied");
        return or;
    }

    private void saveObjReferences() throws ConsoleException {
        this.saveCommandScan();
        for (AdminDefinedScan adminDefinedScan : this.definedScans) {
            if (this.objRefAlreadyDefinedFor(adminDefinedScan)) continue;
            this.definedScansObjRefs.add(this.saveOneScanAndGetObjRef(adminDefinedScan));
        }
    }

    private void removeObjRef(String scanID) {
        Iterator<ObjReference> i = this.definedScansObjRefs.iterator();
        while (i.hasNext()) {
            ObjReference or = i.next();
            if (!or.getTargetId().equals(scanID)) continue;
            i.remove();
        }
    }

    private void deleteScansAndReferences() throws ConsoleException {
        for (AdminDefinedScan ads : this.deletedScans) {
            this.removeObjRef(ads.getId());
        }
    }

    private void saveAvScanPolicyObjRef() {
        int j;
        boolean isExist;
        ObjReference objRef;
        int i = this.scanPolicy.getObjReferenceCount();
        while (--i >= 0) {
            objRef = this.scanPolicy.getObjReference(i);
            isExist = false;
            for (j = 0; j < this.definedScansObjRefs.size(); ++j) {
                ObjReference ref = this.definedScansObjRefs.get(j);
                if (!objRef.getTargetId().equals(ref.getTargetId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.scanPolicy.removeObjReference(objRef);
        }
        for (i = 0; i < this.definedScansObjRefs.size(); ++i) {
            objRef = this.definedScansObjRefs.get(i);
            isExist = false;
            for (j = 0; j < this.scanPolicy.getObjReferenceCount(); ++j) {
                if (!objRef.getTargetId().equals(this.scanPolicy.getObjReference(j).getTargetId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.scanPolicy.addObjReference(objRef);
        }
    }

    private String getRes(String component, String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", component + key);
    }

    private String getRes(String key) {
        return this.getRes("AdminScanPane.", key);
    }

    private void setupTable() {
        String[] colNames = new String[]{this.getRes("table.column.head.name"), this.getRes("table.column.head.enabled"), this.getRes("table.column.head.when"), this.getRes("table.column.head.desc")};
        this.model = new SortableTableModel(){
            private static final long serialVersionUID = 7585842144026275453L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }
        };
        this.model.setColumnNames(colNames);
        this.scansTable = new StripesTable(this.model, false, false);
        this.scansTable.putClientProperty("dynamicEventsEnabled", true);
        this.model.addMouseListenerToHeaderInTable(this.scansTable);
        this.scansTable.getSelectionModel().setSelectionMode(0);
        UIUtilities.setTableColumnWidth(this.scansTable, new float[]{0.4f, 0.1f, 0.25f, 0.25f}, (int)this.scansTable.getPreferredScrollableViewportSize().getWidth());
        this.scansTable.setPreferredScrollableViewportSize(new Dimension(10, 200));
        this.scansTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AdminDefinedScanPane.this.scansTable.isEnabled()) {
                    this.maybeShowPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (AdminDefinedScanPane.this.scansTable.isEnabled()) {
                    this.maybeShowPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && AdminDefinedScanPane.this.scansTable.isEnabled() && AdminDefinedScanPane.this.scansTable.getSelectedColumn() != 1) {
                    AdminDefinedScanPane.this.editScan();
                }
            }

            private void maybeShowPopup(MouseEvent e) {
                Point p = e.getPoint();
                int row = AdminDefinedScanPane.this.scansTable.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    return;
                }
                AdminDefinedScanPane.this.scansTable.setRowSelectionInterval(row, row);
                TableRow asto = AdminDefinedScanPane.this.model.getRow(row);
                if (asto == null) {
                    return;
                }
                AdminDefinedScanPane.this.popup.show(AdminDefinedScanPane.this.scansTable, e.getX(), e.getY());
            }
        });
    }

    private void saveCopyAsTemplate(AdminDefinedScan ads) throws ConsoleException {
        try {
            WashIDHandler idHandler = new WashIDHandler();
            AdminDefinedScan tempCopy = (AdminDefinedScan)idHandler.duplicateObject((ConfigObject)ads, new HashMap<String, TopLevelObject>());
            this.getScanPoolObj().addPolicyObject(new AdminDefinedScanObject(tempCopy));
        }
        catch (SAXException saxe) {
            throw new ConsoleException(saxe);
        }
        catch (ValidationException ve) {
            throw new ConsoleException(ve);
        }
        catch (IOException ioe) {
            throw new ConsoleException(ioe);
        }
    }

    private void addScan() {
        AddScanTypeDialog astd = new AddScanTypeDialog(this.getRes("label.adminScanDialogNewTitle"));
        astd.setPoolObj(this.getScanPoolObj());
        if (LicenseObject.getInstance().isSBProduct()) {
            astd.setVisible(false);
            astd.newScanButton.setSelected(true);
            astd.ok();
        } else {
            astd.setVisible(true);
        }
        if (astd.isOk()) {
            Vector<ConfigObject> result = astd.getObject();
            this.definedScans.addAll(result);
            for (AdminDefinedScan adminDefinedScan : result) {
                MetadataAttributes mda = new MetadataAttributes();
                mda.setOwner(new GUID(this.avObj.getId()));
                adminDefinedScan.setMetadataAttributes(mda);
                this.avObj.getNewObjSet().put(adminDefinedScan.getId(), (TopLevelObject)adminDefinedScan);
                AdminScanTableObject asto = new AdminScanTableObject(adminDefinedScan);
                this.model.addRow(asto);
                this.setBtnState();
            }
        }
    }

    private void editScan() {
        block7: {
            int selected = this.scansTable.getSelectedRow();
            if (selected == -1) {
                JOptionPaneUtil.showMessageDialog(Manager.getFrame(), this.getRes("edit.message"), this.getRes("edit.title"), 1);
                return;
            }
            AdminScanTableObject asto = (AdminScanTableObject)this.model.getRow(selected);
            Vector<TableRow> datavect = this.model.getDataVector();
            Vector<String> allScanNames = new Vector<String>();
            AdminDefinedScan tempScan = null;
            for (int i = 0; i < datavect.size(); ++i) {
                tempScan = ((AdminScanTableObject)datavect.get(i)).getAdminScan();
                allScanNames.add(tempScan.getName());
            }
            try {
                AdminDefinedScan newObj;
                AdminScanDialog asd = new AdminScanDialog(this.getRes("label.adminScanDialogEditTitle"), false, this.getScanPoolObj(), allScanNames, true, false, 1);
                AdminDefinedScan oldObj = asto.getAdminScan();
                asd.setObject((AdminDefinedScan)oldObj.clone());
                asd.setVisible(true);
                if (!asd.isOk() || ConfigObjectUtils.isEqualObj((Object)(newObj = asd.getObject()), (Object)oldObj)) break block7;
                this.avObj.getChangedObjSet().put(newObj.getId(), (TopLevelObject)newObj);
                if (asd.getSaveAsTemplate()) {
                    try {
                        this.saveCopyAsTemplate(newObj);
                    }
                    catch (ConsoleException ce) {
                        LoggerUtilities.logException((Throwable)ce);
                    }
                }
                this.model.setRow(selected, new AdminScanTableObject(newObj));
                this.model.fireTableRowsUpdated(selected, selected);
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e);
            }
        }
    }

    private void deleteScan() {
        int selected = this.scansTable.getSelectedRow();
        if (selected != -1) {
            int choice = JOptionPane.showConfirmDialog(Manager.getFrame(), this.getRes("label.removeScheduledScan"), this.getRes("title.confirm"), 0);
            if (choice == 0) {
                AdminScanTableObject asto = (AdminScanTableObject)this.model.getRow(selected);
                AdminDefinedScan ads = asto.getAdminScan();
                this.deletedScans.add(ads);
                this.avObj.getDeletedObjSet().put(ads.getId(), (TopLevelObject)ads);
                this.model.removeRow(selected);
                this.setBtnState();
            }
        } else {
            JOptionPaneUtil.showMessageDialog(Manager.getFrame(), this.getRes("delete.message"), this.getRes("delete.title"), 1);
        }
    }

    private void setupComponents() {
        this.setupTable();
        this.addScanAction = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminDefinedScanPane.this.addScan();
            }
        };
        this.addScanButton = new JButton(this.addScanAction);
        this.addScanButton.setText(this.getRes("button.addScan"));
        this.addScanMenuItem = new JMenuItem(this.addScanAction);
        this.editScanAction = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminDefinedScanPane.this.editScan();
            }
        };
        this.editScanButton = new JButton(this.editScanAction);
        this.editScanButton.setText(this.getRes("button.editScan"));
        this.editScanMenuItem = new JMenuItem(this.editScanAction);
        this.deleteScanAction = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminDefinedScanPane.this.deleteScan();
            }
        };
        this.deleteScanButton = new JButton(this.deleteScanAction);
        this.deleteScanButton.setText(this.getRes("button.deleteScan"));
        this.setBtnState();
        this.deleteScanMenuItem = new JMenuItem(this.deleteScanAction);
        this.commandScanButton = new AlwaysEnabledButton(this.getRes("button.editScan"));
        this.commandScanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    AdminDefinedScan newObj;
                    AdminScanDialog asd = new AdminScanDialog(AdminDefinedScanPane.this.getRes("label.adminScanDialogCommandTitle"), false, true, AdminDefinedScanPane.this.getScanPoolObj());
                    asd.setObject((AdminDefinedScan)AdminDefinedScanPane.this.definedCommandScan.clone());
                    ReadOnlyUtils.disableDialogIfNeeded(AdminDefinedScanPane.this.commandScanButton, asd);
                    asd.setVisible(true);
                    if (asd.isOk() && !ConfigObjectUtils.isEqualObj((Object)(newObj = asd.getObject()), (Object)AdminDefinedScanPane.this.definedCommandScan)) {
                        AdminDefinedScanPane.this.definedCommandScan = newObj;
                        AdminDefinedScanPane.this.avObj.getChangedObjSet().put(AdminDefinedScanPane.this.definedCommandScan.getId(), (TopLevelObject)AdminDefinedScanPane.this.definedCommandScan);
                    }
                }
                catch (ConsoleException e) {
                    ConsoleLogger.log(e);
                }
            }
        });
        this.popup.add(this.addScanMenuItem);
        this.popup.add(this.editScanMenuItem);
        this.popup.add(this.deleteScanMenuItem);
        this.delayBatteryBox = new JCheckBox(this.getRes("checkbox.delayBattery"));
        this.delayBatteryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdminDefinedScanPane.this.delayBatteryBox.setFocusPainted(true);
            }
        });
        this.notLoggedOnBox = new JCheckBox(this.getRes("checkbox.noLoggedOn"));
        this.startupScanBox = new JCheckBox(this.getRes("checkbox.startupScan"));
        this.startupScanBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdminDefinedScanPane.this.enableAppropriateForStartupScan();
            }
        });
        this.allowModBox = new JCheckBox(this.getRes("checkbox.allowMod"));
        this.quickScanBox = new JCheckBox(this.getRes("checkbox.quickScan"));
        String[] userOpts = new String[]{this.getRes("label.noShowProgress"), this.getRes("label.showProgress"), this.getRes("label.showProgressRisk"), this.getRes("label.showProgressHighMediumRisk")};
        this.userOptionsBox = new JComboBox<String>(userOpts);
        this.userOptionsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminDefinedScanPane.this.enableAppropriate();
            }
        });
        this.closeBox = new JCheckBox(this.getRes("checkbox.close"));
        this.stopBox = new JCheckBox(this.getRes("checkbox.stop"));
        this.pauseButton = new AlwaysEnabledButton(this.getRes("button.pause"));
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PauseOptsDialog pod = new PauseOptsDialog(AdminDefinedScanPane.this.getRes("label.pauseDialogTitle"));
                pod.setObject(AdminDefinedScanPane.this.pauseOptions);
                ReadOnlyUtils.disableDialogIfNeeded(AdminDefinedScanPane.this.pauseButton, pod);
                pod.setVisible(true);
                if (pod.isOk()) {
                    AdminDefinedScanPane.this.pauseOptions = pod.getObject();
                }
            }
        });
        this.pauseOrSnoozeBox = new JCheckBox(this.getRes("checkbox.pauseOrSnooze"));
        this.pauseOrSnoozeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminDefinedScanPane.this.enableAppropriate();
            }
        });
    }

    private void enableAppropriateForStartupScan() {
        this.allowModBox.setEnabled(this.startupScanBox.isSelected());
    }

    private void enableAppropriate() {
        boolean enableUserOpts = this.userOptionsBox.getSelectedIndex() > 0;
        this.closeBox.setEnabled(enableUserOpts);
        this.stopBox.setEnabled(enableUserOpts);
        this.pauseOrSnoozeBox.setEnabled(enableUserOpts);
        if (enableUserOpts && this.pauseOrSnoozeBox.isSelected()) {
            this.pauseButton.setEnabled(true);
        } else {
            this.pauseButton.setEnabled(false);
        }
    }

    private void setupPanel() {
        this.setupComponents();
        this.addTab(this.getRes("label.scanDetails"), UIUtilities.createScrollPaneWithoutBoard(this.getScanDetailsPanel()));
        this.addTab(this.getRes("label.advanced"), UIUtilities.createScrollPaneWithoutBoard(this.getAdvancedPanel()));
    }

    private JPanel getAdvancedPanel() {
        AdvancedPanel result = new AdvancedPanel();
        result.add(this.getScheduledScansAdvPane());
        result.add(this.getUserPane());
        result.add(this.getStartupPane());
        return result;
    }

    private JPanel getUserPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.userTitle"), this.getRes("label.userDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        p.add(this.userOptionsBox, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        p.add((Component)this.closeBox, c);
        c.gridx = 0;
        c.gridy = 2;
        p.add((Component)this.stopBox, c);
        c.gridx = 0;
        c.gridy = 3;
        p.add((Component)this.pauseOrSnoozeBox, c);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 4;
        p.add((Component)this.pauseButton, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getStartupPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.startupTitle"), this.getRes("label.startupDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.startupScanBox, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets.left = 20;
        p.add((Component)this.allowModBox, c);
        c.gridx = 0;
        c.gridy = 2;
        c.insets.left = 0;
        p.add((Component)this.quickScanBox, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private JPanel getScheduledScansAdvPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.schedAdvTitle"), this.getRes("label.schedAdvDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.delayBatteryBox, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)this.notLoggedOnBox, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        result.addHierarchyListener(new HierarchyListenerImpl());
        return result;
    }

    private JPanel getScanDetailsPanel() {
        ScanDetailsPanel result = new ScanDetailsPanel();
        result.add(this.getScheduledScansPane());
        result.add(this.getCommandScanPane());
        return result;
    }

    private JPanel getScheduledScansPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.schedTitle"), this.getRes("label.schedDesc"));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.scansTable), "Center");
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.addScanButton, this.editScanButton, this.deleteScanButton}, 0, 2, true);
        p.add((Component)buttonPanel, "South");
        result.add(p);
        return result;
    }

    private JPanel getCommandScanPane() {
        AvTemplatePane result = new AvTemplatePane(this.getRes("label.commandTitle"), this.getRes("label.commandDesc"));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)new JLabel(this.getRes("label.commandScan")), c);
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        p.add((Component)this.commandScanButton, c);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "Before");
        result.add(temp);
        return result;
    }

    private void saveAdvSettings() {
        this.progressOptions.setProgressDisplayOption(Integer.valueOf(this.userOptionsBox.getSelectedIndex()));
        this.progressOptions.setOptCloseProgressWindowWhenDone(Boolean.valueOf(this.closeBox.isSelected()));
        this.progressOptions.setOptAllowUserStopScan(Boolean.valueOf(this.stopBox.isSelected()));
        this.progressOptions.setOptAllowPauseOrDelayScan(Boolean.valueOf(this.pauseOrSnoozeBox.isSelected()));
        this.progressOptions.setOptPauseOptions(this.pauseOptions);
        this.advSettings.setScanProgressOptions(this.progressOptions);
        this.advSettings.setOptDelayScanWhenRunningOnBatteries(Boolean.valueOf(this.delayBatteryBox.isSelected()));
        this.advSettings.setOptAllowScanWithoutLogin(Boolean.valueOf(this.notLoggedOnBox.isSelected()));
        this.advSettings.setOptRunStartupScanOnLogin(Boolean.valueOf(this.startupScanBox.isSelected()));
        this.advSettings.setOptAllowUserModifyStartupScans(Boolean.valueOf(this.allowModBox.isSelected()));
        this.advSettings.setOptRunQuickScanOnNewDefs(Boolean.valueOf(this.quickScanBox.isSelected()));
    }

    private void updateValues() {
        Boolean b = this.advSettings.getOptDelayScanWhenRunningOnBatteries();
        if (b == null) {
            b = this.advSettings.getDefDelayScanWhenRunningOnBatteries();
        }
        this.delayBatteryBox.setSelected(b);
        b = this.advSettings.getOptAllowScanWithoutLogin();
        if (b == null) {
            b = this.advSettings.getDefAllowScanWithoutLogin();
        }
        this.notLoggedOnBox.setSelected(b);
        b = this.advSettings.getOptRunStartupScanOnLogin();
        if (b == null) {
            b = this.advSettings.getDefRunStartupScanOnLogin();
        }
        this.startupScanBox.setSelected(b);
        b = this.advSettings.getOptAllowUserModifyStartupScans();
        if (b == null) {
            b = this.advSettings.getDefAllowUserModifyStartupScans();
        }
        this.allowModBox.setSelected(b);
        b = this.advSettings.getOptRunQuickScanOnNewDefs();
        if (b == null) {
            b = this.advSettings.getDefRunQuickScanOnNewDefs();
        }
        this.quickScanBox.setSelected(b);
        Integer i = this.progressOptions.getProgressDisplayOption();
        if (i == null) {
            i = 0;
        }
        this.userOptionsBox.setSelectedIndex(i);
        b = this.progressOptions.getOptCloseProgressWindowWhenDone();
        if (b == null) {
            b = this.progressOptions.getDefCloseProgressWindowWhenDone();
        }
        this.closeBox.setSelected(b);
        b = this.progressOptions.getOptAllowUserStopScan();
        if (b == null) {
            b = this.progressOptions.getDefAllowUserStopScan();
        }
        this.stopBox.setSelected(b);
        b = this.progressOptions.getOptAllowPauseOrDelayScan();
        if (b == null) {
            b = this.progressOptions.getDefAllowPauseOrDelayScan();
        }
        this.pauseOrSnoozeBox.setSelected(b);
        Iterator<ConfigObject> it = this.definedScans.iterator();
        while (it.hasNext()) {
            AdminScanTableObject asto = new AdminScanTableObject((AdminDefinedScan)it.next());
            this.model.addRow(asto);
            String name = asto.getAdminScan().getName();
            if (!name.startsWith(this.getNewScanName())) continue;
            if (name.length() == this.getNewScanName().length()) {
                this.newLastNumber = Math.max(1, this.newLastNumber);
            }
            String prepend = name.substring(this.getNewScanName().length()).trim();
            try {
                if (prepend.length() <= 0) continue;
                int number = Integer.parseInt(prepend);
                this.newLastNumber = Math.max(number, this.newLastNumber);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.enableAppropriateForStartupScan();
        this.setBtnState();
    }

    private String getNewScanName() {
        if (this.newScanName != null) {
            return this.newScanName;
        }
        this.newScanName = this.getRes("name.newAdminScan");
        return this.newScanName;
    }

    private void setBtnState() {
        boolean value = false;
        if (this.scansTable != null && this.scansTable.getRowCount() > 0) {
            value = true;
        }
        this.editScanButton.setEnabled(value);
        this.deleteScanButton.setEnabled(value);
    }

    private AdminDefinedScanPoolObject getScanPoolObj() {
        if (this.scanPoolObj == null) {
            try {
                this.scanPoolObj = AdminDefinedScanPoolObject.getPolicyPool();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return this.scanPoolObj;
    }

    public void setObject(AvScanPolicy avsp, AvPolicyObject avObj) throws ConsoleException {
        this.scanPolicy = avsp;
        this.avObj = avObj;
        this.advSettings = avsp.getOptAvScanSettings();
        if (this.advSettings == null) {
            this.advSettings = new AvScanSettings();
        }
        this.progressOptions = this.advSettings.getScanProgressOptions();
        if (this.progressOptions == null) {
            this.progressOptions = new ScanProgressOptions();
        }
        this.pauseOptions = this.progressOptions.getOptPauseOptions();
        if (this.pauseOptions == null) {
            this.pauseOptions = new PauseOptions();
        }
        this.definedScansObjRefs = avsp.getObjReference();
        this.commandScan = avsp.getCommandScan();
        if (this.commandScan == null) {
            this.commandScan = new CommandScan();
        }
        this.resolveObjReferences();
        this.updateValues();
        this.enableAppropriate();
    }

    public boolean valuesValid() {
        if (this.definedCommandScan.getName() == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), "Must define command scan settings.\nPlease specify command scan settings from the Admin-defined Scan tab.", this.getRes("label.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return HelpUtil.getContentSensitiveHelpToken(this.getSelectedComponent());
    }

    private static class AdvancedPanel
    extends JPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        public AdvancedPanel() {
            super(new VerticalFlowLayout());
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_advanced";
        }
    }

    private static class ScanDetailsPanel
    extends JPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        public ScanDetailsPanel() {
            super(new VerticalFlowLayout());
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans";
        }
    }

    private static class PauseOptsDialog
    extends AvDialogBase {
        private static final long serialVersionUID = 1L;
        private JPanel contentPane;
        private JCheckBox limitBox;
        private JSpinner limitMinSpinner;
        private JSpinner maxSnoozeSpinner;
        private JCheckBox allowSnoozeBox;
        private PauseOptions pauseOpts;

        public PauseOptsDialog(String title) {
            super(title, true, true);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_advanced_pause";
        }

        @Override
        protected JPanel getContentPanel() {
            if (this.contentPane == null) {
                this.contentPane = new JPanel(new VerticalFlowLayout());
                this.setupComponents();
                this.contentPane.add(this.getPauseOptsPane());
                this.contentPane.add(this.getSnoozeOptsPane());
            }
            return this.contentPane;
        }

        @Override
        protected boolean isValidate() {
            return super.isValidate();
        }

        @Override
        protected void commit() {
            this.pauseOpts.setOptLimitPauseTime(Boolean.valueOf(this.limitBox.isSelected()));
            if (this.limitBox.isSelected()) {
                this.pauseOpts.setOptMaxPauseMinutes((Integer)this.limitMinSpinner.getValue());
            }
            this.pauseOpts.setOptMaxNumberOfSnooze((Integer)this.maxSnoozeSpinner.getValue());
            this.pauseOpts.setOptExtendSnoozeTime(Boolean.valueOf(this.allowSnoozeBox.isSelected()));
        }

        private void setupComponents() {
            this.limitBox = new JCheckBox(this.getRes("checkbox.limit"));
            this.limitBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.enableAppropriate();
                }
            });
            SpinnerNumberModel model = new SpinnerNumberModel(3, 3, 180, 1);
            this.limitMinSpinner = new JSpinner(model);
            UIUtilities.enableOnlyValidEdits(this.limitMinSpinner);
            model = new SpinnerNumberModel(3, 1, 8, 1);
            this.maxSnoozeSpinner = new JSpinner(model);
            UIUtilities.enableOnlyValidEdits(this.maxSnoozeSpinner);
            this.allowSnoozeBox = new JCheckBox(this.getRes("checkbox.allowSnooze"));
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "PauseOptsDialog." + key);
        }

        private JPanel getPauseOptsPane() {
            AvTemplatePane result = new AvTemplatePane(this.getRes("label.pauseOptsTitle"), this.getRes("label.pauseOptsDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            p.add((Component)this.limitBox, c);
            c.insets = new Insets(5, 25, 0, 0);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            p.add((Component)new JLabel(this.getRes("label.minToPause")), c);
            c.insets = new Insets(5, 20, 0, 0);
            c.gridx = 1;
            c.gridy = 1;
            p.add((Component)this.limitMinSpinner, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            result.add(temp);
            return result;
        }

        private JPanel getSnoozeOptsPane() {
            AvTemplatePane result = new AvTemplatePane(this.getRes("label.snoozeTitle"), this.getRes("label.snoozeDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)new JLabel(this.getRes("label.maxSnooze")), c);
            c.insets = new Insets(5, 10, 0, 0);
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 0;
            p.add((Component)this.maxSnoozeSpinner, c);
            c.insets = new Insets(10, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.fill = 2;
            p.add((Component)new JLabel(this.getRes("label.userOptSnooze")), c);
            c.insets = new Insets(10, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 2;
            p.add((Component)this.allowSnoozeBox, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            result.add(temp);
            return result;
        }

        private void enableAppropriate() {
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
                this.limitMinSpinner.setEnabled(false);
            } else {
                this.limitMinSpinner.setEnabled(this.limitBox.isSelected());
            }
        }

        private void updatePanel() {
            Boolean b = this.pauseOpts.getOptLimitPauseTime();
            if (b == null) {
                b = this.pauseOpts.getDefLimitPauseTime();
            }
            this.limitBox.setSelected(b);
            Integer i = this.pauseOpts.getOptMaxPauseMinutes();
            if (i == null) {
                i = this.pauseOpts.getDefMaxPauseMinutes();
            }
            this.limitMinSpinner.setValue(i);
            i = this.pauseOpts.getOptMaxNumberOfSnooze();
            if (i == null) {
                i = this.pauseOpts.getDefMaxNumberOfSnooze();
            }
            this.maxSnoozeSpinner.setValue(i);
            b = this.pauseOpts.getOptExtendSnoozeTime();
            if (b == null) {
                b = this.pauseOpts.getDefExtendSnoozeTime();
            }
            this.allowSnoozeBox.setSelected(b);
        }

        public void setObject(PauseOptions pauseOpts) {
            this.pauseOpts = pauseOpts;
            this.updatePanel();
            this.enableAppropriate();
        }

        public PauseOptions getObject() {
            return this.pauseOpts;
        }
    }

    private class AddScanTypeDialog
    extends AvDialogBase {
        private static final long serialVersionUID = 1L;
        private JPanel contentPane;
        private JRadioButton newScanButton;
        private JRadioButton templateButton;
        private JTable templateTable;
        private SortableTableModel templateModel;
        private Vector<ConfigObject> newScans;

        public AddScanTypeDialog(String title) {
            super(title, true, true);
            this.newScans = new Vector();
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_policies_dialog_av_ads_scans_add_scan";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean ok() {
            this.setVisible(false);
            if (this.newScanButton.isSelected()) {
                Vector<TableRow> datavect = AdminDefinedScanPane.this.model.getDataVector();
                Vector<String> allScanNames = new Vector<String>();
                AdminDefinedScan tempScan = null;
                for (int i = 0; i < datavect.size(); ++i) {
                    tempScan = ((AdminScanTableObject)datavect.get(i)).getAdminScan();
                    allScanNames.add(tempScan.getName());
                }
                AdminScanDialog asd = new AdminScanDialog(this.getRes("label.adminScanDialogNewTitle"), true, AdminDefinedScanPane.this.getScanPoolObj(), allScanNames, false, false, 1);
                AdminDefinedScan defaultScan = null;
                try {
                    defaultScan = PolicyHandler.getDefaultAdminDefinedScan();
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    defaultScan = new AdminDefinedScan();
                }
                defaultScan.setOptDescription(null);
                boolean usedNumber = false;
                Object newName = AdminDefinedScanPane.this.getNewScanName();
                if (AdminDefinedScanPane.this.newLastNumber >= 1) {
                    newName = (String)newName + " " + (AdminDefinedScanPane.this.newLastNumber + 1);
                    usedNumber = true;
                } else {
                    AdminDefinedScanPane.this.newLastNumber = 1;
                }
                defaultScan.setName((String)newName);
                defaultScan.setOptDisplayName(null);
                try {
                    asd.setObject(defaultScan);
                }
                catch (ConsoleException e) {
                    LoggerUtilities.logException((Throwable)e);
                }
                asd.setVisible(true);
                if (!asd.isOk()) return true;
                AdminDefinedScan ads = asd.getObject();
                ads.setId(GUIDGenerator.getInstance().getGUIDString());
                this.newScans.add((ConfigObject)ads);
                if (usedNumber) {
                    if (((String)newName).equals(ads.getName())) {
                        ++AdminDefinedScanPane.this.newLastNumber;
                    }
                    if (AdminDefinedScanPane.this.newLastNumber < 2) {
                        AdminDefinedScanPane.this.newLastNumber = 1;
                    }
                }
                if (asd.getSaveAsTemplate()) {
                    try {
                        AdminDefinedScanPane.this.saveCopyAsTemplate(ads);
                    }
                    catch (ConsoleException ce) {
                        LoggerUtilities.logException((Throwable)ce);
                    }
                }
            } else {
                for (int i = 0; i < this.templateModel.getRowCount(); ++i) {
                    TemplateTableObject tto = (TemplateTableObject)this.templateModel.getRow(i);
                    if (!tto.getSelected()) continue;
                    ObjInfoObject oio = tto.getInfoObject();
                    AdminDefinedScanObject adso = (AdminDefinedScanObject)PolicyHelper.getPolicyObject(oio);
                    try {
                        AdminDefinedScan ads = (AdminDefinedScan)adso.getCopyOfPolicyObject();
                        Object newName = ads.getOptDisplayName() == null ? ads.getName() : ads.getOptDisplayName();
                        ads.setId(GUIDGenerator.getInstance().getGUIDString());
                        int testLastNumber = 0;
                        for (int index = 0; index < AdminDefinedScanPane.this.model.getRowCount(); ++index) {
                            String testName;
                            AdminScanTableObject asto = (AdminScanTableObject)AdminDefinedScanPane.this.model.getRow(index);
                            String string = testName = asto.getAdminScan().getOptDisplayName() == null ? asto.getAdminScan().getName() : asto.getAdminScan().getOptDisplayName();
                            if (!testName.startsWith((String)newName)) continue;
                            if (testName.length() == ((String)newName).length()) {
                                testLastNumber = Math.max(1, testLastNumber);
                            }
                            String prepend = testName.substring(((String)newName).length()).trim();
                            try {
                                if (prepend.length() <= 0) continue;
                                int number = Integer.parseInt(prepend);
                                testLastNumber = Math.max(number, testLastNumber);
                                continue;
                            }
                            catch (NumberFormatException e) {
                                LoggerUtilities.logException((Throwable)e);
                            }
                        }
                        if (testLastNumber >= 1) {
                            newName = (String)newName + " " + (testLastNumber + 1);
                            ads.setName((String)newName);
                            ads.setOptDisplayName(null);
                        }
                        this.newScans.add((ConfigObject)ads);
                        continue;
                    }
                    catch (ConsoleException ce) {
                        LoggerUtilities.logException((Throwable)ce);
                    }
                }
            }
            this.isOk = true;
            return true;
        }

        @Override
        protected JPanel getContentPanel() {
            if (this.contentPane == null) {
                this.contentPane = new JPanel(new VerticalFlowLayout());
                this.setupComponents();
                this.contentPane.add(this.getAddScanPane());
            }
            return this.contentPane;
        }

        private Vector<TopLevelObject> getConfigObjsFromObjInfo(Vector<ObjInfoObject> objInfos) {
            Vector<TopLevelObject> result = new Vector<TopLevelObject>();
            for (ObjInfoObject oio : objInfos) {
                AdminDefinedScanObject adso = (AdminDefinedScanObject)PolicyHelper.getPolicyObject(oio);
                result.add(adso.getSchemaObj());
            }
            return result;
        }

        private void enableAppropriate() {
            this.templateButton.setEnabled(this.templateTable.getRowCount() > 0);
            this.templateTable.setEnabled(this.templateButton.isSelected());
            if (!this.templateButton.isSelected()) {
                this.templateTable.clearSelection();
            }
        }

        private void setupTable() {
            String[] colNames = new String[]{this.getRes("table.column.head.copy"), this.getRes("table.column.head.templateName"), this.getRes("table.column.head.lastUpdate")};
            this.templateModel = new SortableTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == 0;
                }
            };
            this.templateModel.setColumnNames(colNames);
            this.templateTable = new StripesTable(this.templateModel, false, false);
            this.templateTable.putClientProperty("dynamicEventsEnabled", true);
            this.templateModel.addMouseListenerToHeaderInTable(this.templateTable);
            this.templateTable.getSelectionModel().setSelectionMode(0);
            this.templateTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        TemplateTableObject tto;
                        int column = AddScanTypeDialog.this.templateTable.getSelectedColumn();
                        if (column == 0) {
                            return;
                        }
                        int row = AddScanTypeDialog.this.templateTable.getSelectedRow();
                        if (row == -1) {
                            return;
                        }
                        tto.setSelected(!(tto = (TemplateTableObject)AddScanTypeDialog.this.templateModel.getRow(row)).getSelected());
                        AddScanTypeDialog.this.templateModel.fireTableCellUpdated(row, 0);
                    }
                }
            });
            UIUtilities.setTableColumnWidth(this.templateTable, new float[]{0.1f, 0.5f, 0.4f}, (int)this.templateTable.getPreferredScrollableViewportSize().getWidth());
            this.templateTable.setPreferredScrollableViewportSize(new Dimension(500, 150));
            TableColumn column = this.templateTable.getColumnModel().getColumn(0);
            column.setCellRenderer(new CheckBoxRenderer(true));
            column.setCellEditor(new CheckBoxEditor(this.templateTable){
                private static final long serialVersionUID = 1L;

                @Override
                protected void updateModel(TableModel tableModel, int selIndex) {
                }
            });
        }

        private void setupComponents() {
            this.setupTable();
            this.newScanButton = new JRadioButton(this.getRes("rbutton.newscan"));
            this.newScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AddScanTypeDialog.this.newScanButton.setFocusPainted(true);
                    AddScanTypeDialog.this.enableAppropriate();
                }
            });
            this.templateButton = new JRadioButton(this.getRes("rbutton.template"));
            this.templateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AddScanTypeDialog.this.enableAppropriate();
                }
            });
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.newScanButton);
            bg.add(this.templateButton);
            this.newScanButton.setSelected(true);
            this.enableAppropriate();
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.adminscan.avscan", "AddScanTypeDialog." + key);
        }

        private JPanel getAddScanPane() {
            AvTemplatePane result = new AvTemplatePane(this.getRes("label.scanTypeTitle"), this.getRes("label.scanTypeDesc"));
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)this.newScanButton, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 1;
            p.add((Component)this.templateButton, c);
            c.insets = new Insets(5, 25, 0, 0);
            c.gridx = 0;
            c.gridy = 2;
            p.add((Component)new JLabel(this.getRes("label.templateDesc")), c);
            c.insets = new Insets(5, 20, 0, 0);
            c.gridx = 0;
            c.gridy = 3;
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)this.templateTable);
            p.add((Component)scrollPane, c);
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)p, "Before");
            result.add(temp);
            result.addHierarchyListener(new HierarchyListenerImpl());
            return result;
        }

        public Vector<ConfigObject> getObject() {
            return this.newScans;
        }

        public void setPoolObj(final AdminDefinedScanPoolObject poolObj) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    final Vector<ObjInfoObject> data = new Vector<ObjInfoObject>(Arrays.asList(poolObj.getInfoObjectList()));
                    final Vector<TopLevelObject> configObjs = AddScanTypeDialog.this.getConfigObjsFromObjInfo(data);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Vector<TableRow> tableRows = new Vector<TableRow>();
                            for (int i = 0; i < data.size(); ++i) {
                                TemplateTableObject tto = new TemplateTableObject((ObjInfoObject)data.get(i), (ConfigObject)configObjs.get(i));
                                tableRows.add(tto);
                            }
                            AddScanTypeDialog.this.templateModel.setDataVector(tableRows);
                            AddScanTypeDialog.this.templateModel.fireTableDataChanged();
                            AddScanTypeDialog.this.enableAppropriate();
                        }
                    });
                }
            };
            t.start();
        }

        private class TemplateTableObject
        implements TableRow {
            private ObjInfoObject oio;
            private ConfigObject co;
            private boolean selected = false;

            public TemplateTableObject(ObjInfoObject oio, ConfigObject co) {
                this.oio = oio;
                this.co = co;
            }

            public ObjInfoObject getInfoObject() {
                return this.oio;
            }

            @Override
            public Object getValueAt(int index) {
                switch (index) {
                    case 0: {
                        return this.selected;
                    }
                    case 1: {
                        AdminDefinedScanObject adso = (AdminDefinedScanObject)PolicyHelper.getPolicyObject(this.oio);
                        try {
                            AdminDefinedScan ads = (AdminDefinedScan)adso.getCopyOfPolicyObject();
                            return ads.getOptDisplayName() == null ? ads.getName() : ads.getOptDisplayName();
                        }
                        catch (ConsoleException e) {
                            LoggerUtilities.logException((Throwable)e);
                            return "";
                        }
                    }
                    case 2: {
                        DateFormat df = DateFormat.getDateInstance(1);
                        df.setTimeZone(Utility.getLocalTimeZone());
                        return df.format(new Date(this.co.getT()));
                    }
                }
                return "";
            }

            @Override
            public Class<?> getValueTypeAt(int index) {
                switch (index) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Date.class;
                    }
                }
                return String.class;
            }

            public boolean getSelected() {
                return this.selected;
            }

            public void setSelected(boolean b) {
                this.selected = b;
            }

            @Override
            public void setValueAt(Object value, int index) {
                if (index == 0) {
                    this.selected = (Boolean)value;
                }
            }
        }
    }

    private class AdminScanTableObject
    implements TableRow {
        private AdminDefinedScan scan;

        public AdminScanTableObject(AdminDefinedScan scan) {
            this.scan = scan;
        }

        private String getScanSchedule() {
            Object[] arr;
            String monthDay;
            ScanSchedule ss = this.scan.getOptScanSchedule();
            if (ss == null) {
                return AdminDefinedScanPane.this.getRes("label.na");
            }
            Schedule schedule = ss.getSchedule();
            if (schedule == null) {
                return AdminDefinedScanPane.this.getRes("label.na");
            }
            String hourMinute = AdminDefinedScanPane.this.getRes("label.na");
            String dayHour = schedule.getOptStartHour();
            if (dayHour != null) {
                Calendar calendar = Utility.getCalendarInstance();
                TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
                calendar.setTimeZone(gmtTimeZone);
                calendar.set(11, Integer.parseInt(dayHour));
                Integer minutes = schedule.getOptStartMinute();
                if (minutes != null) {
                    calendar.set(12, minutes);
                }
                SimpleDateFormat formater = new SimpleDateFormat(MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern"));
                formater.setTimeZone(gmtTimeZone);
                hourMinute = formater.format(calendar.getTime());
            }
            if ((monthDay = schedule.getOptStartDayOfMonth()) != null) {
                Object[] arr2 = new Object[]{monthDay.indexOf(44) == -1 ? monthDay : AdminDefinedScanPane.this.getRes("label.na"), hourMinute};
                return MessageFormat.format(AdminDefinedScanPane.this.getRes("label.monthlySchedStr"), arr2);
            }
            String weekDay = schedule.getOptStartDayOfWeek();
            if (weekDay != null) {
                arr = new Object[]{weekDay.indexOf(44) == -1 ? AdminScanDialog.DAYS_OF_WEEK[Integer.parseInt(weekDay)] : AdminDefinedScanPane.this.getRes("label.na"), hourMinute};
                return MessageFormat.format(AdminDefinedScanPane.this.getRes("label.weeklySchedStr"), arr);
            }
            arr = new Object[]{hourMinute};
            return MessageFormat.format(AdminDefinedScanPane.this.getRes("label.dailySchedStr"), arr);
        }

        public AdminDefinedScan getAdminScan() {
            return this.scan;
        }

        @Override
        public Object getValueAt(int index) {
            switch (index) {
                case 0: {
                    return this.scan.getOptDisplayName() == null ? this.scan.getName() : this.scan.getOptDisplayName();
                }
                case 1: {
                    if (this.scan.getOptScanSchedule() != null) {
                        if (this.scan.getOptScanSchedule().getOptEnable() != null) {
                            return this.scan.getOptScanSchedule().getOptEnable();
                        }
                        return this.scan.getOptScanSchedule().getDefEnable();
                    }
                    return Boolean.FALSE;
                }
                case 2: {
                    return this.getScanSchedule();
                }
                case 3: {
                    return this.scan.getOptDescription();
                }
            }
            return AdminDefinedScanPane.this.getRes("label.na");
        }

        @Override
        public Class<?> getValueTypeAt(int index) {
            switch (index) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int index) {
            switch (index) {
                case 1: {
                    if (value == null || !(value instanceof Boolean) || this.scan.getOptScanSchedule() == null) break;
                    this.scan.getOptScanSchedule().setOptEnable((Boolean)value);
                    AdminDefinedScanPane.this.avObj.getChangedObjSet().put(this.scan.getId(), (TopLevelObject)this.scan);
                    break;
                }
            }
        }
    }
}

