/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.av;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AvAutoProtect;
import com.sygate.scm.common.configobject.schema.AvFileAp;
import com.sygate.scm.common.configobject.schema.AvGeneral;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.AvQuarantine;
import com.sygate.scm.common.configobject.schema.AvScanPolicy;
import com.sygate.scm.common.configobject.schema.AvSubmission;
import com.sygate.scm.common.configobject.schema.DownloadAdvisorOptions;
import com.sygate.scm.common.configobject.schema.ElamDriverOptions;
import com.sygate.scm.common.configobject.schema.GeneralInfo;
import com.sygate.scm.common.configobject.schema.HppPolicy;
import com.sygate.scm.common.configobject.schema.LinuxAvAutoProtect;
import com.sygate.scm.common.configobject.schema.LinuxAvScanPolicy;
import com.sygate.scm.common.configobject.schema.LogHandling;
import com.sygate.scm.common.configobject.schema.LotusNotesAp;
import com.sygate.scm.common.configobject.schema.MacAvAutoProtect;
import com.sygate.scm.common.configobject.schema.MacAvGeneral;
import com.sygate.scm.common.configobject.schema.MacAvScanPolicy;
import com.sygate.scm.common.configobject.schema.MacHppPolicy;
import com.sygate.scm.common.configobject.schema.MsftExchangeAp;
import com.sygate.scm.common.configobject.schema.WebMailAp;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.av.AvPolicyTabPanel;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminDefinedScanPane;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.LinuxAdminDefinedScanPane;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.MacAdminDefinedScanPane;
import com.sygate.scm.console.ui.policy.av.ap.ApExchangePane;
import com.sygate.scm.console.ui.policy.av.ap.ApFilePane;
import com.sygate.scm.console.ui.policy.av.ap.ApLotusNotesPane;
import com.sygate.scm.console.ui.policy.av.ap.ApWebMailPane;
import com.sygate.scm.console.ui.policy.av.ap.DownloadProtectionPane;
import com.sygate.scm.console.ui.policy.av.ap.MacApFilePane;
import com.sygate.scm.console.ui.policy.av.ap.MacGeneralScanDetailsPane;
import com.sygate.scm.console.ui.policy.av.ap.interop.AutoProtectStateManager;
import com.sygate.scm.console.ui.policy.av.general.GeneralTabPane;
import com.sygate.scm.console.ui.policy.av.general.LinuxGlobalPanel;
import com.sygate.scm.console.ui.policy.av.general.MacGeneralTabPane;
import com.sygate.scm.console.ui.policy.av.globalscan.ElamDriverOptionsPanel;
import com.sygate.scm.console.ui.policy.av.globalscan.GlobalScanOptionsPanel;
import com.sygate.scm.console.ui.policy.av.hpp.HppTabPane;
import com.sygate.scm.console.ui.policy.av.logicobject.ApFileScanDetailsObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.GeneralInfoObject;
import com.sygate.scm.console.ui.policy.av.quarantine.QuarantineInfoPane;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AvPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 1L;
    private GeneralTabPane generalPanel;
    private GeneralTabPane linuxGeneralPanel;
    private MacGeneralTabPane macGeneralPanel;
    private ApFilePane apFilePanel;
    private MacApFilePane macApFilePanel;
    private ApFilePane linuxApFilePanel;
    private LinuxGlobalPanel linuxGlobalPanel;
    private ApWebMailPane apWebMailPanel;
    private ApExchangePane apExchangePanel;
    private ApLotusNotesPane apNotesPanel;
    private AdminDefinedScanPane adminDefinedScanPanel;
    private LinuxAdminDefinedScanPane adminDefinedScanLinuxPanel;
    private MacAdminDefinedScanPane adminDefinedScanMacPanel;
    private MacGeneralScanDetailsPane macGeneralScanDetailsPane;
    private QuarantineInfoPane quarantinePanel;
    private ElamDriverOptionsPanel elamDriverOptionsPanel;
    private GlobalScanOptionsPanel globalScanOptionsPanel;
    private HppTabPane heuristicScanPanel;
    private DownloadProtectionPane apDownloadProtectionPanel;
    private AvPolicy avPolicy;
    private AvAutoProtect avAp;
    private AvGeneral avGeneral;
    private AvGeneral linuxAvGeneral;
    private AvFileAp avFileAp;
    private WebMailAp webMailAp;
    private HppPolicy hppPolicy;
    private AvQuarantine avQuarantine;
    private AvSubmission avQuarantineSubmission;
    private AvScanPolicy scanPolicy;
    private MacAvScanPolicy macScanPolicy;
    private LinuxAvScanPolicy linuxScanPolicy;
    private MacAvGeneral macAvGeneral;
    private ElamDriverOptions elamDriverOptions;
    private MacAvAutoProtect macAvAp;
    private MacHppPolicy macHpp;
    private AvFileAp macAvFileAp;
    private LinuxAvAutoProtect linuxAvAp;
    private AvFileAp linuxAvFileAp;
    private MsftExchangeAp msftExchangeAp;
    private LotusNotesAp lotusNotesAp;
    private Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
    private DownloadAdvisorOptions downloadAdvisorOptions;
    private AvPolicyObject avObj;
    private AutoProtectStateManager apStateManager;

    public AvPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(134, name, gpObj, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.title"), false, isLocal);
        this.init();
    }

    public AvPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public AvPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(134, pool, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.title"), isCheckPolicyEnforcement, false);
        this.init();
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        AvPolicy policy = this.createAvPolicy();
        this.avObj = new AvPolicyObject((TopLevelObject)policy);
        List<String> nameList = pool.getAllName();
        if (this.avObj.getName() != null && (newName = PolicyHandler.adjustName(this.avObj.getName(), nameList, 255)) != null) {
            this.avObj.setName(newName);
        }
        this.avObj.addNewObj((TopLevelObject)policy);
        this.avObj.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.avPolicy = policy;
        this.setValues();
        return this.avObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        AvPolicy policy = (AvPolicy)schema;
        this.avObj = new AvPolicyObject((TopLevelObject)policy);
        this.avPolicy = policy;
        this.setValues();
        return this.avObj;
    }

    @Override
    protected void commit() {
        block2: {
            try {
                this.avPolicy.setName(this.getOverviewPanel().getPolicyName());
                this.avPolicy.setOptDescription(this.getOverviewPanel().getPolicyDesc());
                this.getGeneralPanel().save();
                this.getLinuxGeneralPanel().save();
                this.getApFilePanel().save();
                this.getApWebMailPanel().save();
                this.getApExchangePanel().save();
                this.getApNotesPanel().save();
                this.getQuarantinePanel().save();
                this.getDownloadProtectionPanel().saveObject();
                this.avPolicy.setOptAvGeneral(this.avGeneral);
                this.avPolicy.getOptLinuxAvGeneral().setAvGeneral(this.linuxAvGeneral);
                this.avAp.setOptAvFileAp(this.avFileAp);
                this.avAp.setOptWebMailAp(this.webMailAp);
                this.avAp.setOptMsftExchangeAp(this.msftExchangeAp);
                this.avAp.setOptLotusNotesAp(this.lotusNotesAp);
                this.avPolicy.setOptAvQuarantine(this.avQuarantine);
                this.avPolicy.setOptAvSubmission(this.avQuarantineSubmission);
                this.avPolicy.setOptAvAutoProtect(this.avAp);
                this.getMacApFilePanel().save();
                this.getMacGeneralScanDetailsPanel().save();
                this.macAvAp.setOptAvFileAp(this.macAvFileAp);
                this.avPolicy.setOptMacAvScanPolicy(this.macScanPolicy);
                this.avPolicy.setOptMacHppPolicy(this.macHpp);
                this.getLinuxApFilePanel().save();
                this.linuxAvAp.setOptAvFileAp(this.linuxAvFileAp);
                this.avPolicy.setOptLinuxAvScanPolicy(this.linuxScanPolicy);
                this.getElamDriverOptionsPanel().save();
                this.getMacGeneralPanel().save();
                this.avPolicy.setOptMacAvGeneral(this.macAvGeneral);
                this.getHppPanel().saveObject();
                this.avPolicy.setOptHppPolicy(this.hppPolicy);
                this.getAdminDefinedScanPanel().saveObject();
                this.avPolicy.setOptAvScanPolicy(this.scanPolicy);
                this.globalScanOptionsPanel.save();
                this.getAdminDefinedScanMacPanel().saveObject();
                this.avPolicy.setOptMacAvScanPolicy(this.macScanPolicy);
                this.getLinuxGlobalPanel().save();
                this.getAdminDefinedScanLinuxPanel().saveObject();
                this.avPolicy.setOptLinuxAvScanPolicy(this.linuxScanPolicy);
                PolicyHandler.clearAllObjectPool();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    @Override
    protected void cancel() {
        PolicyHandler.clearAllObjectPool();
        super.cancel();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.apStateManager.removeAllHandlers();
    }

    @Override
    protected boolean isValidate() {
        return this.isOverviewPanelValidate() && this.isWindowsPanelsValidate() && this.isMacPanelsValidate() && this.isLinuxPanelsValidate();
    }

    private boolean isLinuxPanelsValidate() {
        if (!this.getLinuxApFilePanel().valuesValid()) {
            return false;
        }
        if (!this.getAdminDefinedScanLinuxPanel().valuesValid()) {
            return false;
        }
        return this.getLinuxGeneralPanel().valuesValid();
    }

    private boolean isMacPanelsValidate() {
        if (!this.getMacApFilePanel().valuesValid()) {
            return false;
        }
        if (!this.getAdminDefinedScanMacPanel().valuesValid()) {
            return false;
        }
        return this.getMacGeneralScanDetailsPanel().valuesValid();
    }

    private boolean isWindowsPanelsValidate() {
        if (!this.getApFilePanel().valuesValid()) {
            return false;
        }
        if (!this.getApExchangePanel().valuesValid()) {
            return false;
        }
        if (!this.getApWebMailPanel().valuesValid()) {
            return false;
        }
        if (!this.getApNotesPanel().valuesValid()) {
            return false;
        }
        if (!this.getAdminDefinedScanPanel().valuesValid()) {
            return false;
        }
        if (!this.getQuarantinePanel().valuesValid()) {
            return false;
        }
        if (!this.getApWebMailPanel().valuesValid()) {
            return false;
        }
        if (!this.getGeneralPanel().valuesValid()) {
            return false;
        }
        if (!this.getDownloadProtectionPanel().valuesValid()) {
            return false;
        }
        if (!this.heuristicScanPanel.valuesValid()) {
            return false;
        }
        return this.getElamDriverOptionsPanel().valuesValid();
    }

    private boolean isOverviewPanelValidate() {
        return this.isValidName((TopLevelObject)this.avPolicy, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.nameIsARequirementFiled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.theNameHasBeenUsed"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.invalidName"));
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getAdminDefinedScanPanel(), this.getAdminDefinedScanLinuxPanel(), this.getAdminDefinedScanMacPanel(), this.getGeneralPanel(), this.getLinuxGeneralPanel(), this.getMacGeneralPanel(), this.getApFilePanel(), this.getMacApFilePanel(), this.getLinuxApFilePanel(), this.getApWebMailPanel(), this.getApExchangePanel(), this.getApNotesPanel(), this.getHppPanel(), this.getQuarantinePanel(), this.getDownloadProtectionPanel(), this.getGlobalScanOptionsPanel(), this.getElamDriverOptionsPanel(), this.getMacGeneralScanDetailsPanel(), this.getLinuxGeneralPanel()};
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        AvPolicyTabPanel buttonPanel = new AvPolicyTabPanel(this, "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.AntiVirusPolicy") + "</html>", "av_policy_32.png");
        return buttonPanel;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        this.apStateManager = new AutoProtectStateManager();
        mainPanel.add((Component)this.getAdminDefinedScanPanel(), "Windows Administrator-Defined Scans");
        mainPanel.add((Component)this.getApFilePanel(), "Windows FilesAndProcesses Scans");
        mainPanel.add((Component)this.getDownloadProtectionPanel(), "Download Protection");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getHppPanel()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.HeuristicProcessProtection"));
        mainPanel.add((Component)this.getElamDriverOptionsPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.ElamDriverOptions"));
        mainPanel.add((Component)this.getApWebMailPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.InternetEmail"));
        mainPanel.add((Component)this.getApExchangePanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.MicrosoftExchange"));
        mainPanel.add((Component)this.getApNotesPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.LotusNotes"));
        mainPanel.add((Component)this.getGlobalScanOptionsPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.GlobalScanOptions"));
        mainPanel.add((Component)this.getQuarantinePanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Quarantine"));
        mainPanel.add((Component)this.getGeneralPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.General"));
        mainPanel.add((Component)this.getAdminDefinedScanMacPanel(), "Macintosh Administrator-Defined Scans");
        mainPanel.add((Component)this.getMacApFilePanel(), "Macintosh FilesAndProcesses Scans");
        mainPanel.add((Component)this.getMacGeneralScanDetailsPanel(), "Macintosh Global Scan Options");
        mainPanel.add((Component)this.getMacGeneralPanel(), "Macintosh Miscellaneous");
        mainPanel.add((Component)this.getAdminDefinedScanLinuxPanel(), "Linux Administrator-Defined Scans");
        mainPanel.add((Component)this.getLinuxApFilePanel(), "Linux FilesAndProcesses Scans");
        mainPanel.add((Component)this.getLinuxGlobalPanel(), "Linux Global");
        mainPanel.add((Component)this.getLinuxGeneralPanel(), "Linux Miscellaneous");
    }

    protected GeneralTabPane getGeneralPanel() {
        if (this.generalPanel == null) {
            this.generalPanel = new GeneralTabPane(1);
        }
        return this.generalPanel;
    }

    protected GeneralTabPane getLinuxGeneralPanel() {
        if (this.linuxGeneralPanel == null) {
            this.linuxGeneralPanel = new GeneralTabPane(3);
        }
        return this.linuxGeneralPanel;
    }

    protected MacGeneralTabPane getMacGeneralPanel() {
        if (this.macGeneralPanel == null) {
            this.macGeneralPanel = new MacGeneralTabPane();
        }
        return this.macGeneralPanel;
    }

    protected ApFilePane getApFilePanel() {
        if (this.apFilePanel == null) {
            this.apFilePanel = new ApFilePane(this.apStateManager, 1);
        }
        return this.apFilePanel;
    }

    protected ApFilePane getLinuxApFilePanel() {
        if (this.linuxApFilePanel == null) {
            this.linuxApFilePanel = new ApFilePane(this.apStateManager, 3);
        }
        return this.linuxApFilePanel;
    }

    protected LinuxGlobalPanel getLinuxGlobalPanel() {
        if (this.linuxGlobalPanel == null) {
            this.linuxGlobalPanel = new LinuxGlobalPanel();
        }
        return this.linuxGlobalPanel;
    }

    protected DownloadProtectionPane getDownloadProtectionPanel() {
        if (this.apDownloadProtectionPanel == null) {
            this.apDownloadProtectionPanel = new DownloadProtectionPane(this.apStateManager);
        }
        return this.apDownloadProtectionPanel;
    }

    protected MacApFilePane getMacApFilePanel() {
        if (this.macApFilePanel == null) {
            this.macApFilePanel = new MacApFilePane();
        }
        return this.macApFilePanel;
    }

    protected ApExchangePane getApExchangePanel() {
        if (this.apExchangePanel == null) {
            this.apExchangePanel = new ApExchangePane();
        }
        return this.apExchangePanel;
    }

    protected ApLotusNotesPane getApNotesPanel() {
        if (this.apNotesPanel == null) {
            this.apNotesPanel = new ApLotusNotesPane();
        }
        return this.apNotesPanel;
    }

    protected ApWebMailPane getApWebMailPanel() {
        if (this.apWebMailPanel == null) {
            this.apWebMailPanel = new ApWebMailPane();
        }
        return this.apWebMailPanel;
    }

    public AdminDefinedScanPane getAdminDefinedScanPanel() {
        if (this.adminDefinedScanPanel == null) {
            this.adminDefinedScanPanel = new AdminDefinedScanPane();
        }
        return this.adminDefinedScanPanel;
    }

    public LinuxAdminDefinedScanPane getAdminDefinedScanLinuxPanel() {
        if (this.adminDefinedScanLinuxPanel == null) {
            this.adminDefinedScanLinuxPanel = new LinuxAdminDefinedScanPane();
        }
        return this.adminDefinedScanLinuxPanel;
    }

    public MacAdminDefinedScanPane getAdminDefinedScanMacPanel() {
        if (this.adminDefinedScanMacPanel == null) {
            this.adminDefinedScanMacPanel = new MacAdminDefinedScanPane();
        }
        return this.adminDefinedScanMacPanel;
    }

    public QuarantineInfoPane getQuarantinePanel() {
        if (this.quarantinePanel == null) {
            this.quarantinePanel = new QuarantineInfoPane();
        }
        return this.quarantinePanel;
    }

    public GlobalScanOptionsPanel getGlobalScanOptionsPanel() {
        if (this.globalScanOptionsPanel == null) {
            this.globalScanOptionsPanel = new GlobalScanOptionsPanel();
        }
        return this.globalScanOptionsPanel;
    }

    public MacGeneralScanDetailsPane getMacGeneralScanDetailsPanel() {
        if (this.macGeneralScanDetailsPane == null) {
            this.macGeneralScanDetailsPane = new MacGeneralScanDetailsPane();
        }
        return this.macGeneralScanDetailsPane;
    }

    public ElamDriverOptionsPanel getElamDriverOptionsPanel() {
        if (this.elamDriverOptionsPanel == null) {
            this.elamDriverOptionsPanel = new ElamDriverOptionsPanel();
        }
        return this.elamDriverOptionsPanel;
    }

    public HppTabPane getHppPanel() {
        if (this.heuristicScanPanel == null) {
            this.heuristicScanPanel = new HppTabPane();
        }
        return this.heuristicScanPanel;
    }

    @Override
    public boolean isNewPolicy() {
        return super.isNewPolicy();
    }

    private AvPolicy createAvPolicy() {
        try {
            if (this.avPolicy == null) {
                this.avPolicy = PolicyHandler.getDefaultAvPolicy(this.newObjList);
            }
            if (this.avPolicy == null) {
                this.avPolicy = new AvPolicy();
                String GUIDString = new GUIDGenerator().getGUIDString();
                this.avPolicy.setId(GUIDString);
                MetadataAttributes mAttr = new MetadataAttributes();
                this.avPolicy.setMetadataAttributes(mAttr);
                this.avPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return this.avPolicy;
    }

    private void init() {
    }

    private void setValues() {
        block22: {
            try {
                this.getOverviewPanel().setObject(new AvPolicyObject((TopLevelObject)this.avPolicy));
                this.avGeneral = this.avPolicy.getOptAvGeneral();
                if (this.avGeneral == null) {
                    this.avGeneral = new AvGeneral();
                    GeneralInfo generalInfo = new GeneralInfo();
                    generalInfo.setDisableSecurityCenter(GeneralInfo.NEVER);
                    generalInfo.setSecurityCenterAvAlert(GeneralInfo.NO_ACTION);
                    LogHandling logHandling = new LogHandling();
                    this.avGeneral.setGeneralInfo(generalInfo);
                    this.avGeneral.setLogHandling(logHandling);
                }
                this.getGeneralPanel().setPolicyIsNonShared(this.isPolicyNonShared());
                this.getGeneralPanel().setGeneralObject(this.avGeneral);
                this.linuxAvGeneral = this.avPolicy.getOptLinuxAvGeneral().getAvGeneral();
                this.getLinuxGeneralPanel().setPolicyIsNonShared(this.isPolicyNonShared());
                this.getLinuxGeneralPanel().setGeneralObject(this.linuxAvGeneral);
                this.macAvGeneral = this.avPolicy.getOptMacAvGeneral();
                if (this.macAvGeneral == null) {
                    this.macAvGeneral = new MacAvGeneral();
                }
                this.getMacGeneralPanel().setGeneralObject(this.macAvGeneral);
                this.avAp = this.avPolicy.getOptAvAutoProtect();
                if (this.avAp == null) {
                    this.avAp = new AvAutoProtect();
                }
                this.avFileAp = this.avAp.getOptAvFileAp();
                if (this.avFileAp == null) {
                    this.avFileAp = new AvFileAp();
                }
                this.getApFilePanel().setFileApObject(this.avFileAp);
                this.downloadAdvisorOptions = this.avAp.getOptAvFileAp().getOptDownloadAdvisorOptions();
                if (this.downloadAdvisorOptions == null) {
                    this.downloadAdvisorOptions = new DownloadAdvisorOptions();
                    this.avFileAp.setOptDownloadAdvisorOptions(this.downloadAdvisorOptions);
                }
                ApFileScanDetailsObject apScanDetailsObj = this.getApFilePanel().getApFileScanDetailsObject();
                this.getDownloadProtectionPanel().setObject(this.downloadAdvisorOptions, apScanDetailsObj, this.avFileAp.getOptApActions());
                this.linuxAvAp = this.avPolicy.getOptLinuxAvAutoProtect();
                if (this.linuxAvAp == null) {
                    this.linuxAvAp = new LinuxAvAutoProtect();
                    this.avPolicy.setOptLinuxAvAutoProtect(this.linuxAvAp);
                }
                this.linuxAvFileAp = this.linuxAvAp.getOptAvFileAp();
                if (this.linuxAvFileAp == null) {
                    this.linuxAvFileAp = new AvFileAp();
                }
                this.getLinuxApFilePanel().setFileApObject(this.linuxAvFileAp);
                this.macAvAp = this.avPolicy.getOptMacAvAutoProtect();
                if (this.macAvAp == null) {
                    this.macAvAp = new MacAvAutoProtect();
                }
                this.avPolicy.setOptMacAvAutoProtect(this.macAvAp);
                this.macAvFileAp = this.macAvAp.getOptAvFileAp();
                if (this.macAvFileAp == null) {
                    this.macAvFileAp = new AvFileAp();
                }
                this.macHpp = this.avPolicy.getOptMacHppPolicy();
                if (this.macHpp == null) {
                    this.macHpp = new MacHppPolicy();
                }
                this.getMacApFilePanel().setFileApObject(this.macAvFileAp, this.macHpp);
                this.getMacGeneralScanDetailsPanel().setObject(this.macAvFileAp.getOptApScanOptions(), true);
                this.webMailAp = this.avAp.getOptWebMailAp();
                if (this.webMailAp == null) {
                    this.webMailAp = new WebMailAp();
                }
                this.getApWebMailPanel().setMailApObject(this.webMailAp);
                this.msftExchangeAp = this.avAp.getOptMsftExchangeAp();
                if (this.msftExchangeAp == null) {
                    this.msftExchangeAp = new MsftExchangeAp();
                }
                this.getApExchangePanel().setMailApObject(this.msftExchangeAp);
                this.lotusNotesAp = this.avAp.getOptLotusNotesAp();
                if (this.lotusNotesAp == null) {
                    this.lotusNotesAp = new LotusNotesAp();
                }
                this.getApNotesPanel().setMailApObject(this.lotusNotesAp);
                this.scanPolicy = this.avPolicy.getOptAvScanPolicy();
                if (this.scanPolicy == null) {
                    this.scanPolicy = new AvScanPolicy();
                }
                this.getAdminDefinedScanPanel().setObject(this.scanPolicy, this.avObj);
                this.macScanPolicy = this.avPolicy.getOptMacAvScanPolicy();
                if (this.macScanPolicy == null) {
                    this.macScanPolicy = new MacAvScanPolicy();
                }
                this.getAdminDefinedScanMacPanel().setObject(this.macScanPolicy, this.avObj);
                this.linuxScanPolicy = this.avPolicy.getOptLinuxAvScanPolicy();
                if (this.linuxScanPolicy == null) {
                    this.linuxScanPolicy = new LinuxAvScanPolicy();
                }
                this.getAdminDefinedScanLinuxPanel().setObject(this.linuxScanPolicy, this.avObj);
                this.getLinuxGlobalPanel().setObject(this.linuxScanPolicy);
                this.avQuarantine = this.avPolicy.getOptAvQuarantine();
                if (this.avQuarantine == null) {
                    this.avQuarantine = new AvQuarantine();
                }
                this.avQuarantineSubmission = this.avPolicy.getOptAvSubmission();
                if (this.avQuarantineSubmission == null) {
                    this.avQuarantineSubmission = new AvSubmission();
                }
                this.getQuarantinePanel().setQuarantineObject(this.avQuarantine);
                this.hppPolicy = this.avPolicy.getOptHppPolicy();
                if (this.hppPolicy == null) {
                    this.hppPolicy = this.getHppPolicy();
                }
                this.getHppPanel().setObject(this.hppPolicy);
                GeneralInfoObject generalInfoObj = new GeneralInfoObject(this.avGeneral.getGeneralInfo());
                this.getGlobalScanOptionsPanel().setObject(generalInfoObj, apScanDetailsObj, this.scanPolicy);
                this.elamDriverOptions = this.avPolicy.getOptElamDriverOptions();
                if (this.elamDriverOptions == null) {
                    this.elamDriverOptions = new ElamDriverOptions();
                    this.avPolicy.setOptElamDriverOptions(this.elamDriverOptions);
                }
                this.getElamDriverOptionsPanel().setObject(new AvPolicyObject((TopLevelObject)this.avPolicy));
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block22;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private HppPolicy getHppPolicy() {
        if (this.hppPolicy != null) {
            return this.hppPolicy;
        }
        this.hppPolicy = new HppPolicy();
        return this.hppPolicy;
    }
}

