/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive.logicobject;

import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptiveTableRow;
import java.util.Comparator;

public class AdaptiveTableRowComparator
implements Comparator<AdaptiveTableRow> {
    private final int column;
    private final boolean ascending;

    public AdaptiveTableRowComparator(int column, boolean ascending) {
        this.column = column;
        this.ascending = ascending;
    }

    @Override
    public int compare(AdaptiveTableRow row1, AdaptiveTableRow row2) {
        int result = this.compareAdaptiveTableRow(row1, row2);
        if (!this.ascending) {
            result = -result;
        }
        return result;
    }

    private int compareAdaptiveTableRow(AdaptiveTableRow o1, AdaptiveTableRow o2) {
        int result = 0;
        if (this.column < AdaptiveTableRow.ColumnIndex.values().length) {
            switch (AdaptiveTableRow.ColumnIndex.values()[this.column]) {
                case COL_NAME: {
                    result = String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
                    break;
                }
                case COL_MITRE: {
                    result = String.CASE_INSENSITIVE_ORDER.compare(o1.getMitreOriginal(), o2.getMitreOriginal());
                    break;
                }
                case COL_PREVALENCE: {
                    result = String.CASE_INSENSITIVE_ORDER.compare(o1.getPrevalence(), o2.getPrevalence());
                    if (result != 0 || o1.getPrevalencePercent() == null || o2.getPrevalencePercent() == null) break;
                    result = Integer.compare(o1.getPrevalencePercent(), o2.getPrevalencePercent());
                    break;
                }
                case COL_ACTION: {
                    result = String.CASE_INSENSITIVE_ORDER.compare(o1.getAction(), o2.getAction());
                    break;
                }
                case COL_EVENT_COUNT: {
                    result = Integer.compare(o1.getEventCount(), o2.getEventCount());
                    break;
                }
            }
        }
        return result;
    }
}

