/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive.logicobject;

import com.sygate.scm.console.logicobject.TableRow;

public class AdaptiveTableRow
implements TableRow {
    private String vid = "";
    private String name = "";
    private String[] mitre = null;
    private String[] mitreNames = null;
    private String mitreOriginal = "";
    private String prevalence = "";
    private String action = "";
    private boolean isDirty = false;
    private boolean isTuned = false;
    private int ruleIndex;
    private String actor = "";
    private String target = "";
    private Integer eventCount = 0;
    private Integer prevalencePercent;

    @Override
    public Object getValueAt(int index) {
        if (index < ColumnIndex.values().length) {
            switch (ColumnIndex.values()[index]) {
                case COL_NAME: {
                    return this.name;
                }
                case COL_MITRE: {
                    return this.mitre;
                }
                case COL_PREVALENCE: {
                    return this.prevalence;
                }
                case COL_ACTION: {
                    return this.action;
                }
                case COL_EVENT_COUNT: {
                    return this.eventCount;
                }
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        return index < ColumnIndex.values().length && ColumnIndex.values()[index] == ColumnIndex.COL_EVENT_COUNT ? Integer.class : String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (index < ColumnIndex.values().length && ColumnIndex.values()[index] == ColumnIndex.COL_ACTION && value instanceof String && this.action != value) {
            this.setAction((String)value);
            this.isDirty = true;
            this.isTuned = false;
        }
    }

    public static boolean isCellEditable(int index, boolean readOnly) {
        return index == ColumnIndex.COL_MITRE.ordinal() || index == ColumnIndex.COL_ACTION.ordinal() && !readOnly;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public String getVid() {
        return this.vid;
    }

    public void setVid(String vid) {
        this.vid = vid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getMitre() {
        return this.mitre;
    }

    public String[] getMitreNames() {
        return this.mitreNames;
    }

    public String getMitreOriginal() {
        return this.mitreOriginal;
    }

    public void setMitre(String mitre) {
        this.mitreOriginal = mitre;
        this.mitreNames = mitre.split("\\s+");
        this.mitre = this.getMitreLinks(this.mitreNames);
    }

    public String getPrevalence() {
        return this.prevalence;
    }

    public void setPrevalence(String prevalence) {
        this.prevalence = prevalence;
    }

    public Integer getPrevalencePercent() {
        return this.prevalencePercent;
    }

    public void setPrevalencePercent(Integer prevalencePercent) {
        this.prevalencePercent = prevalencePercent;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int getRuleIndex() {
        return this.ruleIndex;
    }

    public void setRuleIndex(int index) {
        this.ruleIndex = index;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isTuned() {
        return this.isTuned;
    }

    public void setTuned() {
        this.isTuned = true;
    }

    private String[] getMitreLinks(String[] mitreNames) {
        String[] linkList = new String[mitreNames.length];
        int i = 0;
        for (String tech : mitreNames) {
            linkList[i++] = this.getLink(tech);
        }
        return linkList;
    }

    private String getLink(String technique) {
        String[] paths;
        StringBuilder sb = new StringBuilder("<html><body><a href=\"https://attack.mitre.org/techniques/");
        for (String path : paths = technique.split("\\.")) {
            sb.append(path);
            sb.append("/");
        }
        sb.append("\">");
        sb.append(technique);
        sb.append("</a></body></html>");
        return sb.toString();
    }

    public static enum ColumnIndex {
        COL_NAME,
        COL_MITRE,
        COL_PREVALENCE,
        COL_EVENT_COUNT,
        COL_ACTION;

    }
}

