/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.AdaptiveConfiguration;
import com.sygate.scm.common.configobject.schema.AdaptivePolicy;
import com.sygate.scm.common.configobject.schema.AdaptivePrevalenceRules;
import com.sygate.scm.common.configobject.schema.BPEEnhancementsRule;
import com.sygate.scm.common.configobject.schema.BPEEnhancementsRulesList;
import com.sygate.scm.common.configobject.schema.EndpointNotification;
import com.sygate.scm.common.configobject.schema.PrevalenceRule;
import com.sygate.scm.common.configobject.schema.PrevalenceRulesList;
import com.sygate.scm.common.configobject.schema.SourceInfo;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.common.configobject.table.SemTables;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptiveTableRow;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.AdaptivePolicyUtility;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AdaptivePolicyObject
extends PolicyIntObjectBase {
    private static final String CELL_COLOR_LEARNING = "#E48EF5";
    private static final String CELL_COLOR_ZERO = "#1FADEC";
    private static final String CELL_COLOR_LOW = "#C2E7F8";
    private static final String CELL_COLOR_MED = "#FBDCB5";
    private static final String CELL_COLOR_HIGH = "#FC8D59";
    private static final String ADAPTIVE = "com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy";
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String PREFIX_PREVALENCE = "Prevalence.";
    private static final Map<String, String> prevalenceMap = new HashMap<String, String>();
    private static final Map<String, String> actionMap = new HashMap<String, String>();
    private static final String DESC_LOOKUP_ACTOR = "(actor:";
    private static final String DESC_LOOKUP_TARGET = "(target:";
    private static final String DESC_LOOKUP_MITRE = "[mitre:";
    private static final String DESC_LOOKUP_END = ")";
    private static final String DESC_LOOKUP_END_MITRE = "]";
    private static final BPEEnhancementsRule denyRule = new BPEEnhancementsRule();
    private static final BPEEnhancementsRule allowRule = new BPEEnhancementsRule();
    private static final BPEEnhancementsRule logRule = new BPEEnhancementsRule();
    private final HashMap<String, String> mapPrevPerVid = new HashMap();
    private final HashMap<String, Integer> mapPrevPercentPerVid = new HashMap();
    private final HashMap<String, Integer> mapEventPerVid30Days = new HashMap();
    private final HashMap<String, Integer> mapEventPerVid60Days = new HashMap();
    private final HashMap<String, Integer> mapEventPerVid90Days = new HashMap();
    private final HashMap<String, Integer> mapMachinePerVid30Days = new HashMap();
    private final HashMap<String, Integer> mapMachinePerVid60Days = new HashMap();
    private final HashMap<String, Integer> mapMachinePerVid90Days = new HashMap();
    private boolean isExclusiveEdit = false;
    private Vector<TableRow> all = new Vector();
    private final HashSet<String> pickListActor = new HashSet();
    private final HashSet<String> pickListTarget = new HashSet();
    private final HashSet<String> pickListPrevalence = new HashSet();
    private final HashSet<String> pickListMitre = new HashSet();
    private static final String LABEL_PREVALENCE_AGE_DAYS = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Prevalence.AgeDays");
    private static final String LABEL_PREVALENCE_AGE = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Prevalence.AgeLabel");
    private String labelPrevalenceAge = "";

    public AdaptivePolicyObject() {
    }

    public AdaptivePolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
        this.loadPrevalenceFromHeatMap();
        this.fillInDefaults();
        this.setIsExclusiveEdit();
    }

    public AdaptivePolicyObject(TopLevelObject policy) {
        super(policy);
        this.loadPrevalenceFromHeatMap();
        this.fillInDefaults();
        this.setIsExclusiveEdit();
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof AdaptivePolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        return new AdaptivePolicyObject(policyObj);
    }

    private void fillInDefaults() {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy != null) {
            if (adaptivePolicy.getOptAdaptiveConfiguration() == null) {
                adaptivePolicy.setOptAdaptiveConfiguration(new AdaptiveConfiguration());
            }
            if (adaptivePolicy.getOptAdaptiveConfiguration().getOptBPEEnhancementsRulesList() == null) {
                adaptivePolicy.getOptAdaptiveConfiguration().setOptBPEEnhancementsRulesList(new BPEEnhancementsRulesList());
            }
            if (adaptivePolicy.getOptAdaptiveConfiguration().getOptEndpointNotification() == null) {
                adaptivePolicy.getOptAdaptiveConfiguration().setOptEndpointNotification(new EndpointNotification());
            }
        }
    }

    private void setIsExclusiveEdit() {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy != null) {
            Vector sources = adaptivePolicy.getSourceInfo();
            for (SourceInfo sourceInfo : sources) {
                if (sourceInfo.getOptexclusiveEdit() == null || !sourceInfo.getOptexclusiveEdit().booleanValue()) continue;
                this.isExclusiveEdit = true;
            }
        }
    }

    public AdaptivePolicy getAdaptivePolicy() {
        return (AdaptivePolicy)this.policy;
    }

    @Override
    public boolean isExclusiveEdit() {
        return this.isExclusiveEdit;
    }

    @Override
    public boolean getEnabled() {
        if ((AdaptivePolicy)this.policy == null) {
            return false;
        }
        return Utility.getBooleanValue((Boolean)((AdaptivePolicy)this.policy).getOptEnable(), (Boolean)((AdaptivePolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if ((AdaptivePolicy)this.policy == null) {
            return;
        }
        ((AdaptivePolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        if ((AdaptivePolicy)this.policy == null) {
            return null;
        }
        return ((AdaptivePolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        if ((AdaptivePolicy)this.policy == null) {
            return;
        }
        ((AdaptivePolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString(ADAPTIVE, "AdaptivePolicyObject.AdaptivePolicy");
    }

    @Override
    public String getTargetType() {
        return "AdaptivePolicy";
    }

    @Override
    public String getTargetName() {
        return "AdaptivePolicyApplied";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedAdaptivePolicyLink";
    }

    @Override
    public int getItemType() {
        return 313;
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalAdaptivePolicy";
    }

    public boolean getNotificationEnabled() {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return false;
        }
        return Optional.ofNullable(adaptivePolicy.getOptAdaptiveConfiguration().getOptEndpointNotification().getOptEnabled()).orElse(adaptivePolicy.getOptAdaptiveConfiguration().getOptEndpointNotification().getDefEnabled());
    }

    public void setNotificationEnabled(boolean bEnabled) {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return;
        }
        adaptivePolicy.getOptAdaptiveConfiguration().getOptEndpointNotification().setOptEnabled(Boolean.valueOf(bEnabled));
    }

    public String getCustomText() {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return null;
        }
        return adaptivePolicy.getOptAdaptiveConfiguration().getOptEndpointNotification().getOptNotificationMessage();
    }

    public void setCustomText(String text) {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return;
        }
        adaptivePolicy.getOptAdaptiveConfiguration().getOptEndpointNotification().setOptNotificationMessage(text);
    }

    public boolean getAuditMode() {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return false;
        }
        Integer bpeEnhancementsAction = Optional.ofNullable(adaptivePolicy.getOptAdaptiveConfiguration().getOptBPEEnhancementsAction()).orElse(adaptivePolicy.getOptAdaptiveConfiguration().getDefBPEEnhancementsAction());
        return AdaptiveConfiguration.LOG.equals(bpeEnhancementsAction);
    }

    public void setAuditMode(boolean bAudit) {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return;
        }
        adaptivePolicy.getOptAdaptiveConfiguration().setOptBPEEnhancementsAction(bAudit ? AdaptiveConfiguration.LOG : AdaptiveConfiguration.BLOCK);
    }

    public String getPrevalenceAgeLabel() {
        return this.labelPrevalenceAge;
    }

    public Vector<TableRow> getRuleList() throws ValidationException {
        this.all.clear();
        this.pickListActor.clear();
        this.pickListTarget.clear();
        this.pickListPrevalence.clear();
        this.pickListMitre.clear();
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return this.all;
        }
        AdaptiveConfiguration ac = adaptivePolicy.getOptAdaptiveConfiguration();
        BPEEnhancementsRulesList ruleList = ac.getOptBPEEnhancementsRulesList();
        Iterator it = ruleList.getBPEEnhancementsRule().iterator();
        ArrayList<AdaptiveTableRow> tableRows = new ArrayList<AdaptiveTableRow>(ruleList.getBPEEnhancementsRuleCount());
        int index = 0;
        while (it.hasNext()) {
            BPEEnhancementsRule rule = (BPEEnhancementsRule)it.next();
            AdaptiveTableRow row = new AdaptiveTableRow();
            this.setDataFromDescription(rule.getOptDesc(), row);
            row.setAction(rule.getOptActionValue());
            row.setRuleIndex(index++);
            row.setVid(rule.getOptVirusId());
            this.setPrevalenceFromHeatMap(row);
            tableRows.add(row);
            this.pickListActor.add(row.getActor());
            this.pickListTarget.add(row.getTarget());
            this.pickListPrevalence.add(row.getPrevalence());
            if (row.getMitreNames() == null) continue;
            this.pickListMitre.addAll(Arrays.asList(row.getMitreNames()));
        }
        tableRows.sort(Comparator.comparing(AdaptiveTableRow::getName, String.CASE_INSENSITIVE_ORDER));
        this.all.addAll(tableRows);
        return this.all;
    }

    public Integer getTotalBehaviorCount() {
        return this.all.size();
    }

    public void saveRuleList() throws ValidationException {
        AdaptivePolicy adaptivePolicy = (AdaptivePolicy)this.policy;
        if (adaptivePolicy == null) {
            return;
        }
        Iterator<TableRow> it = this.all.iterator();
        AdaptiveConfiguration ac = adaptivePolicy.getOptAdaptiveConfiguration();
        BPEEnhancementsRulesList ruleList = ac.getOptBPEEnhancementsRulesList();
        Vector rules = ruleList.getBPEEnhancementsRule();
        while (it.hasNext()) {
            AdaptiveTableRow tr = (AdaptiveTableRow)it.next();
            if (!tr.isDirty()) continue;
            BPEEnhancementsRule rule = (BPEEnhancementsRule)rules.get(tr.getRuleIndex());
            rule.setOptActionValue(tr.getAction());
        }
    }

    public static Pair<Color, PrevalenceIcon> getPrevalenceImage(String prevalenceString) {
        Optional<AdaptivePolicyUtility.Prevalence> prevalence = Optional.of(prevalenceMap.entrySet().stream().filter(entry -> prevalenceString.equals(entry.getValue())).map(Map.Entry::getKey).map(AdaptivePolicyUtility.Prevalence::valueOf).findFirst().orElse(AdaptivePolicyUtility.Prevalence.UNKNOWN));
        switch (prevalence.get()) {
            case LEARNING: {
                return new ImmutablePair<Color, PrevalenceIcon>(Color.decode(CELL_COLOR_LEARNING), PrevalenceIcon.ICON_DIAMOND);
            }
            case LOW: {
                return new ImmutablePair<Color, PrevalenceIcon>(Color.decode(CELL_COLOR_LOW), PrevalenceIcon.ICON_SQUARE);
            }
            case MED: {
                return new ImmutablePair<Color, PrevalenceIcon>(Color.decode(CELL_COLOR_MED), PrevalenceIcon.ICON_SQUARE);
            }
            case HIGH: {
                return new ImmutablePair<Color, PrevalenceIcon>(Color.decode(CELL_COLOR_HIGH), PrevalenceIcon.ICON_SQUARE);
            }
            case ZERO: {
                return new ImmutablePair<Color, PrevalenceIcon>(Color.decode(CELL_COLOR_ZERO), PrevalenceIcon.ICON_SQUARE);
            }
        }
        return new ImmutablePair<Color, PrevalenceIcon>(Color.GRAY, PrevalenceIcon.ICON_SQUARE);
    }

    public void tuneRules(Vector<TableRow> rowsToTune) {
        try {
            for (TableRow tr : rowsToTune) {
                AdaptiveTableRow atr = (AdaptiveTableRow)tr;
                atr.setValueAt(denyRule.getOptActionValue(), AdaptiveTableRow.ColumnIndex.COL_ACTION.ordinal());
                atr.setTuned();
            }
        }
        catch (ValidationException ve) {
            ConsoleLogger.log(ve);
        }
    }

    public Vector<TableRow> getQuickTuneRows() {
        Vector<TableRow> subset = new Vector<TableRow>();
        for (TableRow tr : this.all) {
            AdaptiveTableRow atr = (AdaptiveTableRow)tr;
            try {
                if (!atr.getPrevalence().contains(prevalenceMap.get(AdaptivePolicyUtility.Prevalence.ZERO.name())) || denyRule.getOptActionValue().equalsIgnoreCase(atr.getAction())) continue;
                subset.add(atr);
            }
            catch (ValidationException ve) {
                ConsoleLogger.log(ve);
            }
        }
        return subset;
    }

    public String[] getActorPickList() {
        return this.pickListActor.toArray(new String[0]);
    }

    public String[] getTargetPickList() {
        return this.pickListTarget.toArray(new String[0]);
    }

    public String[] getPrevalencePickList() {
        return this.pickListPrevalence.toArray(new String[0]);
    }

    public String[] getMitrePickList() {
        return this.pickListMitre.toArray(new String[0]);
    }

    public boolean hasQuickTune() {
        return this.pickListPrevalence.stream().anyMatch(s -> s.contains(prevalenceMap.get(AdaptivePolicyUtility.Prevalence.ZERO.name())));
    }

    public Vector<TableRow> filter(String filterActor, String filterTarget, String filterPrevalence, String filterMitre, String filterAction) {
        Vector<TableRow> subset = this.getSubset(filterActor, RowFilter.ACTOR, this.all);
        subset = this.getSubset(filterTarget, RowFilter.TARGET, subset);
        subset = this.getSubset(filterPrevalence, RowFilter.PREVALENCE, subset);
        subset = this.getSubset(filterMitre, RowFilter.MITRE, subset);
        subset = this.getSubset(filterAction, RowFilter.ACTION, subset);
        return subset;
    }

    private Vector<TableRow> getSubset(String filter, RowFilter filterType, Vector<TableRow> listToFilter) {
        if (StringUtils.isBlank(filter)) {
            return listToFilter;
        }
        Vector<TableRow> subset = new Vector<TableRow>();
        for (TableRow tr : listToFilter) {
            String rowValue = "";
            AdaptiveTableRow atr = (AdaptiveTableRow)tr;
            switch (filterType) {
                case ACTOR: {
                    rowValue = atr.getActor();
                    break;
                }
                case TARGET: {
                    rowValue = atr.getTarget();
                    break;
                }
                case MITRE: {
                    rowValue = atr.getMitreOriginal();
                    break;
                }
                case PREVALENCE: {
                    rowValue = atr.getPrevalence();
                    break;
                }
                case ACTION: {
                    rowValue = actionMap.get(atr.getAction());
                }
            }
            if (!rowValue.contains(filter)) continue;
            subset.add(atr);
        }
        return subset;
    }

    private void setDataFromDescription(String ruleDesc, AdaptiveTableRow tr) {
        int mitreIndex;
        int targetIndex;
        if (ruleDesc == null) {
            return;
        }
        String actor = "";
        String target = "";
        String mitre = "";
        String name = ruleDesc;
        String lowerRuleDesc = ruleDesc.toLowerCase(Locale.US);
        int actorIndex = lowerRuleDesc.indexOf(DESC_LOOKUP_ACTOR);
        if (actorIndex != -1) {
            int endActorIndex = lowerRuleDesc.indexOf(DESC_LOOKUP_END, actorIndex);
            actor = ruleDesc.substring(actorIndex + DESC_LOOKUP_ACTOR.length(), endActorIndex).trim();
            name = ruleDesc.substring(0, actorIndex).trim();
        }
        if ((targetIndex = lowerRuleDesc.indexOf(DESC_LOOKUP_TARGET)) != -1) {
            int endActorIndex = lowerRuleDesc.indexOf(DESC_LOOKUP_END, targetIndex);
            target = ruleDesc.substring(targetIndex + DESC_LOOKUP_TARGET.length(), endActorIndex).trim();
        }
        if ((mitreIndex = lowerRuleDesc.indexOf(DESC_LOOKUP_MITRE)) != -1) {
            int endMitreIndex = lowerRuleDesc.indexOf(DESC_LOOKUP_END_MITRE);
            mitre = ruleDesc.substring(mitreIndex + DESC_LOOKUP_MITRE.length(), endMitreIndex).trim();
        }
        tr.setActor(actor);
        tr.setTarget(target);
        tr.setName(name);
        tr.setMitre(mitre);
    }

    private void setPrevalenceFromHeatMap(AdaptiveTableRow tr) {
        if (this.mapPrevPerVid.isEmpty()) {
            tr.setPrevalence(prevalenceMap.get(AdaptivePolicyUtility.Prevalence.UNKNOWN.name()));
        } else {
            tr.setPrevalence(prevalenceMap.get(this.mapPrevPerVid.getOrDefault(tr.getVid(), AdaptivePolicyUtility.Prevalence.UNKNOWN.name())));
            tr.setPrevalencePercent(this.mapPrevPercentPerVid.get(tr.getVid()));
        }
    }

    private String formatPrevalenceLabel(Integer aprPrevalenceAge) {
        String age = MSGRES.getString(ADAPTIVE, "Prevalence.InProgress");
        if (AdaptivePrevalenceRules.DAYS_90.equals(aprPrevalenceAge)) {
            age = MessageFormat.format(LABEL_PREVALENCE_AGE_DAYS, 90);
        } else if (AdaptivePrevalenceRules.DAYS_180.equals(aprPrevalenceAge)) {
            age = MessageFormat.format(LABEL_PREVALENCE_AGE_DAYS, 180);
        } else if (AdaptivePrevalenceRules.DAYS_365.equals(aprPrevalenceAge)) {
            age = MessageFormat.format(LABEL_PREVALENCE_AGE_DAYS, "365+");
        } else if (AdaptivePrevalenceRules.LEARNING.equals(aprPrevalenceAge)) {
            age = prevalenceMap.get(AdaptivePolicyUtility.Prevalence.LEARNING.name());
        }
        return MessageFormat.format(LABEL_PREVALENCE_AGE, age);
    }

    private void loadPrevalenceFromHeatMap() {
        try {
            ConsoleLogger.log("Loading prevalence from heat map");
            AdaptivePrevalenceRules apr = GUIManager.getAdaptivePrevalenceInfo();
            this.labelPrevalenceAge = MessageFormat.format(LABEL_PREVALENCE_AGE, MSGRES.getString(ADAPTIVE, "Prevalence.UNKNOWN"));
            if (apr != null) {
                if (Boolean.TRUE.equals(apr.getOptIsLightRegistered())) {
                    this.labelPrevalenceAge = this.formatPrevalenceLabel(apr.getOptPrevalenceAge());
                }
                PrevalenceRulesList prevalenceRuleList = apr.getOptPrevalenceRulesList();
                for (PrevalenceRule pr : prevalenceRuleList.getPrevalenceRule()) {
                    this.mapPrevPerVid.put(pr.getOptVirusId(), pr.getOptPrevalenceValue());
                    this.mapPrevPercentPerVid.put(pr.getOptVirusId(), pr.getOptPrevalencePercentage());
                }
                prevalenceMap.put(AdaptivePolicyUtility.Prevalence.UNKNOWN.name(), MSGRES.getString(ADAPTIVE, Boolean.TRUE.equals(apr.getOptIsLightRegistered()) ? "Prevalence.InProgress" : "Prevalence.UNKNOWN"));
            }
        }
        catch (ValidationException | ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
    }

    public void filterEvents(DayFilter dayFilter, EventFilter filter) {
        Map<String, Integer> eventMap = filter == EventFilter.ALL_EVENTS ? this.chooseEventPerVidMap(dayFilter) : this.chooseEventByMachineMap(dayFilter);
        for (TableRow row : this.all) {
            AdaptiveTableRow atr = (AdaptiveTableRow)row;
            atr.setEventCount(Optional.ofNullable(eventMap.get(atr.getVid())).orElse(0));
        }
    }

    public void loadEvents() {
        try {
            ConsoleLogger.log("Loading event data from SEPM database");
            SemTables tables = GUIManager.getAdaptiveEventInfo(Manager.getCurrentDomainId());
            if (tables != null && tables.getSemTableCount() > 0) {
                this.loadMap(this.mapEventPerVid30Days, tables.getSemTable(0));
                this.loadMap(this.mapEventPerVid60Days, tables.getSemTable(1));
                this.loadMap(this.mapEventPerVid90Days, tables.getSemTable(2));
                this.loadMap(this.mapMachinePerVid30Days, tables.getSemTable(3));
                this.loadMap(this.mapMachinePerVid60Days, tables.getSemTable(4));
                this.loadMap(this.mapMachinePerVid90Days, tables.getSemTable(5));
            }
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
    }

    private void loadMap(HashMap<String, Integer> eventMap, SemTable table) {
        for (SemTableRow row : table.getSemTableRow()) {
            try {
                eventMap.put(row.getSemTableValue(0).getValue().toLowerCase(Locale.ENGLISH), Integer.valueOf(row.getSemTableValue(1).getValue()));
            }
            catch (NumberFormatException nfe) {
                eventMap.put(row.getSemTableValue(0).getValue().toLowerCase(Locale.ENGLISH), 0);
                LoggerUtilities.logException((Throwable)nfe);
            }
        }
    }

    private Map<String, Integer> chooseEventPerVidMap(DayFilter dayFilter) {
        switch (dayFilter) {
            case SIXTY: {
                return this.mapEventPerVid60Days;
            }
            case NINETY: {
                return this.mapEventPerVid90Days;
            }
        }
        return this.mapEventPerVid30Days;
    }

    private Map<String, Integer> chooseEventByMachineMap(DayFilter dayFilter) {
        switch (dayFilter) {
            case SIXTY: {
                return this.mapMachinePerVid60Days;
            }
            case NINETY: {
                return this.mapMachinePerVid90Days;
            }
        }
        return this.mapMachinePerVid30Days;
    }

    static {
        denyRule.setOptAction(BPEEnhancementsRule.BLOCK);
        allowRule.setOptAction(BPEEnhancementsRule.ALLOW);
        logRule.setOptAction(BPEEnhancementsRule.LOG);
        try {
            actionMap.put(denyRule.getOptActionValue(), Utilities.getLocalizedString(ADAPTIVE, "AdaptiveRulePanel.Block"));
            actionMap.put(allowRule.getOptActionValue(), Utilities.getLocalizedString(ADAPTIVE, "AdaptiveRulePanel.Allow"));
            actionMap.put(logRule.getOptActionValue(), Utilities.getLocalizedString(ADAPTIVE, "AdaptiveRulePanel.Log"));
        }
        catch (ValidationException ve) {
            ConsoleLogger.log(ve);
        }
        prevalenceMap.put(AdaptivePolicyUtility.Prevalence.UNKNOWN.name(), MSGRES.getString(ADAPTIVE, PREFIX_PREVALENCE + AdaptivePolicyUtility.Prevalence.UNKNOWN.name()));
        prevalenceMap.put(AdaptivePolicyUtility.Prevalence.ZERO.name(), MSGRES.getString(ADAPTIVE, PREFIX_PREVALENCE + AdaptivePolicyUtility.Prevalence.ZERO.name()));
        prevalenceMap.put(AdaptivePolicyUtility.Prevalence.LOW.name(), MSGRES.getString(ADAPTIVE, PREFIX_PREVALENCE + AdaptivePolicyUtility.Prevalence.LOW.name()));
        prevalenceMap.put(AdaptivePolicyUtility.Prevalence.MED.name(), MSGRES.getString(ADAPTIVE, PREFIX_PREVALENCE + AdaptivePolicyUtility.Prevalence.MED.name()));
        prevalenceMap.put(AdaptivePolicyUtility.Prevalence.HIGH.name(), MSGRES.getString(ADAPTIVE, PREFIX_PREVALENCE + AdaptivePolicyUtility.Prevalence.HIGH.name()));
        prevalenceMap.put(AdaptivePolicyUtility.Prevalence.LEARNING.name(), MSGRES.getString(ADAPTIVE, PREFIX_PREVALENCE + AdaptivePolicyUtility.Prevalence.LEARNING.name()));
    }

    public static enum DayFilter {
        THIRTY,
        SIXTY,
        NINETY;

    }

    public static enum EventFilter {
        ALL_EVENTS,
        BY_MACHINE;

    }

    public static enum PrevalenceIcon {
        ICON_SQUARE,
        ICON_DIAMOND;

    }

    public static enum RowFilter {
        ACTOR,
        TARGET,
        PREVALENCE,
        MITRE,
        ACTION;

    }
}

