/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.adaptive.AdaptiveRuleModel;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptiveTableRow;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.renderer.TableHeaderRenderer;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AdaptiveRulePanel
extends JPanel {
    private static final long serialVersionUID = 8873135024022966639L;
    private static final int DEFAULT_WIDTH = 750;
    private static final int DEFAULT_HEIGHT = 350;
    private static final int MITRE_COLUMN = AdaptiveTableRow.ColumnIndex.COL_MITRE.ordinal();
    private static final int ACTION_COLUMN = AdaptiveTableRow.ColumnIndex.COL_ACTION.ordinal();
    private static final int PREVALENCE_COLUMN = AdaptiveTableRow.ColumnIndex.COL_PREVALENCE.ordinal();
    private static final int EVENT_COUNT_COLUMN = AdaptiveTableRow.ColumnIndex.COL_EVENT_COUNT.ordinal();
    private static final String ACTION_COMMAND_LOG = "LOG";
    private static final String ACTION_COMMAND_BLOCK = "BLOCK";
    private static final String ACTION_COMMAND_ALLOW = "ALLOW";
    private static final Color DARK_RED = new Color(204, 0, 0);
    private static final Color DARK_GREEN = new Color(0, 153, 0);
    private static final String BEHAVIOR_COUNT = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.BehaviorCount");
    private static final String NO_BEHAVIORS_MATCHED = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.NoBehaviorsMatched");
    private static final String NO_BEHAVIORS_LOADED = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.NoBehaviorsLoaded");
    private static final String QUICK_TUNE = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.QuickTune");
    private static final String TITLE_CONFIRM = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.title.Confirm");
    private static final String QUICK_TUNE_CONFIRM = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.QuickTuneConfirm");
    private static final String QUICK_TUNE_NONE = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.NothingToTune");
    private static final String TUNED = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Tuned");
    private static final String BLOCK = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Block");
    private static final String ALLOW = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Allow");
    private static final String LOG = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Log");
    private static final String FILTER_ALL = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Filter.type.all");
    private static final String FILTER_ACTOR = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Filter.type.actor");
    private static final String FILTER_TARGET = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Filter.type.behavior");
    private static final String FILTER_PREVALENCE = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Filter.type.prevalence");
    private static final String FILTER_MITRE = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Filter.type.mitre");
    private static final String FILTER_ACTION = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Filter.type.action");
    private static final String FILTER_EVENTS = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Filter.type.events");
    private static final String FILTER_EVENT_30 = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "EventFilter.type.thirty");
    private static final String FILTER_EVENT_60 = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "EventFilter.type.sixty");
    private static final String FILTER_EVENT_90 = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "EventFilter.type.ninety");
    private static final String FILTER_EVENT_ALL = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "EventFilter.type.all");
    private static final String FILTER_EVENT_DISTINCT = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "EventFilter.type.distinct");
    private static final String BUTTON_PREVIOUS = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Button.Previous");
    private static final String BUTTON_NEXT = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Button.Next");
    private static final String BUTTON_FIRST = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Button.First");
    private static final String BUTTON_LAST = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Button.Last");
    private static final String PREVALENCE_PERCENT = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "Prevalence.Percent");
    private static final float[] TABLE_COLUMN_WIDTH = new float[]{0.55f, 0.1f, 0.14f, 0.01f, 0.2f};
    private static final int TABLE_COLUMN_HEIGHTS_PER_MITRE = 18;
    private static final int TABLE_COLUMN_HEIGHTS_MIN = 36;
    private static final String[] TABLE_COLUMN_NAME = new String[]{Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Behavior"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Mitre"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Prevalence"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.EventCount"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.Action")};
    private final JScrollPane scroll = new JScrollPane();
    private final JPanel paginationPanel = new JPanel();
    private final JButton previousButton = new JButton(BUTTON_PREVIOUS);
    private final JButton nextButton = new JButton(BUTTON_NEXT);
    private final JButton firstButton = new JButton(BUTTON_FIRST);
    private final JButton lastButton = new JButton(BUTTON_LAST);
    private final JLabel jlBehaviorCount = new JLabel();
    private final JLabel jlPrevalenceAge = new JLabel();
    private JPanel filterPanel;
    private JTable ruleTable;
    private AdaptiveRuleModel ruleModel;
    private final JButton quickTuneButton = new JButton(QUICK_TUNE);
    private final DefaultComboBoxModel<String> filterActorModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<String> filterTargetModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<String> filterPrevalenceModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<String> filterMitreModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<String> filterActionModel = new DefaultComboBoxModel();
    private final JComboBox<DropdownItem> cbEventDays = new JComboBox();
    private final JComboBox<DropdownItem> cbEvents = new JComboBox();
    private final JLabel jlEventCountInProgress = new JLabel(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.EventCountLoading"));
    private AdaptivePolicyObject adaptivePolicyObject = null;
    private volatile boolean bEventsUpdated = false;
    private final EventDataWorker eventDataWorker = new EventDataWorker();

    public AdaptiveRulePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        UiUtilities.setupScrollPane((JScrollPane)this.scroll, (JTable)this.createRuleTable());
        this.scroll.setOpaque(false);
        this.add((Component)this.scroll, "Center");
        this.setupPaginationPanel();
        this.add((Component)this.paginationPanel, "South");
    }

    private void setupPaginationPanel() {
        this.firstButton.addActionListener(e -> this.onModelPageChange(0));
        this.previousButton.addActionListener(e -> this.onModelPageChange(this.ruleModel.getCurrentPage() - 1));
        this.nextButton.addActionListener(e -> this.onModelPageChange(this.ruleModel.getCurrentPage() + 1));
        this.lastButton.addActionListener(e -> this.onModelPageChange(this.getLastPageNum()));
        this.paginationPanel.setLayout(new BoxLayout(this.paginationPanel, 0));
        this.paginationPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.paginationPanel.add(this.firstButton);
        this.paginationPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.paginationPanel.add(this.previousButton);
        this.paginationPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.paginationPanel.add(this.nextButton);
        this.paginationPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.paginationPanel.add(this.lastButton);
    }

    protected int getLastPageNum() {
        if (this.ruleModel.getDataVector().isEmpty()) {
            return 0;
        }
        return (int)Math.ceil((double)this.ruleModel.getDataVector().size() / 25.0) - 1;
    }

    void onModelPageChange(int currentPage) {
        this.ruleModel.setCurrentPage(currentPage);
        this.ruleModel.fireTableDataChanged();
        this.scroll.getVerticalScrollBar().setValue(0);
        this.ruleTable.repaint();
    }

    protected void windowClosed() {
        if (!this.eventDataWorker.isDone() && !this.eventDataWorker.isCancelled()) {
            ConsoleLogger.log("Cancelling the event data worker...");
            this.eventDataWorker.cancel(true);
        }
    }

    protected void setObject(AdaptivePolicyObject adaptivePolicyObject) throws ValidationException {
        this.adaptivePolicyObject = adaptivePolicyObject;
        this.getRuleModel().setDataVector(adaptivePolicyObject.getRuleList());
        this.initFilter(this.filterActorModel, AdaptivePolicyObject.RowFilter.ACTOR);
        this.initFilter(this.filterTargetModel, AdaptivePolicyObject.RowFilter.TARGET);
        this.initFilter(this.filterPrevalenceModel, AdaptivePolicyObject.RowFilter.PREVALENCE);
        this.initFilter(this.filterMitreModel, AdaptivePolicyObject.RowFilter.MITRE);
        this.initFilter(this.filterActionModel, AdaptivePolicyObject.RowFilter.ACTION);
        if (adaptivePolicyObject.getRuleList().isEmpty()) {
            this.bEventsUpdated = true;
            this.jlEventCountInProgress.setText("");
            this.jlEventCountInProgress.setIcon(null);
            UIUtilities.showWarningDialog(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.RuleListEmpty"));
        } else {
            Dimension size = this.ruleTable.getPreferredScrollableViewportSize();
            size.height = 350;
            this.scroll.setPreferredSize(size);
            UIUtilities.resizeColumns(this.ruleTable, TABLE_COLUMN_WIDTH, 750.0f, false);
            this.jlPrevalenceAge.setText(adaptivePolicyObject.getPrevalenceAgeLabel());
            this.updateBehaviorCount();
            this.updatePaginationButtons();
            SwingWorkerExecutor.getInstance().execute(this.eventDataWorker);
        }
    }

    protected void initFilter(DefaultComboBoxModel<String> cbModel, AdaptivePolicyObject.RowFilter filterType) {
        if (cbModel == null) {
            return;
        }
        cbModel.removeAllElements();
        if (this.adaptivePolicyObject == null) {
            return;
        }
        String[] items = null;
        switch (filterType) {
            case ACTOR: {
                items = this.adaptivePolicyObject.getActorPickList();
                break;
            }
            case TARGET: {
                items = this.adaptivePolicyObject.getTargetPickList();
                break;
            }
            case PREVALENCE: {
                items = this.adaptivePolicyObject.getPrevalencePickList();
                this.quickTuneButton.setEnabled(this.adaptivePolicyObject.hasQuickTune());
                break;
            }
            case MITRE: {
                items = this.adaptivePolicyObject.getMitrePickList();
                break;
            }
            case ACTION: {
                items = new String[]{BLOCK, ALLOW, LOG};
            }
        }
        if (items == null) {
            return;
        }
        Arrays.sort(items, String.CASE_INSENSITIVE_ORDER);
        cbModel.addAll(Arrays.asList(items).stream().map(String.class::cast).collect(Collectors.toList()));
        cbModel.insertElementAt(FILTER_ALL, 0);
        cbModel.setSelectedItem(FILTER_ALL);
    }

    protected JPanel getFilterPanel() {
        if (this.filterPanel != null) {
            return this.filterPanel;
        }
        this.filterPanel = new JPanel();
        this.filterPanel.setLayout(new BorderLayout());
        Box hBox = Box.createHorizontalBox();
        JLabel jlActor = new JLabel(FILTER_ACTOR);
        JLabel jlTarget = new JLabel(FILTER_TARGET);
        JLabel jlPrevalence = new JLabel(FILTER_PREVALENCE);
        JLabel jlMitre = new JLabel(FILTER_MITRE);
        JLabel jlAction = new JLabel(FILTER_ACTION);
        JComboBox<String> cbActor = new JComboBox<String>(this.filterActorModel);
        JComboBox<String> cbTarget = new JComboBox<String>(this.filterTargetModel);
        JComboBox<String> cbPrevalence = new JComboBox<String>(this.filterPrevalenceModel);
        JComboBox<String> cbMitre = new JComboBox<String>(this.filterMitreModel);
        JComboBox<String> cbAction = new JComboBox<String>(this.filterActionModel);
        cbActor.addItemListener(new ItemChangeListener());
        cbTarget.addItemListener(new ItemChangeListener());
        this.handleTableRepaintForBehaviorComboBoxDropdown(cbTarget, () -> {
            this.ruleModel.fireTableRowsUpdated(1, 1);
            return true;
        });
        cbPrevalence.addItemListener(new ItemChangeListener());
        cbMitre.addItemListener(new ItemChangeListener());
        cbAction.addItemListener(new ItemChangeListener());
        this.addToHBox(hBox, jlActor, cbActor);
        this.addToHBox(hBox, jlTarget, cbTarget);
        this.addToHBox(hBox, jlPrevalence, cbPrevalence);
        this.addToHBox(hBox, jlMitre, cbMitre);
        this.addToHBox(hBox, jlAction, cbAction);
        this.filterPanel.add((Component)hBox, "West");
        return this.filterPanel;
    }

    protected boolean handleTableRepaintForBehaviorComboBoxDropdown(JComboBox<String> cbBehavior, Supplier<Boolean> refreshHandler) {
        cbBehavior.addPopupMenuListener(this.getBehaviorFilterPopupMenuListener(cbBehavior, refreshHandler));
        return true;
    }

    protected PopupMenuListener getBehaviorFilterPopupMenuListener(final JComboBox<String> cbBehavior, final Supplier<Boolean> refreshHandler) {
        return new PopupMenuListener(){
            private int cbBehaviorPreviousSelection = 0;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                int currentSelection = cbBehavior.getSelectedIndex();
                if (this.cbBehaviorPreviousSelection == currentSelection && cbBehavior.getItemCount() > 1) {
                    refreshHandler.get();
                }
                this.cbBehaviorPreviousSelection = currentSelection;
                cbBehavior.hidePopup();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                cbBehavior.hidePopup();
            }
        };
    }

    protected JPanel getEventFilterPanel() {
        JPanel eventFilterPanel = new JPanel();
        eventFilterPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        eventFilterPanel.setLayout(new BorderLayout());
        DropdownItem dropdownItem30Days = new DropdownItem(FILTER_EVENT_30, (Object)AdaptivePolicyObject.DayFilter.THIRTY);
        DropdownItem dropdownItem60Days = new DropdownItem(FILTER_EVENT_60, (Object)AdaptivePolicyObject.DayFilter.SIXTY);
        DropdownItem dropdownItem90Days = new DropdownItem(FILTER_EVENT_90, (Object)AdaptivePolicyObject.DayFilter.NINETY);
        DropdownItem dropdownItemAll = new DropdownItem(FILTER_EVENT_ALL, (Object)AdaptivePolicyObject.EventFilter.ALL_EVENTS);
        DropdownItem dropdownItemDistinct = new DropdownItem(FILTER_EVENT_DISTINCT, (Object)AdaptivePolicyObject.EventFilter.BY_MACHINE);
        this.cbEventDays.addItem(dropdownItem30Days);
        this.cbEventDays.addItem(dropdownItem60Days);
        this.cbEventDays.addItem(dropdownItem90Days);
        this.cbEvents.addItem(dropdownItemAll);
        this.cbEvents.addItem(dropdownItemDistinct);
        this.cbEventDays.setEnabled(false);
        this.cbEvents.setEnabled(false);
        this.cbEventDays.addItemListener(new EventItemChangeListener());
        this.cbEvents.addItemListener(new EventItemChangeListener());
        Box hBox = Box.createHorizontalBox();
        JLabel jlEvents = new JLabel(FILTER_EVENTS);
        this.addToHBox(hBox, jlEvents, this.cbEventDays);
        this.addToHBox(hBox, new JLabel(""), this.cbEvents);
        eventFilterPanel.add((Component)hBox, "West");
        return eventFilterPanel;
    }

    private void addToHBox(Box hBox, Component label, Component cb) {
        hBox.add(label);
        hBox.add(Box.createHorizontalStrut(5));
        hBox.add(cb);
        hBox.add(Box.createHorizontalStrut(20));
        hBox.add(Box.createHorizontalGlue());
    }

    protected JPanel getBehaviorCountPanel() {
        JPanel behaviorCountPanel = new JPanel(new BorderLayout());
        behaviorCountPanel.add((Component)this.jlBehaviorCount, "West");
        behaviorCountPanel.add((Component)this.jlPrevalenceAge, "East");
        this.jlBehaviorCount.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.jlBehaviorCount.setFont(this.jlBehaviorCount.getFont().deriveFont(1));
        return behaviorCountPanel;
    }

    protected JPanel getEventCountPanel() {
        JPanel eventCountPanel = new JPanel(new BorderLayout());
        eventCountPanel.add((Component)this.jlEventCountInProgress, "West");
        this.jlEventCountInProgress.setBorder(new EmptyBorder(10, 0, 5, 0));
        this.jlEventCountInProgress.setFont(this.jlEventCountInProgress.getFont().deriveFont(2));
        this.jlEventCountInProgress.setIcon(ConsoleMain.activeTimeIcon);
        return eventCountPanel;
    }

    protected JPanel getQuickTunePanel() {
        JPanel quickTunePanel = new JPanel(new BorderLayout());
        quickTunePanel.setBorder(new EmptyBorder(0, 0, 4, 0));
        Box hBox = Box.createHorizontalBox();
        hBox.add(this.quickTuneButton);
        hBox.add(Box.createHorizontalGlue());
        this.quickTuneButton.addActionListener(e -> {
            Vector<TableRow> rowsToTune = this.adaptivePolicyObject.getQuickTuneRows();
            if (0 == this.getConfirmation(rowsToTune.size())) {
                this.adaptivePolicyObject.tuneRules(rowsToTune);
                this.ruleModel.fireTableDataChanged();
            }
        });
        quickTunePanel.add((Component)hBox, "West");
        return quickTunePanel;
    }

    protected int getConfirmation(int count) {
        if (count == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), QUICK_TUNE_NONE, TITLE_CONFIRM, 1);
            return 1;
        }
        Object[] obj = new Object[]{count};
        String confirm = MessageFormat.format(QUICK_TUNE_CONFIRM, obj);
        return JOptionPane.showConfirmDialog(Manager.getFrame(), confirm, TITLE_CONFIRM, 0);
    }

    protected AdaptiveRuleModel getRuleModel() {
        if (this.ruleModel == null) {
            this.ruleModel = this.createRuleModel();
        }
        return this.ruleModel;
    }

    private JTable createRuleTable() {
        this.ruleTable = new StripesTable(this.createRuleModel(), true, true);
        this.ruleTable.getTableHeader().setReorderingAllowed(false);
        this.ruleTable.setRowHeight(36);
        this.ruleModel.addMouseListenerToHeaderInTable(this.ruleTable);
        this.ruleTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn prevCol = this.ruleTable.getColumnModel().getColumn(PREVALENCE_COLUMN);
        PrevalenceRenderer prevRenderer = new PrevalenceRenderer();
        prevCol.setCellRenderer(prevRenderer);
        TableColumn actionCol = this.ruleTable.getColumnModel().getColumn(ACTION_COLUMN);
        ActionCellEditor actionEditor = new ActionCellEditor();
        actionCol.setCellRenderer(actionEditor);
        actionCol.setCellEditor(actionEditor);
        actionCol.setHeaderRenderer(new TableHeaderRendererWithCentralizedText());
        TableColumn mitreCol = this.ruleTable.getColumnModel().getColumn(MITRE_COLUMN);
        MitreCellEditorRenderer mitreCellRenderer = new MitreCellEditorRenderer(this.ruleTable);
        mitreCol.setCellRenderer(mitreCellRenderer);
        mitreCol.setCellEditor(mitreCellRenderer);
        TableColumn eventCountCol = this.ruleTable.getColumnModel().getColumn(EVENT_COUNT_COLUMN);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        eventCountCol.setCellRenderer(centerRenderer);
        eventCountCol.setHeaderRenderer(new EventColumnHeaderRenderer(this.cbEvents));
        this.ruleTable.setRowSelectionAllowed(false);
        this.ruleTable.setAutoResizeMode(2);
        this.ruleTable.getModel().addTableModelListener(e -> {
            this.updateBehaviorCount();
            this.updatePaginationButtons();
        });
        this.ruleTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingUtilities.invokeLater(() -> AdaptiveRulePanel.this.ruleTable.getTableHeader().repaint());
            }
        });
        return this.ruleTable;
    }

    protected void updateBehaviorCount() {
        if (this.adaptivePolicyObject.getTotalBehaviorCount() == 0) {
            this.jlBehaviorCount.setText(NO_BEHAVIORS_LOADED);
            return;
        }
        if (this.ruleModel.getDataVector().isEmpty()) {
            this.jlBehaviorCount.setText(NO_BEHAVIORS_MATCHED);
            return;
        }
        int displayFrom = 0;
        int iInitIndex = this.ruleModel.getCurrentPage() * 25;
        if (this.ruleTable.getModel().getRowCount() > 0) {
            displayFrom = iInitIndex + 1;
        }
        Object[] obj = new Object[]{displayFrom, iInitIndex + this.ruleTable.getModel().getRowCount(), this.ruleModel.getDataVector().size(), this.adaptivePolicyObject.getTotalBehaviorCount()};
        String behaviorCountMessage = MessageFormat.format(BEHAVIOR_COUNT, obj);
        this.jlBehaviorCount.setText(behaviorCountMessage);
    }

    protected void updatePaginationButtons() {
        this.firstButton.setEnabled(this.ruleModel.getCurrentPage() > 0);
        this.previousButton.setEnabled(this.ruleModel.getCurrentPage() > 0);
        this.nextButton.setEnabled((this.ruleModel.getCurrentPage() + 1) * 25 < this.ruleModel.getDataVector().size());
        this.lastButton.setEnabled((this.ruleModel.getCurrentPage() + 1) * 25 < this.ruleModel.getDataVector().size());
    }

    protected void setReadOnly(boolean readOnly) {
        this.ruleModel.setReadOnly(readOnly);
    }

    private AdaptiveRuleModel createRuleModel() {
        this.ruleModel = new AdaptiveRuleModel();
        this.ruleModel.setColumnNames(TABLE_COLUMN_NAME);
        return this.ruleModel;
    }

    void filterTable() {
        String filterActor = (String)this.filterActorModel.getSelectedItem();
        String filterTarget = (String)this.filterTargetModel.getSelectedItem();
        String filterPrevalence = (String)this.filterPrevalenceModel.getSelectedItem();
        String filterMitre = (String)this.filterMitreModel.getSelectedItem();
        String filterAction = (String)this.filterActionModel.getSelectedItem();
        if (FILTER_ALL.equals(filterActor)) {
            filterActor = "";
        }
        if (FILTER_ALL.equals(filterTarget)) {
            filterTarget = "";
        }
        if (FILTER_ALL.equals(filterPrevalence)) {
            filterPrevalence = "";
        }
        if (FILTER_ALL.equals(filterMitre)) {
            filterMitre = "";
        }
        if (FILTER_ALL.equals(filterAction)) {
            filterAction = "";
        }
        this.getRuleModel().setDataVector(this.adaptivePolicyObject.filter(filterActor, filterTarget, filterPrevalence, filterMitre, filterAction));
        this.ruleModel.fireTableDataChanged();
    }

    void resetCurrentPage() {
        this.ruleModel.setCurrentPage(0);
    }

    void filterEvents() {
        if (!this.bEventsUpdated) {
            return;
        }
        DropdownItem itemDays = (DropdownItem)this.cbEventDays.getSelectedItem();
        DropdownItem itemEvents = (DropdownItem)this.cbEvents.getSelectedItem();
        AdaptivePolicyObject.DayFilter dayFilter = (AdaptivePolicyObject.DayFilter)((Object)itemDays.getValue());
        AdaptivePolicyObject.EventFilter eventFilter = (AdaptivePolicyObject.EventFilter)((Object)itemEvents.getValue());
        this.adaptivePolicyObject.filterEvents(dayFilter, eventFilter);
        int curSortedColumn = this.ruleModel.getSortedColumn();
        boolean curSortAscending = this.ruleModel.getIsAscending();
        this.ruleModel.sortTable(curSortedColumn, curSortAscending);
        this.ruleModel.fireTableDataChanged();
    }

    static class EventColumnHeaderRenderer
    extends TableHeaderRenderer {
        private static final long serialVersionUID = 1L;
        JComboBox<DropdownItem> comboBoxEvents;

        EventColumnHeaderRenderer(JComboBox<DropdownItem> comboBoxEvents) {
            this.comboBoxEvents = comboBoxEvents;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component header = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)header).setHorizontalAlignment(0);
            if (this.comboBoxEvents.getItemCount() > 0) {
                DropdownItem itemEvents = (DropdownItem)this.comboBoxEvents.getSelectedItem();
                AdaptivePolicyObject.EventFilter eventFilter = (AdaptivePolicyObject.EventFilter)((Object)itemEvents.getValue());
                if (eventFilter == AdaptivePolicyObject.EventFilter.BY_MACHINE) {
                    ((JLabel)header).setText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.ComputerCount"));
                } else {
                    ((JLabel)header).setText(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveRulePanel.EventCount"));
                }
            }
            return header;
        }
    }

    static class TableHeaderRendererWithCentralizedText
    extends TableHeaderRenderer {
        private static final long serialVersionUID = 1L;

        TableHeaderRendererWithCentralizedText() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component header = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)header).setHorizontalAlignment(0);
            return header;
        }
    }

    protected class EventDataWorker
    extends SwingWorker<Void, Void> {
        protected EventDataWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AdaptiveRulePanel.this.adaptivePolicyObject.loadEvents();
            return null;
        }

        @Override
        protected void done() {
            ConsoleLogger.log("Done loading events. Is Cancelled: " + this.isCancelled());
            if (!this.isCancelled()) {
                AdaptiveRulePanel.this.bEventsUpdated = true;
                AdaptiveRulePanel.this.jlEventCountInProgress.setText("");
                AdaptiveRulePanel.this.jlEventCountInProgress.setIcon(null);
                AdaptiveRulePanel.this.cbEventDays.setEnabled(true);
                AdaptiveRulePanel.this.cbEvents.setEnabled(true);
                AdaptiveRulePanel.this.filterEvents();
            }
        }
    }

    class EventItemChangeListener
    implements ItemListener {
        EventItemChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                AdaptiveRulePanel.this.resetCurrentPage();
                AdaptiveRulePanel.this.filterEvents();
            }
        }
    }

    class ItemChangeListener
    implements ItemListener {
        ItemChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                AdaptiveRulePanel.this.resetCurrentPage();
                AdaptiveRulePanel.this.filterTable();
            }
        }
    }

    static class ColorIcon
    implements Icon {
        Color color;

        public ColorIcon(Color c) {
            this.color = c;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillOval(x, y, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    static class ActionCellEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private final JLabel quickTunedLabelEd = new JLabel(TUNED);
        private final JLabel quickTunedLabelRend = new JLabel(TUNED);
        private JPanel panelRenderer = new JPanel();
        private JPanel panelEditor = new JPanel();
        private ButtonGroup bgRenderer = null;
        private ButtonGroup bgEditor = null;

        public ActionCellEditor() {
            GridBagConstraints gbcTunedBox = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
            Box hBox1 = Box.createHorizontalBox();
            this.bgRenderer = this.getActionSelector(null, hBox1);
            this.panelRenderer.setLayout(new GridBagLayout());
            this.panelRenderer.add((Component)hBox1, gbcTunedBox);
            gbcTunedBox.gridx = 0;
            gbcTunedBox.gridy = 0;
            Box hBox2 = Box.createHorizontalBox();
            this.bgEditor = this.getActionSelector(this, hBox2);
            this.panelEditor.setLayout(new GridBagLayout());
            this.panelEditor.add((Component)hBox2, gbcTunedBox);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof String)) {
                return null;
            }
            this.setButtonGroup((String)value, this.bgRenderer.getElements());
            this.quickTunedLabelRend.setVisible(this.isTuned(table, row));
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)table, true));
            return this.panelRenderer;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object o, boolean isSelected, int row, int column) {
            if (!(o instanceof String)) {
                return null;
            }
            this.setButtonGroup((String)o, this.bgEditor.getElements());
            this.quickTunedLabelEd.setVisible(this.isTuned(table, row));
            if (row % 2 > 0) {
                this.panelEditor.setBackground(UIColorUtilities.TABLE_STRIPE);
            } else {
                this.panelEditor.setBackground(UIColorUtilities.DEFAULT_BACKGROUND);
            }
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)table, true));
            return this.panelEditor;
        }

        private boolean isTuned(JTable table, int tableRow) {
            int rowIndexInPagedModel = table.convertRowIndexToModel(tableRow);
            AdaptiveTableRow adaptiveTableRow = ((AdaptiveRuleModel)table.getModel()).getAdaptiveTableRow(rowIndexInPagedModel);
            return adaptiveTableRow.isTuned();
        }

        @Override
        public Object getCellEditorValue() {
            return this.bgEditor.getSelection().getActionCommand();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }

        private ButtonGroup getActionSelector(ActionListener listener, Box hbox) {
            JRadioButton rb1 = new JRadioButton(ALLOW);
            rb1.setOpaque(false);
            rb1.setActionCommand(AdaptiveRulePanel.ACTION_COMMAND_ALLOW);
            JRadioButton rb2 = new JRadioButton(LOG);
            rb2.setOpaque(false);
            rb2.setActionCommand(AdaptiveRulePanel.ACTION_COMMAND_LOG);
            JRadioButton rb3 = new JRadioButton(BLOCK);
            rb3.setOpaque(false);
            rb3.setActionCommand(AdaptiveRulePanel.ACTION_COMMAND_BLOCK);
            hbox.add(rb1);
            hbox.add(rb2);
            hbox.add(rb3);
            ButtonGroup bg = new ButtonGroup();
            bg.add(rb1);
            bg.add(rb2);
            bg.add(rb3);
            hbox.add(Box.createHorizontalStrut(5));
            if (listener != null) {
                rb1.addActionListener(listener);
                rb2.addActionListener(listener);
                rb3.addActionListener(listener);
                this.setTunedLabelEsthetics(this.quickTunedLabelEd);
                hbox.add(this.quickTunedLabelEd);
            } else {
                this.setTunedLabelEsthetics(this.quickTunedLabelRend);
                hbox.add(this.quickTunedLabelRend);
            }
            return bg;
        }

        private void setTunedLabelEsthetics(JLabel quickTunedCaption) {
            quickTunedCaption.setBackground(DARK_GREEN);
            quickTunedCaption.setForeground(Color.WHITE);
            quickTunedCaption.setOpaque(true);
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                Font font = quickTunedCaption.getFont();
                quickTunedCaption.setFont(font.deriveFont((float)font.getSize() - 1.0f));
                quickTunedCaption.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1), BorderFactory.createEmptyBorder(0, 0, -2, 0)));
            });
        }

        private void setButtonGroup(String value, Enumeration<AbstractButton> elements) {
            while (elements.hasMoreElements()) {
                AbstractButton button = elements.nextElement();
                if (button.getActionCommand().equals(value)) {
                    button.setSelected(true);
                    this.setButtonIcon(button);
                    continue;
                }
                button.setIcon(null);
            }
        }

        private void setButtonIcon(AbstractButton button) {
            String actionCommand;
            switch (actionCommand = button.getActionCommand()) {
                case "ALLOW": {
                    button.setIcon(new ColorIcon(DARK_RED));
                    break;
                }
                case "BLOCK": {
                    button.setIcon(new ColorIcon(DARK_GREEN));
                    break;
                }
                case "LOG": {
                    button.setIcon(new ColorIcon(Color.ORANGE));
                    break;
                }
                default: {
                    button.setIcon(null);
                }
            }
        }
    }

    static class MitreCellEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private static final long serialVersionUID = 1L;
        private Object currentValue = null;
        JTable table = null;

        public MitreCellEditorRenderer(JTable table) {
            if (table != null) {
                this.table = table;
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!this.isMitreColumn(column, value)) {
                return null;
            }
            return this.setupMitrePanel(table, row, value, this.getBackgroundColor(row));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = value;
            if (!this.isMitreColumn(column, value)) {
                return null;
            }
            return this.setupMitrePanel(table, row, value, this.getBackgroundColor(row));
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                SwingUtilities.invokeLater(() -> this.sendMouseEventOverToJLabel((MouseEvent)anEvent, this.table));
            }
            return false;
        }

        boolean isMitreColumn(int column, Object value) {
            return column == AdaptiveTableRow.ColumnIndex.COL_MITRE.ordinal() && value instanceof String[];
        }

        Color getBackgroundColor(int row) {
            return row % 2 > 0 ? UIColorUtilities.TABLE_STRIPE : UIColorUtilities.DEFAULT_BACKGROUND;
        }

        void openMitreHelpLink(String mitreLink) {
            String mitreLinkInput = Optional.ofNullable(mitreLink).orElse("");
            int urlStart = mitreLinkInput.indexOf("\"");
            int urlEnd = mitreLinkInput.lastIndexOf("\"");
            if (urlStart != -1 && urlEnd != -1 && urlStart != urlEnd) {
                String strURL = mitreLinkInput.substring(urlStart + 1, urlEnd);
                ConsoleLogger.log("Mitre >> mouseClicked, URL: " + strURL);
                URLUtility.openURI((String)strURL);
            }
        }

        JPanel setupMitrePanel(JTable table, int row, Object value, Color backgroundColor) {
            String[] mitreLinks = (String[])value;
            JPanel jPanelMitre = new JPanel(new GridLayout(0, 1));
            jPanelMitre.setBackground(backgroundColor);
            for (String mitreLink : mitreLinks) {
                JLabel jLabelMitre = new JLabel(mitreLink);
                jLabelMitre.setOpaque(true);
                jLabelMitre.setBackground(backgroundColor);
                jPanelMitre.add(jLabelMitre);
            }
            int newHeight = Math.max(mitreLinks.length * 18, 36);
            Dimension dim = jPanelMitre.getPreferredSize();
            dim.setSize(dim.getWidth(), (double)newHeight);
            jPanelMitre.setPreferredSize(dim);
            if (newHeight != table.getRowHeight(row)) {
                table.setRowHeight(row, newHeight);
            }
            SwingUtilities.invokeLater(() -> AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)table, true)));
            return jPanelMitre;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMouseEventOverToJLabel(MouseEvent e, JTable table) {
            try {
                JPanel editorPanel;
                Component clickedComponent;
                Point point = e.getPoint();
                int row = table.rowAtPoint(point);
                int column = table.columnAtPoint(point);
                if (row < 0 || column < 0 || column >= table.getColumnCount() || row >= table.getRowCount()) {
                    return;
                }
                table.editCellAt(row, column);
                Component editor = table.getEditorComponent();
                if (editor instanceof JPanel && (clickedComponent = SwingUtilities.getDeepestComponentAt(editorPanel = (JPanel)editor, e.getX() - editorPanel.getX(), e.getY() - editorPanel.getY())) instanceof JLabel) {
                    JLabel clickedLabel = (JLabel)clickedComponent;
                    ConsoleLogger.log("sendMouseEventOverToJLabel >> The clickedComponent is JLabel: " + clickedLabel.getText());
                    this.openMitreHelpLink(clickedLabel.getText());
                }
            }
            finally {
                this.stopCellEditing();
            }
        }
    }

    static class PrevalenceRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final int IMAGE_SIZE = 16;
        private static final int IMAGE_SHIFT = 7;
        private static final String HTML_START = "<html><span style=\"white-space: nowrap;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        private static final String HTML_END = "</span></html>";
        private Pair<Color, AdaptivePolicyObject.PrevalenceIcon> image = new ImmutablePair<Color, AdaptivePolicyObject.PrevalenceIcon>(Color.GRAY, AdaptivePolicyObject.PrevalenceIcon.ICON_SQUARE);
        private static final String LEARNING_DIAMOND = "learning_diamond.png";
        private transient BufferedImage diamondImage = this.getDiamondImage("learning_diamond.png");

        PrevalenceRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Integer prevalencePercent = this.getPrevalencePercent(table, row);
            if (value instanceof String) {
                this.setText((String)value, prevalencePercent);
            } else {
                this.setText("", null);
            }
            this.setBackground(row % 2 > 0 ? UIColorUtilities.TABLE_STRIPE : UIColorUtilities.DEFAULT_BACKGROUND);
            return this;
        }

        @Override
        public void setText(String text) {
            super.setText(HTML_START + text + HTML_END);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image.getRight() == AdaptivePolicyObject.PrevalenceIcon.ICON_DIAMOND) {
                this.diamond(g);
            } else {
                this.square(g, this.image.getLeft());
            }
        }

        protected void setText(String text, Integer prevalencePercent) {
            this.image = AdaptivePolicyObject.getPrevalenceImage(text);
            String textWithPercent = prevalencePercent == null ? text : text + " " + MessageFormat.format(PREVALENCE_PERCENT, prevalencePercent);
            this.setText(textWithPercent);
        }

        private Integer getPrevalencePercent(JTable table, int tableRow) {
            int rowIndexInPagedModel = table.convertRowIndexToModel(tableRow);
            AdaptiveTableRow adaptiveTableRow = ((AdaptiveRuleModel)table.getModel()).getAdaptiveTableRow(rowIndexInPagedModel);
            return adaptiveTableRow.getPrevalencePercent();
        }

        private void square(Graphics g, Color color) {
            int y = (this.getHeight() - 16) / 2;
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(color);
            g2.drawRect(7, y, 16, 16);
            g2.fillRect(7, y, 16, 16);
        }

        private void diamond(Graphics g) {
            int y = (this.getHeight() - 16) / 2;
            if (this.diamondImage != null) {
                g.drawImage(this.diamondImage, 7, y, 16, 16, null);
            }
        }

        BufferedImage getDiamondImage(String resourceName) {
            try {
                return ImageIO.read(ConsoleMain.class.getResource(resourceName));
            }
            catch (IOException | IllegalArgumentException e) {
                ConsoleLogger.log(e);
                return null;
            }
        }
    }
}

