/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptiveTableRow;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptiveTableRowComparator;
import com.sygate.scm.console.ui.util.SortableTableModel;
import java.util.Comparator;

public class AdaptiveRuleModel
extends SortableTableModel {
    static final int ROWS_PER_PAGE = 25;
    private static final long serialVersionUID = 5705805922857032904L;
    private int currentPage = 0;
    private boolean readOnly = false;

    public AdaptiveRuleModel() {
        super(false);
        this.isAscending = true;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return AdaptiveTableRow.isCellEditable(col, this.readOnly);
    }

    @Override
    protected Comparator<Object> getRowComparator(int column, boolean isAscending) {
        return (Comparator)Cast.cast((Object)new AdaptiveTableRowComparator(column, isAscending));
    }

    @Override
    public int getRowCount() {
        int startIndex = this.currentPage * 25;
        int endIndex = Math.min(startIndex + 25, this.getDataVector().size());
        return endIndex - startIndex;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int index = this.currentPage * 25 + rowIndex;
        return this.getValueAt(this.getDataVector(), index, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        int index = this.currentPage * 25 + rowIndex;
        TableRow tableRow = this.getDataVector().elementAt(index);
        tableRow.setValueAt(value, this.convertToRowIndex(columnIndex));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public AdaptiveTableRow getAdaptiveTableRow(int rowIndexInPage) {
        int index = this.currentPage * 25 + rowIndexInPage;
        TableRow tableRow = this.getDataVector().elementAt(index);
        return (AdaptiveTableRow)tableRow;
    }
}

