/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.adaptive.AdaptiveRulePanel;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AdaptivePolicyPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -443145385458649965L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADAPTIVE = "com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy";
    private JPanel rulesPanel;
    private AdaptiveRulePanel rulesTablePanel;
    private transient AdaptivePolicyObject policyObj;

    public AdaptivePolicyPanel() {
        this.initialize();
    }

    private void initialize() {
        AvTemplatePane avPane = new AvTemplatePane(MSGRES.getString(ADAPTIVE, "AdaptivePolicyPanel.title.PolicyName"), MSGRES.getString(ADAPTIVE, "AdaptivePolicyPanel.description.PolicyDescription"));
        avPane.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.setLayout(new BorderLayout(20, 0));
        this.add((Component)avPane, "First");
        this.add((Component)this.getRulesPanel(), "Center");
    }

    private JPanel getRulesPanel() {
        if (this.rulesPanel == null) {
            this.rulesTablePanel = new AdaptiveRulePanel();
            GridBagLayout gbl = new GridBagLayout();
            gbl.columnWidths = new int[]{0, 0, 0, 0};
            gbl.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            gbl.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
            gbl.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.rulesPanel = new JPanel(gbl);
            this.rulesPanel.setBorder(new EmptyBorder(0, 10, 5, 5));
            this.rulesPanel.add((Component)this.rulesTablePanel.getQuickTunePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rulesPanel.add((Component)this.rulesTablePanel.getFilterPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rulesPanel.add((Component)this.rulesTablePanel.getEventFilterPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rulesPanel.add((Component)this.rulesTablePanel.getEventCountPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rulesPanel.add((Component)this.rulesTablePanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.rulesPanel.add((Component)this.rulesTablePanel.getBehaviorCountPanel(), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.rulesPanel;
    }

    protected void windowClosed() {
        if (this.rulesTablePanel != null) {
            this.rulesTablePanel.windowClosed();
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_adaptive_protection";
    }

    public void setObject(AdaptivePolicyObject policyObj) throws ConsoleException {
        this.policyObj = policyObj;
        if (policyObj == null) {
            throw new ConsoleException(new Exception("Updating AdaptivePolicyPanel with null policy!"));
        }
        ConsoleLogger.log("Updating AdaptivePolicyPanel");
        this.removeAll();
        this.initialize();
        this.validate();
        this.repaint();
        this.updateValues();
        ConsoleLogger.log("Updating AdaptivePolicyPanel done");
    }

    protected void updateValues() throws ConsoleException {
        try {
            this.rulesTablePanel.setObject(this.policyObj);
        }
        catch (ValidationException ve) {
            throw new ConsoleException(ve);
        }
    }

    public void save() throws ValidationException {
        this.policyObj.saveRuleList();
    }

    public void setReadOnly() {
        this.rulesTablePanel.setReadOnly(true);
    }
}

