/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.AdaptivePolicy;
import com.sygate.scm.common.configobject.schema.SymantecAdaptiveRules;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.adaptive.AdaptiveAdvancedPanel;
import com.sygate.scm.console.ui.policy.adaptive.AdaptivePolicyPanel;
import com.sygate.scm.console.ui.policy.adaptive.AdaptivePolicyTabPanel;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.AdaptivePolicyUtility;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.SystemLevel;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class AdaptivePolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_WIDTH_BUFFER = 455;
    private static final MessageResourcesFile TEMPLATE_RES = new MessageResourcesFile("com.sygate.scm.util.template.template_displayname");
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADAPTIVE = "com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy";
    private static final String AUTOMATION_BUTTON_OK = "ButtonOK";
    private static final Logger logger = Logger.getLogger(AdaptivePolicyDialog.class.getName());
    private AdaptivePolicyObject policyObj;
    private AdaptivePolicyPanel adaptivePolicyPanel;
    private AdaptiveAdvancedPanel adaptiveAdvancedPanel;

    public AdaptivePolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(313, name, gpObj, MSGRES.getString(ADAPTIVE, "AdaptivePolicyDialog.title"), true, isLocal);
        this.initialize();
    }

    public AdaptivePolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public AdaptivePolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(313, pool, MSGRES.getString(ADAPTIVE, "AdaptivePolicyDialog.title"), isCheckPolicyEnforcement, true);
        this.initialize();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.adaptivePolicyPanel.setReadOnly();
        }
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        AdaptivePolicy policy = this.createAdaptivePolicy();
        this.policyObj = new AdaptivePolicyObject((TopLevelObject)policy);
        if (this.policyObj.getName() != null && (newName = PolicyHandler.adjustName(this.policyObj.getName(), pool.getAllName(), 512)) != null) {
            this.policyObj.setName(newName);
        }
        this.policyObj.addNewObj((TopLevelObject)policy);
        this.setValues();
        return this.policyObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject policy) {
        this.policyObj = new AdaptivePolicyObject(policy);
        this.setValues();
        return this.policyObj;
    }

    @Override
    protected void commit() {
        this.policyObj.getAdaptivePolicy().setName(this.getOverviewPanel().getPolicyName());
        this.policyObj.getAdaptivePolicy().setOptDescription(this.getOverviewPanel().getPolicyDesc());
        this.policyObj.getAdaptivePolicy().setOptEnable(Boolean.valueOf(this.getOverviewPanel().isPolicyEnabled()));
        try {
            this.getAdaptivePolicyPanel().save();
            this.getAdaptiveAdvancedPanel().save();
        }
        catch (ValidationException ve) {
            ConsoleLogger.logError("Unexpected error saving the action cell item.");
        }
    }

    @Override
    protected boolean isValidate() {
        return true;
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        this.makeWider(455);
        AdaptivePolicyTabPanel buttonPanel = new AdaptivePolicyTabPanel(this, "<html>" + MSGRES.getString(ADAPTIVE, "AdaptivePolicyDialog.AdaptivePolicy") + "</html>", "");
        buttonPanel.putClientProperty("cssClass", "AdaptivePolicyDialogTabPanel");
        return buttonPanel;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getAdaptivePolicyPanel()), MSGRES.getString(ADAPTIVE, "AdaptivePolicyTabPanel.AdaptivePolicySettings"));
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getAdaptiveAdvancedPanel()), MSGRES.getString(ADAPTIVE, "AdaptivePolicyTabPanel.AdaptivePolicyAdvanced"));
    }

    protected AdaptivePolicyPanel getAdaptivePolicyPanel() {
        if (this.adaptivePolicyPanel == null) {
            this.adaptivePolicyPanel = new AdaptivePolicyPanel();
        }
        return this.adaptivePolicyPanel;
    }

    protected AdaptiveAdvancedPanel getAdaptiveAdvancedPanel() {
        if (this.adaptiveAdvancedPanel == null) {
            this.adaptiveAdvancedPanel = new AdaptiveAdvancedPanel();
        }
        return this.adaptiveAdvancedPanel;
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getAdaptivePolicyPanel(), this.getAdaptiveAdvancedPanel()};
    }

    private void initialize() {
        UIUtilities.setName(this.jBOk, "policyPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_OK);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (AdaptivePolicyDialog.this.adaptivePolicyPanel != null) {
                    AdaptivePolicyDialog.this.adaptivePolicyPanel.windowClosed();
                }
            }
        });
    }

    private AdaptivePolicy createAdaptivePolicy() {
        AdaptivePolicy policy = AdaptivePolicyUtility.getInstance().getDefaultAdaptivePolicy(null);
        if (policy == null) {
            policy = new AdaptivePolicy();
            policy.setId(new GUIDGenerator().getGUIDString());
            policy.setMetadataAttributes(new MetadataAttributes());
        }
        policy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
        policy.setOptEnable(Boolean.TRUE);
        policy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.ADAPTIVE.POLICY$$"));
        policy.setOptDescription("");
        this.addSymantecRules(policy);
        return policy;
    }

    private void addSymantecRules(AdaptivePolicy newAdaptivePolicy) {
        String objID = Utility.calculateHash((String)"nullSymantecAdaptiveRulesSymantecAdaptiveRules");
        ConsoleLogger.log("Retrieving Symantec Adaptive Rules: " + objID);
        SymantecAdaptiveRules sar = null;
        try {
            sar = (SymantecAdaptiveRules)GUIManager.getObject("SymantecAdaptiveRules", objID);
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
            return;
        }
        if (sar != null) {
            AdaptivePolicyUtility.getInstance().mergeSymantecRules(newAdaptivePolicy, sar.getOptBPEEnhancementsRulesList());
        }
    }

    private void setValues() {
        block2: {
            try {
                this.getOverviewPanel().setObject(this.policyObj);
                this.getOverviewPanel().setPolicyEnabled(Utility.getBooleanValue((Boolean)this.policyObj.getAdaptivePolicy().getOptEnable(), (Boolean)this.policyObj.getAdaptivePolicy().getDefEnable()));
                this.getAdaptivePolicyPanel().setObject(this.policyObj);
                this.getAdaptiveAdvancedPanel().setObject(this.policyObj);
            }
            catch (ConsoleException ex) {
                logger.log(SystemLevel.STDERR, "", ex);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }
}

