/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.adaptive;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.AdditionalTextDialog;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AdaptiveAdvancedPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -443145385458649965L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADAPTIVE = "com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy";
    private JCheckBox jChkNotify = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveAdvancedPanel.check.notify"));
    private JButton jBCustomText = new JButton(UIText.get(4616));
    private JCheckBox jChkMonitor = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.adaptive.adaptivePolicy", "AdaptiveAdvancedPanel.check.monitor"));
    private transient AdaptivePolicyObject policyObj;

    public AdaptiveAdvancedPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        panel.add((Component)this.getDisplayOptionPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.getAuditModePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 5, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_adaptive_advanced_settings";
    }

    public void setObject(AdaptivePolicyObject policyObj) throws ConsoleException {
        this.policyObj = policyObj;
        if (policyObj == null) {
            throw new ConsoleException(new Exception("Updating AdaptivePolicyPanel with null policy!"));
        }
        this.updateValues();
    }

    protected void updateValues() {
        this.jChkNotify.setSelected(this.policyObj.getNotificationEnabled());
        this.setCustomTextStatus();
        this.jChkMonitor.setSelected(this.policyObj.getAuditMode());
    }

    private void setCustomTextStatus() {
        this.jBCustomText.setEnabled(this.jChkNotify.isSelected());
    }

    public void save() {
        this.policyObj.setNotificationEnabled(this.jChkNotify.isSelected());
        this.policyObj.setAuditMode(this.jChkMonitor.isSelected());
    }

    protected void handleCustomTextDialog() {
        String customText = this.policyObj.getCustomText();
        AdditionalTextDialog dlg = this.getCustomTextDialog(customText);
        if (dlg.isOk()) {
            this.policyObj.setCustomText(dlg.getAdditionalText());
        }
        dlg.dispose();
    }

    private JPanel getDisplayOptionPanel() {
        this.jChkNotify.addActionListener(e -> this.setCustomTextStatus());
        this.jBCustomText.addActionListener(e -> this.handleCustomTextDialog());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add((Component)this.jChkNotify, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBCustomText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 28, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(ADAPTIVE, "AdaptiveAdvancedPanel.title.Notifications"), MSGRES.getString(ADAPTIVE, "AdaptiveAdvancedPanel.desc.Notifications"), false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    protected AdditionalTextDialog getCustomTextDialog(String customText) {
        RestrictedPlainDocument textDocument = new RestrictedPlainDocument(512);
        textDocument.setValidator("\n", false);
        return new AdditionalTextDialog(MSGRES.getString(ADAPTIVE, "AdaptiveAdvancedPanel.title.EnterAdditionalText"), customText, textDocument);
    }

    private JPanel getAuditModePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add((Component)this.jChkMonitor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(ADAPTIVE, "AdaptiveAdvancedPanel.title.MonitorMode"), MSGRES.getString(ADAPTIVE, "AdaptiveAdvancedPanel.desc.MonitorMode"), false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }
}

