/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.creamtec.ajaxswing.support.FileOpener;
import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.FirewallPolicyObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.NtrPolicyObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyPoolPane;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.policy.up.logicobject.UpgradePolicyObject;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PolicyTask {
    public static final int ADD = 0;
    public static final int IMPORT = 1;
    public static final int ABOUT = 2;
    public static final int EDIT = 3;
    public static final int DELETE = 4;
    public static final int EXPORT = 5;
    public static final int APPLY = 6;
    public static final int WITHDRAW = 7;
    public static final int REPLACE = 8;
    public static final int COPY = 9;
    public static final int PASTE = 10;
    public static final int SHOW = 11;
    public static final int CHANGE = 13;
    public static final int LEARNAPP = 14;
    public static final int ADD_SYSTEM = 15;
    public static final int LU_DOWNLOAD_NOW = 16;
    public static final int LU_SHOW_STATUS = 17;
    public static final int SHOW_OS_OPTIONS = 21;
    private static final Icon applyAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("apply.png")));
    private static final Icon copyAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("copy.png")));
    private static final Icon editAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
    private static final Icon deleteAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("delete.png")));
    private static final Icon addAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
    private static final Icon addIPSCustomAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
    private static final Icon learnedAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("show_policies.png")));
    private static final Icon importAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("import.png")));
    private static final Icon withdrawAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("withdraw.png")));
    private static final Icon exportAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("export.png")));
    private static final Icon replaceAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("switchDomain.png")));
    private static final Icon pasteAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("paste.png")));
    private static final Icon showAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("show_policies.png")));
    private static final Icon aboutAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.globalURL));
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    private static final String POLICY = "com.sygate.scm.console.ui.policy.policy";
    private static final String TASK_NAME_EDIT = MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicyTask.pEdit");
    private static final String TASK_NAME_DEL = MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicyTask.pDelete");
    private static final String TASK_NAME_APPLY = MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicyTask.pApply");
    private static final String TASK_NAME_WITHDRAW = MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicyTask.pWithdraw");
    private static final String TASK_NAME_REPLACE = MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicyTask.pReplace");
    private static final String TASK_NAME_COPY = MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicyTask.pCopy");
    private static final String TASK_NAME_EXPORT = MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicyTask.pExport");
    private PagePanel panel;
    private boolean isReadOnly;
    private boolean isCloudEnrolled = false;

    public PolicyTask(PagePanel panel) {
        this.panel = panel;
        this.isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    }

    public List<List<TaskObject>> getTask(int type) {
        TaskPanel taskPanel = (TaskPanel)((Object)this.panel.getCurrentTaskPanel());
        int tableSelType = taskPanel.getTableSelectedItem();
        if (tableSelType != -1) {
            type = tableSelType;
        }
        List<List<TaskObject>> taskList = null;
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        this.isReadOnly = AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context);
        switch (type) {
            case 314: {
                taskList = this.getAdaptivePolicyPoolTask();
                break;
            }
            case 125: {
                taskList = this.getAntiVirusPolicyPoolTask();
                break;
            }
            case 136: {
                taskList = this.getOverridePolicyPoolTask();
                break;
            }
            case 310: {
                taskList = this.getUpgradePolicyPoolTask();
                break;
            }
            case 57: {
                taskList = this.getFirewallPolicyPoolTask();
                break;
            }
            case 58: {
                taskList = this.getHostIntegrityPolicyPoolTask();
                break;
            }
            case 64: {
                taskList = this.getHardwareProtectionPolicyPoolTask();
                break;
            }
            case 145: {
                taskList = this.getLiveUpdatePolicyPoolTask();
                break;
            }
            case 149: {
                taskList = this.getLiveUpdateContentPolicyPoolTask();
                break;
            }
            case 61: {
                taskList = this.getPolicyManagerListPolicyPoolTask();
                break;
            }
            case 142: {
                taskList = this.getAVScanPoolTask();
                break;
            }
            case 66: 
            case 305: {
                taskList = this.getIPSPoolTask(type);
                break;
            }
            case 91: {
                taskList = this.getFileFingerprintPoolTask();
                break;
            }
            case 152: {
                taskList = this.getHostGroupPoolTask();
                break;
            }
            case 62: {
                taskList = this.getNetworkServicePoolTask();
                break;
            }
            case 100: {
                taskList = this.getNetworkAdapterPoolTask();
                break;
            }
            case 101: {
                taskList = this.getHardwareDevicePoolTask();
                break;
            }
            case 129: {
                taskList = this.getAVScanTask();
                break;
            }
            case 313: {
                taskList = this.getAdaptivePolicyTask();
                break;
            }
            case 134: {
                taskList = this.getAntiVirusPolicyTask();
                break;
            }
            case 128: {
                taskList = this.getOverridePolicyTask();
                break;
            }
            case 309: {
                taskList = this.getUpgradePolicyTask();
                break;
            }
            case 43: {
                taskList = this.getFirewallPolicyTask();
                break;
            }
            case 56: {
                taskList = this.getHostIntegrityPolicyTask();
                break;
            }
            case 63: {
                taskList = this.getHardwareProtectionPolicyTask();
                break;
            }
            case 144: {
                taskList = this.getLiveUpdatePolicyTask();
                break;
            }
            case 148: {
                taskList = this.getLiveUpdateContentPolicyTask();
                break;
            }
            case 60: {
                taskList = this.getPolicyManagerListPolicyTask();
                break;
            }
            case 65: {
                taskList = this.getIPSCustomPolicyTask();
                break;
            }
            case 143: {
                taskList = this.getIPSPolicyTask();
                break;
            }
            case 170: {
                taskList = this.getMemPolicyPoolTask();
                break;
            }
            case 169: {
                taskList = this.getMemPolicyTask();
                break;
            }
            case 172: {
                taskList = this.getNtrPolicyPoolTask();
                break;
            }
            case 171: {
                taskList = this.getNtrPolicyTask();
                break;
            }
            case 130: {
                taskList = this.getFileFingerprintTask();
                break;
            }
            case 9: {
                taskList = this.getHostGroupTask();
                break;
            }
            case 131: {
                taskList = this.getNetworkServiceTask();
                break;
            }
            case 132: {
                taskList = this.getNetworkAdapterTask();
                break;
            }
            case 133: {
                taskList = this.getHardwareDeviceTask();
                break;
            }
            case 401: {
                taskList = this.getAVScanTask();
                break;
            }
        }
        if (taskList == null) {
            taskList = new ArrayList<List<TaskObject>>();
        } else {
            boolean hasGroupRight;
            boolean bl = hasGroupRight = AdminPrivilegeObject.isCurrentAdminHasComputerUserPrivilege() && AdminObject.retrieveCurrentAdminObject().hasGroupFullAccessRight();
            if (!hasGroupRight) {
                this.modifyTaskListBasedOnGroupRight(taskList);
            }
        }
        return taskList;
    }

    private List<List<TaskObject>> getAdaptivePolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createAdaptivePolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getAntiVirusPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createAntiVirusPolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getOverridePolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createOverridePolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getUpgradePolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createUpgradePolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getFirewallPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createFirewallPolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getHostIntegrityPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createHostIntegrityPolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getHardwareProtectionPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createHardwareProtectionPolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getLiveUpdatePolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createLiveUpdatePolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getLiveUpdateContentPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createLiveUpdateContentPolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getAVScanPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createAVScanPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getIPSPoolTask(int poolType) {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createIPSPoolTask(poolType));
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getMemPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createMemPolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getNtrPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createNtrPolicyPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getPolicyManagerListPolicyPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createPolicyManagerListPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getFileFingerprintPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createFileFingerprintPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getHostGroupPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createHostGroupPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getNetworkServicePoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createNetworkServicePoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getNetworkAdapterPoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createNetworkAdapterPoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getHardwareDevicePoolTask() {
        ArrayList<List<TaskObject>> task = new ArrayList<List<TaskObject>>();
        task.add(this.createHardwareDevicePoolTask());
        task.add(this.createLearnedApplicationTask());
        return task;
    }

    private List<List<TaskObject>> getAdaptivePolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createAdaptivePolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getAntiVirusPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createAntiVirusPolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getAVScanTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.scanEdit"), 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.scanDelete"), 4, deleteAction));
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createAVScanPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getOverridePolicyTask() {
        boolean isExclusiveEdit = false;
        String exclusiveEditTooltip = null;
        OverridePolicyObject overridePolicyObject = (OverridePolicyObject)this.getSelectedPolicyObject();
        if (overridePolicyObject != null && overridePolicyObject.isExclusiveEdit()) {
            isExclusiveEdit = true;
            exclusiveEditTooltip = MSG_RES.getString(POLICY, "PolicyTask.exclusiveEditTooltip");
        }
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(TASK_NAME_EDIT, 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(TASK_NAME_DEL, 4, deleteAction, null, null, !isExclusiveEdit, exclusiveEditTooltip));
        }
        task.add(new TaskObject(TASK_NAME_APPLY, 6, applyAction, null, null, !isExclusiveEdit, exclusiveEditTooltip));
        task.add(new TaskObject(TASK_NAME_WITHDRAW, 7, withdrawAction, null, null, !isExclusiveEdit, exclusiveEditTooltip));
        task.add(new TaskObject(TASK_NAME_REPLACE, 8, replaceAction, null, null, !isExclusiveEdit, exclusiveEditTooltip));
        task.add(new TaskObject(TASK_NAME_COPY, 9, copyAction, null, null, !isExclusiveEdit, exclusiveEditTooltip));
        task.add(new TaskObject(TASK_NAME_EXPORT, 5, exportAction));
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createOverridePolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getUpgradePolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createUpgradePolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getFirewallPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createFirewallPolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getHostIntegrityPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createHostIntegrityPolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getHardwareProtectionPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createHardwareProtectionPolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getLiveUpdatePolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createLiveUpdatePolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getLiveUpdateContentPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createLiveUpdateContentPolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getIPSPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createIPSPoolTask(143)));
        return list;
    }

    private List<List<TaskObject>> getIPSCustomPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createIPSPoolTask(65)));
        return list;
    }

    private List<List<TaskObject>> getNtrPolicyTask() {
        List<List<TaskObject>> list = this.getStandardPolicyTask();
        list.add(this.addLearnedApplicationTask(this.createNtrPolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getStandardPolicyTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(TASK_NAME_EDIT, 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(TASK_NAME_DEL, 4, deleteAction));
        }
        task.add(new TaskObject(TASK_NAME_APPLY, 6, applyAction));
        task.add(new TaskObject(TASK_NAME_WITHDRAW, 7, withdrawAction));
        task.add(new TaskObject(TASK_NAME_REPLACE, 8, replaceAction));
        task.add(new TaskObject(TASK_NAME_COPY, 9, copyAction));
        task.add(new TaskObject(TASK_NAME_EXPORT, 5, exportAction));
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        return list;
    }

    private List<List<TaskObject>> getMemPolicyTask() {
        boolean isExclusiveEdit = false;
        String cloudManagedTaskTooltip = this.isCloudEnrolled ? MSG_RES.getString(POLICY, "PolicyTask.cloudManagedTaskTooltip") : null;
        String exclusiveEditTooltip = null;
        MemPolicyObject memPolicyObject = (MemPolicyObject)this.getSelectedPolicyObject();
        if (memPolicyObject != null && memPolicyObject.isExclusiveEdit()) {
            isExclusiveEdit = true;
            exclusiveEditTooltip = MSG_RES.getString(POLICY, "PolicyTask.exclusiveEditTooltip");
        }
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(TASK_NAME_EDIT, 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(TASK_NAME_DEL, 4, deleteAction, null, null, !isExclusiveEdit, exclusiveEditTooltip));
        }
        boolean isEnabled = true;
        String tooltip = null;
        if (isExclusiveEdit) {
            isEnabled = false;
            tooltip = exclusiveEditTooltip;
        } else if (CloudUtil.isCloudMemPolicyInUse()) {
            isEnabled = false;
            tooltip = cloudManagedTaskTooltip;
        }
        task.add(new TaskObject(TASK_NAME_APPLY, 6, applyAction, null, null, isEnabled, tooltip));
        task.add(new TaskObject(TASK_NAME_WITHDRAW, 7, withdrawAction, null, null, isEnabled, tooltip));
        task.add(new TaskObject(TASK_NAME_REPLACE, 8, replaceAction, null, null, isEnabled, tooltip));
        task.add(new TaskObject(TASK_NAME_COPY, 9, copyAction, null, null, isEnabled, tooltip));
        task.add(new TaskObject(TASK_NAME_EXPORT, 5, exportAction));
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createMemPolicyPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getPolicyManagerListPolicyTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmEdit"), 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmDelete"), 4, deleteAction));
        }
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmApply"), 6, applyAction));
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmReplace"), 8, replaceAction));
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmCopy"), 9, copyAction));
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmShow"), 11, showAction));
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmExport"), 5, exportAction));
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createPolicyManagerListPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getFileFingerprintTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fingerprintEdit"), 3, editAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fingerprintDelete"), 4, deleteAction));
        }
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fingerprintExport"), 5, exportAction));
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fingerprintProperties"), 2, aboutAction));
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createFileFingerprintPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getHostGroupTask() {
        ArrayList<TaskObject> tasks = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            tasks.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hostGroupEdit"), 3, editAction));
            tasks.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hostGroupDelete"), 4, deleteAction));
        }
        tasks.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hostGroupExport"), 5, exportAction));
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(tasks);
        list.add(this.addLearnedApplicationTask(this.createHostGroupPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getNetworkServiceTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.networkServiceEdit"), 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.networkServiceDelete"), 4, deleteAction));
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createNetworkServicePoolTask()));
        return list;
    }

    private List<List<TaskObject>> getNetworkAdapterTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.networkAdapterEdit"), 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.networkAdapterDelete"), 4, deleteAction));
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createNetworkAdapterPoolTask()));
        return list;
    }

    private List<List<TaskObject>> getHardwareDeviceTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.deviceEdit"), 3, editAction));
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.deviceDelete"), 4, deleteAction));
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(this.addLearnedApplicationTask(this.createHardwareDevicePoolTask()));
        return list;
    }

    private List<TaskObject> createAdaptivePolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.adaptivePoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.adaptivePoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(AdaptivePolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.adaptivePoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createFirewallPolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fwPoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fwPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(FirewallPolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fwPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createAntiVirusPolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.avPoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.avPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(AvPolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.avPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createOverridePolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.overridePoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.overridePoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(OverridePolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.overridePoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createUpgradePolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            TaskObject taskAdd = new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.upgradePoolAdd"), 0, addAction);
            task.add(taskAdd);
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.upgradePoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(UpgradePolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.upgradePoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createHostIntegrityPolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hiPoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hiPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(HostIntegrityObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hiPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createHardwareProtectionPolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hpPoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hpPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(AppProtectionPolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hpPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createLiveUpdatePolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.luPoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.luPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(LiveUpdateObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.luPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private FileOpener getFileOpener() {
        Component currentTaskPanel = this.panel.getCurrentTaskPanel();
        return currentTaskPanel instanceof FileOpener ? (FileOpener)currentTaskPanel : null;
    }

    private List<TaskObject> createLiveUpdateContentPolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.luContentPoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.luContentPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(LiveUpdateContentObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.luContentPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createPolicyManagerListPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmPoolAdd"), 0, addAction));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            if (PolicyHandler.hasCopiedObject(ServerListObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.pmPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createAVScanPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.avScanAdd"), 0, addAction));
        }
        return task;
    }

    private List<TaskObject> createIPSPoolTask(Integer type) {
        boolean isIPSSignature = type == 65 || type == 66;
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            if (!isIPSSignature) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.idsPoolAddSystem"), 0, addAction));
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.idsPoolImport"), 1, importAction, null, this.getFileOpener(), true));
            } else {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.idsPoolAddCustom"), 0, addIPSCustomAction));
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.idsPoolImportCustom"), 1, importAction, null, this.getFileOpener(), true));
            }
        }
        if (!this.isReadOnly) {
            if (PolicyHandler.hasCopiedObject(Arrays.asList(IdsLibraryObject.class)) && isIPSSignature) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.idsPoolPaste"), 10, pasteAction));
            } else if (PolicyHandler.hasCopiedObject(Arrays.asList(IdsPolicyObject.class)) && !isIPSSignature) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.idsPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createMemPolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            boolean isTaskEnabled = true;
            String toolTipText = null;
            if (CloudUtil.isCloudMemPolicyInUse()) {
                isTaskEnabled = false;
                toolTipText = MSG_RES.getString(POLICY, "PolicyTask.cloudManagedTaskTooltip");
            }
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.memPoolAdd"), 0, addAction, null, null, isTaskEnabled, toolTipText));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.memPoolImport"), 1, importAction, null, this.getFileOpener(), isTaskEnabled, toolTipText));
            if (PolicyHandler.hasCopiedObject(MemPolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.memPoolPaste"), 10, pasteAction, null, null, isTaskEnabled, toolTipText));
            }
        }
        return task;
    }

    private List<TaskObject> createNtrPolicyPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            boolean isTaskEnabled = true;
            String toolTipText = null;
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.ntrPoolAdd"), 0, addAction, null, null, isTaskEnabled, toolTipText));
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.ntrPoolImport"), 1, importAction, null, this.getFileOpener(), isTaskEnabled, toolTipText));
            if (PolicyHandler.hasCopiedObject(NtrPolicyObject.class)) {
                task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.ntrPoolPaste"), 10, pasteAction));
            }
        }
        return task;
    }

    private List<TaskObject> createFileFingerprintPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.fingerprintPoolAdd"), 0, addAction));
        }
        return task;
    }

    private List<TaskObject> createHostGroupPoolTask() {
        ArrayList<TaskObject> tasks = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            tasks.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hostGroupAdd"), 0, addAction));
            tasks.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.hostGroupImport"), 1, importAction, null, this.getFileOpener(), true));
        }
        return tasks;
    }

    private List<TaskObject> createNetworkServicePoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.networkServicePoolAdd"), 0, addAction));
        }
        return task;
    }

    private List<TaskObject> createNetworkAdapterPoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.networkAdapterPoolAdd"), 0, addAction));
        }
        return task;
    }

    private List<TaskObject> createHardwareDevicePoolTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!this.isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.devicePoolAdd"), 0, addAction));
        }
        return task;
    }

    private List<TaskObject> createLearnedApplicationTask() {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        this.addLearnedApplicationTask(task);
        return task;
    }

    private List<TaskObject> addLearnedApplicationTask(List<TaskObject> task) {
        LicenseObject licenseObject = LicenseObject.getInstance();
        if (!licenseObject.isSNACOnlyProduct() && !licenseObject.isSBProduct()) {
            task.add(new TaskObject(MSG_RES.getString(POLICY, "PolicyTask.learnApp"), 14, learnedAction));
        }
        return task;
    }

    private void modifyTaskListBasedOnGroupRight(List<List<TaskObject>> tasks) {
        for (List<TaskObject> taskList : tasks) {
            Iterator<TaskObject> iterator = taskList.iterator();
            block4: while (iterator.hasNext()) {
                switch (iterator.next().getTaskIndex()) {
                    case 6: 
                    case 7: 
                    case 8: {
                        iterator.remove();
                        continue block4;
                    }
                }
            }
        }
    }

    protected PolicyObjectBase getSelectedPolicyObject() {
        Component component = this.panel.getCurrentTaskPanel();
        if (component instanceof PolicyPoolPane) {
            PolicyPoolPane policyPoolPane = (PolicyPoolPane)component;
            return policyPoolPane.getSelectedPolicyObj();
        }
        return null;
    }
}

