/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.ButtonEntry;
import com.sygate.scm.console.ui.policy.common.ExpandingTabPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;

public abstract class PolicyTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String autoProtectCommandText;
    public static final String TAB_BUTTON_UI_CLASS_ID = "TabButtonUI";
    protected BasePolicyDialog policyDialog;
    protected JPanel buttonGroupPanel;
    protected String iconFile;
    protected TabButton[] tabButtons;
    protected ArrayList<ButtonEntry> buttonList;
    protected String tabTitle;
    ExpandingTabPanel[] aps;
    JPanel[] panels;
    OuterPanel outerPanel = new OuterPanel();
    HashMap<String, Boolean> ids = new HashMap();

    public PolicyTabPanel(BasePolicyDialog policyDialog, String tabTitle, String iconFile) {
        this.policyDialog = policyDialog;
        this.iconFile = iconFile;
        this.buttonList = this.getButtonList();
        this.tabTitle = tabTitle;
        this.assembleTabPanels();
        this.assemblePanels();
        this.add(this.outerPanel.getComponent());
    }

    private void assembleTabPanels() {
        String[] tabNames = this.getParentButtonText();
        this.aps = new ExpandingTabPanel[this.ids.size()];
        String tabName = "";
        for (int tabCount = 0; tabCount < tabNames.length; ++tabCount) {
            tabName = tabNames[tabCount];
            this.aps[tabCount] = new ExpandingTabPanel(tabName, this.outerPanel, this.ids.get(tabName), this.buttonList.get(tabCount).isExpanded());
        }
    }

    private String[] getParentButtonText() {
        String[] tabNames = new String[this.buttonList.size()];
        Iterator<ButtonEntry> itr = this.buttonList.iterator();
        int count = 0;
        while (itr.hasNext()) {
            ButtonEntry buttonEntry = itr.next();
            if (buttonEntry.getSubButtonList() != null) {
                this.ids.put(buttonEntry.getButtonText(), true);
            } else {
                this.ids.put(buttonEntry.getButtonText(), false);
            }
            tabNames[count] = buttonEntry.getButtonText();
            ++count;
        }
        return tabNames;
    }

    protected abstract ArrayList<ButtonEntry> getButtonList();

    protected int getExpandedMenuIndex() {
        return 0;
    }

    protected boolean needTreeMenu() {
        return false;
    }

    protected JPanel getButtonsToGroupPanel(TabButton parentButton, ArrayList<ButtonEntry> buttonList, ButtonGroup buttonGroup) {
        HeaderLabel titleLabel = null;
        Iterator<ButtonEntry> itr = buttonList.iterator();
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalFlowLayout(0, 0, 0, false, false));
        if (parentButton == null) {
            Image selIcon = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(this.iconFile));
            titleLabel = new HeaderLabel(this.tabTitle, new ImageIcon(selIcon), 2);
            titleLabel.putClientProperty("cssClass", "policyTabPaneltitleLabel");
            panel.add(titleLabel);
        }
        while (itr.hasNext()) {
            ButtonEntry buttonEntry = itr.next();
            TabButton button = new TabButton(buttonEntry.getButtonText(), buttonEntry.getButtonIcon(), buttonEntry.getActionCommand(), buttonEntry.getTitle(), parentButton);
            button.setButtonGroup(buttonGroup);
            buttonGroup.add(button);
            panel.add(button);
            buttonGroup.setSelected(button.getModel(), buttonEntry.isDefault());
            ArrayList<ButtonEntry> subButtonList = buttonEntry.getSubButtonList();
            if (subButtonList == null) continue;
            button.putClientProperty("cssClass", "policyTabPanelMidNode");
            JPanel subGroupPanel = this.getButtonsToGroupPanel(button, subButtonList, buttonGroup);
            subGroupPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            button.setSubGroupPanel(subGroupPanel);
            panel.add(subGroupPanel);
        }
        Dimension dim = this.fitButtons(buttonGroup);
        this.setButtouGroupSize(buttonGroup, dim);
        if (parentButton != null) {
            parentButton.setSubButtonGroup(buttonGroup);
            parentButton.setSubGroupPanel(panel);
        }
        panel.putClientProperty("cssClass", "policyTabPanelMain");
        return panel;
    }

    protected Dimension fitButtons(ButtonGroup buttonGroup) {
        Dimension d = null;
        int width = 0;
        int height = 0;
        for (ExpandingTabPanel component : this.aps) {
            d = component.getPreferredSize();
            width = Integer.max(d.width, width);
            height = Integer.max(d.height, height);
        }
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            TabButton button = (TabButton)buttons.nextElement();
            d = button.getPreferredSize();
            width = Integer.max(d.width, width);
            height = Integer.max(d.height, height);
        }
        return new Dimension(width, height);
    }

    protected void setButtouGroupSize(ButtonGroup buttonGroup, Dimension dim) {
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            TabButton button = (TabButton)buttons.nextElement();
            button.setPreferredSize(dim);
        }
    }

    public JPanel getTopLabelPanel() {
        HtmlEnabledJLabel titleLabel = null;
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalFlowLayout(0, 0, 0, false, false));
        titleLabel = new HtmlEnabledJLabel(this.tabTitle, 2);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)titleLabel);
        panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIColorUtilities.CONTROL_BACKGROUND));
        panel.putClientProperty("cssClass", "policyTabPaneltopLabelPanel");
        return panel;
    }

    private void assemblePanels() {
        Iterator<ButtonEntry> itr = this.buttonList.iterator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.panels = new JPanel[this.buttonList.size()];
        int count = 0;
        while (itr.hasNext()) {
            TabButton button;
            ButtonEntry buttonEntry = itr.next();
            JPanel buttonPanel = new JPanel();
            buttonPanel.putClientProperty("cssClass", "policyTabPanelasswmpledButons");
            buttonPanel.setLayout(new VerticalFlowLayout(0, 0, 0, false, false));
            ArrayList<ButtonEntry> subButtonList = buttonEntry.getSubButtonList();
            if (subButtonList != null) {
                button = new TabButton(buttonEntry.getButtonText(), buttonEntry.getButtonIcon(), buttonEntry.getActionCommand(), buttonEntry.getTitle(), null);
                UIUtilities.setName(button, "policyPage", UIUtilities.ComponentType.BUTTON, buttonEntry.getButtonText());
                buttonGroup.add(button);
                buttonPanel = this.getButtonsToGroupPanel(button, subButtonList, buttonGroup);
            } else {
                button = new TabButton(buttonEntry.getButtonText(), buttonEntry.getButtonIcon(), buttonEntry.getActionCommand(), buttonEntry.getTitle(), null);
                UIUtilities.setName(button, "policyPage", UIUtilities.ComponentType.BUTTON, buttonEntry.getButtonText());
                button.setButtonGroup(buttonGroup);
                buttonGroup.add(button);
                buttonPanel.add(button);
                buttonGroup.setSelected(button.getModel(), buttonEntry.isDefault());
            }
            this.panels[count] = buttonPanel;
            ++count;
        }
        Dimension dim = this.fitButtons(buttonGroup);
        this.setButtouGroupSize(buttonGroup, dim);
    }

    static {
        UIDefaults uiDefaults = UIManager.getDefaults();
        uiDefaults.put(TAB_BUTTON_UI_CLASS_ID, TabButtonUI.class.getName());
        autoProtectCommandText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.FilesAndProcesses");
    }

    private class OuterPanel
    extends MouseAdapter {
        private OuterPanel() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ExpandingTabPanel ap = (ExpandingTabPanel)e.getSource();
            ap.toggleSelection();
            this.togglePanelVisibility(ap);
        }

        private void togglePanelVisibility(ExpandingTabPanel ap) {
            int index = this.getPanelIndex(ap);
            if (PolicyTabPanel.this.panels[index].isShowing()) {
                PolicyTabPanel.this.panels[index].setVisible(false);
            } else if (PolicyTabPanel.this.panels[index].getComponentCount() > 0 && !PolicyTabPanel.this.panels[index].isShowing()) {
                PolicyTabPanel.this.panels[index].setVisible(true);
            }
            ap.getParent().validate();
        }

        private int getPanelIndex(ExpandingTabPanel ap) {
            for (int j = 0; j < PolicyTabPanel.this.aps.length; ++j) {
                if (ap != PolicyTabPanel.this.aps[j]) continue;
                return j;
            }
            return -1;
        }

        private JPanel getComponent() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(1, 3, 0, 3);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            for (int j = 0; j < PolicyTabPanel.this.aps.length; ++j) {
                if (PolicyTabPanel.this.aps[j].isVisible()) {
                    panel.add((Component)PolicyTabPanel.this.aps[j], gbc);
                    panel.add((Component)PolicyTabPanel.this.panels[j], gbc);
                    if (PolicyTabPanel.this.aps[j].isExpanded()) {
                        PolicyTabPanel.this.panels[j].setVisible(true);
                        PolicyTabPanel.this.aps[j].setSelected(true);
                        continue;
                    }
                    PolicyTabPanel.this.panels[j].setVisible(false);
                    continue;
                }
                panel.add((Component)PolicyTabPanel.this.panels[j], gbc);
                PolicyTabPanel.this.panels[j].setVisible(true);
            }
            JLabel padding = new JLabel();
            gbc.weighty = 1.0;
            panel.add((Component)padding, gbc);
            panel.putClientProperty("cssClass", "policyTabPanelContaier");
            return panel;
        }
    }

    private static class ButtonListener
    extends BasicButtonListener {
        public ButtonListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            TabButton button = (TabButton)e.getSource();
            ButtonGroup buttonGroup = button.getButtonGroup();
            this.adjustSelection(buttonGroup, button);
            button.repaint();
        }

        public void adjustSelection(ButtonGroup buttonGroup, TabButton selectedButton) {
            Enumeration<AbstractButton> buttons = buttonGroup.getElements();
            TabButton button = null;
            while (buttons.hasMoreElements()) {
                button = (TabButton)buttons.nextElement();
                try {
                    this.setButtonSelection(buttonGroup, button, button == selectedButton);
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "IntrusionProtectionPanel.title.Error"), 0);
                    Manager.getFrame().showLoginPanel();
                }
            }
        }

        public void setButtonSelection(ButtonGroup buttonGroup, TabButton button, boolean selected) throws ConsoleException {
            try {
                if (selected) {
                    ButtonGroup subGroup;
                    this.setButtonSelected(buttonGroup, button);
                    if (button.getSubButtonGroup() == null) {
                        button.getPolicyDialog().setPolicyEditorPane(button.getTitle());
                    }
                    if ((subGroup = button.getSubButtonGroup()) != null) {
                        JPanel subPanel = button.getSubGroupPanel();
                        Component[] components = subPanel.getComponents();
                        for (int index = 0; index < components.length; ++index) {
                            TabButton subButton;
                            Component component = components[index];
                            if (!(component instanceof TabButton) || !autoProtectCommandText.equals((subButton = (TabButton)component).getActionCommand())) continue;
                            this.setButtonSelected(subGroup, subButton);
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new ConsoleException(ex);
            }
        }

        public void setButtonSelected(ButtonGroup buttonGroup, TabButton button) throws ConsoleException {
            try {
                buttonGroup.setSelected(button.getModel(), true);
                if (button.getSubButtonGroup() == null) {
                    button.getPolicyDialog().setPolicyEditorPane(button.getActionCommand());
                }
            }
            catch (Exception ex) {
                throw new ConsoleException(ex);
            }
        }
    }

    public static class TabButtonUI
    extends MetalButtonUI {
        public static ComponentUI createUI(JComponent component) {
            return new TabButtonUI();
        }

        @Override
        public void update(Graphics g, JComponent c) {
            super.update(g, c);
            TabButton button = (TabButton)c;
            ButtonGroup buttonGroup = button.getButtonGroup();
            ButtonModel model = button.getModel();
            Graphics2D g2d = (Graphics2D)g;
            int height = button.getHeight();
            Paint oldPaint = g2d.getPaint();
            Font oldFont = g2d.getFont();
            boolean isChildNode = button.isChildNode();
            int hTextOffset = 3;
            int hRectOffset = 0;
            if (buttonGroup.getSelection() == model) {
                g2d.setPaint(UIColorUtilities.DEFAULT_SELECTION_BACKGROUND);
            } else {
                g2d.setPaint(UIColorUtilities.DEFAULT_BACKGROUND);
            }
            g2d.fillRect(hRectOffset, 0, button.getWidth(), button.getHeight());
            if (!isChildNode && button.needTreeMenu() && !button.getText().equals(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Overview"))) {
                g2d.setPaint(UIColorUtilities.DEFAULT_BACKGROUND);
                g2d.fillRect(hRectOffset, 0, button.getWidth(), button.getHeight());
                g2d.setFont(button.getFont().deriveFont(1));
            }
            g2d.setPaint(UIColorUtilities.DEFAULT_FOREGROUND);
            g2d.drawString(button.getText(), hTextOffset, height / 2 + 5);
            g2d.setFont(oldFont);
            g2d.setPaint(oldPaint);
            Icon icon = button.getIcon();
            if (icon != null && icon.equals(UIUtilities.DEPRECATED_LINUX_ICON)) {
                icon.paintIcon(button, g2d, g2d.getFontMetrics().stringWidth(button.getText()) + 5, 2);
                button.setToolTipText(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP);
            }
        }

        @Override
        protected BasicButtonListener createButtonListener(AbstractButton b) {
            return new ButtonListener(b);
        }
    }

    private class TabButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private JPanel subGroupPanel;
        private ButtonGroup buttonGroup;
        private ButtonGroup subButtonGroup;
        private TabButton parentButton;
        private String title;

        public TabButton(String text, Icon icon, String actionCommand, String title, TabButton parentButton) {
            super(text, icon);
            if (actionCommand != null) {
                this.setActionCommand(actionCommand);
            } else {
                this.setActionCommand(text);
            }
            this.title = title != null ? title : text;
            this.parentButton = parentButton;
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setHorizontalTextPosition(4);
            this.setVerticalTextPosition(3);
            this.setRolloverEnabled(true);
            this.putClientProperty("cssClass", "tabButton");
            this.setFocusable(false);
        }

        @Override
        public String getUIClassID() {
            return PolicyTabPanel.TAB_BUTTON_UI_CLASS_ID;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public Insets getInsets() {
            return new Insets(0, 5, 0, 5);
        }

        @Override
        public void paintBorder(Graphics g) {
        }

        public void setButtonGroup(ButtonGroup buttonGroup) {
            this.buttonGroup = buttonGroup;
        }

        public ButtonGroup getButtonGroup() {
            return this.buttonGroup;
        }

        public TabButton getParentButton() {
            return this.parentButton;
        }

        public void setSubButtonGroup(ButtonGroup subButtonGroup) {
            this.subButtonGroup = subButtonGroup;
        }

        public ButtonGroup getSubButtonGroup() {
            return this.subButtonGroup;
        }

        public void setSubGroupPanel(JPanel subGroupPanel) {
            this.subGroupPanel = subGroupPanel;
        }

        public JPanel getSubGroupPanel() {
            return this.subGroupPanel;
        }

        public boolean isChildNode() {
            boolean isChildNode = false;
            if (this.getParentButton() != null && this.getParentButton().getParentButton() != null) {
                isChildNode = true;
            }
            return isChildNode;
        }

        public boolean needTreeMenu() {
            return PolicyTabPanel.this.needTreeMenu();
        }

        public BasePolicyDialog getPolicyDialog() {
            return PolicyTabPanel.this.policyDialog;
        }
    }

    public static class HeaderLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public HeaderLabel(String tabTitle, ImageIcon imageIcon, int left) {
            super(tabTitle, imageIcon, left);
        }
    }
}

