/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ExportedPackage;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.Communication;
import com.sygate.scm.common.configobject.schema.ExternalCommunication;
import com.sygate.scm.common.configobject.schema.LuContentSelection;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.configobject.schema.SourceInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.CloudPolicyHandler;
import com.sygate.scm.console.handler.HTMLTemp.PolicyTemp;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.AutoLocationObject;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.PolicyReferenceObject;
import com.sygate.scm.console.logicobject.UserInterfaceObject;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.client.ClientPanel;
import com.sygate.scm.console.ui.client.ClientTaskPanel;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.HistoryPane;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.AbsPolicyEditorDlg;
import com.sygate.scm.console.ui.policy.dialog.AddMorePolicyDlg;
import com.sygate.scm.console.ui.policy.dialog.AgentGUIDlg;
import com.sygate.scm.console.ui.policy.dialog.ClientPasswordSettingsDlg;
import com.sygate.scm.console.ui.policy.dialog.CommunicationDlg;
import com.sygate.scm.console.ui.policy.dialog.ControlModeDlg;
import com.sygate.scm.console.ui.policy.dialog.ExternalCommunicationDlg;
import com.sygate.scm.console.ui.policy.dialog.GlobalSettingDlg;
import com.sygate.scm.console.ui.policy.dialog.LocationHandler;
import com.sygate.scm.console.ui.policy.dialog.LocationSettingDlg;
import com.sygate.scm.console.ui.policy.dialog.LocationWizardDialog;
import com.sygate.scm.console.ui.policy.dialog.PolicyDialog;
import com.sygate.scm.console.ui.policy.dialog.PolicySelectDlg;
import com.sygate.scm.console.ui.policy.dialog.PolicyType;
import com.sygate.scm.console.ui.policy.lu.LuContentPolicySelectDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.MessageHandler;
import com.sygate.scm.console.util.TopicEvent;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class PolicySummaryPane
extends JPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.policy");
    private static final String USE_SHARE = MSGRES.getString("PolicySummaryPane.switchToPolicyInLibraryMsg");
    private static final String USE_OTHER_SHARE = MSGRES.getString("PolicySummaryPane.switchToOtherPolicyMsg");
    private static final String EDIT_POLICY_ITEM = MSGRES.getString("PolicySummaryPane.editPolicyMenu");
    private static final String VIEW_POLICY_ITEM = MSGRES.getString("PolicySummaryPane.viewPolicyMenu");
    private static final String EDIT_POLICY_TITLE = MSGRES.getString("PolicySummaryPane.editTitle");
    private static final String VIEW_POLICY_TITLE = MSGRES.getString("PolicySummaryPane.viewTitle");
    private static final String EDIT_SHARED_BUTTON = MSGRES.getString("PolicySummaryPane.option.editShared");
    private static final String VIEW_SHARED_BUTTON = MSGRES.getString("PolicySummaryPane.option.viewShared");
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private GroupPolicyObject gpObj;
    private String oldSemGroupPolicyID;
    private final JEditorPane mainPane = new HTMLEditorPane(this);
    private URL baseURL = null;
    private HistoryPane hisPane = null;
    private int x;
    private int y;
    private final JPopupMenu comPMenu = new JPopupMenu();
    private final JCheckBoxMenuItem comMenuItem = new JCheckBoxMenuItem(MSGRES.getString("PolicySummaryPane.userGroupCommunicationSettingMenu"));
    private final JPopupMenu externalCommunicationPMenu = new JPopupMenu();
    private final JCheckBoxMenuItem externalCommunicationMenuItem = new JCheckBoxMenuItem(MSGRES.getString("PolicySummaryPane.userGroupExternalCommunicationSettingMenu"));
    private final JPopupMenu controlMenu = new JPopupMenu();
    private final JPopupMenu moreOptionPMenu = new JPopupMenu();
    private final JMenuItem useLocalItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.switchToLocalPolicyMenu"));
    private final JMenuItem useSharedItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.switchToPolicyInLibraryMenu"));
    private final JMenuItem editPolicyItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.editPolicyMenu"));
    private final JMenuItem removePolicyItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.removePolicyMenu"));
    private final JMenuItem copyPolicyItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.copyMenu"));
    private final JMenuItem pastePolicyItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.pasteMenu"));
    private final JMenuItem exportPolicyItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.exportPolicyMenu"));
    private final JMenuItem comEditSettingsItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.editSettingsMenu"));
    private final JMenuItem externalComEditSettingsItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.editSettingsMenu"));
    private final JMenuItem controlEditSettingsItem = new JMenuItem(MSGRES.getString("PolicySummaryPane.editSettingsMenu"));
    private TopLevelObject curPolicyObj = null;
    private String curEditorType;
    private String curPolicyTypeName;
    private LocationObject curLocObj;
    private boolean curPolicyIsLocal = false;
    private String currentLocId = null;
    private URL currURL = null;
    private JPopupMenu pmenuToShow = null;
    public boolean isPolicyPoolEdited = false;
    private final PolicyTemp myTemplateObj = new PolicyTemp();
    private final Map<String, PolicyTemp.ExpandStatus> statusMap = new HashMap<String, PolicyTemp.ExpandStatus>();
    private JPanel inheritPane;
    private final JCheckBox inheritCbx = new JCheckBox();
    private final HtmlEnabledJLabel inheritStatLbl = new HtmlEnabledJLabel();
    private static final String EDIT_LOCATION = "edit_location";
    private static final String ADVANCED_SETTING = "advance_setting";
    private static final String SECURITY_SETTING = "security_setting";
    private static final String INHERITCOM = "inheritcom";
    private static final String INHERITEXTERNALCOM = "inheritexternalcom";
    private static final String CONTROL_SETTING = "control_setting";
    private static final String COMMUNICATION = "communication";
    private static final String EXTERNAL_COMMUNICATION = "external_communication";
    private static final String SUBMISSIONS = "submissions";
    private static final String EDIT_MODE = "edit_mode";
    private static final String ADD_MORE_POLICY = "add_more_policy";
    private static final String EDIT_POLICY = "edit_policy";
    private static final String MORE_OPTIONS = "more_options";
    private static final String LOC_EXPAND = "loc_expand";
    private static final String LUCONTENTPOLICY = "lucontentpolicy";

    public PolicySummaryPane(HistoryPane historyPane) {
        this.hisPane = historyPane;
        try {
            this.jbInit();
            this.baseURL = new URL("jarex", "", -1, "group_3.gif", new JarExStreamHandler());
        }
        catch (MalformedURLException e) {
            this.baseURL = ConsoleMain.class.getResource("group_3.gif");
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.mainPane.setEditable(false);
        this.mainPane.setContentType("text/html");
        this.mainPane.putClientProperty("cssClass", "policySummMainPanelContainer");
        this.mainPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                PolicySummaryPane.this.this_mouseClicked(event);
            }
        });
        this.inheritPane = new JPanel();
        this.inheritPane.putClientProperty("cssClass", "policySummInheritPane");
        this.inheritPane.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.mainPane);
        scrollPane.putClientProperty("cssClass", "policySummScrollPane");
        JPanel topPanel = new JPanel();
        topPanel.putClientProperty("cssClass", "policySummTopPanel");
        this.inheritPane.add((Component)this.inheritStatLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.inheritPane.add((Component)this.inheritCbx, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 0), 0, 0));
        topPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)this.inheritPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollTopPane = new JScrollPane(topPanel);
        scrollTopPane.putClientProperty("cssClass", "policySummScrollTopPanel");
        scrollTopPane.setBorder(null);
        this.add((Component)scrollTopPane, "North");
        this.add((Component)scrollPane, "Center");
        this.comPMenu.add(this.comMenuItem);
        this.comMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.comSettingChanged();
            }
        });
        this.comPMenu.add(this.comEditSettingsItem);
        this.comEditSettingsItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    PolicySummaryPane.this.editCommunication(PolicySummaryPane.this.currentLocId, null);
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        });
        this.externalCommunicationPMenu.add(this.externalCommunicationMenuItem);
        this.externalCommunicationMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.externalComSettingChanged();
            }
        });
        this.externalCommunicationPMenu.add(this.externalComEditSettingsItem);
        this.externalComEditSettingsItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    PolicySummaryPane.this.editExternalCommunication(PolicySummaryPane.this.currentLocId, null);
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        });
        this.controlMenu.add(this.controlEditSettingsItem);
        this.controlEditSettingsItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (PolicySummaryPane.this.currURL != null) {
                        PolicySummaryPane.this.editControlMode(PolicySummaryPane.this.currURL);
                    }
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        });
        this.useSharedItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.changeToSharedPolicy();
            }
        });
        this.useLocalItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.changeToLocalPolicy();
            }
        });
        this.editPolicyItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.editPolicy();
            }
        });
        this.removePolicyItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.removePolicy();
            }
        });
        this.exportPolicyItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicySummaryPane.this.exportPolicy();
            }
        });
        this.copyPolicyItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.copyPolicy();
                if (MainPanel.getCurrentPanel() != null) {
                    MainPanel.getCurrentPanel().refresh();
                }
            }
        });
        this.pastePolicyItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.pasteSharedPolicy();
            }
        });
        this.inheritCbx.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicySummaryPane.this.inheritChanged();
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        block37: {
            try {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block37;
                URL url = e.getURL();
                String ref = url.getRef();
                System.out.println("Reference link :::::::::::::::: " + ref);
                String query = url.getQuery();
                if (query != null) {
                    try {
                        query = URLDecoder.decode(query, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ue) {
                        LoggerUtilities.logException((Throwable)ue);
                    }
                }
                if (ref != null) {
                    if (this.isCurrentGroupPolicyChanged()) {
                        return;
                    }
                    if (EDIT_LOCATION.equals(ref = ref.toLowerCase())) {
                        this.editLocation(e.getURL());
                    } else if (ADVANCED_SETTING.equals(ref)) {
                        this.setGroupSetting(query);
                    } else if (SECURITY_SETTING.equals(ref)) {
                        this.showClientSecuritySettings();
                    } else if (INHERITCOM.equals(ref)) {
                        this.showInheritCommunicationMenu(query);
                    } else if (INHERITEXTERNALCOM.equals(ref)) {
                        this.showInheritExternalCommunicationMenu(query);
                    } else if (CONTROL_SETTING.equals(ref)) {
                        this.showControlSettingsMenu(url);
                    } else if (COMMUNICATION.equals(ref)) {
                        this.editCommunication(query, null);
                    } else if (EXTERNAL_COMMUNICATION.equals(ref)) {
                        this.editExternalCommunication(query, null);
                    } else if (SUBMISSIONS.equals(ref)) {
                        this.editExternalCommunication(query, SUBMISSIONS);
                    } else if (EDIT_MODE.equals(ref)) {
                        this.editControlMode(url);
                    } else if (ADD_MORE_POLICY.equals(ref)) {
                        this.addMorePolicy(url);
                    } else if (EDIT_POLICY.equals(ref)) {
                        this.editPolicy(url);
                    } else if (MORE_OPTIONS.equals(ref)) {
                        this.showMoreOptionMenu(url);
                    } else if (LOC_EXPAND.equals(ref)) {
                        this.expandLocation(query);
                    } else if (LUCONTENTPOLICY.equals(ref)) {
                        this.editLuContentSetting();
                    } else {
                        JOptionPane.showMessageDialog(this, MSGRES.getString("PolicySummaryPane.notImplementedYetMsg"), MSGRES.getString("PolicySummaryPane.notImplementYetMsg"), -1);
                    }
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.consoleErrorMsg"), 0);
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void editLocations() throws ConsoleException {
        LocationSettingDlg dlg = new LocationSettingDlg(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.adaptivePolicyMsg"), true, true);
        dlg.setObject(this.gpObj);
        if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
            dlg.setReadOnly(this.gpObj.isInherit());
        }
        dlg.setVisible(true);
        if (dlg.isOk()) {
            this.saveData();
        }
    }

    public void addLocation() throws ConsoleException {
        if (this.gpObj.isInherit()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.locationCannotBeAddedToMsg"), MSGRES.getString("PolicySummaryPane.warningMsg"), 2);
        } else {
            LocationHandler.getInstance().setGroupObj(this.gpObj.getGroupObject());
            LocationWizardDialog dlg = new LocationWizardDialog();
            if (dlg.isOk()) {
                GroupPolicyObject newgpObj;
                LocationObject locObj = LocationHandler.getInstance().getLocObj();
                GroupObject grpObj = LocationHandler.getInstance().getGroupObj();
                this.gpObj = newgpObj = PolicyHandler.getGroupPolicyByGroup(grpObj);
                AutoLocationObject autoLocObj = this.gpObj.getAutoLocation();
                this.gpObj.copyAppliedPoliciesToLocation(this.gpObj.getDefaultLocationAppliedPolicy(), locObj);
                autoLocObj.addANewLocation(locObj);
                this.gpObj.setAutoLocation(autoLocObj);
                PolicyHandler.updateGroupPolicy(this.gpObj);
                String sname = "";
                sname = grpObj.getName().length() > 64 ? UIUtilities.wrapString(64, grpObj.getName()) : grpObj.getName();
                Object[] obj = new Object[]{locObj.getName(), sname};
                String str = MSGRES.getString("PolicySummaryPane.locationHasBeenAddedToMsg");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(this, fm, MSGRES.getString("PolicySummaryPane.locationAddedMsg"), -1);
                this.refreshHtmlPage();
                if (this.hisPane != null) {
                    this.hisPane.updatePanel();
                }
                int len = this.mainPane.getDocument().getLength();
                this.mainPane.setCaretPosition(len);
            }
            LocationHandler.getInstance().clearData();
        }
    }

    protected void pasteSharedPolicy() {
        if (this.curLocObj == null || this.curEditorType == null || this.curPolicyTypeName == null || this.curPolicyObj == null) {
            return;
        }
        AppliedPolicyObject appliedObj = this.curLocObj.getAppliedPolicyObject();
        PolicyInt policyObj = PolicyIntObjectBase.getPolicyObject(this.curPolicyTypeName);
        boolean isQuaratine = PolicyType.isQuaratinePolicy(this.curPolicyTypeName);
        PolicyReferenceObject copiedPolicy = PolicyHandler.getCopiedPolicy();
        if (copiedPolicy != null) {
            int result;
            if (appliedObj.hasSameTypePolicy(copiedPolicy, isQuaratine) && (result = JOptionPane.showConfirmDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.thePastedPolicyWillOverwriteMsg"), MSGRES.getString("PolicySummaryPane.pastePolicyMsg"), 0)) != 0) {
                this.curLocObj = null;
                this.curEditorType = null;
                this.curPolicyTypeName = null;
                this.curPolicyObj = null;
                return;
            }
            try {
                boolean appliedFine = appliedObj.pastePolicy(copiedPolicy, isQuaratine);
                if (appliedFine && policyObj != null) {
                    this.curLocObj.setAppliedPolicyObject(appliedObj);
                    this.gpObj.addNewObjSet(this.curLocObj.getNewObjSet());
                    this.gpObj.addChangedObjSet(this.curLocObj.getChangedObjSet());
                    this.gpObj.addDeletedObjSet(this.curLocObj.getDeletedObj());
                    this.gpObj.addLogList(this.curLocObj.getLogList());
                    this.gpObj.setPhysicalFileObject(appliedObj.getPhysicalFileObject());
                    this.curLocObj.clearAllObjSets();
                    String typeDesc = policyObj.getTypeDesc();
                    PolicyInt copiedPolicyObj = PolicyIntObjectBase.getPolicyObject(copiedPolicy.getAppliedPolicy().getName());
                    if (copiedPolicyObj != null) {
                        typeDesc = copiedPolicyObj.getTypeDesc();
                    }
                    Object[] obj = new Object[]{typeDesc, this.curLocObj.getName()};
                    String str = null;
                    str = !LicenseObject.getInstance().isSBProduct() ? MSGRES.getString("PolicySummaryPane.pasteAtMsg") : MSGRES.getString("PolicySummaryPane.pasteAtMsgSB");
                    String fm = MessageFormat.format(str, obj);
                    this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
                    this.saveData();
                }
            }
            catch (GUICheckException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage());
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage());
                Manager.getFrame().showLoginPanel();
            }
        }
        this.curLocObj = null;
        this.curEditorType = null;
        this.curPolicyTypeName = null;
        this.curPolicyObj = null;
    }

    protected void copyPolicy() {
        if (this.curLocObj == null || this.curEditorType == null || this.curPolicyTypeName == null || this.curPolicyObj == null) {
            return;
        }
        PolicyInt policyObj = PolicyIntObjectBase.getPolicyObject(this.curPolicyTypeName);
        if (policyObj != null) {
            policyObj.setSchemaObj(this.curPolicyObj);
            AppliedPolicyObject appliedObj = this.curLocObj.getAppliedPolicyObject();
            ObjReference appliedPolicy = appliedObj.getAppliedReferenceOfPolicy(policyObj);
            ObjReference localPolicy = appliedObj.getAppliedLocalReferenceOfPolicy(policyObj);
            PolicyHandler.copyPolicy(appliedPolicy, localPolicy, policyObj);
        }
        this.curLocObj = null;
        this.curEditorType = null;
        this.curPolicyTypeName = null;
        this.curPolicyObj = null;
    }

    protected void removePolicy() {
        if (this.curLocObj == null || this.curEditorType == null || this.curPolicyTypeName == null || this.curPolicyObj == null) {
            return;
        }
        PolicyInt policyObj = PolicyIntObjectBase.getPolicyObject(this.curPolicyTypeName);
        try {
            if (policyObj != null) {
                Object[] choice = new String[]{MSGRES.getString("PolicySummaryPane.YesLabel"), MSGRES.getString("PolicySummaryPane.NoLabel")};
                String action = MSGRES.getString("PolicySummaryPane.withdraw");
                if (!PolicyType.isQuaratinePolicy(this.curPolicyTypeName)) {
                    String infoString = "";
                    if (this.curPolicyObj instanceof LuPolicy) {
                        infoString = MSGRES.getString("PolicySummaryPane.cannotWithrawLU");
                        JOptionPane.showMessageDialog(Manager.getFrame(), infoString, MSGRES.getString("PolicySummaryPane.InfoDlgTitle"), 0);
                        return;
                    }
                    if (this.curPolicyObj instanceof AvPolicy) {
                        infoString = MSGRES.getString("PolicySummaryPane.cannotWithrawAV");
                        JOptionPane.showMessageDialog(Manager.getFrame(), infoString, MSGRES.getString("PolicySummaryPane.InfoDlgTitle"), 0);
                        return;
                    }
                    if (this.curPolicyObj instanceof MemPolicy) {
                        infoString = MSGRES.getString("PolicySummaryPane.cannotWithrawMEM");
                        JOptionPane.showMessageDialog(Manager.getFrame(), infoString, MSGRES.getString("PolicySummaryPane.InfoDlgTitle"), 0);
                        return;
                    }
                }
                Object[] obj = new Object[]{action, policyObj.getTypeDesc()};
                String str = MSGRES.getString("PolicySummaryPane.youAreAboutRemoveMsg");
                if (this.curPolicyIsLocal) {
                    str = MSGRES.getString("PolicySummaryPane.youAreAboutRemoveLocalMsg");
                }
                String fm = MessageFormat.format(str, obj);
                int result = JOptionPane.showOptionDialog(Manager.getFrame(), fm, MSGRES.getString("PolicySummaryPane.removePolicyMsg"), 0, 3, null, choice, choice[1]);
                if (result == 0) {
                    int i;
                    AppliedPolicyObject appliedObj = this.curLocObj.getAppliedPolicyObject();
                    Vector o1 = appliedObj.getAppliedPolicyArray().getObjReference();
                    for (i = 0; i < o1.size(); ++i) {
                        System.out.println("Before: " + i + ":  " + ((ObjReference)o1.get(i)).getName() + "  " + ((ObjReference)o1.get(i)).getTargetType());
                    }
                    policyObj.setSchemaObj(this.curPolicyObj);
                    appliedObj.removePolicy(policyObj, true);
                    o1 = appliedObj.getAppliedPolicyArray().getObjReference();
                    for (i = 0; i < o1.size(); ++i) {
                        System.out.println("After: " + i + ":  " + ((ObjReference)o1.get(i)).getName() + "  " + ((ObjReference)o1.get(i)).getTargetType());
                    }
                    this.curLocObj.setAppliedPolicyObject(appliedObj);
                    this.gpObj.addChangedObjSet(this.curLocObj.getChangedObjSet());
                    this.gpObj.addNewObjSet(this.curLocObj.getNewObjSet());
                    this.gpObj.addDeletedObjSet(this.curLocObj.getDeletedObjSet());
                    this.gpObj.addLogList(this.curLocObj.getLogList());
                    this.gpObj.setPhysicalFileObject(appliedObj.getPhysicalFileObject());
                    this.curLocObj.clearAllObjSets();
                    this.saveData();
                }
            }
            this.curLocObj = null;
            this.curEditorType = null;
            this.curPolicyTypeName = null;
            this.curPolicyObj = null;
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.errorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    protected void changeToLocalPolicy() {
        block9: {
            if (this.curLocObj == null || this.curEditorType == null || this.curPolicyTypeName == null || this.curPolicyObj == null) {
                return;
            }
            try {
                AppliedPolicyObject appliedObj = this.curLocObj.getAppliedPolicyObject();
                PolicyInt policyObj = PolicyIntObjectBase.getPolicyObject(this.curPolicyTypeName);
                TopLevelObject locPolicyObj = null;
                if (policyObj != null) {
                    locPolicyObj = appliedObj.getLocalSchemaOfPolicy(policyObj);
                }
                if (locPolicyObj == null) {
                    AbsPolicyEditorDlg policyEditor = BasePolicyDialog.getEditor(this.curLocObj.getName(), this.curPolicyTypeName, this.gpObj, true);
                    if (policyEditor != null) {
                        AppliablePolicyPool pool = PolicyType.getObjectPool(this.curPolicyTypeName);
                        PolicyInt newObj = policyEditor.createNewPolicy(pool);
                        policyEditor.setVisible(true);
                        if (policyEditor.isOk()) {
                            appliedObj.addNewLocalPolicy(newObj);
                            this.curLocObj.setAppliedPolicyObject(appliedObj);
                            this.gpObj.addNewObjSet(this.curLocObj.getNewObjSet());
                            this.gpObj.addChangedObjSet(this.curLocObj.getChangedObjSet());
                            this.gpObj.addDeletedObjSet(this.curLocObj.getDeletedObjSet());
                            this.gpObj.addLogList(this.curLocObj.getLogList());
                            this.curLocObj.clearAllObjSets();
                            this.saveData();
                        }
                    }
                } else {
                    boolean changed = appliedObj.switchToLocalPolicy(policyObj, locPolicyObj);
                    if (changed) {
                        this.curLocObj.setAppliedPolicyObject(appliedObj);
                        this.gpObj.addNewObjSet(this.curLocObj.getNewObjSet());
                        this.gpObj.addChangedObjSet(this.curLocObj.getChangedObjSet());
                        this.gpObj.addDeletedObjSet(this.curLocObj.getDeletedObjSet());
                        this.gpObj.addLogList(this.curLocObj.getLogList());
                        this.curLocObj.clearAllObjSets();
                        this.saveData();
                    }
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.errorMsg"), 0);
                if (!ex.needRelogin()) break block9;
                Manager.getFrame().showLoginPanel();
            }
        }
        this.curLocObj = null;
        this.curEditorType = null;
        this.curPolicyTypeName = null;
        this.curPolicyObj = null;
    }

    protected void changeToSharedPolicy() {
        if (this.curLocObj == null || this.curEditorType == null || this.curPolicyTypeName == null || this.curPolicyObj == null) {
            return;
        }
        try {
            PolicySelectDlg dlg = (PolicySelectDlg)PolicySelectDlg.getSelectDlg(this.curPolicyTypeName, this.gpObj.getGroupName(), this.curLocObj.getName(), ((NamedObject)this.curPolicyObj).getName());
            if (dlg != null) {
                if (dlg.getPolicyList().getItemCount() == 0) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.noSharedPolicy"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.error"), 0);
                    return;
                }
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    AppliedPolicyObject appliedObj = this.curLocObj.getAppliedPolicyObject();
                    PolicyInt policyObj = PolicyIntObjectBase.getPolicyObject(this.curPolicyTypeName);
                    policyObj.setSchemaObj(this.curPolicyObj);
                    appliedObj.removeLocalPolicy(policyObj, true);
                    PolicyInt newPolicy = (PolicyInt)((Object)dlg.getSelectedObject());
                    appliedObj.setPolicy(newPolicy, true);
                    this.curLocObj.setAppliedPolicyObject(appliedObj);
                    this.gpObj.addChangedObjSet(this.curLocObj.getChangedObjSet());
                    this.gpObj.addNewObjSet(this.curLocObj.getNewObjSet());
                    this.gpObj.addDeletedObjSet(this.curLocObj.getDeletedObj());
                    this.gpObj.addLogList(this.curLocObj.getLogList());
                    this.curLocObj.clearAllObjSets();
                    this.saveData();
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.errorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
        this.curLocObj = null;
        this.curEditorType = null;
        this.curPolicyTypeName = null;
        this.curPolicyObj = null;
    }

    protected void exportPolicy() {
        if (this.curLocObj == null || this.curEditorType == null || this.curPolicyTypeName == null || this.curPolicyObj == null) {
            return;
        }
        if ("OpAppProtectionPolicy".equals(this.curEditorType)) {
            ExportedPackage exportedPackage = new ExportedPackage("sygate.spm.osp.policy", "1.0");
            PolicyHandler.exportPolicy((ConfigObject)this.curPolicyObj, ((NamedObject)this.curPolicyObj).getName(), exportedPackage);
        } else {
            PolicyHandler.exportPolicy((ConfigObject)this.curPolicyObj, ((NamedObject)this.curPolicyObj).getName());
        }
    }

    void comSettingChanged() {
        if (this.isReadOnlyGroup()) {
            Object[] obj = new Object[]{this.gpObj.getGroupName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.cantChangeCommunication");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.errorMsg"), 0);
            return;
        }
        try {
            AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
            LocationObject locObj = autoLoc.getLocation(this.currentLocId);
            if (locObj == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
                return;
            }
            boolean isGlobal = this.comMenuItem.getState();
            Object[] obj = new Object[]{locObj.getName()};
            String str = MSGRES.getString("PolicySummaryPane.changedCommunicationSettingMsg");
            String fm = MessageFormat.format(str, obj);
            if (!isGlobal) {
                CommunicationObject comObj = this.gpObj.getCommunicationObject();
                CommunicationObject newObj = comObj.getClone();
                try {
                    WashIDHandler washer = new WashIDHandler();
                    HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
                    Communication newComObj = (Communication)washer.duplicateObject((ConfigObject)newObj.getCommunication(), createdObj);
                    newComObj.setOptDownloadProfile(Boolean.TRUE);
                    locObj.setCommunication(new CommunicationObject(newComObj));
                }
                catch (Exception e) {
                    throw new ConsoleException(e);
                }
                SemLocationConfig locConfig = locObj.getSemLocationConfigObj();
                if (locConfig != null) {
                    this.gpObj.addChangedObject((TopLevelObject)locConfig);
                }
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
            } else {
                locObj.setCommunication(null);
                SemLocationConfig locConfig = locObj.getSemLocationConfigObj();
                if (locConfig != null) {
                    this.gpObj.addChangedObject((TopLevelObject)locConfig);
                }
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
            }
            this.saveData();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.consoleErrorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void externalComSettingChanged() {
        if (this.isReadOnlyGroup()) {
            Object[] obj = new Object[]{this.gpObj.getGroupName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.cantChangeExternalCommunication");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.errorMsg"), 0);
            return;
        }
        try {
            AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
            LocationObject locObj = autoLoc.getLocation(this.currentLocId);
            if (locObj == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
                return;
            }
            boolean isGlobal = this.externalCommunicationMenuItem.getState();
            Object[] obj = new Object[]{locObj.getName()};
            String str = MSGRES.getString("PolicySummaryPane.changedCommunicationSettingMsg");
            String fm = MessageFormat.format(str, obj);
            if (!isGlobal) {
                ExternalCommunicationObject comObj = this.gpObj.getExternalCommunicationObject();
                ExternalCommunicationObject newObj = comObj.getClone();
                try {
                    WashIDHandler washer = new WashIDHandler();
                    HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
                    ExternalCommunication newComObj = (ExternalCommunication)washer.duplicateObject((ConfigObject)newObj.getExternalCommunication(), createdObj);
                    locObj.setExternalCommunication(new ExternalCommunicationObject(newComObj));
                }
                catch (Exception e) {
                    throw new ConsoleException(e);
                }
                SemLocationConfig locConfig = locObj.getSemLocationConfigObj();
                if (locConfig != null) {
                    this.gpObj.addChangedObject((TopLevelObject)locConfig);
                }
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
            } else {
                locObj.setExternalCommunication(null);
                SemLocationConfig locConfig = locObj.getSemLocationConfigObj();
                if (locConfig != null) {
                    this.gpObj.addChangedObject((TopLevelObject)locConfig);
                }
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
            }
            this.saveData();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.consoleErrorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inheritChanged() {
        if (this.isReadOnlyGroup()) {
            Object[] obj = new Object[]{this.gpObj.getGroupName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.cantChangeInheritance");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.errorMsg"), 0);
            return;
        }
        Cursor curCursor = Manager.getFrame().getCursor();
        try {
            int ret;
            boolean toInherit;
            if (this.isCurrentGroupPolicyChanged()) {
                return;
            }
            boolean bl = toInherit = !this.gpObj.isInherit();
            if (toInherit && (ret = JOptionPane.showConfirmDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.theParentPolicyAutomaticallyOverwritesMsg"), MSGRES.getString("PolicySummaryPane.confirmPolicyOverwrite"), 0)) != 0) {
                this.inheritCbx.setSelected(false);
                return;
            }
            boolean changed = this.gpObj.setInherit(toInherit);
            if (changed) {
                Manager.getFrame().setCursor(WAIT_CURSOR);
                PolicyHandler.resetCopyOfAgentPolicy(this.gpObj);
                this.gpObj.addLog(2, this.gpObj.getId(), MSGRES.getString("PolicySummaryPane.inheritanceStatusChangedMsg"));
                this.setInheritanceStatus();
                this.updateMoreOptionMenu();
                this.saveData();
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.consoleErrorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
        finally {
            Manager.getFrame().setCursor(curCursor);
        }
    }

    protected void editPolicy() {
        if (this.curLocObj == null || this.curEditorType == null || this.curPolicyTypeName == null || this.curPolicyObj == null) {
            return;
        }
        boolean isCopiedToLocal = false;
        HashMap<String, TopLevelObject> newObjs = new HashMap<String, TopLevelObject>();
        AppliablePolicyPool pool = null;
        LicenseObject licenseObject = LicenseObject.getInstance();
        GUID domainId = new GUID(Manager.getCurrentDomainId());
        try {
            AbsPolicyEditorDlg dlg;
            block38: {
                block39: {
                    block37: {
                        dlg = null;
                        if (!this.curPolicyIsLocal) break block37;
                        dlg = BasePolicyDialog.getEditor(this.curLocObj.getName(), this.curPolicyTypeName, this.gpObj, true);
                        break block38;
                    }
                    Method method = this.curPolicyObj.getClass().getMethod("getSourceInfo", new Class[0]);
                    Vector sources = (Vector)method.invoke((Object)this.curPolicyObj, new Object[0]);
                    boolean exclusiveEdit = false;
                    for (int i = sources.size() - 1; i >= 0; --i) {
                        SourceInfo source = (SourceInfo)sources.get(i);
                        if (!Boolean.TRUE.equals(source.getOptexclusiveEdit())) continue;
                        exclusiveEdit = true;
                        break;
                    }
                    if (this.gpObj.isInherit() || this.isReadOnlyGroup() || licenseObject.isSBProduct() || exclusiveEdit) break block39;
                    String buttonText = this.gpObj.isPolicyEditable(!this.curPolicyIsLocal) ? EDIT_SHARED_BUTTON : VIEW_SHARED_BUTTON;
                    Object[] options = new String[]{buttonText, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.option.createLocal"), UIText.get(512)};
                    String title = this.gpObj.isPolicyEditable(!this.curPolicyIsLocal) ? EDIT_POLICY_TITLE : VIEW_POLICY_TITLE;
                    int retCode = JOptionPane.showOptionDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.editMsg"), title, 1, 1, null, options, options[0]);
                    switch (retCode) {
                        case 1: {
                            isCopiedToLocal = true;
                            this.curPolicyObj = (TopLevelObject)new WashIDHandler().duplicateObject((ConfigObject)this.curPolicyObj, newObjs);
                            this.curPolicyIsLocal = true;
                            dlg = BasePolicyDialog.getEditor(this.curLocObj.getName(), this.curPolicyTypeName, this.gpObj, true);
                            if (dlg instanceof BasePolicyDialog) {
                                dlg.setPolicyIsNonShared(this.curPolicyIsLocal);
                                break;
                            }
                            break block38;
                        }
                        case 0: {
                            pool = PolicyType.getObjectPool(this.curEditorType);
                            dlg = BasePolicyDialog.getEditor(pool, this.curPolicyTypeName);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    break block38;
                }
                pool = PolicyType.getObjectPool(this.curEditorType);
                dlg = BasePolicyDialog.getEditor(pool, this.curPolicyTypeName);
            }
            if (dlg != null) {
                PolicyInt newPolicyObj = null;
                if (this.curPolicyIsLocal && isCopiedToLocal) {
                    newPolicyObj = dlg.createNewPolicy(this.curPolicyObj);
                } else {
                    if (dlg instanceof BasePolicyDialog) {
                        dlg.setPolicyIsNonShared(this.curPolicyIsLocal);
                    }
                    TopLevelObject copyOfTopLevelObject = (TopLevelObject)PolicyHandler.getCopyOfObj((ConfigObject)this.curPolicyObj);
                    newPolicyObj = dlg.createNewPolicy(copyOfTopLevelObject);
                }
                boolean isCloudMemPolicy = false;
                if (this.curPolicyTypeName.equals("MemPolicyApplied")) {
                    isCloudMemPolicy = CloudPolicyHandler.getInstance().isCloudPolicy(this.gpObj.getClientGroup(), domainId, "MemPolicy", ConstantValue.CLOUD_POLICY_NO_SUB_TYPE, this.curPolicyObj.getId());
                }
                boolean isCloudPolicy = false;
                if (isCloudMemPolicy || this.curPolicyTypeName.equals("CloudBlackListPolicyOverrideApplied") || this.curPolicyTypeName.equals("CloudWhiteListPolicyOverrideApplied")) {
                    isCloudPolicy = true;
                }
                boolean isCloudParentPolicy = true;
                ObjReference ownPolicy = null;
                if (isCloudPolicy) {
                    if (isCloudMemPolicy) {
                        ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(this.gpObj.getClientGroup(), domainId, "MemPolicy", ConstantValue.CLOUD_POLICY_NO_SUB_TYPE, false);
                    } else if (this.curPolicyTypeName.equals("CloudBlackListPolicyOverrideApplied")) {
                        ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(this.gpObj.getClientGroup(), domainId, "PolicyOverride", "BlackList", false);
                    } else if (this.curPolicyTypeName.equals("CloudWhiteListPolicyOverrideApplied")) {
                        ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(this.gpObj.getClientGroup(), domainId, "PolicyOverride", "WhiteList", false);
                    }
                    if (ownPolicy != null && ownPolicy.getTargetId().equals(this.curPolicyObj.getId())) {
                        isCloudParentPolicy = false;
                    }
                    if (isCloudParentPolicy) {
                        dlg.setReadOnlyReason(4);
                    }
                } else if (this.gpObj.isInherit() && !licenseObject.isSBProduct()) {
                    dlg.setReadOnlyReason(1);
                } else if (this.isReadOnlyGroup() && this.curPolicyIsLocal) {
                    dlg.setReadOnlyReason(3);
                }
                ReadOnlyUtils.disableAbsPolicyEditorDlgIfNeeded(dlg);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    if (isCopiedToLocal) {
                        newPolicyObj.addNewObj(newPolicyObj.getSchemaObj());
                        newPolicyObj.getNewObjSet().putAll(newObjs);
                        AppliedPolicyObject appliedObj = this.curLocObj.getAppliedPolicyObject();
                        appliedObj.addNewLocalPolicy(newPolicyObj);
                        this.curLocObj.setAppliedPolicyObject(appliedObj);
                        this.gpObj.addNewObjSet(this.curLocObj.getNewObjSet());
                        this.gpObj.addChangedObjSet(this.curLocObj.getChangedObjSet());
                        this.gpObj.addDeletedObjSet(this.curLocObj.getDeletedObjSet());
                        this.gpObj.addLogList(this.curLocObj.getLogList());
                        this.gpObj.setPhysicalFileObject(newPolicyObj.getPhysicalFileObject());
                        this.curLocObj.clearAllObjSets();
                    } else if (this.curPolicyIsLocal) {
                        this.gpObj.addChangedObject(newPolicyObj.getSchemaObj());
                        this.gpObj.addNewObjSet(newPolicyObj.getNewObjSet());
                        this.gpObj.addChangedObjSet(newPolicyObj.getChangedObjSet());
                        this.gpObj.addDeletedObjSet(newPolicyObj.getDeletedObjSet());
                        this.gpObj.addLogList(this.curLocObj.getLogList());
                        this.gpObj.setPhysicalFileObject(newPolicyObj.getPhysicalFileObject());
                        if (ConfigObjectUtils.isEqualObj((Object)newPolicyObj.getSchemaObj(), (Object)this.curPolicyObj)) {
                            this.gpObj.getChangedObject().remove(this.curPolicyObj.getId());
                        } else {
                            this.gpObj.addChangedObject(newPolicyObj.getSchemaObj());
                        }
                        PolicyInt policy = newPolicyObj;
                        Object[] obj = new Object[]{policy.getTypeDesc(), policy.getName(), this.curLocObj.getName()};
                        String str = null;
                        str = !licenseObject.isSBProduct() ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.changedAtMsg") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.changedAtMsgSB");
                        String fm = MessageFormat.format(str, obj);
                        this.gpObj.addLog(2, this.curPolicyObj, fm);
                    } else {
                        this.gpObj.addLogList(this.curLocObj.getLogList());
                        if (ConfigObjectUtils.isEqualObj((Object)newPolicyObj.getSchemaObj(), (Object)this.curPolicyObj)) {
                            newPolicyObj.setSchemaObj(this.curPolicyObj);
                        }
                        pool.updatePolicyObject((PolicyObjectBase)((Object)newPolicyObj));
                        this.isPolicyPoolEdited = true;
                        TopicEvent topicEvt = new TopicEvent(this, "edited", newPolicyObj);
                        MessageHandler.getInstance().sendMessage(topicEvt);
                    }
                    this.saveData();
                } else {
                    this.refreshHtmlPageNoPositionMoving();
                }
            }
        }
        catch (RuntimeException ex) {
            ConsoleException ce = null;
            ce = ex.getMessage() == null ? new ConsoleException(ex.getClass().getName()) : new ConsoleException(ex);
            ExceptionHandler.handleConsoleExceptionWithErrorDialog(ce, "com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.consoleErrorMsg");
        }
        catch (Exception ex) {
            ConsoleException ce = null;
            ce = ex.getMessage() == null ? new ConsoleException(ex.getClass().getName()) : new ConsoleException(ex);
            ExceptionHandler.handleConsoleExceptionWithErrorDialog(ce, "com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.consoleErrorMsg");
        }
        this.curLocObj = null;
        this.curEditorType = null;
        this.curPolicyTypeName = null;
        this.curPolicyObj = null;
    }

    void this_mouseClicked(MouseEvent event) {
        this.x = event.getX();
        this.y = event.getY();
        if (this.pmenuToShow != null) {
            this.mainPane.add(this.pmenuToShow);
            this.pmenuToShow.show(this.mainPane, this.x, this.y);
            this.pmenuToShow = null;
        }
    }

    private void redrawHTMLPage() {
        try {
            int caret = this.mainPane.getCaretPosition();
            String text = this.myTemplateObj.getHTMLText(this.gpObj, this.statusMap);
            this.mainPane.setText(text);
            this.mainPane.setCaretPosition(caret);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.consoleErrorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void expandLocation(String query) {
        boolean bStatus;
        StringTokenizer st = new StringTokenizer(query, ";");
        String locId = st.nextToken();
        String expandId = st.nextToken();
        String expandStatus = st.nextToken();
        PolicyTemp.ExpandStatus curStatus = this.statusMap.get(locId);
        if (curStatus == null) {
            curStatus = new PolicyTemp.ExpandStatus();
            this.statusMap.put(locId, curStatus);
        }
        boolean bl = bStatus = !expandStatus.equals("true");
        if ("ExpandLoc".equals(expandId)) {
            curStatus.setWholeLocation(bStatus);
        } else if ("ExpandLocCondition".equals(expandId)) {
            curStatus.setLocationCondition(bStatus);
        } else if ("ExpandPolicy".equals(expandId)) {
            curStatus.setPolicies(bStatus);
        } else if ("ExpandQuaratinePolicy".equals(expandId)) {
            curStatus.setQuarantinePolicies(bStatus);
        } else if ("ExpandAdvancedSetting".equals(expandId)) {
            curStatus.setAdvandedSetting(bStatus);
        }
        this.redrawHTMLPage();
    }

    private void showMoreOptionMenu(URL url) throws ConsoleException {
        String query;
        try {
            query = URLDecoder.decode(url.getQuery(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtilities.logException((Throwable)e);
            query = url.getQuery();
        }
        ConsoleAssertion.runAssert(query == null, MSGRES.getString("PolicySummaryPane.noQueryParameterAfterInheritMsg"));
        this.curEditorType = null;
        this.curPolicyTypeName = null;
        String p_id = null;
        String loc_id = null;
        StringTokenizer st = new StringTokenizer(query, ";");
        if (st.hasMoreTokens()) {
            this.curEditorType = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.curPolicyTypeName = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            p_id = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            loc_id = st.nextToken();
        }
        String isLocalPolicy = null;
        if (st.hasMoreTokens()) {
            isLocalPolicy = st.nextToken();
        }
        if (this.curEditorType == null || this.curPolicyTypeName == null || p_id == null || loc_id == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTypeOrIDMsg"));
            return;
        }
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        this.curLocObj = autoLoc.getLocation(loc_id);
        if (this.curLocObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        this.curLocObj.setPhysicalFileObject(this.gpObj.getPhysicalFileObject());
        this.curPolicyIsLocal = false;
        if (isLocalPolicy != null && isLocalPolicy.equals("true")) {
            this.curPolicyIsLocal = true;
        }
        this.curPolicyObj = PolicyHandler.getObject(this.curEditorType, p_id);
        this.resetMenuItems();
        String itemName = this.gpObj.isPolicyEditable(!this.curPolicyIsLocal) ? EDIT_POLICY_ITEM : VIEW_POLICY_ITEM;
        this.editPolicyItem.setText(itemName);
        if (this.curPolicyObj instanceof MemPolicy && new MemPolicyObject(this.curPolicyObj).isExclusiveEdit()) {
            this.removePolicyItem.setEnabled(false);
            this.useSharedItem.setEnabled(false);
            this.useLocalItem.setEnabled(false);
            String tooltip = MSGRES.getString("PolicyTask.exclusiveEditTooltip");
            this.removePolicyItem.setToolTipText(tooltip);
            this.useSharedItem.setToolTipText(tooltip);
            this.useLocalItem.setToolTipText(tooltip);
        }
        this.pmenuToShow = this.moreOptionPMenu;
    }

    private boolean canRemovePolicy() {
        return true;
    }

    private void updateMoreOptionMenu() {
        this.moreOptionPMenu.removeAll();
        LicenseObject licenseObject = LicenseObject.getInstance();
        if (this.isReadOnlyGroup() || this.gpObj.isInherit()) {
            this.editPolicyItem.setText(VIEW_POLICY_ITEM);
            this.moreOptionPMenu.add(this.editPolicyItem);
            this.moreOptionPMenu.addSeparator();
            if (!licenseObject.isSBProduct()) {
                this.moreOptionPMenu.add(this.exportPolicyItem);
                this.moreOptionPMenu.addSeparator();
            }
            this.moreOptionPMenu.add(this.copyPolicyItem);
            this.moreOptionPMenu.add(this.pastePolicyItem);
        } else {
            this.editPolicyItem.setText(EDIT_POLICY_ITEM);
            this.moreOptionPMenu.add(this.useSharedItem);
            if (!licenseObject.isSBProduct()) {
                this.moreOptionPMenu.add(this.useLocalItem);
                this.moreOptionPMenu.addSeparator();
            }
            this.moreOptionPMenu.add(this.editPolicyItem);
            if (!licenseObject.isSBProduct()) {
                this.moreOptionPMenu.add(this.removePolicyItem);
            }
            this.moreOptionPMenu.addSeparator();
            if (!licenseObject.isSBProduct()) {
                this.moreOptionPMenu.add(this.exportPolicyItem);
                this.moreOptionPMenu.addSeparator();
            }
            this.moreOptionPMenu.add(this.copyPolicyItem);
            this.moreOptionPMenu.add(this.pastePolicyItem);
        }
    }

    private void editPolicy(URL url) throws ConsoleException {
        String query = url.getQuery();
        String type = null;
        String typeName = null;
        String p_id = null;
        String loc_id = null;
        StringTokenizer st = new StringTokenizer(query, ";");
        if (st.hasMoreTokens()) {
            type = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            typeName = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            p_id = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            loc_id = st.nextToken();
        }
        String isLocalPolicy = null;
        if (st.hasMoreTokens()) {
            isLocalPolicy = st.nextToken();
        }
        if (type == null || p_id == null || loc_id == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTypeOrIDMsg"));
            return;
        }
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        LocationObject locObj = autoLoc.getLocation(loc_id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        locObj.setPhysicalFileObject(this.gpObj.getPhysicalFileObject());
        this.curPolicyIsLocal = false;
        if (isLocalPolicy != null && isLocalPolicy.equals("true")) {
            this.curPolicyIsLocal = true;
        }
        this.curEditorType = type;
        this.curPolicyObj = PolicyHandler.getObjectFromDB(this.curEditorType, p_id);
        this.curLocObj = locObj;
        this.curPolicyTypeName = typeName;
        this.editPolicy();
    }

    private void addMorePolicy(URL url) throws ConsoleException {
        if (this.gpObj.isInherit()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.theAgentPolicyIsInheritedMsg"));
            return;
        }
        if (this.isReadOnlyGroup()) {
            Object[] obj = new Object[]{this.gpObj.getGroupName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.readOnlyGroupAgentPolicyMsg");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.errorMsg"), 0);
            return;
        }
        String query = url.getQuery();
        StringTokenizer sTokenizer = new StringTokenizer(query, ";");
        String id = null;
        if (sTokenizer.hasMoreTokens()) {
            id = sTokenizer.nextToken();
        }
        String quaratine = null;
        if (sTokenizer.hasMoreTokens()) {
            quaratine = sTokenizer.nextToken();
        }
        boolean isQuaratine = quaratine != null && quaratine.toLowerCase().equals("quaratine");
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        LocationObject locObj = autoLoc.getLocation(id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        AppliedPolicyObject appliedObj = locObj.getAppliedPolicyObject();
        if (isQuaratine && !appliedObj.hasHostIntegrityPolicy()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), new DescriptionTextArea(MSGRES.getString("PolicySummaryPane.youMustApplyAHostIntegrityPolicyTo")), MSGRES.getString("PolicySummaryPane.errorMsg"), 0);
            return;
        }
        AppliedPolicyObject newObj = appliedObj.getClone();
        String title = MSGRES.getString("PolicySummaryPane.addMorePoliciesTitle");
        if (isQuaratine) {
            title = MSGRES.getString("PolicySummaryPane.addQuarantinePoliciesTitle");
        }
        Object[] obj = new Object[]{locObj.getName()};
        String fm = MessageFormat.format(title, obj);
        AddMorePolicyDlg dlg = new AddMorePolicyDlg(Manager.getFrame(), fm, true);
        dlg.setObject(newObj, this.gpObj, locObj.getUserInterfaceObject().getMode(), isQuaratine);
        if (dlg.hasMorePolicyType()) {
            dlg.setVisible(true);
            if (!dlg.isCancel()) {
                locObj.setAppliedPolicyObject(newObj);
                this.gpObj.addNewObjSet(locObj.getNewObjSet());
                this.gpObj.addChangedObjSet(locObj.getChangedObjSet());
                this.gpObj.addDeletedObjSet(locObj.getDeletedObjSet());
                this.gpObj.addLogList(locObj.getLogList());
                this.gpObj.setPhysicalFileObject(newObj.getPhysicalFileObject());
                this.saveData();
            }
        } else {
            dlg.dispose();
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.allTypesOfPoliciesExistMsg"));
        }
    }

    private void editControlMode(URL url) throws ConsoleException {
        PolicyDialog dlg;
        String id = url.getQuery();
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        LocationObject locObj = autoLoc.getLocation(id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        UserInterfaceObject uiObj = locObj.getUserInterfaceObject();
        UserInterfaceObject newObj = uiObj.getClone();
        LicenseObject licenseObj = LicenseObject.getInstance();
        if (licenseObj.isSNACOnlyProduct()) {
            dlg = new AgentGUIDlg((JFrame)Manager.getFrame(), MSGRES.getString("PolicySummaryPane.agentGUISettingMsg"), true, uiObj.getMode());
        } else {
            Object[] obj = new Object[]{locObj.getName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.newtitle");
            String fm = MessageFormat.format(str, obj);
            dlg = new ControlModeDlg(Manager.getFrame(), fm, true);
        }
        dlg.setObject(newObj);
        if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
            dlg.setReadOnly(this.gpObj.isInherit());
        }
        dlg.setVisible(true);
        if (dlg.isOk()) {
            String str;
            Object[] obj;
            locObj.setUserInterface(newObj);
            SemLocationConfig locConfig = locObj.getSemLocationConfigObj();
            if (locConfig != null) {
                this.gpObj.addChangedObject((TopLevelObject)locConfig);
            }
            if (licenseObj.isSNACOnlyProduct()) {
                obj = new Object[]{locObj.getName()};
                str = MSGRES.getString("PolicySummaryPane.changedAgentATMsg");
                String fm = MessageFormat.format(str, obj);
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
            } else {
                obj = new Object[]{locObj.getName()};
                str = MSGRES.getString("PolicySummaryPane.changedConsoleModeAtMsg");
                String fm = MessageFormat.format(str, obj);
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
            }
            this.saveData();
        }
    }

    private void editCommunication(String id, String key) throws ConsoleException {
        boolean isGlobal = false;
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        LocationObject locObj = autoLoc.getLocation(id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        isGlobal = locObj.isComGlobal();
        if (isGlobal) {
            String titleSting = "";
            titleSting = key == null ? this.getResTitleString("Communication", this.gpObj.getGroupName(), locObj.getName()) : this.getResTitleString("Submissions", this.gpObj.getGroupName(), locObj.getName());
            GlobalSettingDlg gdlg = new GlobalSettingDlg(titleSting, "Communication");
            GroupPolicyObject newObj = this.gpObj.getClone();
            gdlg.setObject(newObj);
            if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
                gdlg.setReadOnly(this.gpObj.isInherit());
            }
            gdlg.setVisible(true);
            if (gdlg.isOk()) {
                this.gpObj.setEnforcerNotificationObject(newObj.getEnforcerNotificationObj());
                this.gpObj.setAutoLocation(newObj.getAutoLocation());
                this.gpObj.setAgentLogObject(newObj.getAgentLogObject());
                this.gpObj.setPrestartingProtection(newObj);
                this.gpObj.setAgentServiceProtection(newObj);
                this.gpObj.setAppAuthentication(newObj.getAppAuthenticationObject());
                this.gpObj.setIDS(newObj.getIDSObject());
                this.gpObj.setPasswordProtection(newObj.getPasswordProtection());
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), MSGRES.getString("PolicySummaryPane.changedAdvancedSettingMsg"));
                this.gpObj.setCommunicationObject(newObj.getCommunicationObject());
                this.gpObj.setExternalCommunicationObject(newObj.getExternalCommunicationObject());
                this.gpObj.setComputerLockdownProtectionObject(newObj.getComputerLockdownProtectionObject());
                this.gpObj.setGroupPolicyObject(newObj);
                this.saveData();
            }
        } else {
            CommunicationObject comObj = locObj.getCommunicationObject();
            CommunicationObject newObj = comObj.getClone();
            Object[] obj = new Object[]{locObj.getName()};
            String str = MSGRES.getString("PolicySummaryPane.communicationSettingAtMsg");
            String fm = MessageFormat.format(str, obj);
            CommunicationDlg dlg = new CommunicationDlg(fm);
            dlg.setObject(newObj, this.gpObj.getTamperProtectionPolicy());
            dlg.setBackgroundObject(autoLoc, locObj.getId());
            if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
                dlg.setReadOnly(this.gpObj.isInherit());
            }
            dlg.setVisible(true);
            if (dlg.isOk()) {
                locObj.setCommunication(newObj);
                SemLocationConfig locConfig = locObj.getSemLocationConfigObj();
                if (locConfig != null) {
                    this.gpObj.addChangedObject((TopLevelObject)locConfig);
                }
                Object[] obj1 = new Object[]{locObj.getName()};
                str = MSGRES.getString("PolicySummaryPane.changedCommunicationSettingAtMsg");
                fm = MessageFormat.format(str, obj1);
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
                this.saveData();
            }
        }
    }

    private void editExternalCommunication(String id, String key) throws ConsoleException {
        boolean isGlobal = false;
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        LocationObject locObj = autoLoc.getLocation(id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        isGlobal = locObj.isExternalCommunicationGlobal();
        if (isGlobal) {
            String titleSting = "";
            titleSting = key == null ? this.getResTitleString("ExternalCommunication", this.gpObj.getGroupName(), locObj.getName()) : this.getResTitleString("Submissions", this.gpObj.getGroupName(), locObj.getName());
            GlobalSettingDlg gdlg = new GlobalSettingDlg(titleSting, "ExternalCommunication");
            GroupPolicyObject newObj = this.gpObj.getClone();
            gdlg.setObject(newObj);
            if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
                gdlg.setReadOnly(this.gpObj.isInherit());
            }
            gdlg.setVisible(true);
            if (gdlg.isOk()) {
                this.gpObj.setEnforcerNotificationObject(newObj.getEnforcerNotificationObj());
                this.gpObj.setAutoLocation(newObj.getAutoLocation());
                this.gpObj.setAgentLogObject(newObj.getAgentLogObject());
                this.gpObj.setPrestartingProtection(newObj);
                this.gpObj.setAgentServiceProtection(newObj);
                this.gpObj.setAppAuthentication(newObj.getAppAuthenticationObject());
                this.gpObj.setIDS(newObj.getIDSObject());
                this.gpObj.setPasswordProtection(newObj.getPasswordProtection());
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), MSGRES.getString("PolicySummaryPane.changedAdvancedSettingMsg"));
                this.gpObj.setCommunicationObject(newObj.getCommunicationObject());
                this.gpObj.setExternalCommunicationObject(newObj.getExternalCommunicationObject());
                this.gpObj.setComputerLockdownProtectionObject(newObj.getComputerLockdownProtectionObject());
                this.gpObj.setGroupPolicyObject(newObj);
                this.saveData();
            }
        } else {
            ExternalCommunicationObject comObj = locObj.getExternalCommunicationObject();
            ExternalCommunicationObject newObj = comObj.getClone();
            Object[] obj = new Object[]{locObj.getName()};
            String str = MSGRES.getString("PolicySummaryPane.changedExternalCommunicationSettingAtMsg");
            String fm = MessageFormat.format(str, obj);
            ExternalCommunicationDlg dlg = new ExternalCommunicationDlg(fm);
            dlg.setObject(newObj, this.gpObj.getTamperProtectionPolicy(), locObj.getId(), this.gpObj.getClientGroup());
            dlg.setBackgroundObject(autoLoc, locObj.getId());
            if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
                dlg.setReadOnly(this.gpObj.isInherit());
            }
            dlg.setVisible(true);
            if (dlg.isOk()) {
                locObj.setExternalCommunication(newObj);
                SemLocationConfig locConfig = locObj.getSemLocationConfigObj();
                if (locConfig != null) {
                    this.gpObj.addChangedObject((TopLevelObject)locConfig);
                }
                Object[] obj1 = new Object[]{locObj.getName()};
                str = MSGRES.getString("PolicySummaryPane.changedExternalCommunicationSettingAtMsg");
                fm = MessageFormat.format(str, obj1);
                this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), fm);
                this.saveData();
            }
        }
    }

    private void showInheritCommunicationMenu(String id) throws ConsoleException {
        boolean isGlobal = false;
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        LocationObject locObj = autoLoc.getLocation(id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        isGlobal = locObj.isComGlobal();
        this.currentLocId = id;
        this.comMenuItem.setSelected(isGlobal);
        this.pmenuToShow = this.comPMenu;
        this.pmenuToShow.getSubElements()[0].getComponent().setEnabled(!this.gpObj.isInherit());
    }

    private void showInheritExternalCommunicationMenu(String id) throws ConsoleException {
        boolean isGlobal = false;
        AutoLocationObject autoLoc = this.gpObj.getAutoLocation();
        LocationObject locObj = autoLoc.getLocation(id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        isGlobal = locObj.isExternalCommunicationGlobal();
        this.currentLocId = id;
        this.externalCommunicationMenuItem.setSelected(isGlobal);
        this.pmenuToShow = this.externalCommunicationPMenu;
        this.pmenuToShow.getSubElements()[0].getComponent().setEnabled(!this.gpObj.isInherit());
    }

    private void showControlSettingsMenu(URL url) throws ConsoleException {
        if (url == null) {
            return;
        }
        this.currURL = url;
        this.pmenuToShow = this.controlMenu;
    }

    private void setGroupSetting(String query) throws ConsoleException {
        String titleSting = this.getResTitleString(query, this.gpObj.getGroupName(), this.gpObj.getGroupName());
        GlobalSettingDlg gdlg = new GlobalSettingDlg(titleSting, query);
        GroupPolicyObject newObj = this.gpObj.getClone();
        gdlg.setObject(newObj);
        if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
            gdlg.setReadOnly(this.gpObj.isInherit());
        }
        gdlg.setVisible(true);
        if (gdlg.isOk()) {
            this.gpObj.setEnforcerNotificationObject(newObj.getEnforcerNotificationObj());
            this.gpObj.setAutoLocation(newObj.getAutoLocation());
            this.gpObj.setAgentLogObject(newObj.getAgentLogObject());
            this.gpObj.setPrestartingProtection(newObj);
            this.gpObj.setAgentServiceProtection(newObj);
            this.gpObj.setAppAuthentication(newObj.getAppAuthenticationObject());
            this.gpObj.setIDS(newObj.getIDSObject());
            this.gpObj.setPasswordProtection(newObj.getPasswordProtection());
            this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), MSGRES.getString("PolicySummaryPane.changedAdvancedSettingMsg"));
            this.gpObj.setCommunicationObject(newObj.getCommunicationObject());
            this.gpObj.setExternalCommunicationObject(newObj.getExternalCommunicationObject());
            this.gpObj.setComputerLockdownProtectionObject(newObj.getComputerLockdownProtectionObject());
            this.gpObj.setRebootOptions(newObj.getRebootOptions());
            this.gpObj.setOptimizationSettings(newObj.getOptimizationSettings());
            this.gpObj.setTamperProtectionPolicy(newObj.getTamperProtectionPolicy());
            this.gpObj.setPerformanceSettings(newObj.getPerformanceSettings());
            this.gpObj.setGroupPolicyObject(newObj);
            this.saveData();
        }
    }

    private void showClientSecuritySettings() {
        String title = MessageFormat.format(MSGRES.getString("PolicySummaryPane.passwordSettings"), this.gpObj.getGroupName());
        ClientPasswordSettingsDlg dlg = new ClientPasswordSettingsDlg(title, this.gpObj);
        if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
            dlg.setReadOnly(this.gpObj.isInherit());
        }
        dlg.setVisible(true);
        if (dlg.isOk()) {
            try {
                this.updateSecuritySettings(dlg);
                GroupPolicyObject newGpObj = PolicyHandler.getGroupPolicyByGroupFromDB(this.gpObj.getGroupObject(), true);
                if (newGpObj != null && this.gpObj.hasChanged(newGpObj)) {
                    this.gpObj = newGpObj;
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        dlg.dispose();
    }

    private void saveData() throws ConsoleException {
        Cursor curCursor = Manager.getFrame().getCursor();
        Manager.getFrame().setCursor(WAIT_CURSOR);
        PolicyHandler.updateGroupPolicy(this.gpObj);
        if (this.hisPane != null) {
            this.hisPane.setObject(this.gpObj.getGroupPolicyHistoryCheckId());
        }
        this.refreshHtmlPage();
        Manager.getFrame().setCursor(curCursor);
        this.updateSerialNumber();
    }

    private void updateSerialNumber() {
        UpdateSerialNumberSwingWorker worker = new UpdateSerialNumberSwingWorker(this.gpObj);
        SwingWorkerExecutor.getInstance().execute(worker);
    }

    private void editLocation(URL url) throws ConsoleException {
        String id = url.getQuery();
        LocationObject locObj = this.gpObj.getAutoLocation().getLocation(id);
        if (locObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.cannotFindTheLocationMsg"));
            return;
        }
        LocationSettingDlg dlg = new LocationSettingDlg(Manager.getFrame(), MSGRES.getString("PolicySummaryPane.adaptivePolicyMsg"), true);
        dlg.setObject(this.gpObj);
        dlg.setSelectLoc(locObj);
        if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
            dlg.setReadOnly(this.gpObj.isInherit());
        }
        dlg.setVisible(true);
        if (dlg.isOk()) {
            this.saveData();
        }
    }

    private void editLuContentSetting() {
        LuContentPolicySelectDialog dlg;
        boolean readOnly = false;
        if (this.gpObj.isInherit() || this.isReadOnlyGroup()) {
            readOnly = true;
        }
        if ((dlg = new LuContentPolicySelectDialog(this.gpObj, readOnly)).isOk()) {
            ObjReference objRef;
            String selId = dlg.getSelectedId();
            if (selId == null) {
                return;
            }
            LuContentSelection luSelection = this.gpObj.getLuContentSelection();
            if (luSelection == null) {
                luSelection = new LuContentSelection();
                this.gpObj.setLuContentSelection(luSelection);
            }
            if ((objRef = luSelection.getObjReference()) == null) {
                objRef = new ObjReference();
                objRef.setName("LuContentPolicyApplied");
                objRef.setTargetType("LuContentPolicy");
                luSelection.setObjReference(objRef);
            }
            objRef.setTargetId(selId);
            this.gpObj.addLog(2, this.gpObj.getAgentPolicyId(), MSGRES.getString("PolicySummaryPane.changedAdvancedSettingMsg"));
            try {
                this.saveData();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        dlg.dispose();
    }

    private void refreshHtmlPage() {
        try {
            String text = this.myTemplateObj.getHTMLText(this.gpObj, this.statusMap);
            this.mainPane.setText(text);
            ((HTMLDocument)this.mainPane.getDocument()).setBase(this.baseURL);
            this.mainPane.setCaretPosition(0);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.consoleErrorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void refreshHtmlPageNoPositionMoving() {
        try {
            String text = this.myTemplateObj.getHTMLText(this.gpObj, this.statusMap);
            this.mainPane.setText(text);
            ((HTMLDocument)this.mainPane.getDocument()).setBase(this.baseURL);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("PolicySummaryPane.consoleErrorMsg"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private boolean isCurrentGroupPolicyChanged() throws ConsoleException {
        GroupObject groupObj = this.gpObj.getGroupObject();
        GroupPolicyObject newGpObj = PolicyHandler.getGroupPolicyByGroupFromDB(groupObj, true);
        if (this.gpObj.hasChanged(newGpObj)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.thePolicyHasBeenChangedByOtherResourceMsg"), MSGRES.getString("PolicySummaryPane.warningMsg"), 2);
            boolean isInheritChanged = this.gpObj.isInherit() != newGpObj.isInherit();
            this.gpObj = newGpObj;
            this.refreshHtmlPage();
            this.inheritCbx.setSelected(this.gpObj.isInherit());
            this.inheritCbx.setEnabled(!this.isReadOnlyGroup());
            if (isInheritChanged) {
                this.setInheritanceStatus();
                this.updateMoreOptionMenu();
            }
            return true;
        }
        return false;
    }

    private boolean isReadOnlyGroup() {
        return this.gpObj.getGroupObject().isReadOnly();
    }

    private void setInheritancePanel() {
        if (this.getObject() == null) {
            return;
        }
        GroupObject pGroup = this.getObject().getGroupObject().getParentGroup();
        LicenseObject licenseObject = LicenseObject.getInstance();
        if (pGroup == null || licenseObject.isSBProduct()) {
            this.inheritStatLbl.setVisible(false);
            this.inheritCbx.setVisible(false);
            return;
        }
        boolean inherit = this.getObject().isInherit();
        Object[] obj1 = new Object[]{pGroup.getDisplayName()};
        String str1 = MSGRES.getString("PolicySummaryPane.inheritPolicies");
        String fm1 = MessageFormat.format(str1, obj1);
        this.inheritCbx.setText(fm1);
        this.inheritCbx.setSelected(inherit);
        this.inheritCbx.setEnabled(!this.isReadOnlyGroup());
        this.setInheritanceStatus();
        this.inheritPane.setVisible(true);
        this.inheritStatLbl.setVisible(true);
        this.inheritCbx.setVisible(true);
    }

    private void setInheritanceStatus() {
        Object[] args = new Object[]{"&nbsp;<b>" + (this.inheritCbx.isSelected() ? MSGRES.getString("PolicySummaryPane.inhertOn") : MSGRES.getString("PolicySummaryPane.inhertOff")) + "</b>"};
        this.inheritStatLbl.setText("<html>" + MessageFormat.format(MSGRES.getString("PolicySummaryPane.inhertIs"), args) + "</html>");
    }

    private void resetMenuItems() {
        this.editPolicyItem.setEnabled(true);
        this.exportPolicyItem.setEnabled(true);
        this.useSharedItem.setEnabled(true);
        this.copyPolicyItem.setEnabled(true);
        this.useLocalItem.setEnabled(true);
        this.removePolicyItem.setEnabled(true);
        this.pastePolicyItem.setEnabled(true);
        this.useLocalItem.setEnabled(!this.curPolicyIsLocal);
        if (this.curPolicyIsLocal) {
            this.useSharedItem.setText(USE_SHARE);
        } else {
            this.useSharedItem.setText(USE_OTHER_SHARE);
        }
        PolicyReferenceObject copiedPolicy = PolicyHandler.getCopiedPolicy();
        boolean hasCopiedObj = copiedPolicy != null && copiedPolicy.canBePasted(this.curPolicyTypeName, this.curEditorType);
        this.pastePolicyItem.setEnabled(hasCopiedObj && !this.isReadOnlyGroup() && !this.gpObj.isInherit());
        this.removePolicyItem.setEnabled(this.canRemovePolicy());
        this.removePolicyItem.setToolTipText(null);
        this.useSharedItem.setToolTipText(null);
        this.useLocalItem.setToolTipText(null);
    }

    private String getResTitleString(String query, String groupName, String locName) {
        String resTitleString = "";
        MessageResources msgRes = MessageResources.getInstance();
        if (query == null) {
            resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.generalSettingsTitle");
        } else if (query.trim().equals("application authentication")) {
            resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.applicationAuthentication");
        } else {
            if (query.trim().equals("Communication")) {
                resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.communicationsTitle");
                if (locName == null) {
                    locName = "";
                }
                Object[] obj = new Object[]{locName};
                return MessageFormat.format(resTitleString, obj);
            }
            if (query.trim().equals("ExternalCommunication")) {
                resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.externalCommunicationsTitle");
                if (locName == null) {
                    locName = "";
                }
                Object[] obj = new Object[]{locName};
                return MessageFormat.format(resTitleString, obj);
            }
            if (query.trim().equals("Lockdown")) {
                resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.customSystemLockDownTitle");
            } else if (query.trim().equals("logs")) {
                resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.logSettingsTitle");
            } else if (query.trim().equals("Intrusion Prevention")) {
                resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.customIntrusionPreventionTitle");
            } else if (query.trim().equals("Submissions")) {
                resTitleString = msgRes.getString("com.sygate.scm.console.ui.policy.policy", "PolicySummaryPane.submissionTitle");
            }
        }
        if (groupName == null) {
            groupName = "";
        }
        Object[] obj = new Object[]{groupName};
        return MessageFormat.format(resTitleString, obj);
    }

    private void updateSecuritySettings(ClientPasswordSettingsDlg dlg) throws ConsoleException {
        if (this.gpObj.getClientGroup() != null) {
            String password3Hash = dlg.getPassword3Hash();
            PolicyHandler.updateClientGroupPasswordSettings(this.gpObj.getClientGroup().getId(), Boolean.TRUE.toString(), dlg.getAskPwdOpenGui(), Boolean.TRUE.toString(), Boolean.TRUE.toString(), Boolean.TRUE.toString(), dlg.getPasswordHash(), dlg.getPassword2Hash(), password3Hash, dlg.getApplyToSubGroups());
        } else {
            ConsoleLogger.log("PolicySummaryPane>updateSecuritySettings>>gbObj.getClientGroup was null!");
        }
    }

    public void setObject(GroupPolicyObject gpObj) {
        this.gpObj = gpObj;
        if (null != gpObj && null != gpObj.getSemGroupPolicyObject() && null != gpObj.getSemGroupPolicyObject().getId() && !gpObj.getSemGroupPolicyObject().getId().equalsIgnoreCase(this.oldSemGroupPolicyID)) {
            this.statusMap.clear();
            this.oldSemGroupPolicyID = gpObj.getSemGroupPolicyObject().getId();
        }
        this.updateMoreOptionMenu();
        this.refreshHtmlPage();
        this.setInheritancePanel();
    }

    public GroupPolicyObject getObject() {
        return this.gpObj;
    }

    public static class UpdateSerialNumberSwingWorker<V, T>
    extends SwingWorker<V, T> {
        private GroupPolicyObject gpObj;
        private String previousSerialNumber;
        private String latestSerialNumber = "";

        public UpdateSerialNumberSwingWorker(GroupPolicyObject gpObj) {
            this.gpObj = gpObj;
            this.previousSerialNumber = gpObj.getGroupObject().getSerialNumbers()[0];
        }

        public String getPreviousSerialNumber() {
            return this.previousSerialNumber;
        }

        @Override
        protected V doInBackground() throws Exception {
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2));
            this.latestSerialNumber = this.gpObj.getGroupObject().getSerialNumbers()[0];
            while (this.previousSerialNumber.equalsIgnoreCase(this.latestSerialNumber)) {
                Thread.sleep(1000L);
                this.latestSerialNumber = this.gpObj.getGroupObject().getSerialNumbers()[0];
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            try {
                ClientTaskPanel panel;
                PagePanel currentPanel = Manager.getFrame().getMainPanel().getPagePanel("client");
                if (currentPanel != null && currentPanel instanceof ClientPanel && (panel = ((ClientPanel)currentPanel).getPanelClientTabs()) != null) {
                    panel.updateGroupSeriaNumber(this.latestSerialNumber);
                    AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)panel.getRightLabel(), true);
                        ClientAgent.getCurrentInstance().setUpdateBrowser(true);
                    });
                }
            }
            catch (ConsoleException ce) {
                if (ce.needRelogin()) {
                    ConsoleLogger.log("PolicySummaryPane.updateSerialNumber> Console session is no longer valid (most likely has timed out).");
                }
                ConsoleLogger.log(ce);
            }
        }
    }

    private static class JarExStreamHandler
    extends URLStreamHandler {
        private JarExStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            URL jaru;
            String filePath = u.getFile();
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1, filePath.length());
            }
            if ((jaru = ConsoleMain.class.getResource(filePath)) == null) {
                throw new FileNotFoundException(filePath);
            }
            return jaru.openConnection();
        }
    }
}

