/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.ContainerObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.PolicyTask;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.SideBar;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class PolicySideBar
extends SideBar {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_ID_UPGRADE_BUTTON = "UpgradePolicyButton";
    private static final String AUTOMATION_ID_POLICY_COMPONENTS_ARROW_BUTTON = "PolicyComponentsArrowButton";
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    private ArrowButton sharedComponentPanel;
    private PolicyButton antiVirus;
    private PolicyButton firewall;
    private PolicyButton intrusionProtect;
    private PolicyButton hostIntegrity;
    private PolicyButton hardwareDevicePro;
    private PolicyButton liveUpdate;
    private PolicyButton policyOverride;
    private PolicyButton upgradePolicy;
    private PolicyButton memoryExploitMitigation;
    private PolicyButton ntrButton;
    private PolicyButton adaptivePolicy;
    private ButtonGroup policyGroup = new ButtonGroup();
    private PolicyTask policyTask;
    private PolicyButton firstButton;
    private PolicyButton lastButton;
    private DisableUpAndLeftKeyAdapter disableUpAndLeftKeyAdapter = new DisableUpAndLeftKeyAdapter();
    private DisableDownAndRightKeyAdapter disableDownAndRightKeyAdapter = new DisableDownAndRightKeyAdapter();
    private boolean inputIsKeyBoard = false;
    private int keySelectionDirection = 0;

    public PolicySideBar(PagePanel pagePanel, String titleView, String titleTask) {
        super(pagePanel, titleView, titleTask, false);
        this.initialize();
        this.policyTask = new PolicyTask(pagePanel);
        this.selectFirstButton();
    }

    public void selectFirstButton() {
        if (this.firstButton != null) {
            this.firstButton.doClick();
            this.firstButton.setSelected(true);
        } else {
            ConsoleLogger.log("Error: There is no button to select while initializing PolicySideBar!!");
        }
    }

    @Override
    public void updateViews() {
        this.policyGroup = new ButtonGroup();
        if (this.firstButton != null) {
            this.firstButton.removeKeyListener(this.disableUpAndLeftKeyAdapter);
        }
        this.firstButton = null;
        if (this.lastButton != null) {
            this.lastButton.removeKeyListener(this.disableDownAndRightKeyAdapter);
        }
        this.lastButton = null;
        GridBagConstraints gridbag = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.putClientProperty("cssClass", "PolicySideBarContainer2");
        if (this.adaptivePolicy != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x32")) {
            this.setUpPolicyButton(this.adaptivePolicy);
            panel.add((Component)this.adaptivePolicy, gridbag);
        }
        if (this.antiVirus != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x22")) {
            this.setUpPolicyButton(this.antiVirus);
            ++gridbag.gridy;
            panel.add((Component)this.antiVirus, gridbag);
        }
        if (this.firewall != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
            this.setUpPolicyButton(this.firewall);
            ++gridbag.gridy;
            panel.add((Component)this.firewall, gridbag);
        }
        if (this.intrusionProtect != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x24")) {
            this.setUpPolicyButton(this.intrusionProtect);
            ++gridbag.gridy;
            panel.add((Component)this.intrusionProtect, gridbag);
        }
        if (this.hardwareDevicePro != null && !LicenseObject.getInstance().isSBProduct() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x25")) {
            this.setUpPolicyButton(this.hardwareDevicePro);
            ++gridbag.gridy;
            panel.add((Component)this.hardwareDevicePro, gridbag);
        }
        if (this.hostIntegrity != null && !LicenseObject.getInstance().isSBProduct() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x28")) {
            this.setUpPolicyButton(this.hostIntegrity);
            ++gridbag.gridy;
            panel.add((Component)this.hostIntegrity, gridbag);
        }
        if (this.liveUpdate != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x26")) {
            this.setUpPolicyButton(this.liveUpdate);
            ++gridbag.gridy;
            panel.add((Component)this.liveUpdate, gridbag);
        }
        if (this.memoryExploitMitigation != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x29")) {
            this.setUpPolicyButton(this.memoryExploitMitigation);
            ++gridbag.gridy;
            panel.add((Component)this.memoryExploitMitigation, gridbag);
        }
        if (this.ntrButton != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x30")) {
            this.setUpPolicyButton(this.ntrButton);
            ++gridbag.gridy;
            panel.add((Component)this.ntrButton, gridbag);
        }
        if (this.policyOverride != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x27")) {
            this.setUpPolicyButton(this.policyOverride);
            ++gridbag.gridy;
            panel.add((Component)this.policyOverride, gridbag);
        }
        if (this.upgradePolicy != null && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x31")) {
            this.setUpPolicyButton(this.upgradePolicy);
            ++gridbag.gridy;
            panel.add((Component)this.upgradePolicy, gridbag);
        }
        if (!LicenseObject.getInstance().isSBProduct() && AdminPrivilegeObject.isCurrentAdminHasPolicyPrivilege()) {
            ++gridbag.gridy;
            panel.add((Component)this.sharedComponentPanel, gridbag);
            if (this.firstButton == null && !this.sharedComponentPanel.isExpand()) {
                this.sharedComponentPanel.expand();
            }
            ++gridbag.gridy;
            if (this.sharedComponentPanel.isExpand()) {
                panel.add((Component)this.createSharedComponentPanel(), gridbag);
            }
        }
        this.firstButton.addKeyListener(this.disableUpAndLeftKeyAdapter);
        this.lastButton.addKeyListener(this.disableDownAndRightKeyAdapter);
        this.updateViews(panel);
    }

    @Override
    public void updateTasks() {
        ButtonModel model = this.policyGroup.getSelection();
        if (model != null) {
            int type = Integer.parseInt(model.getActionCommand());
            this.updateTasks(this.policyTask.getTask(type));
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeViews();
    }

    private void initializeViews() {
        LicenseObject licenseObject = LicenseObject.getInstance();
        if (licenseObject.isAvPolicy()) {
            this.antiVirus = new PolicyButton(125, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.antiVirus"));
            this.antiVirus.putClientProperty("cssClass", "policySideBarAntiVirus");
        }
        if (licenseObject.isIntrusionPreventionEnabled()) {
            this.intrusionProtect = new PolicyButton(66, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.ipsLib"));
        }
        if (licenseObject.isFirewallPolicy()) {
            this.firewall = new PolicyButton(57, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.firewall"));
        }
        if (licenseObject.isOSPretectionPolicy()) {
            this.hardwareDevicePro = new PolicyButton(64, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.hardwareDeviceProtection"));
        }
        if (licenseObject.isMemPolicy()) {
            this.memoryExploitMitigation = new PolicyButton(170, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.memoryExploitMitigation"));
        }
        if (licenseObject.isNtrPolicy()) {
            this.ntrButton = new PolicyButton(172, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.ntr"));
        }
        if (licenseObject.isPolicyOverride()) {
            this.policyOverride = new PolicyButton(136, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.policyOverrides"));
        }
        if (licenseObject.isUpgradePolicy()) {
            this.upgradePolicy = new PolicyButton(310, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.upgradePolicy"));
            UIUtilities.setName(this.upgradePolicy, "policyPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_UPGRADE_BUTTON);
        }
        if (licenseObject.isAdaptivePolicy()) {
            this.adaptivePolicy = new PolicyButton(314, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.adaptivePolicy"));
        }
        if (licenseObject.isHostIntegrityPolicy()) {
            this.hostIntegrity = new PolicyButton(58, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.hostIntegrity"));
        }
        this.liveUpdate = new PolicyButton(145, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.liveUpdate"));
        this.sharedComponentPanel = new ArrowButton(MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.policyComponents"));
        UIUtilities.setName(this.sharedComponentPanel, "policyPage", UIUtilities.ComponentType.JRADIOBUTTON, AUTOMATION_ID_POLICY_COMPONENTS_ARROW_BUTTON);
        this.updateViews();
    }

    private JPanel createSharedComponentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        LicenseObject licenseObject = LicenseObject.getInstance();
        GridBagConstraints gridbag = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        if (licenseObject.isAvPolicy() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x22")) {
            PolicyButton avScanPool = new PolicyButton(142, null, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.antiVirusScan"));
            this.setUpPolicyButton(avScanPool);
            panel.add((Component)avScanPool, gridbag);
        }
        PolicyButton srvListPool = new PolicyButton(61, null, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.securityManagerList"));
        this.setUpPolicyButton(srvListPool);
        ++gridbag.gridy;
        panel.add((Component)srvListPool, gridbag);
        if (!licenseObject.isSNACOnlyProduct()) {
            if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x25")) {
                PolicyButton fileFingerPrintPool = new PolicyButton(91, null, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.fileFingerprintList"));
                UIUtilities.setName(fileFingerPrintPool, "policyPage", UIUtilities.ComponentType.JRADIOBUTTON, "PolicyComponentsFileFingerprintLists");
                this.setUpPolicyButton(fileFingerPrintPool);
                ++gridbag.gridy;
                panel.add((Component)fileFingerPrintPool, gridbag);
            }
            if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x24") || AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
                PolicyButton hstGrpPool = new PolicyButton(152, null, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.hostGroups"));
                this.setUpPolicyButton(hstGrpPool);
                ++gridbag.gridy;
                panel.add((Component)hstGrpPool, gridbag);
            }
            if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
                PolicyButton serviceTypePool = new PolicyButton(62, null, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.networkServices"));
                this.setUpPolicyButton(serviceTypePool);
                ++gridbag.gridy;
                panel.add((Component)serviceTypePool, gridbag);
                PolicyButton adapterPool = new PolicyButton(100, null, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.networkAdapters"));
                this.setUpPolicyButton(adapterPool);
                ++gridbag.gridy;
                panel.add((Component)adapterPool, gridbag);
            }
            if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x25")) {
                PolicyButton devicePool = new PolicyButton(101, null, MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "PolicySideBar.hardwareDevices"));
                this.setUpPolicyButton(devicePool);
                ++gridbag.gridy;
                panel.add((Component)devicePool, gridbag);
            }
        }
        panel.putClientProperty("cssClass", "policySideBarContainer");
        panel.setBorder(BorderFactory.createMatteBorder(0, 10, 0, 0, this.getBackground()));
        return panel;
    }

    private void setUpPolicyButton(final PolicyButton policyButton) {
        policyButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    policyButton.doClick();
                    if (PolicySideBar.this.inputIsKeyBoard) {
                        PolicySideBar.this.inputIsKeyBoard = false;
                    }
                }
            }
        });
        policyButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ev) {
                PolicySideBar.this.inputIsKeyBoard = true;
                if (ev.getKeyCode() == 37 || ev.getKeyCode() == 38) {
                    PolicySideBar.this.keySelectionDirection = -1;
                } else if (ev.getKeyCode() == 39 || ev.getKeyCode() == 40) {
                    PolicySideBar.this.keySelectionDirection = 1;
                }
            }
        });
        this.policyGroup.add(policyButton);
        if (this.firstButton == null) {
            this.firstButton = policyButton;
        }
        this.lastButton = policyButton;
    }

    private static class DisableDownAndRightKeyAdapter
    extends KeyAdapter {
        private DisableDownAndRightKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 39 || ev.getKeyCode() == 40) {
                ev.consume();
            }
        }
    }

    private static class DisableUpAndLeftKeyAdapter
    extends KeyAdapter {
        private DisableUpAndLeftKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 37 || ev.getKeyCode() == 38) {
                ev.consume();
            }
        }
    }

    private class ArrowButton
    extends PolicyButton {
        private static final long serialVersionUID = 1L;
        private int direction;
        private boolean isExpand;

        @Override
        public String getUIClassID() {
            return "ArrowButtonUI";
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.expand();
            PolicySideBar.this.updateViews();
        }

        public ArrowButton(String name) {
            super(-1, null, name);
            this.direction = 1;
        }

        public void setDirection(int direction) {
            this.direction = direction;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension size = new Dimension();
            Rectangle viewRect = new Rectangle();
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            size = this.getSize(size);
            viewRect.x = 0;
            viewRect.y = 0;
            viewRect.width = size.width - viewRect.x;
            viewRect.height = size.height - viewRect.y;
            SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), this.getText(), null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewRect, iconRect, textRect, 0);
            Image image = null;
            switch (this.direction) {
                case 1: {
                    image = CustomLookAndFeel.DOWN_ARROW_IMAGE;
                    break;
                }
                case 5: {
                    image = CustomLookAndFeel.UP_ARROW_IMAGE;
                    break;
                }
                default: {
                    image = null;
                }
            }
            int iconHeight = 10;
            if (image != null) {
                iconHeight = image.getHeight(null);
            }
            int iconY = (this.getSize().height - iconHeight) / 2 + 2;
            g.drawImage(image, textRect.x + textRect.width + 50, iconY, null);
        }

        public void expand() {
            this.isExpand = !this.isExpand;
            this.setDirection(this.isExpand ? 5 : 1);
        }

        public boolean isExpand() {
            return this.isExpand;
        }
    }

    private class PolicyButton
    extends JRadioButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private TreeItem treeItem;

        public PolicyButton(int policyType, Icon icon, String name) {
            super(name, icon);
            this.treeItem = new ContainerObject(policyType, name);
            this.setActionCommand(String.valueOf(policyType));
            this.addActionListener(this);
            this.putClientProperty("cssClass", "policySideBarPolicyButton");
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
            this.setBackground(PolicySideBar.this.getBackground());
        }

        public PolicyButton(int policyType, String name) {
            this(policyType, null, name);
        }

        @Override
        public String getUIClassID() {
            return "PolicyButtonUI";
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Cursor curCursor = Manager.getFrame().getCursor();
            Manager.getFrame().setCursor(new Cursor(3));
            String item = this.treeItem.getName();
            String eventId = null;
            if (!item.equals("Virus and Spyware")) {
                MonitorAgent.getInstance().startScenario("PolicyPanel_" + item + "_Load", "SEPM_Java");
                eventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
            }
            PolicySideBar.this.pagePanel.setCurrentTaskPanel(this.treeItem);
            PolicySideBar.this.updateTasks();
            Manager.getFrame().setCursor(curCursor);
            PolicySideBar.this.firstButton = this;
            if (!item.equals("Virus and Spyware")) {
                MonitorAgent.getInstance().stopEvent(eventId);
                MonitorAgent.getInstance().stopScenario("PolicyPanel_" + item + "_Load");
            }
        }
    }
}

