/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.HardwareDeviceHandler;
import com.sygate.scm.console.handler.HostGroupHandler;
import com.sygate.scm.console.handler.NetworkAdapterHandler;
import com.sygate.scm.console.handler.ServiceTypeHandler;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.PolicyAccessDeniedPanel;
import com.sygate.scm.console.ui.policy.PolicySideBar;
import com.sygate.scm.console.ui.policy.ScheduledScanTaskPopupMenu;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSLibraryHandler;
import com.sygate.scm.console.ui.policy.explorer.lu.LuPolicyHandler;
import com.sygate.scm.console.ui.policy.hi.logicobject.FunctionType;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.SideBar;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;

public class PolicyPanel
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_ID_POLICY_SIDE_BAR = "PolicySideBar";
    private PolicyAccessDeniedPanel policyAccessDeniedPanel = new PolicyAccessDeniedPanel();

    @Override
    public void initPanel() {
        this.initialize();
        ScheduledScanTaskPopupMenu scheduledScanTaskpopupMenu = new ScheduledScanTaskPopupMenu();
        this.sideBar.setScheduledScanTaskPopupMenu(scheduledScanTaskpopupMenu);
        this.refreshTaskBarViews();
        this.setName(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.policiesName"));
        FunctionType.resetConditionFuncPanel();
        this.validate();
        this.isInitialized = true;
    }

    @Override
    public void setCurrentTaskPanel(TreeItem item) {
        JComponent com = this.getPolicyPoolPane(item, this);
        if (com != null) {
            this.setCurrentTaskPanel(com);
            if (com instanceof TaskPanel) {
                ((TaskPanel)((Object)com)).addTableSelectionListener(this);
            }
        }
    }

    @Override
    public void refreshTaskBarViews() {
        super.refreshTaskBarViews();
        try {
            AdminHandler.refreshCurrentAdmin();
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        if (!AdminPrivilegeObject.isCurrentAdminHasPolicyPrivilege()) {
            this.policyAccessDeniedPanel.load();
            this.setCurrentTaskPanel(this.policyAccessDeniedPanel);
            if (this.sideBar != null) {
                this.sideBar.updateTasks("policyPage", new ArrayList<List<TaskObject>>());
            }
        } else if (this.getCurrentTaskPanel() instanceof PolicyAccessDeniedPanel && this.sideBar != null) {
            ((PolicySideBar)this.sideBar).selectFirstButton();
        }
    }

    @Override
    protected SideBar createSideBar() {
        PolicySideBar policySideBar = new PolicySideBar(this, this.getSideBarViewPaneTitle(), this.getSideBarTaskPaneTitle());
        UIUtilities.setName(policySideBar, "policyPage", UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_POLICY_SIDE_BAR);
        return policySideBar;
    }

    @Override
    protected String getSideBarViewPaneTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.viewPolicies");
    }

    @Override
    protected String getSideBarTaskPaneTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.taskList");
    }

    private JComponent getPolicyPoolPane(TreeItem treeItem, PolicyPanel policyPanel) {
        switch (treeItem.getItemType()) {
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 125: 
            case 127: 
            case 129: 
            case 136: 
            case 142: 
            case 170: 
            case 172: 
            case 310: 
            case 314: 
            case 401: {
                return BasePolicyHandler.getInstance(treeItem.getItemType()).getPolicyPoolPane(treeItem);
            }
            case 66: 
            case 305: {
                return IDSLibraryHandler.getInstance().getPolicyPoolPane(treeItem, policyPanel);
            }
            case 145: 
            case 149: {
                return LuPolicyHandler.getInstance().getPolicyPoolPane(treeItem, policyPanel);
            }
            case 152: {
                return HostGroupHandler.getInstance().getHostGroupPanel();
            }
            case 62: {
                return ServiceTypeHandler.getInstance().getComponent(treeItem);
            }
            case 100: {
                return NetworkAdapterHandler.getInstance().getComponent(treeItem);
            }
            case 101: {
                return HardwareDeviceHandler.getInstance().getComponent(treeItem);
            }
            case 91: {
                return WhiteListHandler.getComponent(treeItem);
            }
        }
        BlankPanel panel = new BlankPanel();
        panel.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.underDevelopment")));
        return panel;
    }

    private static class BlankPanel
    extends JPanel
    implements TaskPanel {
        private static final long serialVersionUID = 1L;

        private BlankPanel() {
        }

        @Override
        public void executeTask(int taskIndex, Object userObject) {
        }

        @Override
        public void addTableSelectionListener(ListSelectionListener listener) {
        }

        @Override
        public int getTableSelectedItem() {
            return -1;
        }

        @Override
        public void refresh() {
        }
    }
}

